unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, DCSyntaxMemo, DCSyntaxData;

type
  TForm2 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Button1: TButton;
    StatusBar1: TStatusBar;
    procedure Button1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    SyntaxMemo: TDCSyntaxMemo;
    procedure ColRowChanged(Sender: TObject; Col, Row: integer);
    procedure SetInsertMode(Sender: TObject);
    procedure ModifiedChanged(Sender: TObject);
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

procedure TForm2.Button1Click(Sender: TObject);
begin
  SyntaxMemo := TDCSyntaxMemo.Create(Self, TDCDelphiSyntaxData);
  with SyntaxMemo do
  begin
    Parent := Panel2;
    Align := alClient;
    OnColRowChanged   := ColRowChanged;
    OnSetInsertMode   := SetInsertMode;
    OnModifiedChanged := ModifiedChanged;
    ColRowChanged(SyntaxMemo, Col, Row);
    SetInsertMode(SyntaxMemo);
  end;
end;

procedure TForm2.ColRowChanged(Sender: TObject; Col, Row: integer);
begin
  Statusbar1.Panels[0].Text := Format('%7d:%4d',[SyntaxMemo.Row + 1, SyntaxMemo.Col + 1]);
end;

procedure TForm2.ModifiedChanged(Sender: TObject);
begin
  if Assigned(SyntaxMemo) then
  begin
    if SyntaxMemo.Modified then
      Statusbar1.Panels[2].Text := 'Modified'
    else
      Statusbar1.Panels[2].Text := '';
  end;
end;

procedure TForm2.SetInsertMode(Sender: TObject);
begin
  if SyntaxMemo.InsertMode then
    Statusbar1.Panels[1].Text := 'Insert'
  else
    Statusbar1.Panels[2].Text := 'Override';
end;

procedure TForm2.FormDestroy(Sender: TObject);
begin
  if SyntaxMemo <> nil then SyntaxMemo.Free;
end;

end.
