unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ToolWin, ComCtrls, DCStdCtrls, ExtCtrls, ImgList, Menus,
  ActnList, Buttons, ShellAPI, DCChoice, CommCtrl, Db, DBTables, Grids,
  DCDBGrids, DCCombo, DCKnots, DCStringGrid, SimpleJournalTemplate, D2KConst,
  DCTray, DCConst, DBGrids;

type
  THackControl = class(TWinControl)
    {}
  end;

  TMainForm = class(TForm)
    sbInfo: TStatusBar;
    pnMain: TPanel;
    obNavigator: TDCOutBar;
    ActionList: TActionList;
    acExit: TAction;
    acDemo: TAction;
    tbButtons: TToolBar;
    spNavigator: TSplitter;
    tbExit: TToolButton;
    opJournals: TDCOutBarPanel;
    acAdd: TAction;
    procedure acExitExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure acLinkExecute(Sender: TObject);
    procedure sbInfoDrawPanel(StatusBar: TStatusBar; Panel: TStatusPanel;
      const Rect: TRect);
    procedure opJournalsClick(Sender: TObject);
    procedure acDemoExecute(Sender: TObject);
    procedure acAddExecute(Sender: TObject);
  private
    procedure UpdateUserInfo;
  protected
    procedure SGUserFormFree(var Message: TMessage); message SG_USERFORM_FREE;
    procedure SGUserFormShow(var Message: TMessage); message SG_USERFORM_SHOW;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses MainDB, DMResource, DCEditButton, DCEditTools,
  Demo;

{$R *.DFM}

procedure TMainForm.acExitExecute(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  obNavigator.Constraints.MaxWidth := 200;
end;

procedure TMainForm.acLinkExecute(Sender: TObject);
begin
  ShellExecute(Self.Handle, 'open', 'mailto:support@decosp.spb.ru?subject=DCComponents Demo',
    '', '', SW_SHOWNORMAL);
end;

procedure TMainForm.sbInfoDrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
 var
  R: TRect;
begin
  R := Rect;
  if Panel.Index = 0 then
  begin
    R.Left := R.Left + 1;
    DrawHighLightText(StatusBar.Canvas,
      '/im{50}/ow{2}/f{Tahoma}Administrator',
      R, 1, DT_END_ELLIPSIS, DMResourceForm.imSmallImages);
  end;
end;

procedure TMainForm.UpdateUserInfo;
 var
  PanelRect: TRect;
begin
  with sbInfo.Panels[0] do
  begin
    SendMessage(sbInfo.Handle, SB_GETRECT, Index, Integer(@PanelRect));
    InvalidateRect(sbInfo.Handle, @PanelRect, True);
  end;
end;

procedure TMainForm.SGUserFormFree(var Message: TMessage);
begin
  if Message.LParam = MODE_FREEWINDOW then
  begin
    TCustomForm(Message.WParam).Free;
    TCustomForm(Message.WParam) := nil;
  end;
end;

procedure TMainForm.SGUserFormShow(var Message: TMessage);
begin
  {}
end;

procedure TMainForm.opJournalsClick(Sender: TObject);
 var
  AButton: TDCEditButton;
begin
  if Sender is TDCOutBarpanel then
  begin
    AButton := TDCOutBarPanel(Sender).ActiveButton;
    if AButton <> nil then
      case AButton.Tag of
        1: {Country}  acDemo.Execute;
        2: {Add}      acAdd.Execute;
      end;
  end;
end;

procedure TMainForm.acDemoExecute(Sender: TObject);
begin
  TDemoForm.CreateJournal(Self, MainDbForm.dbDemo, 'Demo StringGrid');
end;

procedure TMainForm.acAddExecute(Sender: TObject);
  var
   FQuery: TQuery;
   i: longint;
begin
  FQuery := TQuery.Create(nil);
  FQuery.DatabaseName := MainDbForm.dbDemo.DatabaseName;
  try
    for i := 1 to 10000 do
    begin
      FQuery.SQL.Clear;
      FQuery.SQL.Add(Format('insert into  country (Name) values("%d")',[i]));
      FQuery.Prepare;
      FQuery.ExecSQL;
    end;
  finally
    FQuery.Free;
  end;
  {}
end;

end.
