unit Demo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SimpleJournalTemplate, Menus, ActnList, ComCtrls, Grids, DCKnots,
  DCStringGrid, DCStdCtrls, Buttons, ToolWin, ExtCtrls;

type
  TDemoForm = class(TSimpleJournalForm)
    procedure pmMainPopup(Sender: TObject);
  private
    { Private declarations }
    procedure ShowApplicationHint(Sender: TObject);
  protected
    procedure InitJournal; override;
  public
    procedure InitGrid; override;
  end;

var
  DemoForm: TDemoForm;

implementation

uses MainDB, DCEditTools, DCConst;

{$R *.DFM}

{ TjrDepoTypeForm }

procedure TDemoForm.InitGrid;
 var
  pColumnData: PColumnData_tag;
begin
  DecimalSeparator := '.';
  with Grid do
  begin
    pColumnData := AddColumn(ddString , 'Name', 'Name');
    with pColumnData^ do
    begin
      EditOptions := [eoUnique];
      Width       := 120;
    end;
    pColumnData := AddColumn(ddString, 'Capital'   , 'Captial'  );
    with pColumnData^ do
    begin
      Comment     := '';
      Width       := 200;
    end;
    AddColumn(ddString, 'Continent' , 'Continent');
    pColumnData := AddColumn(ddFloat, 'Area'      , 'Area'     );
    with pColumnData^ do
    begin
      Width  := 65;
    end;
    pColumnData := AddColumn(ddFloat, 'Population', 'Population');
    with pColumnData^ do
    begin
      Width  := 100;
      Alignment := taRightJustify;
      DisplayFormat := '%f';
    end;
    ParamCount := 5;
  end;
  SQLQuery   := 'select * from country';
  inherited;
  DefineIdent('Name', ddString);
  //Application.OnHint := ShowApplicationHint;
end;

procedure TDemoForm.InitJournal;
begin
  JournalIndex := 24;
  JournalName  := 'Countries';
  Database     := MainDbForm.dbDemo;
end;

procedure TDemoForm.pmMainPopup(Sender: TObject);
begin
  inherited;
  //Application.OnHint := ShowApplicationHint;
end;

procedure TDemoForm.ShowApplicationHint(Sender: TObject);
begin
  //Comment := Application.Hint;
end;

end.
