unit ParamValueTemplate;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ParamTemplate, StdCtrls, ExtCtrls, DCChoice, DCStdCtrls, RegConsts, DCConst;


type
  TParamValueEditMode = (emCreate, emModify);

  TParamValueTemplateForm = class(TParamTemplateForm)
    lbNameValue: TLabel;
    edNameValue: TDCChoiceEdit;
    lbDataValue: TLabel;
    lbError: TDCLabel;
    procedure FormCreate(Sender: TObject);
    procedure btOKClick(Sender: TObject);
  private
    FMainFormHandle: THandle;
    FEditMode: TParamValueEditMode;
    FItem: Pointer;
    function GetError: string;
    procedure SetError(const Value: string);
    function GetNameValue: string;
    procedure SetNameValue(const Value: string);
    function GetEditMode: TParamValueEditMode;
    procedure SetEditMode(const Value: TParamValueEditMode);
 protected
    procedure CMInvalidValue(var Message: TMessage); message CM_INVALIDVALUE;
  public
    function CheckToProcess: boolean; virtual;
    procedure GetMessageData(var CreateData: TWPCreateData); virtual; abstract;
    procedure DoCreateValue;
    property MainFormHandle: THandle read FMainFormHandle write FMainFormHandle;
    property Error: string read GetError write SetError;
    property NameValue: string read GetNameValue write SetNameValue;
    property EditMode: TParamValueEditMode read GetEditMode write SetEditMode;
    property Item: Pointer read FItem write FItem;
  end;

function HexToInt(Value: string): DWORD;

implementation

{$R *.DFM}

function HexToInt(Value: string): DWORD;
  var
   pValue: PChar;
begin
  Result := 0;
  pValue := PChar(AnsiUpperCase(Value));
  while pValue^ <> #0 do
  begin
    case pValue^ of
      '0'..'9': Result := Result*16 + Ord(pValue^) - Ord('0');
      'A'..'F': Result := Result*16 + Ord(pValue^) - Ord('A') + 10;
      else begin
        Result := 0;
        Exit;
      end;
    end;
    inc(pValue);
  end;
end;

{ TParamValueTemplateForm }

function TParamValueTemplateForm.GetError: string;
begin
  Result := lbError.Caption;
end;

function TParamValueTemplateForm.GetNameValue: string;
begin
  Result := edNameValue.Text;
end;

procedure TParamValueTemplateForm.SetError(const Value: string);
begin
  lbError.Caption := Value;
end;

procedure TParamValueTemplateForm.SetNameValue(const Value: string);
begin
  edNameValue.Text := Value;
end;

procedure TParamValueTemplateForm.FormCreate(Sender: TObject);
begin
  inherited;
  Error := '';
end;

function TParamValueTemplateForm.CheckToProcess: boolean;
begin
  Result := True;

  if not btOk.Focused then
  begin
    btOk.SetFocus;
    if not btOk.Focused then Result := False;
  end;

  if (EditMode = emCreate) and (edNameValue.ErrorCode <> ERR_EDIT_NONE) then
  begin
    edNameValue.SetFocus;
    edNameValue.ShowErrorMessage;
    Result := False;
    Exit;
  end;

end;

procedure TParamValueTemplateForm.DoCreateValue;
 var
  hResult: DWORD;
  CreateData: TWPCreateData;
begin
  GetMessageData(CreateData);
  hResult := SendMessage(MainFormHandle, CM_REGFILE_CREATEVALUE, Integer(@CreateData), 0);
  if hResult = ERROR_SUCCESS then
  begin
    Error := '';
    Close;
  end
  else begin
    case hResult of
      ERROR_DUP_NAME:
        Error := Format(SDAT_ERROR_DUP_NAME_2 ,[NameValue]);
      ERROR_BAD_LENGTH:
        Error := SDAT_ERROR_BAD_LENGTH;
      ERROR_WRITE_FAULT:
        Error := SDAT_ERROR_WRITE_FAULT;
    end;
    ActiveControl := edNameValue;
  end;
end;

function TParamValueTemplateForm.GetEditMode: TParamValueEditMode;
begin
  Result := FEditMode;
end;

procedure TParamValueTemplateForm.SetEditMode(
  const Value: TParamValueEditMode);
begin
  FEditMode := Value;
  case FEditMode of
    emCreate:
      begin
        edNameValue.ReadOnly := False;
        edNameValue.Color    := clWindow;
        ActiveControl := edNameValue;
      end;
    emModify :
      begin
        edNameValue.ReadOnly := True;
        edNameValue.Color    := clBtnFace;
      end;
  end;
end;

procedure TParamValueTemplateForm.btOKClick(Sender: TObject);
begin
  inherited;
  if CheckToProcess then DoCreateValue;
end;

procedure TParamValueTemplateForm.CMInvalidValue(var Message: TMessage);
begin
  if ActiveControl = btCancel then Message.Result := Integer(True);
end;

end.
