unit StringValue;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ParamValueTemplate, StdCtrls, DCChoice, ExtCtrls, DCStdCtrls, RegConsts,
  DCIniStream;

type
  TStringValueForm = class(TParamValueTemplateForm)
    edDataValue: TDCChoiceEdit;
  private
    FDataValue: string;
    FNameValue: string;
    function GetDataValue: string;
    procedure SetDataValue(const Value: string);
  public
    procedure GetMessageData(var CreateData: TWPCreateData); override;
    property DataValue: string read GetDataValue write SetDataValue;
  end;

procedure CreateStringValue(AHandle: THandle);
procedure ModifyStringValue(AName: string; AValue: string; AHandle: THandle; AItem: Pointer);

implementation

{$R *.DFM}

procedure CreateStringValue(AHandle: THandle);
begin
  with TStringValueForm.Create(nil) do
  begin
    Error    := '';
    Caption  := ' ';
    EditMode := emCreate;
    MainFormHandle := AHandle;
    try
      Item      := nil;
      NameValue := ' #';
      DataValue := '';
      ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure ModifyStringValue(AName: string; AValue: string; AHandle: THandle; AItem: Pointer);
begin
  with TStringValueForm.Create(nil) do
  begin
    Error    := '';
    Caption  := ' ';
    EditMode := emModify;
    MainFormHandle := AHandle;
    ActiveControl  := edDataValue;
    try
      Item      := AItem;
      NameValue := AName;
      DataValue := AValue;
      ShowModal;
    finally
      Free;
    end;
  end;
end;

{ TStringValueForm }

function TStringValueForm.GetDataValue: string;
begin
  Result := edDataValue.Text;
end;

procedure TStringValueForm.GetMessageData(var CreateData: TWPCreateData);
begin
  FDataValue := DataValue;
  FNameValue := NameValue;
  with CreateData do
  begin
    DataObject:= Item;
    DataName  := PChar(FNameValue);
    DataBuffer:= @FDataValue;
    DataSize  := Length(DataValue)+1;
    if EditMode = emCreate then
      DataType  := Ord(idString)
    else
      DataType  := -1;
  end;
end;

procedure TStringValueForm.SetDataValue(const Value: string);
begin
  edDataValue.Text := Value;
end;

end.
   