unit NewKey;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ParamTemplate, StdCtrls, ExtCtrls, DCChoice, RegConsts, DCIniStream,
  DCStdCtrls, DCConst;

type
  TNewKeyForm = class(TParamTemplateForm)
    lbKeyName: TLabel;
    edKeyName: TDCChoiceEdit;
    gbError: TGroupBox;
    lbError: TDCLabel;
    procedure btOKClick(Sender: TObject);
  private
    { Private declarations }
    FMainFormHandle: THandle;
    FNode: Pointer;
    function GetKeyName: string;
    procedure SetKeyName(const Value: string);
    function GetError: string;
    procedure SetError(const Value: string);
  protected
    procedure CMInvalidValue(var Message: TMessage); message CM_INVALIDVALUE;
  public
    { Public declarations }
    class procedure  CreateNewKey(AHandle: THandle; ANode: Pointer);
    property MainFormHandle: THandle read FMainFormHandle write FMainFormHandle;
    property Node: Pointer read FNode write FNode;
    property KeyName: string read GetKeyName write SetKeyName;
    property Error: string read GetError write SetError;
  end;

procedure CreateNewKey(AHandle: THandle; ANode: Pointer);

implementation

{$R *.DFM}

procedure CreateNewKey(AHandle: THandle; ANode: Pointer);
begin
  TNewKeyForm.CreateNewKey(AHandle, ANode);
end;

procedure TNewKeyForm.btOKClick(Sender: TObject);
 var
  WPCreateKey: TWPCreateData;
  hResult: DWORD;
begin
  inherited;

  if not btOk.Focused then
  begin
    btOk.SetFocus;
    if not btOk.Focused then Exit;
  end;

  if edKeyName.ErrorCode <> ERR_EDIT_NONE then
  begin
    edKeyName.SetFocus;
    edKeyName.ShowErrorMessage;
    Exit;
  end;

  WPCreateKey.DataName   := PChar(KeyName);
  WPCreateKey.DataObject := Node;

  hResult := SendMessage(MainFormHandle, CM_REGFILE_CREATEKEY, Integer(@WPCreateKey), 0);
  if hResult = ERROR_SUCCESS then
  begin
    Error := '';
    Close;
  end
  else begin
    case hResult of
      ERROR_DUP_NAME:
        Error := Format(SKEY_ERROR_DUP_NAME ,[KeyName]);
      ERROR_BAD_LENGTH:
        Error := SKEY_ERROR_BAD_LENGTH;
      ERROR_INVALID_DATA:
        Error := SKEY_ERROR_BAD_LENGTH;
    end;
    ActiveControl := edKeyName;
  end;
end;

procedure TNewKeyForm.CMInvalidValue(var Message: TMessage);
begin
  if ActiveControl = btCancel then Message.Result := Integer(True);
end;

class procedure TNewKeyForm.CreateNewKey(AHandle: THandle; ANode: Pointer);
begin
  with TNewKeyForm.Create(nil) do
  begin
    Error    := '';
    Caption  := ' ';
    Node     := ANode;
    MainFormHandle := AHandle;
    try
      KeyName := ' #';
      ActiveControl := edKeyName;
      ShowModal;
    finally
      Free;
    end;
  end;
end;

function TNewKeyForm.GetError: string;
begin
  Result := lbError.Caption;
end;

function TNewKeyForm.GetKeyName: string;
begin
  Result := edKeyName.Text;
end;

procedure TNewKeyForm.SetError(const Value: string);
begin
  lbError.Caption := Value;
end;

procedure TNewKeyForm.SetKeyName(const Value: string);
begin
  edKeyName.Text := Value;
end;

end.
  