unit IntegerValue;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ParamValueTemplate, StdCtrls, DCChoice, ExtCtrls, DCStdCtrls, RegConsts,
  DCIniStream;

type
  TIntegerValueForm = class(TParamValueTemplateForm)
    edDatavalue: TDCChoiceEdit;
    gbBase: TGroupBox;
    rbHexBase: TRadioButton;
    rbDecBase: TRadioButton;
    procedure rbHexBaseClick(Sender: TObject);
    procedure rbDecBaseClick(Sender: TObject);
  private
    FBaseMode: Integer;
    FNameValue: string;
    FDataValue: LongInt;
    function GetDataValue: Longint;
    procedure SetDataValue(const Value: Longint);
    function GetBaseMode: integer;
    procedure SetBaseMode(const Value: integer);
  public
    procedure GetMessageData(var CreateData: TWPCreateData); override;
    property DataValue: Longint read GetDataValue write SetDataValue;
    property BaseMode: integer read GetBaseMode write SetBaseMode;
  end;

procedure CreateIntegerValue(AHandle: THandle);
procedure ModifyIntegerValue(AName: string; AValue: Longint; AHandle: THandle; AItem: Pointer);

implementation

const
  HEX_BASEMODE = 0;
  DEC_BASEMODE = 1;

{$R *.DFM}

procedure CreateIntegerValue(AHandle: THandle);
begin
  with TIntegerValueForm.Create(nil) do
  begin
    Error    := '';
    Caption  := ' ';
    EditMode := emCreate;
    BaseMode := DEC_BASEMODE;
    MainFormHandle := AHandle;
    try
      Item      := nil;
      NameValue := ' #';
      DataValue := 0;
      ShowModal;
    finally
      Free;
    end;
  end;
end;

procedure ModifyIntegerValue(AName: string; AValue: Longint; AHandle: THandle; AItem: Pointer);
begin
  with TIntegerValueForm.Create(nil) do
  begin
    Error    := '';
    Caption  := ' ';
    EditMode := emModify;
    BaseMode := DEC_BASEMODE;
    MainFormHandle := AHandle;
    ActiveControl  := edDataValue;
    try
      Item      := AItem;
      NameValue := AName;
      DataValue := AValue;
      ShowModal;
    finally
      Free;
    end;
  end;
end;

{ TIntegerValueForm }

function TIntegerValueForm.GetBaseMode: integer;
begin
  Result := FBaseMode;
end;

function TIntegerValueForm.GetDataValue: Longint;
begin
  if BaseMode = HEX_BASEMODE then
    Result := HexToInt(edDataValue.Text)
  else
    Result := StrToIntDef(edDataValue.Text, 0);
end;

procedure TIntegerValueForm.GetMessageData(var CreateData: TWPCreateData);
begin
  FDataValue := DataValue;
  FNameValue := NameValue;
  with CreateData do
  begin
    DataObject:= Item;
    DataName  := PChar(FNameValue);
    DataBuffer:= @FDataValue;
    DataSize  := SizeOf(LongInt);
    if EditMode = emCreate then
      DataType  := Ord(idInteger)
    else
      DataType  := -1;
  end;
end;

procedure TIntegerValueForm.SetBaseMode(const Value: integer);
 var
  ADataValue: LongInt;
begin
  ADataValue:= DataValue;
  FBaseMode := Value;
  case FBaseMode of
    HEX_BASEMODE:
      begin
        rbHexBase.Checked := True;
      end;
    DEC_BASEMODE:
      begin
        rbDecBase.Checked := True;
      end;
  end;
  DataValue := ADataValue;
end;

procedure TIntegerValueForm.SetDataValue(const Value: Longint);
begin
  if BaseMode = HEX_BASEMODE then
    edDataValue.Text := IntToHex(Value, 0)
  else
    edDataValue.Text := IntToStr(Value);
end;

procedure TIntegerValueForm.rbHexBaseClick(Sender: TObject);
begin
  inherited;
  BaseMode := HEX_BASEMODE;
end;

procedure TIntegerValueForm.rbDecBaseClick(Sender: TObject);
begin
  inherited;
  BaseMode := DEC_BASEMODE;
end;

end.
