unit About;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, DCStdCtrls;

type
  TAboutForm = class(TForm)
    imBackground: TImage;
    lbDemo: TDCLabel;
    lbType: TDCLabel;
    pnButtons: TPanel;
    bvSep_1: TBevel;
    lbProjectInfo: TDCLabel;
    lbURL: TDCLabel;
    shSep_1: TShape;
    lbSystemInfo: TDCLabel;
    lbMemoryInfo: TDCLabel;
    btOK: TButton;
    Image1: TImage;
    procedure FormCreate(Sender: TObject);
    procedure btOKClick(Sender: TObject);
    procedure lbURLClick(Sender: TObject);
    procedure lbURLMouseEnter(Sender: TObject);
    procedure lbURLMouseLeave(Sender: TObject);
  private
    { Private declarations }
    sURLAdress: string;
    sURLCaption: string;
  public
    { Public declarations }
  end;

implementation
uses DCVerInfo, ShellAPI, DCConst;

{$R *.DFM}

procedure TAboutForm.FormCreate(Sender: TObject);
 var
  MV: TModuleVersion;
  VerInfo: TDCVersionInfo;
begin
  inherited;
  VerInfo := TDCVersionInfo.Create(Application.ExeName);
  MV := VerInfo.ProductLongVersion;
  with MV do
    lbProjectInfo.Caption := Format(INFO_FMT_PROJECT, [Major, Minor, Release, Build]);

  lbSystemInfo.Caption := Format(INFO_FMT_SYSTEM, [VerInfo.OSVersion]);
  lbMemoryInfo.Caption := Format(INFO_FMT_MEMORY, [VerInfo.MemoryTotal]);
  lbType.Caption       := '/ip{DC_IMGABOUT}';

  sURLAdress  := VerInfo.Values['Company URL'];
  sURLCaption := VerInfo.Values['LegalCopyright'];
  VerInfo.Free;

  lbURL.Caption    := Format(INFO_FMT_URL, [sURLCaption]) ;
  lbURL.Font.Style := [fsUnderline];
  lbURLMouseLeave(Self);
end;

procedure TAboutForm.btOKClick(Sender: TObject);
begin
  inherited;
  Close;
end;

procedure TAboutForm.lbURLClick(Sender: TObject);
begin
  inherited;
  ShellExecute(Self.Handle, 'open', PChar('http:\\'+sURLAdress),
    '', '', SW_SHOWNORMAL);
end;

procedure TAboutForm.lbURLMouseEnter(Sender: TObject);
begin
  inherited;
  lbURL.Font.Color := $553399;
end;

procedure TAboutForm.lbURLMouseLeave(Sender: TObject);
begin
  inherited;
  lbURL.Font.Color := $553333;
end;

end.
 
