{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCStdCtrls;

interface
{$I DCConst.inc}

uses Messages, Windows, SysUtils, Classes, Controls, Forms, Menus, Graphics,
     StdCtrls, DCEditTools, DCEditButton, ExtCtrls, Math, CommCtrl, Dialogs,
     DCConst, ComStrs, ImgList;

type
  TOutBarMode = (omNormal, omMoveItem);

  TDCCustomLabel = class(TCustomLabel)
  private
    FImages: TImageList;
    FImageChangeLink: TChangeLink;
    FOnMouseEnter: TNotifyEvent;
    FOnMouseLeave: TNotifyEvent;
    FDBObject : TDCDBObject;
    function GetDBObject: TDCDBObject;
    procedure SetDBObject(const Value: TDCDBObject);
    procedure SetImages(const Value: TImageList);
    procedure ImageListChange(Sender: TObject);
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseLeave: TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
    property DBObject: TDCDBObject read GetDBObject write SetDBObject;
    property Images: TImageList read FImages write SetImages;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
    procedure AdjustBounds; override;
  end;

  TDCLabel = class(TDCCustomLabel)
  published
    property Alignment;
    property Align;
    property Anchors;
    property AutoSize default False;
    property BiDiMode;
    property Caption;
    property Color;
    property Constraints;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property FocusControl;
    property Font;
    property ParentBiDiMode;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowAccelChar;
    property ShowHint;
    property Transparent;
    property Layout;
    property Visible;
    property WordWrap;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;
    property OnMouseEnter;
    property OnMouseLeave;
    property Images;
  end;

  TDCCustomPanel = class(TCustomPanel)
  private
    FImages: TImageList;
    FImageChangeLink: TChangeLink;
    FVertCentered: boolean;
    FOnMouseEnter: TNotifyEvent;
    FOnMouseLeave: TNotifyEvent;
    FMargins: TRect;
    FBrushImage: TImage;
    procedure SetVertCentered(const Value: boolean);
    procedure SetImages(const Value: TImageList);
    procedure SetBrushImage(const Value: TImage);
    procedure ImageListChange(Sender: TObject);
  protected
    function GetRectOffset: TRect; virtual;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure WMEraseBkGnd(var Message: TWMEraseBkGnd); message WM_ERASEBKGND;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseLeave: TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
    property VertCentered: boolean read FVertCentered write SetVertCentered;
    property Images: TImageList read FImages write SetImages;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
    procedure SetMargins(Left, Top, Right, Bottom: integer);
  published
    property BrushImage: TImage read FBrushImage write SetBrushImage;
  end;

  TDCPanel = class(TDCCustomPanel)
  public
    property DockManager;
  published
    property Alignment stored True;
    property Align stored True;
    property Anchors;
    property AutoSize;
    property BevelInner;
    property BevelOuter;
    property BevelWidth;
    property BiDiMode;
    property BorderWidth;
    property BorderStyle;
    property Caption;
    property Color stored True;
    property Constraints;
    property Ctl3D;
    property UseDockManager default True;
    property DockSite;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property FullRepaint;
    property Font;
    property Locked;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnCanResize;
    property OnClick;
    property OnConstrainedResize;
    property OnDockDrop;
    property OnDockOver;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnGetSiteInfo;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
    property OnStartDock;
    property OnStartDrag;
    property OnUnDock;
    property OnMouseEnter;
    property OnMouseLeave;
    property VertCentered;
    property Images;
  end;

  TDCCustomHeaderPanel = class(TDCPanel)
  private
    FButtons: TDCEditButtons;
    FClosed: boolean;
    FOnCloseButtonClick: TNotifyEvent;
    FButtonAllign: boolean;
    procedure CloseButtonClick(Sender: TObject);
    procedure AddCloseButton;
    procedure DelCloseButton;
    procedure SetClosed(const Value: boolean);
    procedure SetButtonAllign(const Value: boolean);
    procedure FillNCArea;
  protected
    procedure CreateWnd; override;
    function GetRectOffset: TRect; override;
    property Closed: boolean read FClosed write SetClosed;
    procedure CMColorChanged(var Message: TMessage); message CM_COLORCHANGED;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure WMKillFocus(var Message: TWMKillFocus); message WM_KILLFOCUS;
    procedure WMNCCalcSize(var Message: TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
    procedure WMNCPaint(var Message: TWMNCPaint); message WM_NCPAINT;
    property CloseButtonExist: boolean read FClosed write SetClosed;
    property OnCloseButtonClick: TNotifyEvent read FOnCloseButtonClick write FOnCloseButtonClick;
    property Buttons: TDCEditButtons read FButtons;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
  published
    property BorderWidth default 2;
    property BevelOuter default bvNone;
    property ButtonAllign: boolean read FButtonAllign write SetButtonAllign;
  end;

  TDCHeaderPanel = class(TDCCustomHeaderPanel)
  public
    property Buttons;
  published
    property CloseButtonExist;
    property OnCloseButtonClick;
    property Align default alTop;
    property Color default clBtnShadow;
    property BevelOuter default bvNone;
  end;

  TDCCustomPageControl = class;

  TDrawTabEvent = procedure (Control: TDCCustomPageControl; PageIndex: Integer;
    const Rect: TRect; Active: Boolean; var DefaultDraw: boolean) of object;

  TGetItemPopup = procedure (Sender: TObject; Item: TDCEditButton;
    var PopupMenu: TPopupMenu) of object;

  TDCCustomPage = class(TCustomControl)
  private
    FPageControl: TDCCustomPageControl;
    FPageVisible: boolean;
    FOnHide: TNotifyEvent;
    FOnShow: TNotifyEvent;
    FTabRect: TRect;
    FFullVisible: boolean;
    FRemoving: boolean;
    FImageIndex: integer;
    function GetPageIndex: Integer;
    procedure SetPageControl(const Value: TDCCustomPageControl);
    procedure SetPageIndex(const Value: Integer);
    procedure SetPageVisible(const Value: boolean);
    procedure UpdatePageShowing;
    procedure SetImageIndex(const Value: integer);
  protected
    procedure DoHide; dynamic;
    procedure DoShow; dynamic;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure ReadState(Reader: TReader); override;
    procedure WMEraseBkGnd(var Message: TWMEraseBkGnd); message WM_ERASEBKGND;
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure CMShowingChanged(var Message: TMessage); message CM_SHOWINGCHANGED;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMEnabledChanged(var Message: TMessage); message CM_ENABLEDCHANGED;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property PageControl: TDCCustomPageControl read FPageControl write SetPageControl;
    procedure Paint; override;
    property ImageIndex: integer read FImageIndex write SetImageIndex;
  published
    property Caption;
    property Color stored True default clBtnFace;
    property Constraints;
    property Enabled;
    property DragMode;
    property Font;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property PageIndex: Integer read GetPageIndex write SetPageIndex stored False;
    property PageVisible: boolean read FPageVisible write SetPageVisible default True;
    property OnClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnHide: TNotifyEvent read FOnHide write FOnHide;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
    property OnShow: TNotifyEvent read FOnShow write FOnShow;
    property OnStartDrag;
  end;

  TDCPage = class(TDCCustomPage)
  published
    property ImageIndex;
  end;

  TPageList = class(TList)
  private
    FVisibleList: TList;
    FPageControl: TDCCustomPageControl;
    function GetVisibleCount: integer;
    procedure ClearVisible;
    procedure UpdateVisible;
    procedure AddVisible(AIndex: integer);
  public
    constructor Create(AComponent: TComponent);
    destructor Destroy; override;
    function VisibleIndexOf(Index: integer): integer;
    procedure SetVisible(APage: TDCCustomPage; AVisible: boolean);
    property VisibleCount: integer read GetVisibleCount;
  end;

  TDCCustomPageControl = class(TCustomControl)
  private
    FPages: TPageList;
    FActivePage: TDCCustomPage;
    FOnChange: TNotifyEvent;
    FOnChanging: TChangingEvent;
    FOnDrawTab: TDrawTabEvent;
    FTabsRect: TRect;
    FImages: TImageList;
    FTabVisible: boolean;
    FImageChangeLink: TChangeLink;
    FFirstIndex: integer;
    FSelectedPage: TDCCustomPage;
    FBitmap: TBitmap;
    FBuffered: boolean;
    procedure InsertPage(Page: TDCCustomPage); virtual;
    procedure RemovePage(Page: TDCCustomPage); virtual;
    procedure SetPageVisible(APageIndex: integer; AVisible: boolean);
    function GetPage(Index: Integer): TDCCustomPage;
    function GetPageCount: Integer;
    function GetPageIndex: integer;
    procedure SetPageIndex(const Value: integer);
    procedure ChangeActivePage(Page: TDCCustomPage); dynamic;
    procedure SetImages(const Value: TImageList); virtual;
    procedure SetTabVisible(const Value: boolean); virtual;
    procedure ImageListChange(Sender: TObject); virtual;
    procedure UpdateTabsRect;
  protected
    procedure AdjustClientRect(var Rect: TRect); override;
    procedure SetActivePage(const Value: TDCCustomPage); virtual;
    procedure CreateParams(var Params: TCreateParams); override;
    function CanChange: Boolean; dynamic;
    function CanShowPage(PageIndex: Integer): Boolean; virtual;
    function GetPageAt(X, Y: integer): TDCCustomPage;
    procedure Change; dynamic;
    procedure Loaded; override;
    procedure TabsChanged; virtual;
    procedure UpdateTabSize; virtual;
    procedure UpdatePage(Page: TDCCustomPage); virtual;
    function GetCurrentPageRect: TRect; virtual;
    function GetTabRect(AIndex: integer; Page: TDCCustomPage;
      var ARect: TRect): TRect; virtual;
    function GetTabsRect: TRect; virtual;
    procedure DrawBorder(ACanvas: TCanvas); virtual;
    procedure DrawTab(ACanvas: TCanvas; ARect: TRect; AIndex: integer;
      APage: TDCCustomPage; var ADefaultDraw: boolean);
    procedure DoDrawTab(ACanvas: TCanvas; ARect: TRect; AIndex: integer;
      APage: TDCCustomPage; AActivePage: boolean); virtual;
    procedure DrawTabsArea(ACanvas: TCanvas); virtual;
    procedure WMEraseBkGnd(var Message: TWMEraseBkGnd); message WM_ERASEBKGND;
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure CMDesignHitTest(var Message: TCMDesignHitTest); message CM_DESIGNHITTEST;
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure CMDialogKey(var Message: TCMDialogKey); message CM_DIALOGKEY;
    procedure ShowControl(AControl: TControl); override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    property PageIndex: integer read GetPageIndex write SetPageIndex;
    property TabsRect: TRect read FTabsRect;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
    function FindNextPage(APage: TDCCustomPage;
      GoForward, CheckTabVisible: Boolean): TDCCustomPage;
    procedure SelectNextPage(GoForward: Boolean);
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    property PageCount: Integer read GetPageCount;
    property Pages[Index: Integer]: TDCCustomPage read GetPage;
  published
    property Align;
    property Color stored True default clBtnFace;
    property Enabled;
    property Font;
    property Visible;
    property PopupMenu;
    property TabStop;
    property ActivePage: TDCCustomPage read FActivePage write SetActivePage;
    property TabVisible: boolean read FTabVisible write SetTabVisible default True;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property OnChanging: TChangingEvent read FOnChanging write FOnChanging;
    property OnDrawTab: TDrawTabEvent read FOnDrawTab write FOnDrawTab;
    property Images: TImageList read FImages write SetImages;
  end;

  {TDCPageControl}
  TDCPageControl = class(TDCCustomPageControl)
  private
    FTabSize: TPoint;
    FTabMargins: TRect;
    FItemMargins: TRect;
    FTabPosition: TLiteTabPosition;
    FDrawStyle: TControlStyle;
    FTabHeight: integer;
    FItemHeight: integer;
    FPrevTrack, FNextTrack: TDCEditButton;
    FMouseDown: boolean;
    FTimer: boolean;
    FCanvasLocked: boolean;
    FRedrawTabs: boolean;
    FChangedPage: TDCCustomPage;
    FPageSelected: boolean;
    procedure SetTabHeight(const Value: integer);
    procedure SetTabWidth(const Value: integer);
    function ControlRect: TRect;
    procedure SetDrawStyle(const Value: TControlStyle);
    procedure SetTabPosition(const Value: TLiteTabPosition); virtual;
    procedure ButtonsUp(Sender: TObject);
    procedure ButtonsDown(Sender: TObject);
    procedure PaintTracks;
    procedure UpdateTracksState(X, Y: integer; lMove: boolean);
    procedure HideTrack(Track: TDCEditButton);
    procedure UpdateTabs;
    procedure CheckToNextTrack;
    procedure CheckToPrevTrack;
    procedure ClearSelection;
    procedure UpdateFirstIndex;
    procedure ChangeActivePage(Page: TDCCustomPage); override;
    procedure RedrawTab(Page: TDCCustomPage);
  protected
    procedure CreateWnd; override;
    procedure Loaded; override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonDblClk(var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
    procedure WMLButtonUp(var Message: TWMLButtonUp); message WM_LBUTTONUP;
    procedure WMMouseMove(var Message: TWMMouseMove); message WM_MOUSEMOVE;
    procedure WMSize(var Message: TMessage); message WM_SIZE;
    procedure WMTimer(var Message: TWMTimer); message WM_TIMER;
    procedure WMKillFocus(var Message: TWMKillFocus); message WM_KILLFOCUS;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SETFOCUS;
    procedure CMRedrawTab(var Message: TMessage); message CM_REDRAWTAB;
    procedure UpdateTabSize; override;
    function GetCurrentPageRect: TRect; override;
    function GetTabRect(AIndex: integer; Page: TDCCustomPage;
      var ARect: TRect): TRect; override;
    function GetTabsRect: TRect; override;
    procedure DrawBorder(ACanvas: TCanvas); override;
    procedure DoDrawTab(ACanvas: TCanvas; ARect: TRect; AIndex: integer;
      APage: TDCCustomPage; AActivePage: boolean); override;
    procedure DrawTabText(ACanvas: TCanvas; ARect: TRect; AIndex: integer;
      APage: TDCCustomPage; AActivePage: boolean);
    procedure DrawTabsArea(ACanvas: TCanvas); override;
    function CanChange: Boolean; override;
    procedure CreateTracks; virtual;
    procedure UpdateTracksPos; virtual;
    procedure TabsChanged; override;
  public
    constructor Create(AComponent: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
  published
    property TabHeight: integer read FTabSize.Y write SetTabHeight;
    property TabWidth: integer read FTabSize.X write SetTabWidth;
    property DrawStyle: TControlStyle read FDrawStyle write SetDrawStyle;
    property TabPosition: TLiteTabPosition read FTabPosition write SetTabPosition;
    property DragKind;
    property DragMode;
    {$IFDEF DELPHI_V5}
    property OnContextPopup;
    {$ENDIF}
    property OnDockDrop;
    property OnDockOver;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnGetSiteInfo;
    property OnResize;
    property OnStartDock;
    property OnStartDrag;
    property OnUnDock;
  end;

  {TDCOutBar}

  TImagesStyle     = (isSmallImages, isLargeImages);
  TOutPanelOption  = (opDropDown, opItemMove);
  TOutPanelOptions = set of TOutPanelOption;

  TDCCustomOutBarPanel = class(TDCCustomPage)
  private
    FButtons: TDCEditButtons;
    FLargeImages: TImageList;
    FSmallImages: TImageList;
    FOnMouseEnter: TNotifyEvent;
    FOnMouseLeave: TNotifyEvent;
    FStyle: TImagesStyle;
    FFirstIndex: integer;
    FPrevTrack, FNextTrack: TDCEditButton;
    FMouseDown: boolean;
    FTimer: boolean;
    FRegionDC: HDC;
    FOptions: TOutPanelOptions;
    FClear: boolean;
    FAnchorStyle: TAnchorStyle;
    FImageChangeLink: TChangeLink;
    FOnItemClick: TNotifyEvent;
    FHintObject: TObject;
    FCanvasLocked: boolean;
    FOnGetItemPopup: TGetItemPopup;
    procedure SetLargeImages(const Value: TImageList);
    procedure SetSmallImages(const Value: TImageList);
    procedure SetStyle(const Value: TImagesStyle);
    procedure CheckArea(Sender: TObject; X, Y: integer; var Selected: boolean);
    procedure SetButtonState(Sender: TObject; var State: TButtonState); virtual;
    procedure UpdateTracksState(X, Y: integer; lMove: boolean);
    procedure PaintTracks;
    procedure GetButtonsRegion(Sender: TObject; var Rgn: HRGN);
    procedure ButtonsUp(Sender: TObject);
    procedure ButtonsDown(Sender: TObject);
    procedure HideTrack(Track: TDCEditButton);
    procedure CheckToNextTrack;
    procedure CheckToPrevTrack;
    function GetActiveButton: TDCEditButton;
    procedure SetOptions(const Value: TOutPanelOptions);
    procedure SetDropDown(const Value: boolean);
    procedure SetFirstIndex(const Value: integer);
    procedure SetActiveButton(Value: TDCEditButton);
    procedure ImageListChange(Sender: TObject);
  protected
    procedure CreateWnd; override;
    function GetPopupMenu: TPopupMenu; override;
    procedure Loaded; override;
    procedure DrawButtonHint(Sender: TObject; Mode: integer); virtual;
    function FormatText(const Value: string; Offset: integer;
      var TextSize: TPoint): string;
    function DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMColorChanged(var Message: TMessage); message CM_COLORCHANGED;
    procedure CMHintShow(var Message: TCMHintShow); message CM_HINTSHOW;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure WMKillFocus(var Message: TWMKillFocus); message WM_KILLFOCUS;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonDblClk(var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
    procedure WMLButtonUp(var Message: TWMLButtonUp); message WM_LBUTTONUP;
    procedure WMMouseMove(var Message: TWMMouseMove); message WM_MOUSEMOVE;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMTimer(var Message: TWMTimer); message WM_TIMER;
    function ButtonVisible(Button: TDCEditButton): boolean; virtual;
    function TracksCovering: boolean; virtual;
    procedure CreateTracks; virtual;
    procedure UpdateTracksPos; virtual;
    procedure SetButtonPos(Index: integer); virtual;
    procedure ItemClick(Sender: TObject); virtual;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    property LargeImages: TImageList read FLargeImages write SetLargeImages;
    property SmallImages: TImageList read FSmallImages write SetSmallImages;
    property Style: TImagesStyle read FStyle write SetStyle;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function AddButton: TDCEditButton; virtual;
    procedure DeleteButton(Index: integer);
    procedure Paint; override;
    procedure UpdateButtonsPos;
    procedure SelectItem(Button: TDCEditButton);
    property Buttons: TDCEditButtons read FButtons write FButtons stored False;
    property ActiveButton: TDCEditButton read GetActiveButton write SetActiveButton;
  published
    property Items: TDCEditButtons read FButtons write FButtons;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseLeave: TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
    property OnItemClick: TNotifyEvent read FOnItemClick write FOnItemClick;
    property FirstIndex: integer read FFirstIndex write SetFirstIndex;
    property Options: TOutPanelOptions read FOptions write SetOptions;
    property OnGetItemPopup: TGetItemPopup read FOnGetItemPopup write FOnGetItemPopup;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

  TDCOutBarPanel = class(TDCCustomOutBarPanel)
  published
    property LargeImages;
    property SmallImages;
    property Style;
    property OnDblClick;
    property OnClick;
    property ImageIndex;
    {$IFDEF DELPHI_V5}
    property OnContextPopup;
    {$ENDIF}
  end;

  TDCOutBar = class(TDCCustomPageControl)
  private
    FTabHeight: integer;
    FItemHeight: integer;
    FTabSize: TPoint;
    FTabMargins: TRect;
    FMode: TOutBarMode;
    function ControlRect: TRect;
    procedure SetTabHeight(const Value: integer);
  protected
    procedure CreateWnd; override;
    procedure Loaded; override;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure WMMouseMove(var Message: TWMMouseMove); message WM_MOUSEMOVE;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMTimer(var Message: TWMTimer); message WM_TIMER;
    function GetCurrentPageRect: TRect; override;
    function GetTabRect(AIndex: integer; Page: TDCCustomPage;
      var ARect: TRect): TRect; override;
    procedure UpdateTabSize; override;
    function GetTabsRect: TRect; override;
    procedure DrawBorder(ACanvas: TCanvas); override;
    procedure DoDrawTab(ACanvas: TCanvas; ARect: TRect; AIndex: integer;
      APage: TDCCustomPage; AActivePage: boolean); override;
    procedure DrawTabsArea(ACanvas: TCanvas); override;
    procedure TabsChanged; override;
  public
    constructor Create(AComponent: TComponent); override;
    procedure Paint; override;
  published
    property TabHeight: integer read FTabSize.Y write SetTabHeight;
  end;

  TDCPaleteBarPanel = class(TDCCustomOutBarPanel)
  private
    FDrawText: boolean;
    FIconStyle: boolean;
    procedure UpdateButtonsVisible;
    function GetImages: TImageList;
    procedure SetImages(const Value: TImageList);
    procedure SetDrawText(const Value: boolean);
    procedure SetIconStyle(const Value: boolean);
  protected
    procedure Loaded; override;
    procedure Click; override;
    procedure DblClick; override;
    procedure CreateTracks; override;
    function ButtonVisible(Button: TDCEditButton): boolean; override;
    function TracksCovering: boolean; override;
    procedure UpdateTracksPos; override;
    procedure SetButtonPos(Index: integer); override;
    procedure ItemClick(Sender: TObject); override;
    procedure CMColorChanged(var Message: TMessage); message CM_COLORCHANGED;
    procedure CMHintShow(var Message: TCMHintShow); message CM_HINTSHOW;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    property LargeImages;
    property SmallImages;
    property Style;
  public
    constructor Create(AOwner: TComponent); override;
    function AddButton: TDCEditButton; override;
  published
    property ImageIndex;
    property Images: TImageList read GetImages write SetImages;
    property DrawText: boolean read FDrawText write SetDrawText;
    property IconStyle: boolean read FIconStyle write SetIconStyle;
  end;

  TDCPaleteBar = class(TDCPageControl)
  private
    FButtons: TDCEditButtons;
    FCancelExist: boolean;
    FCancelSize: integer;
    procedure AddCancelButton;
    procedure SetCancelButtonBounds(Repaint: boolean = True);
    procedure CancelButtonClick(Sender: TObject);
    procedure SetImages(const Value: TImageList); override;
    procedure SetButtonState(Sender: TObject; var State: TButtonState); virtual;
    procedure SetTabPosition(const Value: TLiteTabPosition); override;
    procedure SetTabVisible(const Value: boolean); override;
    procedure RepaintFreeArea;
    procedure ImageListChange(Sender: TObject); override;
    procedure InsertPage(Page: TDCCustomPage); override;
    procedure RemovePage(Page: TDCCustomPage); override;
    function GetSelectedItem: TDCEditButton;
    procedure SetCancelExist(const Value: boolean);
    procedure SetCancelSize(const Value: integer);
  protected
    procedure UpdateTabSize; override;
    function GetCurrentPageRect: TRect; override;
    procedure SetActivePage(const Value: TDCCustomPage); override;
    procedure CMColorChanged(var Message: TMessage); message CM_COLORCHANGED;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
  public
    constructor Create(AComponent: TComponent); override;
    destructor Destroy; override;
    procedure CreateWnd; override;
    procedure AdjustClientRect(var Rect: TRect); override;
    procedure Cancel;
    property SelectedItem: TDCEditButton read GetSelectedItem;
  published
    property Images;
    property OnClick;
    property OnDblClick;
    property CancelExist: boolean read FCancelExist write SetCancelExist default False;
    property CancelSize: integer read FCancelSize write SetCancelSize;
  end;

implementation
uses DCResource;

const
  BTN_CLOSE_WIDTH  = 16;
  BTN_CLOSE_HEIGHT = 16;

  OBMTIMER_IDEVENT = $B0;
  CTRTIMER_IDEVENT = $B1;
  PNLTIMER_IDEVENT = $B2;


var
  DrawBitmap: TBitmap;

procedure CreateDrawBitmap;
begin
  DrawBitmap := TBitmap.Create;
end;

procedure ReleaseDrawBitmap;
begin
  DrawBitmap.Free;
end;

{ TDCCustomLabel }

procedure TDCCustomLabel.AdjustBounds;
 var
  P: TPoint;
begin
  if AutoSize then
  begin
    Canvas.Brush.Color := Self.Color;
    Canvas.Font.Assign(Self.Font);
    P := DrawHighLightText(Canvas, PChar(Caption), Rect(0,0,ClientWidth, ClientHeight), 0,
          DT_END_ELLIPSIS, FImages);
    SetBounds(Left, Top, P.X, P.Y);
  end;
end;

procedure TDCCustomLabel.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseEnter) then FOnMouseEnter(Self);
end;

procedure TDCCustomLabel.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseLeave) then FOnMouseLeave(Self);
end;

constructor TDCCustomLabel.Create(AOwner: TComponent);
begin
  inherited;
  AutoSize := False;
  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;
end;

destructor TDCCustomLabel.Destroy;
begin
  FImageChangeLink.Free;
  inherited;
end;

function TDCCustomLabel.GetDBObject: TDCDBObject;
begin
  Result := FDBObject;
end;

procedure TDCCustomLabel.ImageListChange(Sender: TObject);
begin
  Invalidate;
end;

procedure TDCCustomLabel.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) then
  begin
    if (AComponent = FImages) then
    begin
      FImages := nil;
      Invalidate;
      Exit;
    end;
  end;
end;

procedure TDCCustomLabel.Paint;
 var
  R: TRect;
  P: TPoint;

  procedure DoDrawText(ARect: TRect; AText: string);
  begin
    if not Enabled then
    begin
      OffsetRect(ARect, 1, 1);
      Canvas.Font.Color := clBtnHighlight;
      DrawHighLightText(Canvas, PChar(AText), ARect, 1, DT_END_ELLIPSIS, FImages);
      OffsetRect(ARect, -1, -1);
      Canvas.Font.Color := clBtnShadow;
      DrawHighLightText(Canvas, PChar(AText), ARect, 1, DT_END_ELLIPSIS, FImages);
    end
    else
      DrawHighLightText(Canvas, PChar(AText), ARect, 1, DT_END_ELLIPSIS, FImages);
  end;

begin
  with Canvas do
  begin
    Font := Self.Font;
    Brush.Color := Self.Color;
    if Transparent then
      SetBkMode(Handle, Integer(TRANSPARENT))
    else begin
      SetBkMode(Handle, Integer(OPAQUE));
      Brush.Style := bsSolid;
      FillRect(ClientRect);
    end;
  end;
  R := Rect(0,0,ClientWidth, ClientHeight);
  case Alignment of
    taCenter      :
      begin
        P := DrawHighLightText(Canvas, PChar(Caption), R, 0, DT_END_ELLIPSIS,
          FImages);
        R.Left  := (ClientWidth - P.X) shr 1;
        R.Right := R.Left + P.X;
        DoDrawText(R, Caption);
      end;
    taLeftJustify :
       DoDrawText(R, Caption);
    taRightJustify:
      begin
        P := DrawHighLightText(Canvas, PChar(Caption), R, 0, DT_END_ELLIPSIS,
          FImages);
        R.Left  := ClientWidth - P.X;
        R.Right := R.Left + P.X;
        DoDrawText(R, Caption);
      end;
  end;
end;

procedure TDCCustomLabel.SetDBObject(const Value: TDCDBObject);
begin
  FDBObject.Assign(Value);
end;

procedure TDCCustomLabel.SetImages(const Value: TImageList);
begin
  if Images <> nil then
    Images.UnRegisterChanges(FImageChangeLink);
  FImages := Value;
  if Images <> nil then
  begin
    Images.RegisterChanges(FImageChangeLink);
    Images.FreeNotification(Self);
  end;
end;

{ TDCCustomPanel }

procedure TDCCustomPanel.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseEnter) then FOnMouseEnter(Self);
end;

procedure TDCCustomPanel.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseLeave) then FOnMouseLeave(Self);
end;

constructor TDCCustomPanel.Create(AOwner: TComponent);
begin
  inherited;
  FVertCentered  := True;
  FMargins:= Rect(0,0,0,0);
  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;
end;

destructor TDCCustomPanel.Destroy;
begin
  FImageChangeLink.Free;
  inherited;
end;

function TDCCustomPanel.GetRectOffset: TRect;
begin
  Result := FMargins;
end;

procedure TDCCustomPanel.ImageListChange(Sender: TObject);
begin
  Invalidate;
end;

procedure TDCCustomPanel.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) then
  begin
    if (AComponent = FBrushImage) then
    begin
      FBrushImage := nil;
      Invalidate;
      Exit;
    end;
    if (AComponent = FImages) then
    begin
      FImages := nil;
      Invalidate;
      Exit;
    end;
  end;
end;

procedure TDCCustomPanel.Paint;
 var
  Offset, Rect: TRect;
  TopColor, BottomColor: TColor;
  P: TPoint;

  procedure AdjustColors(Bevel: TPanelBevel);
  begin
    if Bevel = bvLowered then TopColor := clBtnShadow
    else TopColor := clBtnHighlight;
    if Bevel = bvLowered then BottomColor := clBtnHighlight
    else BottomColor := clBtnShadow;
  end;

begin
  CreateDrawBitmap;
  Rect := GetClientRect;
  with DrawBitmap do
  begin
    Height := Rect.Bottom-Rect.Top;
    Width  := Rect.Right-Rect.Left;
    if BevelOuter <> bvNone then
    begin
      AdjustColors(BevelOuter);
      Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
    end;
    Frame3D(Canvas, Rect, Color, Color, BorderWidth);
    if BevelInner <> bvNone then
    begin
      AdjustColors(BevelInner);
      Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
    end;
    with Canvas do
    begin
      Brush.Style := bsSolid;
      if Assigned(FBrushImage) then
        Brush.Bitmap := FBrushImage.Picture.Bitmap
      else
        Brush.Color := Color;
      Font := Self.Font;
      SetBkMode(Handle, Integer(TRANSPARENT));
      FillRect(Rect);
    end;
    Offset := GetRectOffset;
    InflateRect(Rect, -1, 0);
    Rect.Left   := Rect.Left   + Offset.Left;
    Rect.Top    := Rect.Top    + Offset.Top;
    Rect.Right  := Rect.Right  - Offset.Right;
    Rect.Bottom := Rect.Bottom - Offset.Bottom;

    P := Point(0,0);

    if FVertCentered then
    begin
      P := DrawHighLightText(Canvas, PChar(Caption), Rect, 0, DT_END_ELLIPSIS,
        FImages);
      Rect.Top := (ClientHeight - P.Y) div 2;
    end;

    case Alignment of
      taCenter      :
        begin
          if (P.X=0) and (P.Y=0) then
             P := DrawHighLightText(Canvas, PChar(Caption), Rect, 0,
               DT_END_ELLIPSIS, FImages);
          if P.X < (ClientWidth-Offset.Left-Offset.Right) then
          begin
            Rect.Left  := Offset.Left+((ClientWidth-Offset.Left-Offset.Right-P.X) div 2);
            Rect.Right := Rect.Left + P.X;
          end;
          DrawHighLightText(Canvas, PChar(Caption), Rect, 1, DT_END_ELLIPSIS,
            FImages);
        end;
      taLeftJustify :
        DrawHighLightText(Canvas, PChar(Caption), Rect, 1, DT_END_ELLIPSIS,
          FImages);
      taRightJustify:
        begin
          if (P.X=0) and (P.Y=0) then
             P := DrawHighLightText(Canvas, PChar(Caption), Rect, 0,
               DT_END_ELLIPSIS, FImages);
          Rect.Right := ClientWidth - Offset.Right;
          Rect.Left  := Offset.Left + Rect.Right - P.X;
          if Rect.Left < Offset.Left then Rect.Left := Offset.Left;
          DrawHighLightText(Canvas, PChar(Caption), Rect, 1, DT_END_ELLIPSIS,
            FImages);
        end;
    end;
  end;
  Canvas.Draw(0, 0, DrawBitmap);
  ReleaseDrawBitmap;
end;

procedure TDCCustomPanel.SetBrushImage(const Value: TImage);
begin
  FBrushImage := Value;
  Invalidate;
  if Value <> nil then Value.FreeNotification(Self);
end;

procedure TDCCustomPanel.SetImages(const Value: TImageList);
begin
  if Images <> nil then
    Images.UnRegisterChanges(FImageChangeLink);
  FImages := Value;
  if Images <> nil then
  begin
    Images.RegisterChanges(FImageChangeLink);
    Images.FreeNotification(Self);
  end;
end;

procedure TDCCustomPanel.SetMargins(Left, Top, Right, Bottom: integer);
begin
  if Left   > 0 then FMargins.Left  := Left;
  if Top    > 0 then FMargins.Top   := Top;
  if Right  > 0 then FMargins.Right := Right;
  if Bottom > 0 then FMargins.Bottom:= Bottom;
  Invalidate;
end;

procedure TDCCustomPanel.SetVertCentered(const Value: boolean);
begin
  FVertCentered := Value;
  Invalidate;
end;

procedure TDCCustomPanel.WMEraseBkGnd(var Message: TWMEraseBkGnd);
begin
  Message.Result := 0;
end;

{ TDCCustomHeaderPanel }

procedure TDCCustomHeaderPanel.AddCloseButton;
begin
  with FButtons, FButtons.AddButton do
  begin
    Name := '$Close$';
    Allignment := abCentr;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNCLOSE');
    Font  := Self.Font;
    Style := stShadowFlat;
    AbsolutePos  := False;
    DisableStyle := deNormal;
    BrushColor   := Color;
    DrawText     := False;
    OnClick      := CloseButtonClick;
    if FButtonAllign then
    begin
      SetBounds(Rect(Self.Width - (BTN_CLOSE_WIDTH + 2),
        (Self.Height - BTN_CLOSE_HEIGHT) div 2, BTN_CLOSE_WIDTH, BTN_CLOSE_HEIGHT));
      AnchorStyle  := asCnR;
    end
    else begin
      SetBounds(Rect(Self.Width - (BTN_CLOSE_WIDTH + 2),
        2, BTN_CLOSE_WIDTH, BTN_CLOSE_HEIGHT));
      AnchorStyle  := asTR;
    end;
  end;
end;

procedure TDCCustomHeaderPanel.CloseButtonClick(Sender: TObject);
begin
  if Assigned(FOnCloseButtonClick) then FOnCloseButtonClick(Self)
end;

procedure TDCCustomHeaderPanel.CMCancelMode(var Message: TCMCancelMode);
  var
   Pos: TPoint;
   Button: TDCEditButton;
begin
  if Message.Sender = Self then
  begin
    GetCursorPos(Pos);
    with FButtons do
      if not MouseInButtonArea(Pos.X, Pos.Y, Button) then ResetProperties;
  end
  else
    FButtons.ResetProperties;
  inherited;
end;

procedure TDCCustomHeaderPanel.CMColorChanged(var Message: TMessage);
begin
  inherited;
  if Assigned(FButtons) then
  begin
    FButtons.Color := Color;
    if HandleAllocated then
    begin
      FillNCArea;
      FButtons.Invalidate;
    end;
  end;
end;

procedure TDCCustomHeaderPanel.CMDialogChar(var Message: TCMDialogChar);
 var
  Button: TDCEditButton;
begin
  with Message do
  begin
    if Buttons.IsButtonAccel(Message.CharCode, Button) then
    begin
      Result := 1;
      Button.Click;
    end
    else
      inherited;
  end;    
end;

procedure TDCCustomHeaderPanel.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  FButtons.MouseDown := GetAsyncKeyState(VK_LBUTTON)<0;
end;

procedure TDCCustomHeaderPanel.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  FButtons.UpdateButtons( -1, -1, False, True);
end;

constructor TDCCustomHeaderPanel.Create(AOwner: TComponent);
begin
  inherited;
  FButtons := TDCEditButtons.Create(Self);
  FButtons.AnchorStyle := asNone;
  FClosed  := True;

  Height   := BTN_CLOSE_HEIGHT+4;
  Align    := alTop;
  Color    := clBtnShadow;
  Alignment:= taLeftJustify;

  BorderWidth:= 2;
  BevelOuter := bvNone;

  FButtons.Color := Color;
end;

procedure TDCCustomHeaderPanel.CreateWnd;
begin
  inherited;
  if Parent <> nil then
  begin
    FButtons.ClrWndProc;
    FButtons.SetWndProc;
    if FClosed then begin
      AddCloseButton;
      MoveWindow(Handle, Left, Top, Width, Height, False);
    end;
  end;
end;

procedure TDCCustomHeaderPanel.DelCloseButton;
 var
  CloseButton: TDCEditButton;
begin
  CloseButton := FButtons.FindButton('$Close$');
  if Assigned(CloseButton) then FButtons.DeleteButton(CloseButton.Index);
end;

destructor TDCCustomHeaderPanel.Destroy;
begin
  FButtons.Free;
  inherited;
end;

procedure TDCCustomHeaderPanel.FillNCArea;
 var
  DC: HDC;
  R: TRect;
  ABrush: HBRUSH;
begin
  if CloseButtonExist then
  begin
    DC := GetWindowDC(Handle);
    try
      GetWindowRect (Handle, R);  OffsetRect (R, -R.Left, -R.Top);
      R.Left := R.Right - BTN_CLOSE_WIDTH - 4;
      ABrush := CreateSolidBrush(ColorToRGB(Color));
      FillRect(DC, R, ABrush);
      DeleteObject(ABrush);
    finally
      ReleaseDC(Handle, DC);
      DeleteDC(DC);
    end;
  end;
end;

function TDCCustomHeaderPanel.GetRectOffset: TRect;
begin
  Result := inherited GetRectOffset;
end;

procedure TDCCustomHeaderPanel.Paint;
begin
  FButtons.UpdateDeviceRegion(Canvas.Handle);
  inherited;
end;

procedure TDCCustomHeaderPanel.SetButtonAllign(const Value: boolean);
begin
  if FButtonAllign <> Value then
  begin
    FButtonAllign := Value;
    if FClosed then
    begin
      SetClosed(False);
      SetClosed(True);
    end;
  end;
end;

procedure TDCCustomHeaderPanel.SetClosed(const Value: boolean);
begin
  if FClosed <> Value then
  begin
    FClosed := Value;
    if not FClosed then DelCloseButton;
    RecreateWnd;
  end;
end;

procedure TDCCustomHeaderPanel.WMKillFocus(var Message: TWMKillFocus);
begin
  FButtons.ResetProperties;
  inherited;
end;

procedure TDCCustomHeaderPanel.WMNCCalcSize(var Message: TWMNCCalcSize);
begin
  inherited;
  if CloseButtonExist and HandleAllocated then
  begin
    Message.CalcSize_Params^.rgrc[0].Right :=
      Message.CalcSize_Params^.rgrc[0].Right - BTN_CLOSE_WIDTH - 4
  end;
end;

procedure TDCCustomHeaderPanel.WMNCHitTest(var Message: TWMNCHitTest);
 var
  Button: TDCEditButton;
begin
  inherited;
  with Message do
  begin
    if FButtons.MouseInButtonArea(XPos - Left, YPos - Top, Button) then
      Result := HTBORDER;
  end;
end;

procedure TDCCustomHeaderPanel.WMNCPaint(var Message: TWMNCPaint);
 var
  DC: HDC;
  R: TRect;
  ABrush: HBRUSH;
begin
  inherited;
  FillNCArea;
end;

{ TDCCustomOutBarPanel }

function TDCCustomOutBarPanel.AddButton: TDCEditButton;
begin
  Result := Buttons.AddButton;
  with Result do
  begin
    case FStyle of
      isSmallImages: Allignment   := abLeft;
      isLargeImages: Allignment   := abImageTop;
    end;
    Name         := Format('%s%d',['EditButton', Index]);
    ImageIndex   := Index;
    Caption      := Name;
    Style        := stOutBar;
    Font         := Self.Font;
    BrushColor   := Self.Color;
    AbsolutePos  := False;
    Grouped      := True;
    AnchorStyle  := FAnchorStyle;
    DisableStyle := deNone;
    if opDropDown in FOptions then
      EventStyle := esDropDown
    else
      EventStyle := esNormal;
    OnCheckArea  := CheckArea;
    OnClick      := ItemClick;
    SetButtonPos(Index);
    ResetOnExitControl := False;
  end;
end;

procedure TDCCustomOutBarPanel.ButtonsDown;
begin
  if FFirstIndex = 0 then Exit;
  FFirstIndex := FFirstIndex - 1;
  UpdateButtonsPos;
end;

procedure TDCCustomOutBarPanel.ButtonsUp;
begin
  FFirstIndex := FFirstIndex + 1;
  UpdateButtonsPos;
end;

procedure TDCCustomOutBarPanel.CheckArea(Sender: TObject; X, Y: integer;
  var Selected: boolean);
 var
  TextRect, ImageRect: TRect;
  P: TPoint;
begin
  with Sender as TDCEditButton do
  begin
    if Visible and (EventStyle <> esDropDown) then
    begin
      ImageRect := GetImageRect;
      TextRect  := GetTextRect(ImageRect);
      InflateRect(ImageRect, 2, 2);
      P := Point(ImageRect.Left, ImageRect.Right);
      if TextRect.Left  < P.X then P.X := TextRect.Left;
      if TextRect.Right > P.Y then P.Y := TextRect.Right;
      Selected := PtInRect(Rect(Left+P.X,Top,Left+P.Y,Top+Height), Point(X,Y));
    end;
  end;
  if FTimer then Selected := False;
  if Selected and FNextTrack.Visible then
    Selected := not PtInRect(FNextTrack.GetBounds, Point(X,Y));
  if Selected and FPrevTrack.Visible then
    Selected := not PtInRect(FPrevTrack.GetBounds, Point(X,Y));
end;

procedure TDCCustomOutBarPanel.CheckToNextTrack;
 var
  Button: TDCEditButton;
begin
  with Buttons do
    if Count > 0 then
    begin
      Button := Buttons[Count-1];
      with Button do
      begin
        if FNextTrack.Visible then
        begin
          if ButtonVisible(Button) or TracksCovering then HideTrack(FNextTrack);
        end
        else
          if not ButtonVisible(Button) and not TracksCovering then FNextTrack.Visible := True;
      end
   end
   else HideTrack(FNextTrack);
end;

procedure TDCCustomOutBarPanel.CheckToPrevTrack;
 var 
  AFirstIndex: integer; 
begin
  if FFirstIndex > 0 then
  begin
    AFirstIndex   := FFirstIndex;
    FCanvasLocked := True;
    repeat
      ButtonsDown(Self);
      if FNextTrack.Visible then
      begin
        ButtonsUp(Self);
        break;
      end;
    until (FFirstIndex = 0);
    FCanvasLocked := False;
    if FFirstIndex <> AFirstIndex then invalidate;
  end;
end;

procedure TDCCustomOutBarPanel.CMCancelMode(var Message: TCMCancelMode);
begin
  FButtons.ResetProperties;
  inherited;
end;

procedure TDCCustomOutBarPanel.CMColorChanged(var Message: TMessage);
begin
  inherited;
  Buttons.Color := Color;
  if (FPageControl <> nil) and (FPageControl.HandleAllocated) then
    FPageControl.Invalidate;
  Invalidate;
end;

procedure TDCCustomOutBarPanel.CMFontChanged(var Message: TMessage);
 var
  i: integer;
begin
  inherited;
  Canvas.Font := Font;
  for i := 0 to FButtons.Count-1 do
    FButtons.Buttons[i].Font := Font;
  UpdateButtonsPos;  
end;

procedure TDCCustomOutBarPanel.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseEnter) then FOnMouseEnter(Self);
  FButtons.MouseDown  := GetAsyncKeyState(VK_LBUTTON)<0;
end;

procedure TDCCustomOutBarPanel.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if Assigned(FOnMouseLeave) then FOnMouseLeave(Self);
  FButtons.UpdateButtons( -1, -1, False, True);
  FPrevTrack.UpdateButtonState(-1, -1, False, True);
  FNextTrack.UpdateButtonState(-1, -1, False, True);
end;

constructor TDCCustomOutBarPanel.Create(AOwner: TComponent);
begin
  inherited;
  FButtons := TDCEditButtons.Create(Self);
  FButtons.OnGetRegion   := GetButtonsRegion;
  FButtons.PaintOnSizing := False;

  ControlStyle := [csCaptureMouse, csClickEvents, {csOpaque,} csDoubleClicks,
    csReplicatable];
  Width       := 80;
  Height      := 150;

  FFirstIndex := 0;
  FMouseDown  := False;
  FTimer      := False;
  FClear      := False;
  FStyle      := isLargeImages;
  FAnchorStyle:= asTLR;

  FRegionDC := CreateDC('DISPLAY', NIL, NIL, NIL);
  CreateTracks;

  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;

  FHintObject   := nil;
  FCanvasLocked := False;
end;

procedure TDCCustomOutBarPanel.CreateTracks;
begin
  FPrevTrack:= TDCEditButton.Create(Self);
  with FPrevTrack do
  begin
    Visible := False;
    Width   := 15;
    Height  := 13;
    DrawText:= False;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNUP');
    BrushColor := clBtnFace;
    OnClick := ButtonsDown;
  end;

  FNextTrack:= TDCEditButton.Create(Self);
  with FNextTrack do
  begin
    Visible := False;
    Width   := 15;
    Height  := 13;
    DrawText:= False;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNDOWN');
    BrushColor := clBtnFace;
    OnClick := ButtonsUp;
  end;
end;

procedure TDCCustomOutBarPanel.CreateWnd;
begin
  inherited;
  if Parent <> nil then begin
    FButtons.ClrWndProc;
    FButtons.SetWndProc;
  end;
end;

procedure TDCCustomOutBarPanel.DeleteButton(Index: integer);
begin

end;

destructor TDCCustomOutBarPanel.Destroy;
begin
  if Assigned(FPrevTrack) then
  begin
    FPrevTrack.Free;
    FPrevTrack := nil;
  end;
  if Assigned(FNextTrack) then
  begin
    FNextTrack.Free;
    FNextTrack := nil;
  end;
  FButtons.Free;
  DeleteDC(FRegionDC);
  FImageChangeLink.Free;
  inherited;
end;

procedure TDCCustomOutBarPanel.DrawButtonHint(Sender: TObject; Mode: integer);
begin
  if Application <> nil then
  begin
    Application.CancelHint;
  end;
  case Mode of
    0:{Show}
      FHintObject := Sender;
    1:{Hide}
      FHintObject := nil;
  end;
end;

function TDCCustomOutBarPanel.FormatText(const Value: string; Offset: integer;
  var TextSize: TPoint): string;
 var
  SpacePos, AWidth: integer;
  ASize: TPoint;
  AText, BText, BResult: string;
  ARect: TRect;
  pValue: PChar;
begin

  pValue := PChar(Value);
  Result := '';
  while pValue^ <> #0 do
  begin
    if pValue^ <> #10 then Result := Result + pValue^
    else begin
      if ((pValue+1)^ <> #0) and ((pValue+1)^ <> ' ') then Result := Result +  ' ';
    end;
    Inc(pValue);
  end;

  {
  TextSize := DrawHighLightText(Canvas, PChar(Result), Rect(0,0,0,0), 0,
    DT_END_ELLIPSIS);
  }

  ARect := Rect(0,0, 500, 500);
  Windows.DrawText(Canvas.Handle, PChar(Result), Length(Result), ARect,
     DT_END_ELLIPSIS or DT_CALCRECT);
  TextSize :=  Point(ARect.Right - ARect.Left, ARect.Bottom - ARect.Top);

  AWidth := ClientWidth - (ButtonOffset+Offset+3)*2;
  if (Style = isLargeImages) and (TextSize.X > AWidth) then
  begin
    SpacePos := Pos(' ', Result);
    if SpacePos > 0 then
    begin
      ASize    := Point(0, 0);
      BText    := '';
      repeat
        if BText = '' then
        begin
          BText   := Copy(Result, 1, SpacePos-1);
          BResult := Copy(Result, SpacePos+1, Length(Result)-SpacePos);
          AText   := BText;
          Result  := BResult;
        end
        else begin
          BText   := AText;
          BResult := Result;
          AText   := BText + ' ' + Copy(Result, 1, SpacePos-1);
          Result  := Copy(Result, SpacePos+1, Length(Result)-SpacePos);
        end;
        //ASize    := DrawHighLightText(Canvas, PChar(AText), Rect(0,0,0,0), 0,
        //              DT_END_ELLIPSIS);
        Windows.DrawText(Canvas.Handle, PChar(AText), Length(AText), ARect,
          DT_END_ELLIPSIS or DT_CALCRECT);
        ASize :=  Point(ARect.Right - ARect.Left, ARect.Bottom - ARect.Top);

        SpacePos := Pos(' ', Result);
      until (SpacePos = 0) or (ASize.X > AWidth );


      Result := Format('%s'#10'%s', [BText, BResult]);
      //TextSize := DrawHighLightText(Canvas, PChar(Result), Rect(0,0,0,0), 0,
      //  DT_END_ELLIPSIS);
      Windows.DrawText(Canvas.Handle, PChar(Result), Length(Result), ARect,
        DT_END_ELLIPSIS or DT_CALCRECT);
      TextSize :=  Point(ARect.Right - ARect.Left, ARect.Bottom - ARect.Top);
    end;
  end;
end;

function TDCCustomOutBarPanel.GetActiveButton: TDCEditButton;
begin
  Result := FButtons.ActiveButton;
end;

procedure TDCCustomOutBarPanel.GetButtonsRegion(Sender: TObject;
  var Rgn: HRGN);
begin
  with ClientRect do
    if csDesigning in ComponentState then
      Rgn := CreateRectRgn( 1, 1, ClientWidth-1, ClientHeight-1)
    else
      Rgn := CreateRectRgn( 0, 0, ClientWidth-1, ClientHeight);
  SelectClipRgn(FRegionDC, Rgn);

  if FPrevTrack.Visible then
    with FPrevTrack do
       ExcludeClipRect(FRegionDC, Left, Top, Left+Width, Top+Height);
  if FNextTrack.Visible then
    with FNextTrack do
       ExcludeClipRect(FRegionDC, Left, Top, Left+Width, Top+Height);

  GetClipRgn(FRegionDC, Rgn);
end;

function TDCCustomOutBarPanel.GetPopupMenu: TPopupMenu;
begin
  if (ActiveButton <> nil) and Assigned(FOnGetItemPopup) then
    FOnGetItemPopup(Self, ActiveButton, Result)
  else
    Result := inherited GetPopupMenu;
end;

procedure TDCCustomOutBarPanel.HideTrack(Track: TDCEditButton);
begin
  Track.Visible := False;
  if FTimer then KillTimer(Handle, PNLTIMER_IDEVENT);
end;

procedure TDCCustomOutBarPanel.ItemClick(Sender: TObject);
 var
  i: integer;
begin
  if (opDropDown in FOptions) and (ActiveButton<>nil) then
  with Items do
  begin
    for i := 0 to Count-1 do
      if (Buttons[i].ButtonState <> btRest) and
         (Buttons[i].Grouped)and(Buttons[i].Index <> ActiveButton.Index) then
      begin
        Buttons[i].ButtonState := btRest;
        Buttons[i].Invalidate;
      end;
  end;
  if Assigned(FOnItemClick) then FOnItemClick(Sender);
end;

procedure TDCCustomOutBarPanel.Loaded;
 var
  i: integer;
begin
  inherited;
  for i:= 0 to Items.Count-1 do
  begin
    Items.Buttons[i].OnClick    := ItemClick;
    Items.Buttons[i].OnCheckArea:= CheckArea;
    Items.Buttons[i].OnSetButtonState := SetButtonState;
    Items.Buttons[i].OnDrawHint := DrawButtonHint;
    Items.Buttons[i].DownClick  := True;
    Items.Buttons[i].Font := Font;
    Items.Buttons[i].Highlight := False;
  end;
end;

procedure TDCCustomOutBarPanel.Paint;
begin
  with Canvas do
  begin
    Brush.Color := ColorToRGB(Color);
    Brush.Style := bsSolid;

    if not(csDesigning in ComponentState) then
      FButtons.UpdateDeviceRegion(Handle);

    if FPrevTrack.Visible then
      with FPrevTrack do
         ExcludeClipRect(Handle, Left, Top, Left+Width, Top+Height);
    if FNextTrack.Visible then
      with FNextTrack do
         ExcludeClipRect(Handle, Left, Top, Left+Width, Top+Height);

    FillRect(ClientRect);
    if csDesigning in ComponentState then
    begin
      Canvas.Pen.Color   := clNavy;
      Canvas.Pen.Style   := psDot;
      Canvas.PolyLine([Point(0, 0), Point(0,ClientHeight-1),
                       Point(ClientWidth-1,ClientHeight-1),
                       Point(ClientWidth-1, 0), Point(0,0)]);
    end;
  end;
  PaintTracks;
end;

procedure TDCCustomOutBarPanel.PaintTracks;
begin
  if FPrevTrack.Visible then FPrevTrack.Paint;
  if FNextTrack.Visible then FNextTrack.Paint;
end;

procedure TDCCustomOutBarPanel.SelectItem(Button: TDCEditButton);
  procedure ClearButtonsState;
   var
    AButton: TDCEditButton;
    P: TPoint;
    i: integer;
  begin
    if (opDropDown in FOptions) then
      for i:= 0 to FButtons.Count -1 do
      begin
        AButton :=  FButtons.Buttons[i];
        if AButton.ButtonState = btDownMouseInRect then
        begin
          GetCursorPos(P);
          P := ScreenToClient(P);
          FClear := True;
          if AButton.MouseInRect(P.X, P.Y) then
            AButton.ButtonState := btRestMouseInRect
          else
            AButton.ButtonState := btRest;
          AButton.Invalidate;
          FClear := False;
          Break;
        end;
      end;
  end;
begin
  if Assigned(Button) then
  begin
    ClearButtonsState;
    if (opDropDown in FOptions) then
    begin
      Button.ButtonState := btDownMouseInRect;
      if Button.DownClick then Button.DownButton := True;
      Button.Invalidate;
    end;
    Button.Click;
  end
  else
    ClearButtonsState;
end;

procedure TDCCustomOutBarPanel.SetButtonPos(Index: integer);
 var
  TextSize, Pos: TPoint;
  Button: TDCEditButton;
  AHeight: integer;
begin
  Button := Buttons.Buttons[Index];
  Pos.X  := 2;

  Button.Text := FormatText(Button.Text, Pos.X, TextSize);

  case FStyle of
   isLargeImages:
     AHeight := Button.GetGlyphHeight + TextSize.Y + 6;
   isSmallImages:
     AHeight := Max(TextSize.Y, Button.GetGlyphHeight) + 4
   else
      AHeight := 0;
  end;

  Pos.Y := 1;
  if (opItemMove in FOptions) then Inc(Pos.Y);
  if (opDropDown in FOptions) then Inc(AHeight, 4);

  Button.Left  := Pos.X;
  Button.Height:= AHeight;
  Button.Width := Width - Pos.X*2;
  if Index < FFirstIndex then
  begin
    Button.Top     := 0;
    Button.Height  := 0;
    if not FPrevTrack.Visible then FPrevTrack.Visible := True;
  end
  else begin
    Button.Top     := Pos.Y;
    if (Index > 0) then
      with Buttons.Buttons[Index-1] do Button.Top := Button.Top+(Top+Height);
  end;
end;

procedure TDCCustomOutBarPanel.SetButtonState(Sender: TObject;
  var State: TButtonState);
begin
  if not FClear and (opDropDown in FOptions) and (ActiveButton <> nil) and
    (ActiveButton.Name = TDCEditButton(Sender).Name) and
    (ActiveButton.ButtonState = btDownMouseInRect) then
   State := btDownMouseInRect;
end;

procedure TDCCustomOutBarPanel.SetDropDown(const Value: boolean);
 var
  i: integer;
begin
  for i := 0 to FButtons.Count-1 do
  begin
    if Value then
      FButtons.Items[i].EventStyle := esDropDown
    else
      FButtons.Items[i].EventStyle := esNormal;
  end;
end;

procedure TDCCustomOutBarPanel.SetFirstIndex(const Value: integer);
 var
  AOffset: integer;
begin
  if FFirstIndex <> Value then
  begin
    AOffset := (Value - FFirstIndex) div abs(Value - FFirstIndex);
    while FFirstIndex <> Value do
    begin
      if AOffset > 0 then
         ButtonsUp(Self)
      else
         ButtonsDown(Self);
    end;
  end;
end;

procedure TDCCustomOutBarPanel.SetLargeImages(const Value: TImageList);
begin
  if FLargeImages <> nil then FLargeImages.UnRegisterChanges(FImageChangeLink);
  FLargeImages := Value;
  if FLargeImages <> nil then
  begin
    FLargeImages.RegisterChanges(FImageChangeLink);
    FLargeImages.FreeNotification(Self);
  end;
  if FStyle = isLargeImages then Buttons.Images := Value;
  UpdateButtonsPos;
  UpdateTracksPos;
end;

procedure TDCCustomOutBarPanel.SetOptions(const Value: TOutPanelOptions);
begin
  FOptions := Value;
  SetDropDown(opDropDown in Value);
  UpdateButtonsPos;
  UpdateTracksPos;
end;

procedure TDCCustomOutBarPanel.SetSmallImages(const Value: TImageList);
begin
  if FSmallImages <> nil then FSmallImages.UnRegisterChanges(FImageChangeLink);
  FSmallImages := Value;
  if FSmallImages <> nil then
  begin
    FSmallImages.RegisterChanges(FImageChangeLink);
    FSmallImages.FreeNotification(Self);
  end;
  if FStyle = isSmallImages then Buttons.Images := Value;
  UpdateButtonsPos;
  UpdateTracksPos;
end;

procedure TDCCustomOutBarPanel.SetStyle(const Value: TImagesStyle);
 var
  i: integer;
  Button: TDCEditButton;
begin
  FStyle := Value;
  case FStyle of
    isSmallImages:
      begin
        Buttons.Images := FSmallImages;
        Buttons.PaintOnSizing := True;
        if FSmallImages <> nil then
        begin
          FSmallImages.UnRegisterChanges(FImageChangeLink);
          FSmallImages.RegisterChanges(FImageChangeLink);
        end;
      end;
    isLargeImages:
      begin
        Buttons.Images := FLargeImages;
        Buttons.PaintOnSizing := False;
        if FLargeImages <> nil then
        begin
          FLargeImages.UnRegisterChanges(FImageChangeLink);
          FLargeImages.RegisterChanges(FImageChangeLink);
        end;
      end;
  end;
  for i := 0 to FButtons.Count-1 do
  begin
    Button := Buttons.Buttons[i];
    with Button do
      case FStyle of
        isSmallImages: Allignment := abLeft;
        isLargeImages: Allignment := abImageTop;
      end;
  end;
  UpdateButtonsPos;
end;

function TDCCustomOutBarPanel.TracksCovering: boolean;
begin
  if FPrevTrack.Visible and
    (FNextTrack.Top < (FPrevTrack.Top+FPrevTrack.Height)) then
    Result := True
  else
    Result := False;
end;

procedure TDCCustomOutBarPanel.UpdateButtonsPos;
 var
  i: integer;
  Button: TDCEditButton;
begin
  if not HandleAllocated then Exit;
  if (FFirstIndex = 0) and FPrevTrack.Visible then HideTrack(FPrevTrack);
  if not FCanvasLocked then Invalidate;
  with Buttons do
    if Count > 0 then
    begin
      for i := 0 to Count-1 do
      begin
        Button := Buttons[i];
        SetButtonPos(Button.Index);
      end;
      CheckToNextTrack;
    end
    else
      if FNextTrack.Visible then HideTrack(FNextTrack);
end;

procedure TDCCustomOutBarPanel.UpdateTracksPos;
 var
  lVisible: boolean;
begin
  lVisible := False;
  with FPrevTrack do
  begin
    if Visible then
    begin
      Visible := False; lVisible := True;
    end;
    Left :=  ClientRect.Right-Width-1;
    Top  :=  ClientRect.Top+1;
    if lVisible then
    begin
      Visible := True; lVisible := False;
    end;
  end;

  with FNextTrack do
  begin
    if Visible then
    begin
      Visible := False; lVisible := True;
    end;
    Left :=  ClientRect.Right-Width-1;
    Top  :=  ClientRect.Bottom-Height-1;
    if lVisible and not TracksCovering then Visible := True;
  end;
end;

procedure TDCCustomOutBarPanel.UpdateTracksState(X, Y: integer;
  lMove: boolean);
begin
  FPrevTrack.UpdateButtonState(X, Y, FMouseDown, lMove);
  FNextTrack.UpdateButtonState(X, Y, FMouseDown, lMove);
end;

procedure TDCCustomOutBarPanel.WMKillFocus(var Message: TWMKillFocus);
begin
  FButtons.ResetProperties;
  inherited;
end;

procedure TDCCustomOutBarPanel.WMLButtonDblClk(var Message: TWMLButtonDown);
begin
  inherited;
  FMouseDown := True;
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

  if (FPrevTrack.ButtonState  = btDownMouseInRect) or
     (FNextTrack.ButtonState  = btDownMouseInRect) then
   SetTimer(Handle, PNLTIMER_IDEVENT, 200, nil);
end;

procedure TDCCustomOutBarPanel.WMLButtonDown(var Message: TWMLButtonDown);
begin
  inherited;
  FMouseDown := True;
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

  if (FPrevTrack.ButtonState  = btDownMouseInRect) or
     (FNextTrack.ButtonState  = btDownMouseInRect) then
   SetTimer(Handle, PNLTIMER_IDEVENT, 200, nil);
end;

procedure TDCCustomOutBarPanel.WMLButtonUp(var Message: TWMLButtonUp);
begin
  inherited;
  FMouseDown := False;
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

  KillTimer(Handle, PNLTIMER_IDEVENT);
  FTimer := False;
end;

procedure TDCCustomOutBarPanel.WMMouseMove(var Message: TWMMouseMove);
begin
  inherited;
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, True);
end;

procedure TDCCustomOutBarPanel.WMSize(var Message: TWMSize);
begin
  inherited;
  if not FRemoving then
  begin
    if Style = isLargeImages then UpdateButtonsPos;
    CheckToNextTrack;
    if not FNextTrack.Visible then CheckToPrevTrack;
    UpdateTracksPos;
  end;
end;

procedure TDCCustomOutBarPanel.WMTimer(var Message: TWMTimer);
begin
  FTimer := True;
  if FNextTrack.ButtonState = btDownMouseInRect then ButtonsUp(Self);
  if FPrevTrack.ButtonState = btDownMouseInRect then ButtonsDown(Self);
end;

procedure TDCCustomOutBarPanel.SetActiveButton(Value: TDCEditButton);
begin
  SelectItem(Value);
end;

function TDCCustomOutBarPanel.ButtonVisible(Button: TDCEditButton): boolean;
begin
  with Button do Result := (Top + Height) <= Self.Height;
end;

procedure TDCCustomOutBarPanel.ImageListChange(Sender: TObject);
begin
  Invalidate;
  if not FRemoving then
  begin
    UpdateButtonsPos;
    CheckToNextTrack;
    if not FNextTrack.Visible then CheckToPrevTrack;
    UpdateTracksPos;
  end;
end;

procedure TDCCustomOutBarPanel.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) then
  begin
    if (AComponent = FLargeImages) then
    begin
      FLargeImages := nil;
      Invalidate;
      Exit;
    end;
    if (AComponent = FSmallImages) then
    begin
      FSmallImages := nil;
      Invalidate;
      Exit;
    end;
  end;
end;

procedure TDCCustomOutBarPanel.CMHintShow(var Message: TCMHintShow);
begin
  if FHintObject <> nil then
  begin
    with Message, TDCEditButton(FHintObject) do
    begin
      HintInfo.HintStr := GetShortHint(Hint);
      HintInfo.ReshowTimeout := $7FFFFFFF;
      Result := 0;
    end;
  end
  else
   inherited;
end;

function TDCCustomOutBarPanel.DoMouseWheelDown(Shift: TShiftState;
  MousePos: TPoint): Boolean;
begin
  Result := inherited DoMouseWheelDown(Shift, MousePos);
end;

{ TDCCustomPage }

procedure TDCCustomPage.CMEnabledChanged(var Message: TMessage);
begin
  inherited;
end;

procedure TDCCustomPage.CMFontChanged(var Message: TMessage);
begin
  inherited;
  if Assigned(FPageControl) and FPageVisible then FPageControl.UpdatePage(Self);
end;

procedure TDCCustomPage.CMShowingChanged(var Message: TMessage);
begin
  inherited;
  if Showing then
    DoShow
  else
    DoHide;
end;

procedure TDCCustomPage.CMTextChanged(var Message: TMessage);
begin
  inherited;
  if Assigned(FPageControl) and FPageVisible then FPageControl.UpdatePage(Self);
end;

constructor TDCCustomPage.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := [csCaptureMouse, csClickEvents, {csOpaque,}
                   csDoubleClicks, csAcceptsControls];
  FPageVisible := True;
  FFullVisible := True;
  FRemoving    := False;

  Align := alClient;
end;

procedure TDCCustomPage.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params.WindowClass do
    Style := Style and not (CS_HREDRAW or CS_VREDRAW);
end;

destructor TDCCustomPage.Destroy;
begin
  if FPageControl <> nil then  FPageControl.RemovePage(Self);
  inherited Destroy;
end;

procedure TDCCustomPage.DoHide;
begin
  if Assigned(FOnHide) then FOnHide(Self);
end;

procedure TDCCustomPage.DoShow;
begin
  if Assigned(FOnShow) then FOnShow(Self);
end;

function TDCCustomPage.GetPageIndex: Integer;
begin
  if FPageControl <> nil then
    Result := FPageControl.FPages.IndexOf(Self)
  else
    Result := -1;
end;

procedure TDCCustomPage.Paint;
begin
  with Canvas do
  begin
    Canvas.Brush.Color := Self.Color;
    FillRect(ClientRect);
    if csDesigning in ComponentState then
    begin
      Canvas.Pen.Color   := clNavy;
      Canvas.Pen.Style   := psDot;
      Canvas.PolyLine([Point(0, 0), Point(0, ClientHeight - 1),
                       Point(ClientWidth - 1, ClientHeight - 1),
                       Point(ClientWidth - 1, 0), Point(0, 0)]);
    end;
  end;
end;

procedure TDCCustomPage.ReadState(Reader: TReader);
begin
  inherited ReadState(Reader);
  if Reader.Parent is TDCCustomPageControl then
    PageControl := TDCCustomPageControl(Reader.Parent);
end;

procedure TDCCustomPage.SetImageIndex(const Value: integer);
begin
  if ImageIndex <> Value then
  begin
    FImageIndex := Value;
    if FPageControl <> nil then
    begin
      FPageControl.TabsChanged;
      Invalidate;
    end;  
  end;
end;

procedure TDCCustomPage.SetPageControl(const Value: TDCCustomPageControl);
begin
  if FPageControl <> Value then
  begin
    if FPageControl <> nil then FPageControl.RemovePage(Self);
    Parent := Value;
    if Value <> nil then Value.InsertPage(Self);
  end;
end;

procedure TDCCustomPage.SetPageIndex(const Value: Integer);
 var
  MaxPageIndex: Integer;
begin
  if FPageControl <> nil then
  begin
    MaxPageIndex := FPageControl.FPages.Count - 1;
    if Value > MaxPageIndex then
      raise EListError.CreateFmt(SPageIndexError, [Value, MaxPageIndex]);
    FPageControl.FPages.Move(PageIndex, Value);
    TabOrder := PageIndex;
    with FPageControl do
    begin
      TabsChanged;
      Invalidate;
    end;
  end;
end;

procedure TDCCustomPage.SetPageVisible(const Value: boolean);
begin
  if FPageVisible <> Value then
  begin
    FPageVisible := Value;
    if FPageControl <> nil then
      FPageControl.SetPageVisible(PageIndex, Value);
  end;
end;

procedure TDCCustomPage.UpdatePageShowing;
begin
  SetPageVisible((FPageControl <> nil) and (FPageVisible or (csDesigning in ComponentState)));
end;

procedure TDCCustomPage.WMEraseBkGnd(var Message: TWMEraseBkGnd);
begin
  Message.Result := -1;
end;

procedure TDCCustomPage.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  Message.Result := DLGC_WANTARROWS + DLGC_WANTCHARS;
end;

{ TDCCustomPageControl }

procedure TDCCustomPageControl.AdjustClientRect(var Rect: TRect);
begin
  inherited;
  if FTabVisible then
    Rect := GetCurrentPageRect
  else
  begin
    Rect := ClientRect;
    InflateRect(Rect, -2, -2);
  end;
end;

function TDCCustomPageControl.CanChange: Boolean;
begin
  Result := True;
  if Assigned(FOnChanging) and (ComponentState = []) and (ActivePage <> nil) then
    FOnChanging(Self, Result);
end;

function TDCCustomPageControl.CanShowPage(PageIndex: Integer): Boolean;
 var
  Page: TDCCustomPage;
begin
  Page   := FPages[PageIndex];
  Result := (csDesigning in ComponentState) or
            (Page <> nil) and Page.PageVisible;
end;

procedure TDCCustomPageControl.Change;
begin
  if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TDCCustomPageControl.ChangeActivePage(Page: TDCCustomPage);
var
  ParentForm: TCustomForm;
  ActivePage: TDCCustomPage;
begin
  if (FActivePage <> Page) and CanChange then
  begin
    ParentForm := GetParentForm(Self);
    if (ParentForm <> nil) and (FActivePage <> nil) and
      FActivePage.ContainsControl(ParentForm.ActiveControl) then
    begin
      ParentForm.ActiveControl := FActivePage;
      if ParentForm.ActiveControl <> FActivePage then
        Exit;
    end;

    ActivePage := FActivePage;

    if Page <> nil then
    begin
      Page.BringToFront;
      Page.Visible := True;
      if (ParentForm <> nil) and (FActivePage <> nil) and
        (ParentForm.ActiveControl = FActivePage) then
        if Page.CanFocus then
          ParentForm.ActiveControl := Page else
          ParentForm.ActiveControl := Self;

      FActivePage := Page;
      Realign;
    end
    else
      FActivePage := Page;

    if ActivePage <> nil then ActivePage.Visible := False;

    if (ParentForm <> nil) and (FActivePage <> nil) and
      (ParentForm.ActiveControl = FActivePage) then
      FActivePage.SelectFirst;

    TabsChanged;
    if ComponentState = [] then Change;

  end;
end;

procedure TDCCustomPageControl.CMDialogChar(var Message: TCMDialogChar);
 var
  i: Integer;
begin
  for i := 0 to FPages.Count - 1 do
    if IsAccel(Message.CharCode, TDCCustomPage(FPages[I]).Caption) and
       CanShowPage(i) and CanFocus
    then begin
      Message.Result := 1;
      if CanChange then PageIndex := i;
      Exit;
    end;
  inherited;
end;

constructor TDCCustomPageControl.Create(AOwner: TComponent);
begin
  inherited;
  ControlStyle := [csCaptureMouse, csClickEvents, {csOpaque,} csDoubleClicks];
  FPages := TPageList.Create(Self);

  Self.Align  := alNone;
  FTabVisible := True;

  Width  := 200;
  Height := 100;
  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;

  FFirstIndex   := 0;
  FSelectedPage := nil;
  FBitmap := TBitmap.Create;
  FBuffered := True;
end;

destructor TDCCustomPageControl.Destroy;
 var
  i: integer;
begin
  FBitmap.Free;
  for i := 0 to FPages.Count - 1 do TDCCustomPage(FPages[I]).FPageControl := nil;
  FPages.Free;
  FImageChangeLink.Free;
  inherited;
end;

function TDCCustomPageControl.FindNextPage(APage: TDCCustomPage;
  GoForward, CheckTabVisible: Boolean): TDCCustomPage;
 var
  i, StartIndex: Integer;
begin
  if FPages.Count <> 0 then
  begin
    StartIndex := FPages.IndexOf(APage);
    if StartIndex = -1 then
      if GoForward then StartIndex := FPages.Count - 1 else StartIndex := 0;
    i := StartIndex;
    repeat
      if GoForward then
      begin
        Inc(I);
        if i = FPages.Count then I := 0;
      end else
      begin
        if i = 0 then i := FPages.Count;
        Dec(i);
      end;
      Result := FPages[I];
      if not CheckTabVisible or Result.PageVisible then Exit;
    until i = StartIndex;
  end;
  Result := nil;
end;

function TDCCustomPageControl.GetPage(Index: Integer): TDCCustomPage;
begin
  Result := FPages[Index];
end;

function TDCCustomPageControl.GetTabRect(AIndex: integer; Page: TDCCustomPage;
  var ARect: TRect): TRect;
begin
  {}
end;

function TDCCustomPageControl.GetPageCount: Integer;
begin
  Result := FPages.Count;
end;

function TDCCustomPageControl.GetPageIndex: integer;
begin
  if ActivePage <> nil then
    Result := ActivePage.PageIndex
  else
    Result := -1;
end;

procedure TDCCustomPageControl.InsertPage(Page: TDCCustomPage);
begin
  Page.FPageControl := Self;
  FPages.Add(Page);
  Page.ImageIndex := Page.PageIndex;
  if Page.PageVisible then
  begin
    FPages.AddVisible(Page.PageIndex);
    Page.UpdatePageShowing;
    SetActivePage(Page);
  end
end;

procedure TDCCustomPageControl.Paint;
 var
  ARect: TRect;
begin
  if FBuffered then
  begin
    ARect := TabsRect;
    FBitmap.Width  := ARect.Right  - ARect.Left;
    FBitmap.Height := ARect.Bottom - ARect.Top;
    if (FPages.VisibleCount > 0) or (csDesigning in ComponentState) then
    begin
      DrawTabsArea(FBitmap.Canvas);
    end;
    DrawBorder(Canvas);
    Canvas.Draw(ARect.Left, ARect.Top, FBitmap);
  end
  else begin
    DrawBorder(Canvas);
    if (FPages.VisibleCount > 0) or (csDesigning in ComponentState) then
    begin
      DrawTabsArea(Canvas);
    end;  
  end;
end;

procedure TDCCustomPageControl.RemovePage(Page: TDCCustomPage);
var
  NextPage: TDCCustomPage;
begin
  NextPage := FindNextPage(Page, True, not (csDesigning in ComponentState));
  if NextPage = Page then NextPage := nil;

  Page.FRemoving := True;
  Page.SetPageVisible(False);
  Page.FPageControl := nil;
  FPages.Remove(Page);
  FPages.UpdateVisible;
  SetActivePage(NextPage);
  Invalidate;
end;

procedure TDCCustomPageControl.SelectNextPage(GoForward: Boolean);
var
  Page: TDCCustomPage;
begin
  Page := FindNextPage(ActivePage, GoForward, not(csDesigning in ComponentState));
  if (Page <> nil) and (Page <> ActivePage) and CanChange then ActivePage := Page;
end;

procedure TDCCustomPageControl.SetActivePage(const Value: TDCCustomPage);
begin
  if (Value <> nil) and (Value.PageControl <> Self) then Exit;
  ChangeActivePage(Value);
end;

procedure TDCCustomPageControl.SetPageIndex(const Value: integer);
begin
  ActivePage := FPages[Value];
end;

procedure TDCCustomPageControl.SetPageVisible(APageIndex: integer;
  AVisible: boolean);
begin
  FPages.SetVisible(TDCCustomPage(FPages.Items[APageIndex]), AVisible);
  TabsChanged;
end;

procedure TDCCustomPageControl.UpdatePage(Page: TDCCustomPage);
begin
  TabsChanged;
end;

procedure TDCCustomPageControl.WMSize(var Message: TWMSize);
begin
  inherited;
  Realign;
  UpdateTabsRect;
  RedrawWindow(Handle, nil, 0, RDW_INVALIDATE)
end;

procedure TDCCustomPageControl.DrawTab(ACanvas: TCanvas; ARect: TRect;
  AIndex: integer; APage: TDCCustomPage; var ADefaultDraw: boolean);     
 var
  AActivePage: boolean;
begin
  ADefaultDraw := True;
  AActivePage  := ActivePage.PageIndex = APage.PageIndex;

  if Assigned(FOnDrawTab) then
    FOnDrawTab(Self, AIndex, ARect, AActivePage, ADefaultDraw);

  if ADefaultDraw then DoDrawTab(ACanvas, ARect, AIndex, APage, AActivePage);

  with ARect do
    ExcludeClipRect(ACanvas.Handle, Left, Top, Right, Bottom);

end;

procedure TDCCustomPageControl.DrawTabsArea(ACanvas: TCanvas);
 var
  i, VisibleIndex: integer;
  Page: TDCCustomPage;
  ARect: TRect;
  ADefaultDraw: boolean;
begin
  if FTabVisible then
  begin
    for i := 0 to FPages.Count - 1 do
    begin
      Page := FPages.Items[i];
      VisibleIndex := -1;
      ARect := Rect(0, 0, 0, 0);
      if ARect.Left < FTabsRect.Right then
      begin
        if (csDesigning in ComponentState) then
          VisibleIndex := i
        else
         if Page.PageVisible then VisibleIndex := FPages.VisibleIndexOf(Page.PageIndex);
      end;
      if VisibleIndex <> -1 then
      begin
        ARect := Page.FTabRect;
        if FBuffered then OffsetRect(ARect, -FTabsRect.Left, -FTabsRect.Top);
        DrawTab(ACanvas, ARect, VisibleIndex, Page, ADefaultDraw);
      end
    end;
  end;
end;

function TDCCustomPageControl.GetCurrentPageRect: TRect;
begin
  Result := ClientRect;
end;

function TDCCustomPageControl.GetTabsRect: TRect;
begin
  {}
end;

procedure TDCCustomPageControl.ShowControl(AControl: TControl);
begin
  if (AControl is TDCCustomPage) and (TDCCustomPage(AControl).PageControl = Self) then
    SetActivePage(TDCCustomPage(AControl));
  inherited;
end;

procedure TDCCustomPageControl.DrawBorder(ACanvas: TCanvas);
begin
  {}
end;

procedure TDCCustomPageControl.DoDrawTab(ACanvas: TCanvas; ARect: TRect;
  AIndex: integer; APage: TDCCustomPage; AActivePage: boolean);
begin
  {}
end;

procedure TDCCustomPageControl.TabsChanged;
 var
  Form: TCustomForm;
begin
  if csDesigning in ComponentState then
  begin
    Form := GetParentForm(Self);
    if (Form <> nil) and (Form.Designer <> nil) then Form.Designer.Modified;
  end;
  UpdateTabsRect;
  Realign;
  Invalidate;
end;

function ComparePage(Item1, Item2: Pointer): integer; 
begin
  if TDCCustomPage(Item1).TabOrder < TDCCustomPage(Item2).TabOrder then
    Result := -1
  else
  if TDCCustomPage(Item1).TabOrder = TDCCustomPage(Item2).TabOrder then
    Result := 0
  else
    Result := 1
end;

procedure TDCCustomPageControl.Loaded;
begin
  inherited;
  FPages.Sort(ComparePage);
  FPages.UpdateVisible;
  TabsChanged;

  if not(csDesigning in ComponentState) then
  begin
    if (FPages.VisibleCount > 0) then
    begin
      while (ActivePage = nil) or not(ActivePage.PageVisible) do
        SelectNextPage(True)
    end
    else ActivePage := nil;
  end;
end;

procedure TDCCustomPageControl.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  Message.Result := DLGC_WANTARROWS + DLGC_WANTCHARS;
end;

procedure TDCCustomPageControl.CMDialogKey(var Message: TCMDialogKey);
begin
  if FTabVisible and (Focused or Windows.IsChild(Handle, Windows.GetFocus)) and
    (Message.CharCode = VK_TAB) and (GetKeyState(VK_CONTROL) < 0)
  then begin
    SelectNextPage(GetKeyState(VK_SHIFT) >= 0);
    Message.Result := 1;
  end else
    inherited;
end;

procedure TDCCustomPageControl.CMDesignHitTest(var Message: TCMDesignHitTest);
 var
  Page: TDCCustomPage;
begin
  inherited;
  with Message do
  begin
    Page := GetPageAt(Pos.X, Pos.Y);
    if (Page <> nil) and (Page <> ActivePage) then Result := 1;
  end;
end;

procedure TDCCustomPageControl.WMLButtonDown(var Message: TWMLButtonDown);
 var
  Page: TDCCustomPage;
begin
  Page := GetPageAt(Message.Pos.X, Message.Pos.Y);
  if Page <> nil then
  begin
    SendCancelMode(nil);
    SetActivePage(Page);
  end
  else
    inherited;
end;

function TDCCustomPageControl.GetPageAt(X, Y: integer): TDCCustomPage;
 var
  i: integer;
  Page: TDCCustomPage;
begin
  Result := nil;
  if FTabVisible then
    for i := 0 to FPages.Count-1 do
    begin
      Page := FPages.Items[i];
      if (Page.PageVisible or (csDesigning in ComponentState)) and
         PtInRect(Page.FTabRect, Point(X, Y)) then
      begin
        Result := Page;
        Break;
      end;
    end;
end;

procedure TDCCustomPageControl.SetImages(const Value: TImageList);
begin
  if Images <> nil then
    Images.UnRegisterChanges(FImageChangeLink);
  FImages := Value;
  if Images <> nil then
  begin
    Images.RegisterChanges(FImageChangeLink);
    Images.FreeNotification(Self);
  end;
  UpdateTabSize;
  TabsChanged;
end;

procedure TDCCustomPageControl.SetTabVisible(const Value: boolean);
begin
  if FTabVisible <> Value then
  begin
    FTabVisible := Value;
    TabsChanged;
  end;
end;

procedure TDCCustomPageControl.ImageListChange(Sender: TObject);
begin
  Invalidate;
  RedrawWindow(Handle, nil, 0, RDW_INVALIDATE or RDW_ERASE);
end;

procedure TDCCustomPageControl.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) then
  begin
    if (AComponent = FImages) then
    begin
      FImages := nil;
      Invalidate;
      Exit;
    end;
  end;
end;

procedure TDCCustomPageControl.UpdateTabsRect;
 var
  i, VisibleIndex: integer;
  Page: TDCCustomPage;
  ARect: TRect;
begin
  if FTabVisible then
  begin
    FTabsRect := GetTabsRect;
    ARect     := Rect(0, 0, 0, 0);
    for i := 0 to FPages.Count - 1 do
    begin
      Page := FPages.Items[i];
      VisibleIndex := -1;
      if ARect.Left < FTabsRect.Right then
      begin
        if (csDesigning in ComponentState) then
          VisibleIndex := i
        else
         if Page.PageVisible then VisibleIndex := FPages.VisibleIndexOf(Page.PageIndex);
      end;
      if (VisibleIndex <> -1) and (VisibleIndex >= FFirstIndex) then
      begin
        ARect := GetTabRect(VisibleIndex, Page, ARect);
        Page.FTabRect := ARect;
      end
      else
        SetRectEmpty(Page.FTabRect);
    end;
  end
  else
    SetRectEmpty(FTabsRect);
end;

procedure TDCCustomPageControl.WMEraseBkGnd(var Message: TWMEraseBkGnd);
begin
  Message.Result := -1;
end;

procedure TDCCustomPageControl.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params.WindowClass do
    Style := Style and not (CS_HREDRAW or CS_VREDRAW);
end;

procedure TDCCustomPageControl.UpdateTabSize;
begin
  {}
end;

procedure TDCCustomPageControl.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited;
  if FTabVisible then
  begin
    case Key of
      VK_LEFT:
        SelectNextPage(False);
      VK_RIGHT:
        SelectNextPage(True);
    end
  end;
end;

{ TPageList }

procedure TPageList.AddVisible(AIndex: integer);
 var
  pIndex: ^Integer;
begin
  GetMem(pIndex, SizeOf(Integer));
  pIndex^ := AIndex;
  FVisibleList.Add(pIndex);
end;

procedure TPageList.ClearVisible;
 var
  i: integer;
begin
  for i := 0 to FVisibleList.Count-1 do
  begin
    FreeMem(FVisibleList.Items[i], SizeOf(Integer));
  end;
  FVisibleList.Clear;
end;

constructor TPageList.Create(AComponent: TComponent);
begin
  inherited Create;
  FPageControl := TDCCustomPageControl(AComponent);
  FVisibleList := TList.Create;
end;

destructor TPageList.Destroy;
begin
  ClearVisible;
  FVisibleList.Free;
  inherited;
end;

function TPageList.GetVisibleCount: integer;
begin
  Result := FVisibleList.Count;
end;

procedure TPageList.SetVisible(APage: TDCCustomPage; AVisible: boolean);
 var
  i: integer;
  pIndex: ^Integer;
  PageFound: boolean;
begin
  PageFound := False;
  with FVisibleList do
  begin
    i := 0;
    while (i < Count) and PageFound do
    begin
      pIndex := Items[i];
      if APage.PageIndex = pIndex^ then
      begin
        if not AVisible then
        begin
          FreeMem(pIndex, SizeOf(Integer));
          Delete(i);
          PageFound := True;
          Break;
        end;
      end;
      Inc(i);
    end;
    if not PageFound and AVisible then UpdateVisible;
  end;
end;

procedure TPageList.UpdateVisible;
 var
  i, j: integer;
  pIndex: ^Integer;
  Page: TDCCustomPage;
begin
  j := 0;
  for i := 0 to Count-1 do
  begin
    Page := TDCCustomPage(Items[i]);
    if Page.PageVisible then
    begin
      if j < FVisibleList.Count then
        pIndex := FVisibleList.Items[j]
      else begin
        GetMem(pIndex, SizeOf(Integer));
        FVisibleList.Add(pIndex);
      end;
      pIndex^ := Page.PageIndex;
      Inc(j)
    end;
  end;
  if FVisibleList.Count > j then
  begin
    while j < FVisibleList.Count do
    begin
      FreeMem(FVisibleList.Items[j], SizeOf(Integer));
      FVisibleList.Delete(j);
    end;
  end;
end;

function TPageList.VisibleIndexOf(Index: integer): integer;
 var
  i: integer;
begin
  Result := -1;
  with FPageControl do
    if not ((csDesigning in ComponentState) or TabVisible) then Exit;
  for i := 0 to FVisibleList.Count-1 do
    if Index = Integer(FVisibleList.Items[i]^) then
    begin
      if FPageControl.FFirstIndex <= i then Result := i;
      Exit;
    end;
end;

{ TDCPageControl }

constructor TDCPageControl.Create(AComponent: TComponent);
begin
  inherited;
  FTabSize     := Point(0, 0);
  FDrawStyle   := fcsNormal;
  FTabMargins  := Rect(4, 6, 0, 4);
  FItemMargins := Rect(5, 3, 5, 3);
  FTabPosition := tbBottom;
  CreateTracks;

  FTabMargins.Left  := FTabMargins.Left  + FPrevTrack.Width + 2;
  FTabMargins.Right := FTabMargins.Right + FNextTrack.Width + 6;
  FMouseDown  := False;
  FTimer      := False;
  FRedrawTabs := False;

  FCanvasLocked := False;
  FChangedPage  := nil;
  FPageSelected := True;
end;

procedure TDCPageControl.DoDrawTab(ACanvas: TCanvas; ARect: TRect;
  AIndex: integer; APage: TDCCustomPage; AActivePage: boolean);
 var
  BRect: TRect;
begin
  inherited;
  if ARect.Left >= ARect.Right then Exit;

  with ACanvas do
  begin
    if AActivePage then
      Brush.Color := clBtnFace
    else
      Brush.Color  := clBtnShadow;

    FillRect(ARect);
    if (Screen.ActiveControl = Self) and AActivePage then
    begin
      BRect := ARect;
      InflateRect(BRect, -2, -1);
      BRect.Right  := BRect.Right  - 1;
      BRect.Bottom := BRect.Bottom - 1;

      Brush.Bitmap := AllocPatternBitmap(clBlack, Brush.Color);
      FrameRect(BRect);
    end;

    if AActivePage then
    begin
      case FTabPosition of
        tbTop:
          begin
            DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_TOP);
            if APage.FFullVisible then
              DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_RIGHT)
            else begin
            end;
          end;
        tbBottom:
          begin
            if APage.FFullVisible then
               DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT)
            else begin
               DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOM)
            end;
          end;
      end;
      if AIndex = 0 then DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDINNER, BF_LEFT);
    end
    else begin
      case FTabPosition of
        tbTop   : DrawEdge(ACanvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOM);
        tbBottom: DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENINNER, BF_TOP);
      end;
      if (csDesigning in ComponentState) then
      begin
        if AIndex <> FPages.Count-1 then
         if APage.FFullVisible then
           DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENOUTER, BF_RIGHT)
         else begin
         end;
       end
       else with FPages.FVisibleList do
         if AIndex <> Integer(Items[Count-1]^) then
           if APage.FFullVisible then
             DrawEdge(ACanvas.Handle, ARect, BDR_SUNKENOUTER, BF_RIGHT)
           else begin
           end;
    end;

    DrawTabText(ACanvas, ARect, AIndex, APage, AActivePage);
  end;
end;

procedure TDCPageControl.DrawBorder(ACanvas: TCanvas);
 var
  ARect, BRect: TRect;
  ARgn, BRgn: HRGN;
  AResult: integer;
begin
  if (FPages.VisibleCount > 0) or
     ((csDesigning in ComponentState) and (FPages.Count > 0)) then
  begin

    if FTabVisible then
      ARect := GetCurrentPageRect
    else begin
      ARect := ClientRect;
      InflateRect(ARect, -2, -2);
    end;

    InflateRect(ARect, 2, 2);
    with Canvas do
    begin
      Canvas.Brush.Color := Self.Color;
      FrameRect(ARect);
      InflateRect(ARect, -1, -1);
      FrameRect(ARect);
      ARgn := CreateRectRgnIndirect(ARect);
      try
      if ActivePage <> nil then
      begin
        BRect := GetClientRect;
        AdjustClientRect(BRect);
        BRgn  := CreateRectRgnIndirect(BRect);
        try
          AResult := CombineRgn(ARgn, ARgn, BRgn, RGN_DIFF);
          if AResult <> NULLREGION then
            FillRgn(Canvas.Handle, ARgn, Canvas.Brush.Handle)
        finally
          DeleteObject(BRgn);
        end;
      end;
      finally
        DeleteObject(ARgn);
      end;
    end;
  end
  else begin
    ARect := ClientRect;
    Canvas.Brush.Color := Self.Color;
    Canvas.FillRect(ARect);
  end;

  ARect := ClientRect;
  case FDrawStyle of
    fcsNormal:
      begin
        DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT);
        InflateRect(ARect, -1, -1);
        DrawEdge(Canvas.Handle, ARect, BDR_SUNKENINNER, BF_RECT);
      end;
    fsFlat:
      begin
        DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT or BF_ADJUST);
        DrawEdge(Canvas.Handle, ARect, BDR_SUNKENINNER, BF_BOTTOMRIGHT);
      end;
    fsNone:
      ;
    fsSingle:
      with Canvas do
      begin
        Canvas.Brush.Color := clBtnShadow;
        FrameRect(ARect);
      end;
  end;

end;

procedure TDCPageControl.DrawTabsArea(ACanvas: TCanvas);
 var
  ATabRect: TRect;
  DCRegion, TabsRegion: HRGN;
begin
  if not FBuffered then
  begin
    DCRegion  := CreateRectRgnIndirect(ClientRect);
    DCRegion  := GetClipRgn(ACanvas.Handle, DCRegion);
    TabsRegion:= CreateRectRgnIndirect(ControlRect);
    SelectClipRgn(ACanvas.Handle, TabsRegion);
  end
  else begin
    if FTabPosition = tbTop then FBitmap.Height := FBitmap.Height + 1;
    DCRegion   := 0;
    TabsRegion := 0;
  end;

  try
    inherited;
    ATabRect := TabsRect;
    if FBuffered then OffsetRect(ATabRect, -ATabRect.Left, -ATabRect.Top);

    with ACanvas do
    begin

      if FPrevTrack.Visible and not FBuffered then
        with FPrevTrack do
           ExcludeClipRect(Handle, Left, Top, Left+Width, Top+Height);
      if FNextTrack.Visible and not FBuffered then
        with FNextTrack do
           ExcludeClipRect(Handle, Left, Top, Left+Width, Top+Height);

      Brush.Color := clBtnShadow;
      Pen.Color   := clBlack;
      case FTabPosition of
        tbTop:
          begin
            FillRect(ATabRect);
            MoveTo(ATabRect.Left, ATabRect.Bottom);
            LineTo(ATabRect.Right, ATabRect.Bottom);
          end;
        tbBottom:
          begin
            FillRect(ATabRect);
            MoveTo(ATabRect.Left, ATabRect.Top);
            LineTo(ATabRect.Right, ATabRect.Top);
          end;
      end;
    end;
  finally
    if not FBuffered then
    begin
      SelectClipRgn(ACanvas.Handle, DCRegion);
      DeleteObject(TabsRegion);
      DeleteObject(DCRegion);
    end;  
  end;
end;

function TDCPageControl.ControlRect: TRect;
begin
  Result := ClientRect;
  case FDrawStyle of
    fcsNormal:
      InflateRect(Result, -2, -2);
    fsFlat:
      InflateRect(Result, -1, -1);
    fsNone:
      ;
    fsSingle:
      InflateRect(Result, -1, -1);
  end;
end;

function TDCPageControl.GetCurrentPageRect: TRect;
begin
  Result := ControlRect;
  case FTabPosition of
    tbTop   :  Result.Top := Result.Top + FTabHeight;
    tbBottom:  Result.Bottom := Result.Bottom - FTabHeight;
  end;
  InflateRect(Result, -2, -2);
end;

function TDCPageControl.GetTabRect(AIndex: integer; Page: TDCCustomPage;
  var ARect: TRect): TRect;
 var
  ATabsRect: TRect;
  AItemWidth: integer;
  AText: string;
  ASize: TPoint;
begin
  ATabsRect := TabsRect;
  AIndex    := AIndex - FFirstIndex;

  if FTabSize.X = 0 then
  begin
    Canvas.Font := Self.Font;
    if Assigned(Images) and (Page.ImageIndex > -1) then
    begin
      AText := Format('/im{%d}/ow{5}%s', [Page.ImageIndex, Page.Caption]);
      ASize := DrawHighlightText(Canvas, PChar(AText), ATabsrect, 0, DT_SINGLELINE, Images);
      AItemWidth := ASize.X;
    end
    else
      AItemWidth := GetTextWidth(Canvas.Handle, Page.Caption);
    if AIndex <= 0 then
      Result.Left  := FTabMargins.Left
    else
      Result.Left  := ARect.Right;
    Result.Right := Result.Left + AItemWidth + FItemMargins.Left + FItemMargins.Right;
  end
  else begin
    Result.Left  := ATabsRect.Left + FTabMargins.Left + AIndex*FTabSize.X;
    Result.Right := Result.Left + FTabSize.X;
  end;
  case FTabPosition of
    tbTop:
      begin
        Result.Bottom:= ATabsRect.Bottom +1;
        Result.Top   := ATabsRect.Bottom - (FItemHeight + FItemMargins.Top + FItemMargins.Bottom);
      end;
    tbBottom:
      begin
        Result.Top   := ATabsRect.Top;
        Result.Bottom:= ATabsRect.Top + (FItemHeight + FItemMargins.Top + FItemMargins.Bottom);
      end;
  end;
  if Result.Right > ATabsRect.Right - FTabMargins.Right then
  begin
    Page.FFullVisible := False;
    Result.Right := ATabsRect.Right - FTabMargins.Right;
  end
  else
    Page.FFullVisible := True;
end;

function TDCPageControl.GetTabsRect: TRect;
begin
  Result := ControlRect;
  case FTabPosition of
    tbTop   :  Result.Bottom := Result.Top + FTabHeight;
    tbBottom:  Result.Top := Result.Bottom - FTabHeight;
  end;
end;

procedure TDCPageControl.SetTabHeight(const Value: integer);
begin
  if FTabSize.Y <> Value then
  begin
    if Value >= 0 then FTabSize.Y := Value;
    UpdateTabSize;
    UpdateTracksPos;
  end;
end;

procedure TDCPageControl.SetTabWidth(const Value: integer);
begin
  if FTabSize.X <> Value then
  begin
    if Value >= 0 then FTabSize.X := Value;
    UpdateTabSize;
  end;
end;

procedure TDCPageControl.UpdateTabSize;
begin
  Canvas.Font := Self.Font;
  FItemHeight := GetTextHeight(Canvas.Handle, 'Wg');
  if Assigned(Images) and ((Images.Height - 2) > FItemHeight) then
    FItemHeight := Images.Height - 2;

  if FTabSize.Y > 0 then
    FTabHeight := FTabSize.Y
  else
    with FTabMargins do
      FTabHeight := FItemHeight + Top + Bottom;

  FPrevTrack.Height := FTabHeight - 4;
  FNextTrack.Height := FTabHeight - 4;

  TabsChanged;
end;

procedure TDCPageControl.SetDrawStyle(const Value: TControlStyle);
begin
  if FDrawStyle <> Value then
  begin
    FDrawStyle := Value;
    TabsChanged;
    invalidate;
  end;
end;

procedure TDCPageControl.SetTabPosition(const Value: TLiteTabPosition);
begin
  if FTabPosition <> Value then
  begin
    FTabPosition := Value;
    TabsChanged;
    UpdateTracksPos;
    Invalidate;
  end;
end;

procedure TDCPageControl.CreateWnd;
begin
  inherited;
  UpdateTabSize;
  if HandleAllocated then UpdateTracksPos;
end;

procedure TDCPageControl.CMFontChanged(var Message: TMessage);
begin
  inherited;
  UpdateTabSize;
  UpdateTabs;
end;

procedure TDCPageControl.Paint;
begin
  inherited;
  PaintTracks;
end;

function TDCPageControl.CanChange: Boolean;
begin
  Result := inherited CanChange;
end;

destructor TDCPageControl.Destroy;
begin
  if Assigned(FPrevTrack) then
  begin
    FPrevTrack.Free;
    FPrevTrack := nil;
  end;
  if Assigned(FNextTrack) then
  begin
    FNextTrack.Free;
    FNextTrack := nil;
  end;
  inherited;
end;

procedure TDCPageControl.CreateTracks;
begin
  FPrevTrack:= TDCEditButton.Create(Self);
  with FPrevTrack do
  begin
    Visible := False;
    Width   := 13;
    Height  := TabHeight;
    DrawText:= False;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNLEFT');
    BrushColor := clBtnFace;
    OnClick := ButtonsDown;
  end;

  FNextTrack:= TDCEditButton.Create(Self);
  with FNextTrack do
  begin
    Visible := False;
    Width   := 13;
    Height  := TabHeight;
    DrawText:= False;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNRIGHT');
    BrushColor := clBtnFace;
    OnClick := ButtonsUp;
  end;
end;

procedure TDCPageControl.ButtonsDown(Sender: TObject);
begin
  FFirstIndex := FFirstIndex - 1;
  UpdateTabsRect;
  UpdateTabs;
end;

procedure TDCPageControl.ButtonsUp(Sender: TObject);
begin
  FFirstIndex := FFirstIndex + 1;
  UpdateTabsRect;
  UpdateTabs;
end;

procedure TDCPageControl.WMSize(var Message: TMessage);
begin
  inherited;
  if FNextTrack.Visible or FPrevTrack.Visible then
    RedrawWindow(Handle, nil, 0, RDW_INVALIDATE);
  CheckToNextTrack;
  if not FNextTrack.Visible then CheckToPrevTrack;
  UpdateTracksPos;
end;

procedure TDCPageControl.PaintTracks;
begin
  if FPrevTrack.Visible then FPrevTrack.Paint;
  if FNextTrack.Visible then FNextTrack.Paint;
end;

procedure TDCPageControl.UpdateTracksState(X, Y: integer; lMove: boolean);
begin
  FPrevTrack.UpdateButtonState(X, Y, FMouseDown, lMove);
  FNextTrack.UpdateButtonState(X, Y, FMouseDown, lMove);
end;

procedure TDCPageControl.WMLButtonDblClk(var Message: TWMLButtonDown);
begin
  inherited;
  if not (csDesigning in ComponentState) then
  begin
    FMouseDown := True;
    UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

    if (FPrevTrack.ButtonState  = btDownMouseInRect) or
       (FNextTrack.ButtonState  = btDownMouseInRect) then
     SetTimer(Handle, CTRTIMER_IDEVENT, 200, nil);
  end;
end;

procedure TDCPageControl.WMLButtonDown(var Message: TWMLButtonDown);
begin
  inherited;
  if not (csDesigning in ComponentState) then
  begin
    FMouseDown := True;
    UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

    if (FPrevTrack.ButtonState  = btDownMouseInRect) or
       (FNextTrack.ButtonState  = btDownMouseInRect) then
     SetTimer(Handle, CTRTIMER_IDEVENT, 200, nil);
  end;
end;

procedure TDCPageControl.WMLButtonUp(var Message: TWMLButtonUp);
begin
  inherited;
  if not (csDesigning in ComponentState) then
  begin
    FMouseDown := False;
    UpdateTracksState(Message.Pos.X, Message.Pos.Y, False);

    KillTimer(Handle, CTRTIMER_IDEVENT);
    FTimer := False;
  end;
end;

procedure TDCPageControl.WMMouseMove(var Message: TWMMouseMove);
begin
  inherited;
  UpdateTracksState(Message.Pos.X, Message.Pos.Y, True);
end;

procedure TDCPageControl.UpdateTracksPos;
 var
  ARect: TRect;
begin
  ARect :=  GetTabsRect;

  with FPrevTrack do
  begin
    Left :=  ARect.Left + 2;
    Top  :=  ARect.Top  + 2;
  end;

  with FNextTrack do
  begin
    Left :=  ClientRect.Right - Width - 4;
    Top  :=  ARect.Top + 2;
  end;
end;

procedure TDCPageControl.HideTrack(Track: TDCEditButton);
begin
  Track.Visible := False;
  if FTimer then KillTimer(Handle, CTRTIMER_IDEVENT);
end;

procedure TDCPageControl.UpdateTabs;
begin
  if not HandleAllocated then Exit;
  if not FTabVisible then
  begin
    HideTrack(FPrevTrack);
    HideTrack(FNextTrack);
  end
  else begin
    if (FFirstIndex = 0 ) and FPrevTrack.Visible then HideTrack(FPrevTrack);
    if (FFirstIndex <> 0) and not FPrevTrack.Visible then FPrevTrack.Visible := True;
    CheckToNextTrack;
  end;
  if not FCanvasLocked then Invalidate;
end;

procedure TDCPageControl.CheckToNextTrack;
 var
  i, VisibleIndex: integer;
  Page: TDCCustomPage;
  ARect: TRect;
begin
  if FTabVisible then
  begin
    FTabsRect := GetTabsRect;
    ARect     := Rect(0, 0, 0, 0);
    for i := 0 to FPages.Count - 1 do
    begin
      Page := FPages.Items[i];
      VisibleIndex := -1;
      if (csDesigning in ComponentState) then
        VisibleIndex := i
      else
        if Page.PageVisible then VisibleIndex := FPages.VisibleIndexOf(Page.PageIndex);
      if (VisibleIndex <> -1) and not Page.FFullVisible then
      begin
        FNextTrack.Visible := True;
        Exit;
      end;
    end;
  end;
  HideTrack(FNextTrack);
end;

procedure TDCPageControl.CheckToPrevTrack; 
 var
  AFirstIndex: integer;
begin
  if FFirstIndex > 0 then
  begin
    AFirstIndex   := FFirstIndex;
    FCanvasLocked := True;
    repeat
      ButtonsDown(Self);
      if FNextTrack.Visible then
      begin
        ButtonsUp(Self);
        break;
      end;
    until (FFirstIndex = 0);
    FCanvasLocked := False;
    if FFirstIndex <> AFirstIndex then invalidate;
  end;
end;

procedure TDCPageControl.Loaded;
begin
  inherited;
  FCanvasLocked := True;
  UpdateFirstIndex;
  UpdateTabs;
  FCanvasLocked := False;
end;

procedure TDCPageControl.WMTimer(var Message: TWMTimer);
begin
  FTimer := True;
  if FNextTrack.ButtonState = btDownMouseInRect then ButtonsUp(Self);
  if FPrevTrack.ButtonState = btDownMouseInRect then ButtonsDown(Self);
end;

procedure TDCPageControl.TabsChanged;
 var
  Form: TCustomForm;
begin
  if csDesigning in ComponentState then
  begin
    Form := GetParentForm(Self);
    if (Form <> nil) and (Form.Designer <> nil) then Form.Designer.Modified;
  end;
  UpdateTabsRect;
  Realign;
  if (ActivePage <> nil) and
     (not ActivePage.FFullVisible or IsRectEmpty(ActivePage.FTabRect)) then
    UpdateFirstIndex;

  if FRedrawTabs and FTabVisible  then
  begin
    RedrawTab(FChangedPage);
    RedrawTab(ActivePage);
    FRedrawTabs := False;
  end
  else
    UpdateTabs;
end;

procedure TDCPageControl.CMMouseEnter(var Message: TMessage);
begin
  inherited;
end;

procedure TDCPageControl.CMMouseLeave(var Message: TMessage);
begin
  ClearSelection;
  inherited;
  FPrevTrack.UpdateButtonState(-1, -1, False, True);
  FNextTrack.UpdateButtonState(-1, -1, False, True);
end;

procedure TDCPageControl.DrawTabText(ACanvas: TCanvas; ARect: TRect;
  AIndex: integer; APage: TDCCustomPage; AActivePage: boolean);
 var
  Flags: Longint;
  AText: string;
begin
  inherited;
  if ARect.Left >= ARect.Right then Exit;

  with ACanvas do
  begin
    Font := Self.Font;
    if AActivePage then
    begin
      Brush.Color := clBtnFace;
      Font.Color  := clWindowText;
    end
    else begin
      Brush.Color  := clBtnShadow;
      if APage <> FSelectedPage then
        Font.Color := clCaptionLightText
      else
        Font.Color := clCaptionText
    end;

    with ARect do
    begin
      Left   := Left   + FItemMargins.Left   - 1;
      Right  := Right  - FItemMargins.Right  + 1;
      Top    := Top    + FItemMargins.Top    - 1;
      Bottom := Bottom - FItemMargins.Bottom + 1;
    end;

    if APage.FFullVisible then
      Flags := DT_SINGLELINE or DT_CENTER or DT_END_ELLIPSIS
    else
      Flags := DT_SINGLELINE or DT_END_ELLIPSIS;
    SetBkMode(Handle, TRANSPARENT);

    AText := APage.Caption;
    if Assigned(Images) and (APage.ImageIndex > -1) then
    begin
      if AActivePage then
        AText := Format('/im{%d}/ow{5}%s', [APage.ImageIndex, AText])
      else
        AText := Format('/ih{%d}/ow{5}%s', [APage.ImageIndex, AText]);
      DrawHighlightText(ACanvas, PChar(AText), ARect, 1, Flags, Images);
    end
    else
      DrawText(Handle, PChar(APage.Caption), Length(APage.Caption), ARect, Flags);
  end;
end;

procedure TDCPageControl.ClearSelection;
 var
  Page: TDCCustomPage;
begin
  if not(csDesigning in ComponentState) and (FSelectedPage <> nil) then
  begin
    Page := FSelectedPage;
    FSelectedPage := nil;
    DrawTabText(Canvas, Page.FTabRect, FPages.VisibleIndexOf(Page.PageIndex),
      Page, ActivePage.PageIndex = Page.PageIndex);
  end;
end;

procedure TDCPageControl.MouseMove(Shift: TShiftState; X, Y: Integer);
 var
  i: integer;
  Page, APage: TDCCustomPage;
begin
  if not(csDesigning in ComponentState) and TabVisible then
  begin
    for i := 0 to FPages.VisibleCount-1 do
    begin
      Page := FPages.Items[Integer(FPages.FVisibleList.Items[i]^)];
      if PtInRect(Page.FTabRect, Point(X, Y)) then
      begin
        APage := FSelectedPage;
        FSelectedPage := Page;
        if APage <> Page then
        begin
          if APage <> nil then
            DrawTabText(Canvas, APage.FTabRect, i, APage, ActivePage.PageIndex = APage.PageIndex);
          DrawTabText(Canvas, Page.FTabRect, i, Page, ActivePage.PageIndex = Page.PageIndex);
        end;
        Exit;
      end;
    end;
    ClearSelection;
  end;
  inherited;
end;

procedure TDCPageControl.UpdateFirstIndex;
 var
  Page: TDCCustomPage;
  VisibleIndex: integer;
begin
  FFirstIndex  := -1;
  VisibleIndex := -1;
  Page := ActivePage;
  if (csDesigning in ComponentState) then
    VisibleIndex := Page.PageIndex
  else
    if Page.PageVisible then VisibleIndex := FPages.VisibleIndexOf(Page.PageIndex);
  repeat
    Inc(FFirstIndex);
    UpdateTabsRect;
  until not IsRectEmpty(Page.FTabRect) and Page.FFullVisible or
   (FFirstIndex >= VisibleIndex);
end;

procedure TDCPageControl.ChangeActivePage(Page: TDCCustomPage);
 var
  ParentForm: TCustomForm;
begin
  FChangedPage := ActivePage;

  FRedrawTabs  := (FChangedPage <> nil) and (FChangedPage.FFullVisible) and
   not IsRectEmpty(FChangedPage.FTabRect) and (Page <> nil) and
   (Page.FFullVisible) and not IsRectEmpty(Page.FTabRect);

  if FPageSelected and (ComponentState = []) then
  begin
    ParentForm := GetParentForm(Self);
    if ActivePage = Page then
    begin
      if ParentForm <> nil then ParentForm.ActiveControl := Self;
      RedrawTab(ActivePage);
    end
    else if CanChange then
    begin
      if not Focused and (ParentForm <> nil) and
         FActivePage.ContainsControl(ParentForm.ActiveControl) then
        ParentForm.ActiveControl := ActivePage;
      inherited;
    end;
  end
  else
    inherited;
end;

procedure TDCPageControl.RedrawTab(Page: TDCCustomPage);
 var
  VisibleIndex: integer;
  ADefaultDraw: boolean;
begin
  ADefaultDraw := True;
  VisibleIndex := -1;
  if (csDesigning in ComponentState) then
    VisibleIndex := Page.PageIndex
  else
    if Page.PageVisible then VisibleIndex := FPages.VisibleIndexOf(Page.PageIndex);
  if VisibleIndex >= 0 then
    DrawTab(Canvas, Page.FTabRect, VisibleIndex, Page, ADefaultDraw);
end;

procedure TDCPageControl.WMKillFocus(var Message: TWMKillFocus);
begin
  inherited;
  PostMessage(Handle, CM_REDRAWTAB, Integer(ActivePage), 0);
end;

procedure TDCPageControl.CMRedrawTab(var Message: TMessage);
begin
  if FPageSelected then RedrawTab(TDCCustomPage(Message.WParam))
end;

procedure TDCPageControl.WMSetFocus(var Message: TWMSetFocus);
begin
  inherited;
  if not FTabVisible then Message.Result := 1
  else
    PostMessage(Handle, CM_REDRAWTAB, Integer(ActivePage), 0);
end;

{ TDCOutBar }

procedure TDCOutBar.CMFontChanged(var Message: TMessage);
begin
  inherited;
  UpdateTabSize;
end;

function TDCOutBar.ControlRect: TRect;
begin
  Result := ClientRect;
  InflateRect(Result, -1, -1);
end;

constructor TDCOutBar.Create(AComponent: TComponent);
begin
  inherited;
  Width       := 80;
  FTabMargins := Rect(4, 4, 4, 4);
  Align       := alLeft;
  FMode       := omNormal;
  FBuffered   := False;
//  TabStop := False;
end;

procedure TDCOutBar.CreateWnd;
begin
  inherited;
  UpdateTabSize;
end;

procedure TDCOutBar.DoDrawTab(ACanvas: TCanvas; ARect: TRect;
  AIndex: integer; APage: TDCCustomPage; AActivePage: boolean);
 var
  Flags: Longint;
  AText: string;
begin
  inherited;
  with Canvas do
  begin
    Font := Self.Font;
    Brush.Color := clBtnFace;
    FillRect(ARect);

    DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);

    with ARect do
    begin
      Left   := Left   + FTabMargins.Left   - 1;
      Right  := Right  - FTabMargins.Right  + 1;
      Top    := Top    + FTabMargins.Top    - 1;
      Bottom := Bottom - FTabMargins.Bottom + 1;
    end;

    Flags := DT_SINGLELINE or DT_CENTER or DT_END_ELLIPSIS;
    AText := APage.Caption;
    if Assigned(Images) and (APage.ImageIndex > -1) then
    begin
      AText := Format('/im{%d}/ow{5}%s', [APage.ImageIndex, AText]);
      DrawHighlightText(Canvas, PChar(AText), ARect, 1, Flags, Images);
    end
    else
      DrawText(Handle, PChar(APage.Caption), Length(APage.Caption), ARect, Flags)
  end;
end;

procedure TDCOutBar.DrawBorder(ACanvas: TCanvas);
 var
  ARect: TRect;
begin
  if (FPages.VisibleCount > 0) or
     ((csDesigning in ComponentState) and (FPages.Count > 0)) then
  begin

    if FTabVisible then
      ARect := GetCurrentPageRect
    else begin
      ARect := ClientRect;
      InflateRect(ARect, -2, -2);
    end;

    InflateRect(ARect, 1, 1);
    with Canvas do
    begin
      if ActivePage.Color = clBtnShadow then
      begin
       DrawEdge (Canvas.Handle, ARect, BDR_SUNKENINNER, BF_TOPLEFT);
      end
      else begin
        Canvas.Brush.Color := Self.{ActivePage.}Color;
        FrameRect(ARect);
      end;
    end;
  end
  else begin
    ARect := ClientRect;
    Canvas.Brush.Color := Self.Color;
    Canvas.FillRect(ARect);
  end;

  ARect := ClientRect;
  DrawEdge (Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT or BF_ADJUST);
  DrawEdge (Canvas.Handle, ARect, BDR_SUNKENINNER, BF_BOTTOMRIGHT);
end;

procedure TDCOutBar.DrawTabsArea(ACanvas: TCanvas);
begin
  inherited;
end;

function TDCOutBar.GetCurrentPageRect: TRect;
 var
  AIndex, AVisibleCount: integer;
  PageOffset: TPoint;
begin
  Result := ControlRect;
  
  InflateRect(Result, -1, -1);
  try
    if (ActivePage <> nil) and (ActivePage.PageControl <> nil) then
    begin
      if csDesigning in ComponentState then
      begin
        AIndex := ActivePage.PageIndex;
        AVisibleCount := FPages.Count;
      end
      else begin
        AIndex := FPages.VisibleIndexOf(ActivePage.PageIndex);
        AVisibleCount := FPages.VisibleCount;
      end;
      if (AIndex > -1) then
      begin
        PageOffset.X := (AIndex + 1) * FTabHeight;
        PageOffset.Y := (AVisibleCount - AIndex - 1) * FTabHeight;
        Result.Top   := Result.Top + PageOffset.X;
        Result.Bottom:= Result.Bottom - PageOffset.Y;
      end;
    end;
  except
    //
  end;
end;

function TDCOutBar.GetTabRect(AIndex: integer; Page: TDCCustomPage;
  var ARect: TRect): TRect;
 var
  PIndex, PVisibleCount : integer;
  PageOffset: TPoint;
  PRect: TRect;
begin
  Result := Rect(0, 0, 0, 0);
  PRect  := ControlRect;
  if ActivePage <> nil then
  begin
    if csDesigning in ComponentState then
    begin
      PIndex := ActivePage.PageIndex;
      PVisibleCount := FPages.Count;
    end
    else begin
      PIndex := FPages.VisibleIndexOf(ActivePage.PageIndex);
      PVisibleCount := FPages.VisibleCount;
    end;
    if PIndex > -1 then
    begin
      if AIndex <= PIndex then
        PageOffset.X := AIndex * FTabHeight
      else
        PageOffset.X := PRect.Bottom - (PVisibleCount - AIndex) * FTabHeight - 1;

      Result.Left  := PRect.Left;
      Result.Top   := PRect.Top   + PageOffset.X;
      Result.Right := PRect.Right;
      Result.Bottom:= Result.Top  + FTabHeight;
    end;
  end;
end;

function TDCOutBar.GetTabsRect: TRect;
begin
  Result := ControlRect;
end;

procedure TDCOutBar.Loaded;
begin
  inherited;
  Realign;
end;

procedure TDCOutBar.Paint;
begin
  inherited;
end;

procedure TDCOutBar.SetTabHeight(const Value: integer);
begin
  if FTabSize.Y <> Value then
  begin
    if Value >= 0 then FTabSize.Y := Value;
    UpdateTabSize;
  end;
end;

procedure TDCOutBar.TabsChanged;
begin
  inherited;
end;

procedure TDCOutBar.UpdateTabSize;
begin
  Canvas.Font := Self.Font;
  FItemHeight := GetTextHeight(Canvas.Handle, 'Wg');
  if Assigned(Images) and (Images.Height > FItemHeight) then
    FItemHeight := Images.Height;

  if FTabSize.Y > 0 then
    FTabHeight := FTabSize.Y
  else
    with FTabMargins do
      FTabHeight := FItemHeight + Top + Bottom;

  TabsChanged;
end;

procedure TDCOutBar.WMMouseMove(var Message: TWMMouseMove);
 var
  Page: TDCCustomPage;
begin
  if FMode = omMoveItem then
  begin
    KillTimer(Handle, OBMTIMER_IDEVENT);
    Page := GetPageAt(Message.Pos.X, Message.Pos.Y);
    if Page <> nil then SetTimer(Handle, OBMTIMER_IDEVENT, 500, nil);
  end;
  inherited;
end;

procedure TDCOutBar.WMSize(var Message: TWMSize);
begin
  inherited;
  UpdateTabsRect;
end;

procedure TDCOutBar.WMTimer(var Message: TWMTimer);
 var
  Page: TDCCustomPage;
  Pos: TPoint;
begin
  inherited;
  if (FMode = omMoveItem) and (Message.TimerID = OBMTIMER_IDEVENT) then
  begin
    GetCursorPos(Pos);
    Pos := ScreenToClient(Pos);
    Page := GetPageAt(Pos.X, Pos.Y);
    if Page <> nil then SetActivePage(Page);
  end;
end;

{ TDCPaleteBarPanel }

function TDCPaleteBarPanel.AddButton: TDCEditButton;
begin
  Result := inherited AddButton;
  if Result <> nil then
  begin
    Result.DrawText := FDrawText;
    if FDrawText then Result.Allignment := abImageTop;
    if FIconStyle then
    begin
      Result.Style    := stIcon;
      Result.DownClick:= False;
    end
    else begin
      Result.Style    := stOutbar;
      Result.DownClick:= True;
    end;
  end;
end;

function TDCPaleteBarPanel.ButtonVisible(Button: TDCEditButton): boolean;
begin
  with Button do Result := (Left + Width) <= (Self.Width - FNextTrack.Width -2);
end;

procedure TDCPaleteBarPanel.Click;
begin
  if PageControl <> nil then PageControl.Click;
end;

procedure TDCPaleteBarPanel.CMColorChanged(var Message: TMessage);
begin
  inherited;
  FPrevTrack.BrushColor := Color;
  FNextTrack.BrushColor := Color;
end;

procedure TDCPaleteBarPanel.CMHintShow(var Message: TCMHintShow);
 var
  AHintPos: TPoint;
begin
  if FHintObject <> nil then
  begin
    with Message, TDCEditButton(FHintObject) do
    begin
      HintInfo.HintStr := Hint;
      HintInfo.ReshowTimeout := 1000;
      AHintPos := Point(Left, Top + Height + 1);
      AHintPos := ClientToScreen(AHintPos);
      HintInfo.HintPos := AHintPos;
      Result := 0;
    end;
  end
  else
   inherited;
end;

constructor TDCPaleteBarPanel.Create(AOwner: TComponent);
begin
  inherited;
  FStyle   := isSmallImages;
  FOptions := [opDropDown];
  FAnchorStyle := asNone;
  FIconStyle   := False;
end;

procedure TDCPaleteBarPanel.CreateTracks;
begin
  inherited;
  with FPrevTrack do
  begin
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNLEFT');
    Style := stShadowFlat;
    Top   := 2;
  end;
  with FNextTrack do
  begin
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNRIGHT');
    Style := stShadowFlat;
    Top   := 2;
  end;
end;

procedure TDCPaleteBarPanel.DblClick;
begin
  if PageControl <> nil then PageControl.DblClick;
end;

function TDCPaleteBarPanel.GetImages: TImageList;
begin
  Result := SmallImages;
end;

procedure TDCPaleteBarPanel.ItemClick(Sender: TObject);
 var
  Button: TDCEditButton;
begin
  if Parent is TDCPaleteBar then
    Button := TDCPaleteBar(Parent).FButtons.FindButton('$Cancel$')
  else
    Button :=  nil;
  if Assigned(Button) and (Button.ButtonState = btDownMouseInRect) then
  begin
    Button.ResetProperties;
    Button.Invalidate;
  end;
  inherited;
end;

procedure TDCPaleteBarPanel.Loaded;
 var
  i: integer;
begin
  inherited;
  for i:= 0 to Items.Count-1 do
  begin
    Items.Buttons[i].DrawText := FDrawText;
    if FDrawText then Items.Buttons[i].Allignment := abImageTop else
      Items.Buttons[i].Allignment := abLeft;
    if FIconStyle then
    begin
      Items.Buttons[i].Style    := stIcon;
      Items.Buttons[i].DownClick:= False;
    end
    else begin
      Items.Buttons[i].Style    := stOutbar;
      Items.Buttons[i].DownClick:= True;
    end;
  end;
  UpdateButtonsPos;
end;

procedure TDCPaleteBarPanel.SetButtonPos(Index: integer);
 var
  TextSize, Pos: TPoint;
  Button: TDCEditButton;
  AHeight: integer;
begin
  Button := Buttons.Buttons[Index];
  Pos.X  := 2 + FPrevTrack.Left + FPrevTrack.Width;

  case FStyle of
   isLargeImages:
     begin
       AHeight := Button.GetGlyphHeight + TextSize.Y + 6;
       if FDrawText then AHeight := AHeight + Button.TextSize.Y + 2;
     end;
   isSmallImages:
     begin
       AHeight := Button.GetGlyphHeight + 8;
       if FDrawText then AHeight := AHeight + Button.TextSize.Y + 2;
     end;
   else
     AHeight := 0;
  end;

  Pos.Y := 2;

  Button.Left  := Pos.X;
  Button.Top   := Pos.Y;
  Button.Height:= AHeight;
  if FDrawText then
    Button.Width := Max(Button.GetGlyphHeight, Button.TextSize.X) + 8
  else
    Button.Width := Button.GetGlyphHeight + 8;

  if Index < FFirstIndex then
  begin
    Button.Left   := Pos.X;
    Button.Top    := 0;
    Button.Height := 0;
    Button.Width  := 0;
    if not FPrevTrack.Visible then FPrevTrack.Visible := True;
  end
  else begin
    Button.Visible := True;
    if (Index > 0) then
    begin
      with Buttons.Buttons[Index-1] do
      begin
        if FDrawText then
          Button.Left := (Left + Width) + 8
        else
          Button.Left := (Left + Width);
      end;
      if Button.Left + Button.Width > FNextTrack.Left then Button.Visible := False;
    end;
  end;
end;

procedure TDCPaleteBarPanel.SetDrawText(const Value: boolean);
 var
  i: integer;
begin
  FDrawText := Value;
  for i:= 0 to Items.Count-1 do
  begin
    Items.Buttons[i].DrawText := FDrawText;
    if FDrawText then Items.Buttons[i].Allignment := abImageTop else
      Items.Buttons[i].Allignment := abLeft;
  end;
  UpdateButtonsPos;
  UpdateTracksPos;
end;

procedure TDCPaleteBarPanel.SetIconStyle(const Value: boolean);
 var
  i: integer;
begin
  FIconStyle := Value;
  for i:= 0 to Items.Count-1 do
  begin
    if Value then
    begin
      Items.Buttons[i].Style    := stIcon;
      Items.Buttons[i].DownClick:= False;
    end
    else begin
      Items.Buttons[i].Style    := stOutbar;
      Items.Buttons[i].DownClick:= True;
    end;
    UpdateButtonsPos;
    UpdateTracksPos;
  end;
end;

procedure TDCPaleteBarPanel.SetImages(const Value: TImageList);
begin
  SmallImages := Value;
end;

function TDCPaleteBarPanel.TracksCovering: boolean;
begin
  if FPrevTrack.Visible and
    (FNextTrack.Left < (FPrevTrack.Left + FPrevTrack.Width)) then
    Result := True
  else
    Result := False;
end;

procedure TDCPaleteBarPanel.UpdateButtonsVisible;
 var
  i: integer;
  Button: TDCEditButton;
begin
  with Buttons do
    if Count > 0 then
    begin
      for i := 0 to Count-1 do
      begin
        Button := Buttons[i];
        Button.Visible := ButtonVisible(Button);
      end;
      CheckToNextTrack;
   end;
end;

procedure TDCPaleteBarPanel.UpdateTracksPos;
 var
  lVisible: boolean;
begin
  lVisible := False;
  with FPrevTrack do
  begin
    if Visible then
    begin
      Visible := False; lVisible := True;
    end;
    Left   :=  ClientRect.Left + 1;
    Top    :=  ClientRect.Top  + 2;
    Width  :=  13;
    if Assigned(Buttons.Images) then  Height :=  Buttons.Images.Height + 8;
    if lVisible then
    begin
      Visible := True; lVisible := False;
    end;
  end;

  with FNextTrack do
  begin
    if Visible then
    begin
      Visible := False; lVisible := True;
    end;
    Left   :=  ClientRect.Right - 15;
    Top    :=  ClientRect.Top   + 2;
    Width  :=  13;
    if Assigned(Buttons.Images) then  Height :=  Buttons.Images.Height + 8;
    if lVisible and not TracksCovering then Visible := True;
  end;
end;

procedure TDCPaleteBarPanel.WMSize(var Message: TWMSize);
begin
  inherited;
  UpdateButtonsVisible;
end;

{ TDCPaleteBar }

procedure TDCPaleteBar.AddCancelButton;
begin
  with FButtons, FButtons.AddButton do
  begin
    Name := '$Cancel$';
    Allignment := abCentr;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNARROW');
    Font  := Self.Font;
    SetCancelButtonBounds;
    Style := stOutBar;
    AbsolutePos  := False;
    EventStyle   := esDropDown;
    DisableStyle := deNormal;
    BrushColor   := Color;
    AnchorStyle  := asNone;
    OnClick      := CancelButtonClick;
    OnSetButtonState := SetButtonState;
    DrawText := False;
    Visible  := FCancelExist;
  end;
end;

procedure TDCPaleteBar.AdjustClientRect(var Rect: TRect);
 var
  Button: TDCEditButton;
begin
  inherited AdjustClientRect(Rect);
  if FCancelExist then
  begin
    Button := FButtons.FindButton('$Cancel$');
    if Assigned(Button) then Rect.Left := Rect.Left + Button.Width + 3;
  end;
end;

procedure TDCPaleteBar.Cancel;
begin
  CancelButtonClick(Self)
end;

procedure TDCPaleteBar.CancelButtonClick(Sender: TObject);
 var
  Button: TDCEditButton;
begin
  Button := FButtons.FindButton('$Cancel$');
  if (ActivePage <> nil) and (ActivePage is TDCCustomOutBarPanel) then
    TDCCustomOutBarPanel(ActivePage).ActiveButton := nil;
  if Button.ButtonState <> btDownMouseInRect then
  begin
    Button.UpdateButtonState(Button.Left + 1, Button.Top + 1, True, False);
    Click;
  end;    
end;

procedure TDCPaleteBar.CMColorChanged(var Message: TMessage);
begin
  inherited;
  FButtons.Color := Self.Color;
end;

procedure TDCPaleteBar.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  FButtons.MouseDown := GetAsyncKeyState(VK_LBUTTON)<0;
end;

procedure TDCPaleteBar.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  FButtons.UpdateButtons( -1, -1, False, True);
end;

constructor TDCPaleteBar.Create(AComponent: TComponent);
begin
  inherited;
  FButtons := TDCEditButtons.Create(Self);
  FTabMargins  := Rect(6, 3, 0, 3);
  FItemMargins := Rect(5, 2, 5, 2);
  FCancelExist := False;

  FTabMargins.Left  := FTabMargins.Left  + FPrevTrack.Width + 2;
  FTabMargins.Right := FTabMargins.Right + FNextTrack.Width + 6;

  FCancelSize := 0;
  FPageSelected := False;
end;

procedure TDCPaleteBar.CreateWnd;
begin
  inherited;
  if Parent <> nil then begin
    FButtons.ClrWndProc;
    FButtons.SetWndProc;
    AddCancelButton;
  end;
end;

destructor TDCPaleteBar.Destroy;
begin
  FButtons.Free;
  inherited;
end;

function TDCPaleteBar.GetCurrentPageRect: TRect;
begin
  Result := inherited GetCurrentPageRect;
end;

function TDCPaleteBar.GetSelectedItem: TDCEditButton;
begin
  Result :=  nil;
  if (ActivePage <> nil) and (ActivePage is TDCPaleteBarPanel) then
    Result := TDCPaleteBarPanel(ActivePage).Buttons.SelectedButton;
end;

procedure TDCPaleteBar.ImageListChange(Sender: TObject);
begin
  inherited;
  SetCancelButtonBounds;
  if ActivePage <> nil then ActivePage.AdjustSize;
end;

procedure TDCPaleteBar.InsertPage(Page: TDCCustomPage);
begin
  inherited;
  if Page is TDCPaleteBarPanel then
  begin
    TDCPaleteBarPanel(Page).Images := Images;
  end;
end;

procedure TDCPaleteBar.RemovePage(Page: TDCCustomPage);
 var
  Button: TDCEditButton;
begin
  inherited;
  if PageCount = 0 then
  begin
    Button := FButtons.FindButton('$Cancel$');
    if Assigned(Button) and (Button.ButtonState = btDownMouseInRect) then
    begin
      Button.ResetProperties;
      Button.Invalidate;
    end;
  end;
end;

procedure TDCPaleteBar.RepaintFreeArea;
 var
  ARect, BRect: TRect;
  ARgn, BRgn: HRGN;
  AResult: integer;
begin
  BRect := ClientRect;
  AdjustClientRect(ARect);
  InflateRect(ARect, -2, -2);

  ARgn := CreateRectRgn(ARect.Left, ARect.Top, ARect.Right, ARect.Bottom);
  BRgn := CreateRectRgn(BRect.Left, BRect.Top, BRect.Right, BRect.Bottom);
  try
    AResult :=  CombineRgn(ARgn, BRgn, ARgn, RGN_DIFF);
    if AResult <> NULLREGION then
    begin
      Canvas.Brush.Color := Self.Color;
      FillRgn(Canvas.Handle, ARgn, Canvas.Brush.Handle)
    end;
  finally
    DeleteObject(ARgn);
    DeleteObject(BRgn);
  end;
end;

procedure TDCPaleteBar.SetActivePage(const Value: TDCCustomPage);
begin
  inherited;
  if (ActivePage = Value) and FCancelExist then Cancel;
end;

procedure TDCPaleteBar.SetButtonState(Sender: TObject;
  var State: TButtonState);
 var
  Button: TDCEditButton;
begin
  Button := FButtons.FindButton('$Cancel$');
  if Assigned(Button) then
  begin
    if (Sender = Button) and (Button.ButtonState = btDownMouseInRect) then
      State := btDownMouseInRect;
  end;
end;

procedure TDCPaleteBar.SetCancelButtonBounds(Repaint: boolean = True);
 var
  Button: TDCEditButton;
  Rect: TRect;
begin
  Button := FButtons.FindButton('$Cancel$');
  if Assigned(Button) then
  begin
    if TabVisible then
      Rect := GetTabsRect
    else
      Rect := ClientRect;

    with Button do
    begin
      Left := Rect.Left + 4;
      if (TabPosition = tbTop) and TabVisible then
        Top := Rect.Bottom + 4
      else begin
        Top := 4;
        if TabVisible then Top := Top + 2;
      end;
      if (Self.Images <> nil) and (FCancelSize = 0) then
      begin
        Width  := Self.Images.Width  + 8;
        Height := Self.Images.Height + 8;
      end
      else begin
        if FCancelSize = 0 then
        begin
          Width  := 24;
          Height := 24;
        end
        else begin
          Width  := FCancelSize;
          Height := FCancelSize;
        end;
      end;
    end
  end;
  if Repaint then RepaintFreeArea;
end;

procedure TDCPaleteBar.SetCancelExist(const Value: boolean);
 var
  Button: TDCEditButton;
begin
  if FCancelExist <> Value then
  begin
    Button := FButtons.FindButton('$Cancel$');
    FCancelExist := Value;
    if Assigned(Button) then Button.Visible := FCancelExist;
    if FCancelExist then Cancel;
    if ActivePage <> nil then
    begin
      ActivePage.AdjustSize;
      ActivePage.Invalidate;
    end
    else
      Repaint;
  end;
end;

procedure TDCPaleteBar.SetCancelSize(const Value: integer);
begin
  FCancelSize := Value;
  SetCancelButtonBounds(False);
  Realign;
  invalidate;
end;

procedure TDCPaleteBar.SetImages(const Value: TImageList);
 var
  i: integer;
  Page: TDCPaleteBarPanel;
begin
  for i := 0 to PageCount - 1 do
  begin
    if (Pages[i] is TDCPaleteBarPanel) then
    begin
      Page := TDCPaleteBarPanel(Pages[i]);
      if Page.Images = Images then Page.Images := Value;
    end;
  end;
  inherited;
  SetCancelButtonBounds;
end;

procedure TDCPaleteBar.SetTabPosition(const Value: TLiteTabPosition);
begin
  inherited;
  SetCancelButtonBounds;
end;

procedure TDCPaleteBar.SetTabVisible(const Value: boolean);
begin
  inherited;
  SetCancelButtonBounds;
end;

procedure TDCPaleteBar.UpdateTabSize;
begin
  Canvas.Font := Self.Font;
  FItemHeight := GetTextHeight(Canvas.Handle, 'Wg') + 1;
  
  if FTabSize.Y > 0 then
    FTabHeight := FTabSize.Y
  else
    with FTabMargins do
      FTabHeight := FItemHeight + Top + Bottom;

  FPrevTrack.Height := FTabHeight - 4;
  FNextTrack.Height := FTabHeight - 4;

  TabsChanged;
end;

end.
