{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCOutBarEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Grids, DCStdCtrls, ComCtrls, DCChoice, DsgnIntf, DsgnWnds,
  DCEditButton, ActnList, DCEditTools, DCCapEdit;

type
  TOutPanelEditDlg = class(TDesignWindow)
    pnButtons: TPanel;
    btOk: TButton;
    btCancel: TButton;
    btApply: TButton;
    pnItems: TPanel;
    pnProperties: TPanel;
    pnOutTree: TDCHeaderPanel;
    pnSep_1: TPanel;
    pnItemsInfo: TDCHeaderPanel;
    pnSep_2: TPanel;
    btAdd: TButton;
    btDel: TButton;
    lbCaption: TLabel;
    lbImageIndex: TLabel;
    edImageIndex: TDCChoiceEdit;
    lbEnabled: TLabel;
    cbEnabled: TDCComboBox;
    Actions: TActionList;
    acNew: TAction;
    acDelete: TAction;
    acApply: TAction;
    acOk: TAction;
    acCancel: TAction;
    tvButtons: TTreeView;
    acClear: TAction;
    Bevel1: TBevel;
    btClear: TButton;
    lbTag: TLabel;
    edTag: TDCChoiceEdit;
    edCaption: TDCChoiceEdit;
    lbHint: TLabel;
    edHint: TDCChoiceEdit;
    procedure acNewExecute(Sender: TObject);
    procedure acDeleteExecute(Sender: TObject);
    procedure tvButtonsChanging(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
    procedure tvButtonsKeyPress(Sender: TObject; var Key: Char);
    procedure acApplyExecute(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure edCaptionChange(Sender: TObject);
    procedure SaveItemValue(Node: TTreeNode);
    procedure acClearExecute(Sender: TObject);
    procedure acCancelExecute(Sender: TObject);
    procedure acOkExecute(Sender: TObject);
    procedure edCaptionButtonClick(Sender: TObject);
    procedure edHintButtonClick(Sender: TObject);
  private
    { Private declarations }
    FOutPanel: TDCCustomOutBarPanel;
    FItemsInfo: TList;
    FApply: boolean;
    FChanged: boolean;
    FInitValues: boolean;
    procedure SetOutPanel(const Value: TDCCustomOutBarPanel);
    procedure SaveItemsInfo;
    procedure ClearItemsInfo;
    procedure RestoreItemsInfo;
    function  AddItem(ACaption: string; AIndex: integer;
      AEnabled: boolean; ATag: integer; AHint: string): TDCEditButton;
    procedure UpdateEditControls;
    procedure SetAplly(const Value: boolean);
    procedure InitItemsList;
    function EditTextValue(Value: string): string;
  protected
    function UniqueName(Component: TComponent): string; override;
  public
    { Public declarations }
    constructor Create(Component: TComponent; OutPanel: TDCCustomOutBarPanel); reintroduce;
    destructor Destroy; override;
    property OutPanel: TDCCustomOutBarPanel read FOutPanel write SetOutPanel;
    property Apply: boolean read FApply write SetAplly;
  end;

  TOutPanelProperty = class(TClassProperty)
  public
    procedure Edit; override;
    function GetValue: string; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TOutPanelEditor = class(TDefaultEditor)
  protected
    procedure EditProperty(PropertyEditor: TPropertyEditor;
      var Continue, FreeEditor: Boolean); override;
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

var
  OutPanelEditDlg: TOutPanelEditDlg;

implementation

{$R *.DFM}
type
  TDCEditOutPanel = class(TDCCustomOutBarPanel)
  end;

{ TOutPanelProperty }

procedure TOutPanelProperty.Edit;
var
  OutPanelEditor: TOutPanelEditDlg;
  ADCOutPanel: TDCCustomOutBarPanel;
begin
  ADCOutPanel :=  TDCCustomOutBarPanel(GetComponent(0));
  if ADCOutPanel = nil then Exit;

  OutPanelEditor := TOutPanelEditDlg.Create(Application, ADCOutPanel);
  with OutPanelEditor do
  begin
    try
      Designer := IFormDesigner(Self.Designer);
      Name := OutPanel.Name + '_' + GetName;
      Caption := OutPanel.Name+ '.' + GetName +' Editor';
      ShowModal;
      Free;
    except
     OutPanelEditor.Free;
    raise;
    end;
  end;
end;

function TOutPanelProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog]{ - [paSubProperties]};
end;

function TOutPanelProperty.GetValue: string;
begin
  Result := Format('(%s)', [GetPropType^.Name]);
end;


{ TOutPanelEditor }

procedure TOutPanelEditor.EditProperty(PropertyEditor: TPropertyEditor;
  var Continue, FreeEditor: Boolean);
var
  PropName: string;
begin
  PropName := PropertyEditor.GetName;
  if (CompareText(PropName, 'ITEMS') = 0) then
  begin
    PropertyEditor.Edit;
    Continue := False;
  end;
end;

procedure TOutPanelEditor.ExecuteVerb(Index: Integer);
 var
  APage: TDCCustomPage;
  APageControl: TDCCustomPageControl;
begin
  if (Component is TDCCustomPageControl) then
    APageControl := TDCCustomPageControl(Component)
  else
    APageControl := TDCCustomPage(Component).PageControl;

  case Index of
    0: Edit;
    1:
      begin
        APage := TDCCustomOutBarPanel.Create(Designer.Form);
        with APage do
        begin
          Name    := Designer.UniqueName(ClassName);
          Caption := Name;
          PageControl := APageControl;
        end;
      end;
    2:;
    3: APageControl.SelectNextPage(True);
    4: APageControl.SelectNextPage(False);
  end;
  APage := APageControl.ActivePage;
  Designer.SelectComponent(APage);
  Designer.Modified;
end;

function TOutPanelEditor.GetVerb(Index: Integer): string;
begin
  case Index of
   0: Result := '&Items Editor ...';
   1: Result := 'Ne&w Page';
   2: Result := '-';
   3: Result := '&Next Page';
   4: Result := '&Previous Page';
  end;
end;

function TOutPanelEditor.GetVerbCount: Integer;
begin
  Result := 5;
end;

{ TOutPanelEditDlg }

function TOutPanelEditDlg.AddItem(ACaption: string; AIndex: integer;
  AEnabled: boolean; ATag: integer; AHint: string): TDCEditButton;
begin
  Result := TDCEditButton.Create(Self);
  with Result do
  begin
    Caption    := ACaption;
    Hint       := AHint;
    ImageIndex := AIndex;
    Enabled    := AEnabled;
    Tag        := ATag;
  end;
end;

procedure TOutPanelEditDlg.ClearItemsInfo;
 var
  i: integer;
begin
  for i :=0 to FItemsInfo.Count-1 do
  begin
    TDCEditButton(FItemsInfo.Items[i]).Free;
  end
end;

constructor TOutPanelEditDlg.Create(Component: TComponent; OutPanel: TDCCustomOutBarPanel);
begin
  inherited Create(Component);
  FItemsInfo := TList.Create;
  FOutPanel  := OutPanel;
  with TDCEditOutPanel(FOutPanel) do
    case Style of
      isSmallImages: tvButtons.Images := SmallImages;
      isLargeImages: tvButtons.Images := LargeImages;
    end;
  SaveItemsInfo;
  FInitValues := False;
  FChanged    := False;
  InitItemsList;
  Apply := False;
end;

destructor TOutPanelEditDlg.Destroy;
begin
  ClearItemsInfo;
  FItemsInfo.Free;
  inherited;
end;

procedure TOutPanelEditDlg.SaveItemsInfo;
 var
  i :integer;
  OutButton, Button: TDCEditButton;
begin
  with TDCEditOutPanel(FOutPanel) do
  begin
    for i := 0 to Items.Count-1 do
    begin
      OutButton := Items.Buttons[i];
      with OutButton do
        Button    := AddItem(Caption, Index, Enabled, Tag, Hint);
      FItemsInfo.Add(Button);
    end;
  end;
end;

procedure TOutPanelEditDlg.SetOutPanel(const Value: TDCCustomOutBarPanel);
begin
  FOutPanel := Value;
end;

procedure TOutPanelEditDlg.acNewExecute(Sender: TObject);
 var
  Button: TDCEditButton;
  ItemName: string;
  TreeNode: TTreeNode;
begin
  with tvButtons do
  begin
    Items.BeginUpdate;
    try
      ItemName := Format('Item%d', [Items.Count]);
      Button   := AddItem(ItemName, Items.Count, True, 0, '');
      TreeNode := Items.AddObject(nil, ItemName, Button);
      TreeNode.ImageIndex    := Button.ImageIndex;
      TreeNode.SelectedIndex := Button.ImageIndex;
      tvButtons.Selected := TreeNode;
      Apply := True;
    finally
      Items.EndUpdate;
      UpdateEditControls;
      tvButtons.SetFocus;
    end;
  end;

end;

procedure TOutPanelEditDlg.acDeleteExecute(Sender: TObject);
begin
  with tvButtons do
  begin
    if Selected <> nil then
    begin
      Items.BeginUpdate;
      try
        TDCEditButton(Selected.Data).Free;
        Selected.Data := nil;
        Items.Delete(Selected);
        Apply := True;
      finally
        Items.EndUpdate;
        UpdateEditControls;
        tvButtons.SetFocus;
      end;
    end;
  end;
end;

procedure TOutPanelEditDlg.tvButtonsChanging(Sender: TObject;
  Node: TTreeNode; var AllowChange: Boolean);
begin
  FInitValues := True;
  with tvButtons do
  begin
    SaveItemValue(Selected);
    if Node<>nil then
      with TDCEditButton(Node.Data) do
      begin
        edCaption.Text     := Caption;
        edImageIndex.Text  := IntToStr(ImageIndex);
        cbEnabled.ItemIndex:= Integer(Enabled);
        edTag.Text         := IntToStr(Tag);
        edHint.Text        := TDCEditButton(Node.Data).Hint;
      end;
  end;
  FInitValues := False;
end;

procedure TOutPanelEditDlg.tvButtonsKeyPress(Sender: TObject;
  var Key: Char);
begin
  edCaption.SetFocus;
  edCaption.SelectAll;
  edCaption.Perform(WM_CHAR, Word(Key), 0);
  Key := #0;
end;

procedure TOutPanelEditDlg.UpdateEditControls;
begin
  FInitValues := True;
  if tvButtons.Selected = nil then
  begin
    edCaption.Text       := '';
    edCaption.Enabled    := False;
    edImageIndex.Text    := '';
    edImageIndex.Enabled := False;
    cbEnabled.Text       := '';
    cbEnabled.Enabled    := False;
    edTag.Text           := '0';
    edTag.Enabled        := False;
    edHint.Text          := '';
    edHint.Enabled       := False;
  end
  else begin
    edCaption.Enabled    := True;
    edImageIndex.Enabled := True;
    cbEnabled.Enabled    := True;
    edTag.Enabled        := True;
    edHint.Enabled       := True;
  end;
  FInitValues := False;
end;

procedure TOutPanelEditDlg.acApplyExecute(Sender: TObject);
 var
  TreeNode: TTreeNode;
  Button: TDCEditButton;
begin
  OutPanel.Buttons.BeginUpdate;
  SaveItemValue(tvButtons.Selected);
  TDCEditOutPanel(OutPanel).Items.Clear;
  TreeNode := tvButtons.Items.GetFirstNode;
  while TreeNode <> nil do
  begin
    Button   := OutPanel.AddButton;
    with Button do
    begin
      Caption    := TDCEditButton(TreeNode.Data).Caption;
      Hint       := TDCEditButton(TreeNode.Data).Hint;
      ImageIndex := TDCEditButton(TreeNode.Data).ImageIndex;
      Enabled    := TDCEditButton(TreeNode.Data).Enabled;
      Tag        := TDCEditButton(TreeNode.Data).Tag;
    end;
    TreeNode := TreeNode.GetNextSibling;
  end;
  OutPanel.UpdateButtonsPos;
  Apply := False;
  FChanged := True;
  OutPanel.Buttons.EndUpdate;
  Designer.Modified;
end;

procedure TOutPanelEditDlg.SetAplly(const Value: boolean);
begin
  FApply := Value;
  acApply.Enabled := Value;
end;

procedure TOutPanelEditDlg.InitItemsList;
 var
  i: integer;
  Button: TDCEditButton;
  TreeNode: TTreeNode;
begin
  with tvButtons do
  begin
    Items.BeginUpdate;
    try
      for i := 0 to TDCEditOutPanel(OutPanel).Items.Count-1 do
        with TDCEditOutPanel(OutPanel).Items.Buttons[i] do
        begin
          Button   := AddItem(StringReplace(Caption, #10, ' ',[rfReplaceAll]),
            ImageIndex, Enabled, Tag, Hint);
          TreeNode := Items.AddObject(nil, Button.Caption, Button);
          TreeNode.ImageIndex    := Button.ImageIndex;
          TreeNode.SelectedIndex := Button.ImageIndex;
        end;
    finally
      Items.EndUpdate;
    end;
  end;

end;

procedure TOutPanelEditDlg.FormActivate(Sender: TObject);
begin
  UpdateEditControls;
end;

procedure TOutPanelEditDlg.edCaptionChange(Sender: TObject);
begin
  if not FInitValues then Apply := True
end;

procedure TOutPanelEditDlg.SaveItemValue(Node: TTreeNode);
begin
  if Node<>nil then
    with TDCEditButton(Node.Data) do
    begin
      Caption    := edCaption.Text;
      ImageIndex := StrToInt(edImageIndex.Text);
      Enabled    := boolean(cbEnabled.ItemIndex);
      Tag        := StrToInt(edTag.Text);
      TDCEditButton(Node.Data).Hint := edHint.Text;
      Node.ImageIndex    := ImageIndex;
      Node.SelectedIndex := ImageIndex;
      Node.Text          := Caption;
    end;
end;

procedure TOutPanelEditDlg.acClearExecute(Sender: TObject);
 var
  TreeNode, NextNode: TTreeNode;
begin
  tvButtons.Items.BeginUpdate;
  try
    TreeNode := tvButtons.Items.GetFirstNode;
    while TreeNode <> nil do
    begin
      TDCEditButton(TreeNode.Data).Free;
      TreeNode.Data := nil;

      NextNode := TreeNode.GetNextSibling;
      tvButtons.Items.Delete(TreeNode);
      TreeNode := NextNode;
    end;
    Apply := True;
  finally
    tvButtons.Items.EndUpdate;
    UpdateEditControls;
    tvButtons.SetFocus;
  end;
end;

function TOutPanelEditDlg.UniqueName(Component: TComponent): string;
 var
  Temp: string;
begin
  if (Component <> nil) then Temp := Component.ClassName;
  if (UpCase(Temp[1]) = 'T') and (Length(Temp) > 1) then
     System.Delete(Temp, 1, 1);
  Result := Designer.UniqueName(Temp);
end;

procedure TOutPanelEditDlg.acCancelExecute(Sender: TObject);
begin
  if FChanged then RestoreItemsInfo;
  ModalResult := mrCancel;
end;

procedure TOutPanelEditDlg.RestoreItemsInfo;
 var
  i: integer;
  Button, SavButton: TDCEditButton;
begin
  OutPanel.Buttons.BeginUpdate;
  TDCEditOutPanel(OutPanel).Items.Clear;
  for i := 0 to FItemsInfo.Count-1 do
  begin
    Button    := OutPanel.AddButton;
    SavButton := TDCEditButton(FItemsInfo.Items[i]);
    with Button do
    begin
      Caption    := SavButton.Caption;
      Hint       := SavButton.Hint;
      ImageIndex := SavButton.ImageIndex;
      Enabled    := SavButton.Enabled;
      Tag        := SavButton.Tag;
    end;
  end;
  OutPanel.UpdateButtonsPos;
  OutPanel.Buttons.EndUpdate;
end;

procedure TOutPanelEditDlg.acOkExecute(Sender: TObject);
begin
  if Apply then acApply.Execute;
  ModalResult := mrOK;
end;

procedure TOutPanelEditDlg.edCaptionButtonClick(Sender: TObject);
begin
  edCaption.Text := EditTextValue(edCaption.Text);
end;

function TOutPanelEditDlg.EditTextValue(Value: string): string;
 var
  Temp: string;
  Value1, Value2: string;
  pValue: PChar;
begin
  Result := Value;

  pValue := PChar(Value);
  Value1 := '';
  while pValue^ <> #0 do
  begin
    Value1 := Value1 + pValue^;
    if pValue^ = #13 then Value1 := Value1 + #10;
    Inc(pValue);
  end;

  with TStringEditDlg.Create(Application) do
  begin
    try
      Caption   := 'Edit Text';
      Memo.Text := Value1;
      if ShowModal = mrOk then
      begin
        Temp  := Memo.Text;
        pValue := PChar(Temp);
        Value2:= '';
        while pValue^ <> #0 do
        begin
          if pValue^ <> #10 then Value2:= Value2 + pValue^;
          Inc(pValue);
        end;
        while (Length(Value2) > 0) and (Temp[Length(Value2)] < ' ') do
          System.Delete(Value2, Length(Value2), 1);
        Result := Value2;
      end;
    finally
      Free;
    end;
  end;
end;

procedure TOutPanelEditDlg.edHintButtonClick(Sender: TObject);
begin
  edHint.Text := EditTextValue(edHint.Text);
end;

end.
