{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCListColEdit;

interface
{$I DCConst.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ImgList, ComCtrls, ToolWin, DsgnIntf, DsgnWnds,
  ActnList, Menus, StdActns, DCChoice, DCDBGrids;

type
  TListColEditForm = class(TDesignWindow)
    ToolBar: TToolBar;
    tbNew: TToolButton;
    tbDelete: TToolButton;
    tbSeparator: TToolButton;
    imToolBar: TImageList;
    tbAll: TToolButton;
    tbDefault: TToolButton;
    ColumnsActionList: TActionList;
    aNew: TAction;
    aDelete: TAction;
    aAll: TAction;
    aDefault: TAction;
    PopupMenu: TPopupMenu;
    aToolBar: TAction;
    AddField1: TMenuItem;
    Delete1: TMenuItem;
    aSelectAll: TAction;
    SelectAll1: TMenuItem;
    N1: TMenuItem;
    AddAllFields1: TMenuItem;
    RestoreDefault1: TMenuItem;
    lvColumns: TListView;
    ToolBar1: TMenuItem;
    aDeleteAll: TAction;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure aNewExecute(Sender: TObject);
    procedure aDeleteExecute(Sender: TObject);
    procedure aDeleteAllExecute(Sender: TObject);
    procedure aAllExecute(Sender: TObject);
    procedure aToolBarExecute(Sender: TObject);
    procedure aDefaultExecute(Sender: TObject);
    procedure UpdateColumns;
    procedure lvColumnsChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure aSelectAllExecute(Sender: TObject);
    function CheckCollection: Boolean;
    procedure FormResize(Sender: TObject);
    procedure lvColumnsDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure lvColumnsDragDrop(Sender, Source: TObject; X, Y: Integer);
  protected
    function UniqueName(Component: TComponent): string; override;
    procedure Activated; override;
  private
    { Private declarations }
    FDCGridEdit: TDCGridEdit;
    procedure SetDCGridEdit(const Value: TDCGridEdit);
  public
    property DCGridEdit: TDCGridEdit read FDCGridEdit  write SetDCGridEdit;
    procedure FormModified; override;
    procedure FormClosed(Form: TCustomForm); override;
    procedure ComponentDeleted(Component: IPersistent); override;
  end;

  TListColProperty = class(TClassProperty)
  public
    procedure Edit; override;
    function GetValue: string; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

var
  ListColEditForm: TListColEditForm;

implementation

{$R *.DFM}
//{$R DCCOlEdit.RES}

const
 bmNew    = 'DBC_NEW';
 bmDelete = 'DBC_DELETE';
 bmAll    = 'DBC_ALL';
 bmDefault= 'DBC_DEFAULT';

 fmtListViewItem = '%2.2d - TColumn: %s';

procedure TListColProperty.Edit;
var
  ColumnsEditor: TListColEditForm;
  ADCGridEdit: TDCGridEdit;
  I: integer;
begin
  ColumnsEditor := nil;
  ADCGridEdit :=  TDCGridEdit(GetComponent(0));

  if ADCGridEdit = nil then Exit;

  {  If ColumnsEditor fo ADCGridEdit not found create it
    esle SetFocus }

  {Attempt to Find it}
  for I := 0 to Screen.FormCount - 1 do begin
    if Screen.Forms[I] is TListColEditForm then
      if (TListColEditForm(Screen.Forms[I]).DCGridEdit = ADCGridEdit) and
         (TListColEditForm(Screen.Forms[I]).Name = ADCGridEdit.Name+'_'+GetName)
      then begin
        { Great!. Find }
        ColumnsEditor := TListColEditForm(Screen.Forms[I]);
        Break;
      end;
  end;

  if ColumnsEditor = nil then
  begin
    ColumnsEditor := TListColEditForm.Create(Application);
    try
      ColumnsEditor.Designer := IFormDesigner(Designer);
      ColumnsEditor.DCGridEdit := ADCGridEdit;
      ColumnsEditor.Name := ADCGridEdit.Name + '_' + GetName;
      with ColumnsEditor do
        Caption := 'Editing ' + DCGridEdit.Name + '.' + GetName;
      ColumnsEditor.Show;
    except
      ColumnsEditor.Free;
      raise;
    end;
  end
  else begin
    ColumnsEditor.Show;
    if ColumnsEditor.WindowState = wsMinimized then
      ColumnsEditor.WindowState := wsNormal;
  end;
end;

function TListColProperty.GetValue: string;
begin
  Result := Format('(%s)', [GetPropType^.Name]);
end;

function TListColProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] - [paSubProperties];
end;

function TListColEditForm.CheckCollection: Boolean;
begin
  Result := (DCGridEdit <> nil) and (DCGridEdit.ListBoxColumns <> nil)
    and (Designer.Form <> nil);
end;

procedure TListColEditForm.SetDCGridEdit(const Value: TDCGridEdit);
begin
  if FDCGridEdit <> Value then begin
    FDCGridEdit := Value;
    UpdateColumns;
  end;
end;

procedure TListColEditForm.FormCreate(Sender: TObject);
 var
  Bmp: TBitmap;
begin
  {Initialize Images}
  inherited;

  Bmp := TBitmap.Create;

  imToolBar.Clear;

  Bmp.LoadFromResourceName(HInstance, bmNew);    // 0
  imToolBar.AddMasked(Bmp, clBtnFace);
  Bmp.LoadFromResourceName(HInstance, bmDelete); // 1
  imToolBar.AddMasked(Bmp, clBtnFace);
  Bmp.LoadFromResourceName(HInstance, bmAll);    // 2
  imToolBar.AddMasked(Bmp, clBtnFace);
  Bmp.LoadFromResourceName(HInstance, bmDefault);// 3
  imToolBar.AddMasked(Bmp, clBtnFace);

  aNew.ImageIndex     := 0;
  aDelete.ImageIndex  := 1;
  aAll.ImageIndex     := 2;
  aDefault.ImageIndex := 3;

end;

procedure TListColEditForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TListColEditForm.aNewExecute(Sender: TObject);
 var
  Column: TColumn;
begin
  {Add New Field}
  Column := DCGridEdit.ListBoxColumns.Add;
  Column.Font := DCGridEdit.Font;
  UpdateColumns;
  Designer.Modified;
  lvColumns.Items[lvColumns.Items.Count-1].Selected := True;
  lvColumnsChange(nil,nil,ctState);
end;

procedure TListColEditForm.aDeleteAllExecute(Sender: TObject);
 var
  I:Integer;
  {$IFDEF DELPHI_V5}
    FComponents: IDesignerSelections;
  {$ELSE}
    FComponents: TComponentList;
  {$ENDIF}
begin
  {Delete All Fiedls}

  {$IFNDEF DELPHI_V5}
     FComponents := TComponentList.Create;
  {$ELSE}
     FComponents := CreateSelectionList;
  {$ENDIF}
  try
    DCGridEdit.ListBoxColumns.BeginUpdate;
    lvColumns.Items.BeginUpdate;

    for I := lvColumns.Items.Count - 1 downto 0 do
     if Assigned(lvColumns.Items[i].Data)
     then begin
      {$IFDEF DELPHI_V5}
         FComponents.Add(MakeIPersistent(TColumn(lvColumns.Items[i].Data)));
      {$ELSE}
         FComponents.Add(TColumn(lvColumns.Items[i].Data));
      {$ENDIF}
     end;
    lvColumns.Items.Clear;

    for I := 0 to FComponents.Count - 1 do
      {$IFDEF DELPHI_V5}
         ExtractPersistent(FComponents[i]).Free;
      {$ELSE}
         FComponents[i].Free;
      {$ENDIF}
  finally
    lvColumns.Items.EndUpdate;
    DCGridEdit.ListBoxColumns.EndUpdate;
    {$IFNDEF DELPHI_V5}
      FComponents.Free;
    {$ENDIF}
    Designer.Modified;
  end;
end;

procedure TListColEditForm.aDeleteExecute(Sender: TObject);
 var
  I, SelectedItem:Integer;
  {$IFDEF DELPHI_V5}
    FComponents: IDesignerSelections;
  {$ELSE}
    FComponents: TComponentList;
  {$ENDIF}
begin
  {Delete Selected Fiedls}
  SelectedItem := -1;
  if (lvColumns.SelCount > 0) then begin
    {$IFNDEF DELPHI_V5}
       FComponents := TComponentList.Create;
    {$ELSE}
       FComponents := CreateSelectionList;
    {$ENDIF}
    try
      DCGridEdit.ListBoxColumns.BeginUpdate;
      lvColumns.Items.BeginUpdate;
      SelectedItem := lvColumns.Items.IndexOf(lvColumns.Selected);

      for I := lvColumns.Items.Count - 1 downto 0 do
        if (lvColumns.Items[i].Selected = True) and
            Assigned(lvColumns.Items[i].Data)
        then begin
          {$IFDEF DELPHI_V5}
             FComponents.Add(MakeIPersistent(TColumn(lvColumns.Items[i].Data)));
          {$ELSE}
             FComponents.Add(TColumn(lvColumns.Items[i].Data));
          {$ENDIF}
        end;

      lvColumns.Items.Clear;

      for I := 0 to FComponents.Count - 1 do
        {$IFDEF DELPHI_V5}
           ExtractPersistent(FComponents[i]).Free;
        {$ELSE}
           FComponents[i].Free;
        {$ENDIF}
    finally
      lvColumns.Items.EndUpdate;
      DCGridEdit.ListBoxColumns.EndUpdate;
      {$IFNDEF DELPHI_V5}
        FComponents.Free;
      {$ENDIF}
      Designer.Modified;
      if (lvColumns.Items.Count > 0) then
        if (SelectedItem > lvColumns.Items.Count - 1) then
           lvColumns.Items[lvColumns.Items.Count-1].Selected := True
        else
           lvColumns.Items[SelectedItem].Selected := True;
        lvColumnsChange(nil,nil,ctState);
    end;
   end;
end;

procedure TListColEditForm.aAllExecute(Sender: TObject);
 var
   I: Integer;
   Column: TColumn;
begin
  {Add All Fields}
  for I := 0 to DCGridEdit.DataSet.FieldCount - 1 do
  begin
    Column := DCGridEdit.ListBoxColumns.Add;
    Column.FieldName := DCGridEdit.DataSet.Fields[i].FieldName;
    Column.Font := DCGridEdit.Font;
  end;
  UpdateColumns;
  Designer.Modified;
end;

procedure TListColEditForm.aToolBarExecute(Sender: TObject);
begin
  aToolBar.Checked := not aToolBar.Checked;
  ToolBar.Visible  := aToolBar.Checked
end;

procedure TListColEditForm.aDefaultExecute(Sender: TObject);
 var
  I:Integer;
  ListItem: TListItem;
begin
  {Restore Default}
  if (lvColumns.SelCount > 0) then begin
    ListItem := lvColumns.Selected;
    for i := 0 to lvColumns.SelCount - 1 do begin
      TColumn(ListItem.Data).RestoreDefaults;
      ListItem := lvColumns.GetNextItem(ListItem,sdBelow,[isSelected]);
    end;
    lvColumnsChange(nil,nil,ctState);
    Designer.Modified;
  end;
end;

procedure TListColEditForm.UpdateColumns;
 var
  I: longint;
  UpdateColumns: boolean;
  ListItem: TListItem;
begin
  if not CheckCollection then
  begin
    lvColumns.Items.Clear;
    lvColumnsChange(nil,nil,ctState);
    Exit;
  end;

  lvColumns.StateImages := DCGridEdit.Images;

  UpdateColumns := (lvColumns.Items.Count <> DCGridEdit.ListBoxColumns.Count );
  I := 0;
  while not(UpdateColumns) and (I <= DCGridEdit.ListBoxColumns.Count - 1) do
  begin
    UpdateColumns := (lvColumns.Items[I].Data <> DCGridEdit.ListBoxColumns[I]);
    Inc(I);
  end;

  if UpdateColumns then
  begin
    lvColumns.Items.BeginUpdate;
    lvColumns.Items.Clear;
      try
        if (DCGridEdit.ListBoxColumns.State = csCustomized) then
           for I := 0 to DCGridEdit.ListBoxColumns.Count - 1 do
           begin
             ListItem := lvColumns.Items.Add;
             ListItem.Caption := Format(fmtListViewItem,[I,DCGridEdit.ListBoxColumns[i].DisplayName]);
             ListItem.Data := DCGridEdit.ListBoxColumns[i];
             ListItem.StateIndex := DCGridEdit.ListBoxColumns[i].ItemIndex;
           end;
      finally
        lvColumns.Items.EndUpdate;
      end;
  end else
    for I := 0 to DCGridEdit.ListBoxColumns.Count - 1 do
    begin
        lvColumns.Items[i].Caption    := Format(fmtListViewItem,[I,DCGridEdit.ListBoxColumns[i].DisplayName]);
        lvColumns.Items[i].StateIndex := DCGridEdit.ListBoxColumns[i].ItemIndex;
    end;
  lvColumnsChange(nil,nil,ctState);
end;


procedure TListColEditForm.lvColumnsChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
 var
  {$IFDEF DELPHI_V5}
    FComponents: TDesignerSelectionList;
  {$ELSE}
    FComponents: TComponentList;
  {$ENDIF}
  I: Integer;
begin
   {Check Caption Staus}
   aDelete.Enabled    := lvColumns.SelCount > 0;
   aAll.Enabled       := Assigned(DCGridEdit) and
                         Assigned(DCGridEdit.DataSet) and
                         (DCGridEdit.DataSet.FieldCount > 0) and
                         (lvColumns.Items.Count = 0);
   aDefault.Enabled   := (lvColumns.SelCount > 0);
   aSelectAll.Enabled := (lvColumns.Items.Count > 0);

  if CheckCollection and Active then
  begin
    {$IFNDEF DELPHI_V5}
       FComponents := TComponentList.Create;
    {$ELSE}
       FComponents := TDesignerSelectionList.Create;
    {$ENDIF}
    if (lvColumns.SelCount > 0) then begin
      for i := lvColumns.Items.Count - 1 downto 0 do
        if (lvColumns.Items[i].Selected = True) and
           Assigned(lvColumns.Items[i].Data)
         then
           FComponents.Add(TColumn(lvColumns.Items[i].Data));
    end
    else
      FComponents.Add(DCGridEdit.ListBoxColumns);
    SetSelection(FComponents);

  end;

end;

procedure TListColEditForm.Activated;
begin
  lvColumnsChange(nil,nil,ctState);
end;

function TListColEditForm.UniqueName(Component: TComponent): string;
var
  Temp: string;
begin
  if (Component <> nil) then Temp := Component.ClassName
  else Temp := TColumn.ClassName;
  if (UpCase(Temp[1]) = 'T') and (Length(Temp) > 1) then
    System.Delete(Temp, 1, 1);
  Result := Designer.UniqueName(Temp);
end;

procedure TListColEditForm.FormModified;
begin
  if not (csDestroying in ComponentState) then UpdateColumns;
end;

procedure TListColEditForm.FormClosed(Form: TCustomForm);
begin
  if (Form = Designer.Form) then
  begin
    aDeleteAllExecute(Self);
    Close;
  end;
end;

procedure TListColEditForm.ComponentDeleted(Component: IPersistent);
begin
  if ExtractPersistent(Component) = DCGridEdit then
  begin
    FDCGridEdit := nil;
    Close;
  end;
end;

procedure TListColEditForm.aSelectAllExecute(Sender: TObject);
 var
  I: integer;
begin
  for I := 0 to lvColumns.Items.Count - 1 do
      lvColumns.Items[i].Selected := True;
end;

procedure TListColEditForm.FormResize(Sender: TObject);
begin
  lvColumns.Columns[0].Width := lvColumns.ClientWidth;
end;

procedure TListColEditForm.lvColumnsDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := True;
end;

procedure TListColEditForm.lvColumnsDragDrop(Sender, Source: TObject; X,
  Y: Integer);
 var
  Column: TColumn;
  ColumnFrom, ColumnTarget: TColumn;
begin
  { Move Column                           }
  { lvColumns.Selected   - Dragged Column }
  { lvColumns.DropTarget                  }

  if not Assigned(Sender) or not Assigned(Source) or
     not Assigned(lvColumns.DropTarget) or
     not Assigned(lvColumns.Selected) or
    (lvColumns.Selected.Index =  lvColumns.DropTarget.Index) then Exit;

  Column := TColumn.Create(nil);
  ColumnFrom  := DCGridEdit.ListBoxColumns[lvColumns.Selected.Index];
  ColumnTarget:= DCGridEdit.ListBoxColumns[lvColumns.DropTarget.Index];
  Column.Assign(ColumnFrom);
  try
    ColumnFrom.Assign(ColumnTarget);
    ColumnTarget.Assign(Column);
  finally
    Column.Free;
  end;
  UpdateColumns;
  Designer.Modified;
  lvColumnsChange(nil,nil,ctState);
end;

end.
