{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCKnots;

interface
{$I DCConst.inc}

uses
  Windows, SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Menus,
  Controls, Dialogs, Forms, StdCtrls, Buttons, ExtCtrls, Math, ImgList,
  ComCtrls, DB, Grids, DCDBGrids, DCChoice, DCPopupWindow, DCEditTools,
  DCConst {$IFDEF DELPHI_V5}, DCADOCtrl {$ENDIF};

type
  TKnotsColumnValue  = (cvColor, cvWidth, cvFont, cvAlignment, cvReadOnly, cvTitleColor,
    cvTitleCaption, cvTitleAlignment, cvTitleFont, cvComment, cvDisplayFormat);
  TKnotsColumnValues = set of TKnotsColumnValue;

const
  ColumnTitleValues = [cvTitleColor..cvTitleFont];

type

  TDCCustomTreeGrid = class;
  TKnotColumn = class;

  TKnotColumnTitle = class(TPersistent)
  private
    FColumn: TKnotColumn;
    FCaption: string;
    FFont: TFont;
    FColor: TColor;
    FAlignment: TAlignment;
    procedure FontChanged(Sender: TObject);
    function GetAlignment: TAlignment;
    function GetColor: TColor;
    function GetCaption: string;
    function GetFont: TFont;
    function IsAlignmentStored: Boolean;
    function IsColorStored: Boolean;
    function IsFontStored: Boolean;
    function IsCaptionStored: Boolean;
    procedure SetAlignment(Value: TAlignment);
    procedure SetColor(Value: TColor);
    procedure SetFont(Value: TFont);
    procedure SetCaption(const Value: string); virtual;
  protected
    procedure RefreshDefaultFont;
  public
    constructor Create(Column: TKnotColumn);
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    function DefaultAlignment: TAlignment;
    function DefaultColor: TColor;
    function DefaultFont: TFont;
    function DefaultCaption: string;
    procedure RestoreDefaults; virtual;
    property Column: TKnotColumn read FColumn;
  published
    property Alignment: TAlignment read GetAlignment write SetAlignment stored
      IsAlignmentStored;
    property Caption: string read GetCaption write SetCaption stored
      IsCaptionStored;
    property Color: TColor read GetColor write SetColor stored IsColorStored;
    property Font: TFont read GetFont write SetFont stored IsFontStored;
  end;

  TKnotOption  = (kcIndexed, kcReadOnly, kcShowEdit, kcSizing, kcVisible);
  TKnotOptions = set of TKnotOption;

  TKnotColumn  = class(TCollectionItem)
  private
    FOptions: TKnotOptions;
    FAlignment: TAlignment;
    FTitle: TKnotColumnTitle;
    FMaxWidth: TWidth;
    FMinWidth: TWidth;
    FWidth: TWidth;
    FName: string;
    FComment: string;
    FColor: TColor;
    FFont: TFont;
    FAssignedValues: TKnotsColumnValues;
    FItemIndex: integer;
    FIndexStyle: TColumnIndexStyle;
    FDisplayFormat: string;
    procedure SetColor(const Value: TColor);
    procedure SetFont(const Value: TFont);
    procedure SetTitle(const Value: TKnotColumnTitle);
    function GetAlignment: TAlignment;
    function GetColor: TColor;
    function GetFont: TFont;
    procedure FontChanged(Sender: TObject);
    procedure SetItemIndex(const Value: integer);
    procedure SetIndexStyle(const Value: TColumnIndexStyle);
    function GetWidth: TWidth;
    procedure SetAlignment(const Value: TAlignment);
    procedure SetName(const Value: string);
    procedure SetMaxWidth(const Value: TWidth);
    procedure SetMinWidth(const Value: TWidth);
    procedure SetWidth(const Value: TWidth);
    procedure SetDisplayFormat(const Value: string);
    function IsAlignmentStored: Boolean;
    function IsColorStored: Boolean;
    function IsFontStored: Boolean;
    function IsWidthStored: Boolean;
    function IsCommentStored: Boolean;
    procedure SetOptions(const Value: TKnotOptions);
    procedure SetComment(const Value: string);
    function GetComment: string;
  protected
    function GetDisplayName: string; override;
    procedure RefreshDefaultFont;
  public
    constructor Create(Collection: TCollection); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    function GetGrid: TDCCustomTreeGrid;
    function DefaultAlignment: TAlignment;
    function DefaultColor: TColor;
    function DefaultFont: TFont;
    function DefaultWidth: Integer;
    function DefaultComment: string;
    procedure RestoreDefaults; virtual;
    property AssignedValues: TKnotsColumnValues read FAssignedValues;
    property Grid: TDCCustomTreeGrid read GetGrid;
  published
    property Options: TKnotOptions read FOptions write SetOptions;
    property Alignment: TAlignment read GetAlignment write SetAlignment stored
      IsAlignmentStored;
    property Title: TKnotColumnTitle read FTitle write SetTitle;
    property MaxWidth: TWidth read FMaxWidth write SetMaxWidth;
    property MinWidth: TWidth read FMinWidth write SetMinWidth;
    property Width: TWidth read GetWidth write SetWidth stored IsWidthStored;
    property Name: string read FName write SetName;
    property Comment: string read GetComment write SetComment stored IsCommentStored;
    property Color: TColor read GetColor write SetColor stored  IsColorStored;
    property Font: TFont read GetFont write SetFont stored IsFontStored;
    property ItemIndex: integer read FItemIndex write SetItemIndex;
    property IndexStyle: TColumnIndexStyle read FIndexStyle write SetIndexStyle default idxNone;
    property DisplayFormat: string read FDisplayFormat write SetDisplayFormat;
  end;

  TKnotColumns = class(TCollection)
  private
    FOwner: TDCCustomTreeGrid;
    function GetItem(Index: Integer): TKnotColumn;
    procedure SetItem(Index: Integer; Value: TKnotColumn);
  protected
    function GetOwner: TPersistent; override;
    procedure Update(Item: TCollectionItem); override;
  public
    constructor Create(AOwner: TDCCustomTreeGrid);
    function Add: TKnotColumn;
    property Grid: TDCCustomTreeGrid read FOwner;
    property Owner: TDCCustomTreeGrid read FOwner;
    property Items[Index: Integer]: TKnotColumn read GetItem write SetItem; default;
  end;

  TKnotItems = class;
  TKnotItem  = class(TObject)
  private
    FFlag: WORD;
    FOwner: TKnotItems;
    FParent: TKnotItem;
    FName: string;
    FData: Pointer;
    FKnotID: integer;
    FChildKnots: TList;
    FLevel: smallint;
    FIndex: integer;
    FNormalImage: smallint;
    FSelectImage: smallint;
    FVisible: boolean;
    function GetChild(Index: integer): TKnotItem;
    function GetChildCount: integer;
    procedure SetChild(Index: integer; const Value: TKnotItem);
    procedure SetData(const Value: Pointer);
    procedure SetExpanded(const Value: boolean);
    procedure DeleteChildKnot(KnotIndex: integer);
    function GetVisibleKnotCount: integer;
    function GetExpanded: boolean;
    procedure SetNormalImage(const Value: smallint);
    procedure SetSelectImage(const Value: smallint);
    procedure SetName(const Value: string);
    function GetGrid: TDCCustomTreeGrid;
    procedure SetVisible(const Value: boolean);
    function GetVisibleChildCount: integer;
  public
    constructor Create(AOwner: TKnotItems; AParent: TKnotItem; AName: string);
    destructor Destroy; override;
    procedure Clear;
    procedure Expand(Recurse: boolean);
    procedure Collapse(Recurse: boolean);
    function GetNext: TKnotItem;
    function GetNextSibling: TKnotItem;
    function GetNextVisible: TKnotItem;
    function GetPrev: TKnotItem;
    function GetPrevSibling: TKnotItem;
    function GetPrevVisible: TKnotItem;
    property Owner: TKnotItems read FOwner;
    property Parent: TKnotItem read FParent write FParent;
    property KnotID: integer read FKnotID;
    property Expanded: boolean read GetExpanded write SetExpanded;
    property Childs[Index: integer]: TKnotItem read GetChild write SetChild;
    property Data: Pointer read FData write SetData;
    property ChildCount: integer read GetChildCount;
    property Name: string read FName write SetName;
    property Level: smallint read FLevel;
    property VisibleKnotCount: integer read GetVisibleKnotCount;
    property VisibleChilds: integer read GetVisibleChildCount;
    property Index: integer read FIndex;
    property NormalImage: smallint read FNormalImage write SetNormalImage;
    property SelectImage: smallint read FSelectImage write SetSelectImage;
    property Grid: TDCCustomTreeGrid read GetGrid;
    property Visible: boolean read FVisible write SetVisible;
  end;

  TKnotState = (ksBrowse, ksInsert, ksEdit, ksUpdate);

  TKnotItems = class(TPersistent)
  private
    FOwner: TDCCustomTreeGrid;
    FRootKnot: TKnotItem;
    FLastKnotID: integer;
    FUpdateCount: integer;
    FState: TKnotState;
    function GetItem(Index: integer): TKnotItem;
    procedure SetItem(Index: integer; const Value: TKnotItem);
    function GetCount: integer;
    function GetVisibleKnotCount: integer;
    procedure UpdateTreeGrid;
    function GetUpdateingState: boolean;
    procedure SetUpdateState(Updating: Boolean);
  public
    constructor Create(AOwner: TDCCustomTreeGrid);
    destructor Destroy; override;
    function Add(Name: string; Position: integer = KNOT_END): TKnotItem;
    function AddChild(ParentKnot: TKnotItem; Name: string;
      Position: integer = KNOT_END): TKnotItem;
    function Delete(Knot: TKnotItem): boolean;
    procedure Move(KnotItem, DestKnot: TKnotItem; Position: integer = KNOT_END);
    procedure Exchange(KnotItem1, KnotItem2: TKnotItem);
    procedure Clear;
    function GetKnot(KnotID: integer; var KnotItem: TKnotItem): boolean;
    function GetKnotFromChild(ParentKnot: TKnotItem;
      KnotID: integer; var KnotItem: TKnotItem): boolean;
    function SelectKnot(KnotItem: TKnotItem; Offset: integer): TKnotItem;
    function First: TKnotItem;
    procedure BeginUpdate(LockScreen: boolean = False);
    procedure EndUpdate;
    procedure SetState(Value: TKnotState);
    procedure RebuildIndexes(ParentKnot: TKnotItem; FirstIndex: integer);
    property Owner: TDCCustomTreeGrid read FOwner;
    property Grid: TDCCustomTreeGrid read FOwner;
    property Items[Index: integer]: TKnotItem read GetItem write SetItem;
    property Count:integer read GetCount;
    property LastKnotID: integer read FLastKnotID;
    property VisibleKnotCount: integer read GetVisibleKnotCount;
    property State: TKnotState read FState;
    property Updating: boolean read GetUpdateingState;
  end;

  TKnotBookmarkList = class
  private
    FList: TList;
    FGrid: TDCCustomTreeGrid;
    FCache: integer;
    FCacheIndex: Integer;
    FCacheFind: boolean;
    FSortItems: boolean;
    function GetCount: integer;
    procedure ListChanged;
    function GetItem(Index: Integer): integer;
    function Compare(const KnotID1, KnotID2: integer): Integer;
  public
    constructor Create(AGrid: TDCCustomTreeGrid);
    destructor Destroy; override;
    procedure Clear;
    procedure Delete;
    procedure Sort;
    procedure Select(const KnotID: integer; Value: boolean);
    function Find(const KnotID: integer; var Index: Integer): Boolean;
    function IndexOf(const KnotID: integer): Integer;
    function KnotSelected(const KnotID: integer): Boolean;
    property Count: Integer read GetCount;
    property Items[Index: Integer]: integer read GetItem; default;
    property SortItems: boolean read FSortItems write FSortItems;
  end;

  TTreeGridOption = (tgEditing, tgAlwaysShowEditor, tgTitles, tgIndicator,
    tgColumnResize, tgColLines, tgRowLines, tgColMoving, tgRowMoving, tgTabs,
    tgRowSelect,  tgAlwaysShowSelection, tgConfirmDelete, tgCancelOnExit,
    tgMultiSelect, tgMarker, tgTreePath, tgTitleClicked, tgUserRowHeight,
    tgRowSizing, tgHighlightRow, tgFlatButtons, tgTreePathResize, tgFixedLines,
    tgCompleteLines);

  TTreeGridMessageType = (mtLoadData, mtEmptyColumns);

  TTreeGridOptions = set of TTreeGridOption;

  TTreeDrawCollumnCellEvent = procedure (Sender: TObject; const Rect: TRect;
    Canvas: TCanvas; DataCol: Integer; Column: TKnotColumn; KnotItem: TKnotItem;
    State: TGridDrawState) of object;
  TTreeCellTextEvent  = procedure (Sender: TObject; KnotItem: TKnotItem; var
    Text: string) of object;
  TTreeGridClickEvent = procedure (Column: TKnotColumn) of object;
  TTreeGridClipEvent  = procedure (Sender: TObject; X, Y : LongInt;
    var Show: boolean) of object;
  TTreeGridKnotEvent  = procedure (KnotItem: TKnotItem;
    var Apply: boolean) of object;
  TTreeGridEditEvent  = procedure (KnotItem: TKnotItem;
    var Edit: TDCCustomChoiceEdit; Column: TKnotColumn; var CanCreate: boolean) of object;
  TTreeGridUpdateEvent  = procedure (KnotItem: TKnotItem;
    var Edit: TDCCustomChoiceEdit; Column: TKnotColumn) of object;
  TTreeGridKnotDeleteEvent = procedure (KnotItem: TKnotItem;
    var Apply: boolean; ComponentState: TComponentState) of object;
  TTreeGridCommentEvent = procedure(Sender: TObject; Mode: integer;
    Column: TKnotColumn) of object;
  TTreeGridSelectKnot  = procedure(Sender: TObject; KnotItem: TKnotItem) of object;
  TPaintMessageEvent   = procedure(Sender: TObject; Canvas: TCanvas; ARect: TRect;
    MessageType: TTreeGridMessageType; UpdateMessage: string) of object;

  TTreeGridHitTest    = (htNowere, htOnButton, htOnIcon, htOnLabel);
  TFixedCell = (fcColumn, fcIndicator, fcMarker, fcTreePath);

  TDCCustomTreeGrid = class(TCustomGrid)
  private
    FKnots: TKnotItems;
    FKnotCount: integer;
    FIndicators: TImageList;
    FTreeImages: TImageList;
    FImages: TImageList;
    FTitleFont: TFont;
    FColumns: TKnotColumns;
    FOptions: TTreeGridOptions;
    FTitleOffset, FIndicatorOffset: Byte;
    FUpdateLock: Byte;
    FLayoutLock: Byte;
    FSelfChangingTitleFont: Boolean;
    FDefaultDrawing: Boolean;
    FMousePoint: TPoint;
    FClickedCol: Integer;
    FCurrentCol: Integer;
    FClipDown: boolean;
    FClipPopup: TObject;
    FClipPopupVisible: boolean;
    FFirstGridCell: integer;
    FTreePathWidth: integer;
    FSetTreePath: boolean;
    FFirstVisible: TKnotItem;
    FFirstIndex: integer;
    FBookmarks: TKnotBookmarkList;
    FOnColumnMoved: TMovedEvent;
    FActiveKnot: TKnotItem;
    FSelectedKnot: TKnotItem;
    FOnCellClick: TTreeGridClickEvent;
    FOnTitleClick:TTreeGridClickEvent;
    FOnClipClick: TTreeGridClipEvent;
    FInplaceEdit: TDCCustomChoiceEdit;
    FEditorMode: boolean;
    FIsModified: boolean;
    FRowUpdated: boolean;
    FIsESCKey: boolean;
    FInplaceCol, FInplaceRow: Longint;
    FTreePathSizing: boolean;
    FSizingOff: integer;
    FOnDelete: TTreeGridKnotDeleteEvent;
    FOnInsert: TTreeGridKnotEvent;
    FOnUpdate: TTreeGridUpdateEvent;
    FOnDrawColumnCell: TTreeDrawCollumnCellEvent;
    FOnTreeCellText: TTreeCellTextEvent;
    FHintWindow: TDCMessageWindow;
    FHintRow: integer;
    FOnRowMoved: TMovedEvent;
    FOnSelectCell: TSelectCellEvent;
    FOnTopLeftChanged: TNotifyEvent;
    FOnCreateCellEdit: TTreeGridEditEvent;
    FOnDestroyCellEdit: TNotifyEvent;
    FOnClipButtonClick: TNotifyEvent;
    FPopupTitle: TPopupMenu;
    FOnColumnComment: TTreeGridCommentEvent;
    FShadowFill: boolean;
    FImageChangeLink: TChangeLink;
    FOnSelectKnot: TTreeGridSelectKnot;
    FCurrentPos: array[1..2] of TBookmark;
    FBookMarkSize: integer;
    FLockScreen: boolean;
    FOnPaintMessage: TPaintMessageEvent;
    function GetFixedCellType(ACol, AOffset: integer): TFixedCell;
    procedure SetColumns(const Value: TKnotColumns);
    procedure InternalLayout;
    procedure MoveCol(RawCol, Direction: Integer);
    procedure SetOptions(Value: TTreeGridOptions);
    procedure TitleFontChanged(Sender: TObject);
    procedure UpdateRowCount;
    procedure UpdateActive;
    function AcquireFocus: Boolean;
    procedure DataChanged;
    procedure UpdateEditData;
    procedure SetTitleFont(const Value: TFont);
    procedure SetKnots(const Value: TKnotItems);
    procedure SetTreePathWidth(const Value: integer);
    procedure SetTitleHeight;
    procedure SetClipDown(const Value: boolean);
    function GetSelectedIndex: Integer;
    procedure SetSelectedIndex(Value: Integer);
    function GetTreePathWidth: integer;
    function HideEditor: boolean;
    function Modified: boolean;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMExit(var Message: TMessage); message CM_EXIT;
    procedure CMInvalidValue(var Message: TMessage); message CM_INVALIDVALUE;
    procedure CMKnotChanged(var Message: TMessage); message CM_KNOTCHANGED;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CMParentFontChanged(var Message: TMessage); message CM_PARENTFONTCHANGED;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure WMChar(var Msg: TWMChar); message WM_CHAR;
    procedure WMEraseBkgnd(var Message: TWmEraseBkgnd); message WM_ERASEBKGND;
    procedure WMKillFocus(var Message: TMessage); message WM_KillFocus;
    procedure WMNCLButtonDown(var Message: TWMNCLButtonDown); message WM_NCLBUTTONDOWN;
    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SetFOCUS;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMHScroll(var Message: TWMHScroll); message WM_HSCROLL;
    procedure WMVScroll(var Message: TWMVScroll); message WM_VSCROLL;
    procedure CMPopupWindow(var Message: TMessage); message CM_POPUPWINDOW;
    procedure WMSetCursor(var Msg: TWMSetCursor); message WM_SETCURSOR;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    procedure SetImages(const Value: TImageList);
    function GetHintTreeOffset(KnotItem: TKnotItem; Hint: TTreeGridHitTest): integer;
    procedure GetTreePathCaption(KnotItem: TKnotItem; var Text: string);
    procedure SetPopupTitle(const Value: TPopupMenu);
    procedure InsertKnot(ParentKnot: TKnotItem; lChild: boolean; Shift: TShiftState);
    procedure MarkKnot;
    procedure NextRow(Select: Boolean; Insert: boolean; Shift: TShiftState;
      AOffset: integer = 1);
    procedure PrevRow(Select: Boolean; AOffset: integer = 1);
    procedure ClearSelection;
    function Eof: boolean;
    function BoxRectEx(ALeft, ATop, ARight, ABottom: Longint): TRect;
    procedure ImageListChange(Sender: TObject);
    procedure SetSelectedKnot(KnotItem: TKnotItem);
    procedure SetSelected(const Value: TKnotItem);
    function GetPosition: TBookMark;
    procedure SetPosition(const Value: TBookMark);
  protected
    procedure DoCreateCellEdit(Column: TKnotColumn;
      var Edit: TDCCustomChoiceEdit; var CanCreate: boolean); virtual;
    procedure DoDestroyCellEdit; virtual;
    function ShowEditorChar(Ch: Char): boolean;
    procedure CreateWnd; override;
    procedure Loaded; override;
    procedure Paint; override;
    function  AcquireLayoutLock: Boolean;
    procedure LayoutChanged; virtual;
    procedure BeginLayout;
    procedure BeginUpdate;
    procedure EndLayout;
    procedure EndUpdate;
    procedure SetColumnAttributes; virtual;
    procedure ColWidthsChanged; override;
    procedure TopLeftChanged; override;
    procedure TitleClick(Column: TKnotColumn); dynamic;
    procedure CellClick(Column: TKnotColumn); dynamic;
    procedure ClipClick; dynamic;
    function SelectCell(ACol, ARow: Longint): Boolean; override;
    procedure InvalidateTitles;
    procedure InvalidateSelected;
    function  RawToDataColumn(ACol: Integer): Integer;
    function  DataToRawColumn(ACol: Integer): Integer;
    procedure CalcSizingState(X, Y: Integer; var State: TGridState;
      var Index: Longint; var SizingPos, SizingOfs: Integer;
      var FixedInfo: TGridDrawInfo); override;
    procedure ColumnMoved(FromIndex, ToIndex: Longint); override;
    function  HighlightCell(DataCol, DataRow: Integer;
      AState: TGridDrawState): Boolean; virtual;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    function DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    function DoMouseWheelUp(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    procedure DblClick; override;
    procedure HideHintWindow;
    procedure ShowHintWindow(X, Y, ALeft, ATop, AOff: integer; Text: string);
    procedure ClipButtonClick(Sender: TObject); virtual;
    procedure DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState); override;
    procedure RowMoved(FromIndex, ToIndex: Longint); override;
    function GetPopupMenu: TPopupMenu; override;
    procedure DoInsert(KnotItem: TKnotItem; var Apply: boolean); virtual;
    procedure DoDelete(KnotItem: TKnotItem; var Apply: boolean;
      ComponentState: TComponentState); virtual;
    procedure DoUpdate(KnotItem: TKnotItem; var Edit: TDCCustomChoiceEdit;
      Column: TKnotColumn); virtual;
    procedure DoSelectCell(Sender: TObject; ACol, ARow: Longint;
      var CanSelect: Boolean); virtual;
    procedure DoDrawColumnCell(Canvas: TCanvas; ARect: TRect; ACol: integer;
      AColumn: TKnotColumn; AKnot: TKnotItem; AState: TGridDrawState); virtual;
    procedure DeleteRecords(AtOnce: boolean);
    procedure DoColumnComment(Mode: integer; Column: TKnotColumn); virtual;
    function DeletePrompt: boolean; virtual;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    function GetBookmark(KnotItem: TKnotItem): TBookmark;
    procedure GetBookmarkData(KnotItem: TKnotItem; Data:Pointer); virtual;
    function BookmarksEqual(Bookmark1, Bookmark2: TBookmark): boolean; virtual;
    procedure GotoBookmark(Bookmark: TBookmark); virtual;
    function DataVisible: boolean; virtual;
    property BookmarkSize: integer read FBookmarkSize write FBookmarkSize;
    property IndicatorOffset: Byte read FIndicatorOffset;
    property Columns: TKnotColumns read FColumns write SetColumns;
    property Images: TImageList read FImages write SetImages;
    property Options: TTreeGridOptions read FOptions write SetOptions;
    property TitleFont: TFont read FTitleFont write SetTitleFont;
    property UpdateLock: Byte read FUpdateLock;
    property Knots: TKnotItems read FKnots write SetKnots;
    property TreePathWidth: integer read GetTreePathWidth write SetTreepathWidth;
    property SelectedRows: TKnotBookmarkList read FBookmarks;
    property OnColumnMoved: TMovedEvent read FOnColumnMoved write FOnColumnMoved;
    property OnCellClick: TTreeGridClickEvent read FOnCellClick write FOnCellClick;
    property OnTitleClick: TTreeGridClickEvent read FOnTitleClick write FOnTitleClick;
    property OnClipClick: TTreeGridClipEvent read FOnClipClick write FOnClipClick;
    property OnDelete: TTreeGridKnotDeleteEvent read FOnDelete write FOnDelete;
    property OnInsert: TTreeGridKnotEvent read FOnInsert write FOnInsert;
    property OnUpdate: TTreeGridUpdateEvent read FOnUpdate write FOnUpdate;
    property SelectedKnot: TKnotItem read FSelectedKnot write SetSelected;
    property SelectedIndex: Integer read GetSelectedIndex write SetSelectedIndex;
    property OnDrawColumnCell: TTreeDrawCollumnCellEvent read FOnDrawColumnCell write FOnDrawColumnCell;
    property OnTreeCellText: TTreeCellTextEvent read FOnTreeCellText write FOnTreeCellText;
    property OnRowMoved: TMovedEvent read FOnRowMoved write FOnRowMoved;
    property OnSelectCell: TSelectCellEvent read FOnSelectCell write FOnSelectCell;
    property OnTopLeftChanged: TNotifyEvent read FOnTopLeftChanged write FOnTopLeftChanged;
    property OnCreateCellEdit: TTreeGridEditEvent read FOnCreateCellEdit write FOnCreateCellEdit;
    property OnDestroyCellEdit: TNotifyEvent read FOnDestroyCellEdit write FOnDestroyCellEdit;
    property OnClipButtonClick: TNotifyEvent read FOnClipButtonClick write FOnClipButtonClick;
    property OnColumnComment: TTreeGridCommentEvent read FOnColumnComment write FOnColumnComment;
    property PopupTitle: TPopupMenu read FPopupTitle write SetPopupTitle;
    property RowModified: boolean read Modified;
    property OnSelectKnot: TTreeGridSelectKnot read FOnSelectKnot write FOnSelectKnot;
    property OnPaintMessage: TPaintMessageEvent read FOnPaintMessage write FOnPaintMessage;
  public
    procedure SetModified(Value: boolean);
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure RowHeightsChanged; override;
    function GetHitTestInfoAt(KnotItem: TKnotItem; X,Y: integer): TTreeGridHitTest;
    property ClipDown: boolean read FClipDown write SetClipDown;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure ShowClipPopup(AClipPopup: TObject); virtual;
    procedure HideClipPopup;
    procedure ShowEditor;
    procedure ShowTreePathEditor;
    procedure SavePosition;
    procedure RestPosition;
    property ShadowFill: boolean read FShadowFill write FShadowFill;
    property Position: TBookMark read GetPosition write SetPosition;
  end;

  TDCTreeGrid = class(TDCCustomTreeGrid)
  public
    property Canvas;
    property Knots;
    property ScrollBars;
    property SelectedRows;
    property SelectedKnot;
    property SelectedIndex;
    property Col;
    property Row;
    property RowCount;
    property ColCount;
    property FixedRows;
    property FixedCols;
    property RowModified;
  published
    property Align;
    property Anchors;
    property BiDiMode;
    property BorderStyle;
    property Color;
    property Columns;
    property Constraints;
    property Ctl3D;
    property DefaultDrawing;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property FixedColor;
    property Font;
    property Options;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnColumnMoved;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnStartDock;
    property OnStartDrag;
    property Images;
    property DefaultRowHeight;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnCellClick;
    property OnTitleClick;
    property OnClipClick;
    property OnDelete;
    property OnInsert;
    property OnUpdate;
    property OnDrawColumnCell;
    property OnTreeCellText;
    property TreePathWidth;
    property OnRowMoved;
    property OnSelectCell;
    property OnTopLeftChanged;
    property OnCreateCellEdit;
    property OnDestroyCellEdit;
    property OnClipButtonClick;
    property OnColumnComment;
    property PopupTitle;
    property OnSelectKnot;
    property OnPaintMessage;
  end;

  {Inplace Editors}
  TSelection = record
    StartPos, EndPos: Integer;
  end;

  TDCInplaceChoiceEdit = class(TDCChoiceEdit)
  private
    FGrid: TDCCustomTreeGrid;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
  protected
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
  public
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure ChoiceClick(Sender:TObject); override;
    property Grid: TDCCustomTreeGrid read FGrid write SetGrid;
  end;

  TDCInplaceDateEdit = class(TDCDateEdit)
  private
    FGrid: TDCCustomTreeGrid;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
  protected
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
  public
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure ChoiceClick(Sender:TObject); override;
    property Grid: TDCCustomTreeGrid read FGrid write SetGrid;
  end;

  TDCInplaceFloatEdit = class(TDCFloatEdit)
  private
    FGrid: TDCCustomTreeGrid;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
  protected
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
  public
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure ChoiceClick(Sender:TObject); override;
    property Grid: TDCCustomTreeGrid read FGrid write SetGrid;
  end;

  TDCInplaceGridEdit = class(TDCGridEdit)
  private
    FGrid: TDCCustomTreeGrid;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
  protected
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
  public
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure ChoiceClick(Sender:TObject); override;
    property Grid: TDCCustomTreeGrid read FGrid write SetGrid;
  end;

  TDCInplaceTreeEdit = class(TDCTreeEdit)
  private
    FGrid: TDCCustomTreeGrid;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
  protected
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
  public
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure ChoiceClick(Sender:TObject); override;
    property Grid: TDCCustomTreeGrid read FGrid write SetGrid;
  end;

  TDCInplaceComboBox = class(TDCComboBox)
  private
    FGrid: TDCCustomTreeGrid;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
  protected
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
  public
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure ChoiceClick(Sender:TObject); override;
    property Grid: TDCCustomTreeGrid read FGrid write SetGrid;
  end;

{$IFDEF DELPHI_V5}
  TDCInplaceADOGridEdit = class(TDCADOGridEdit)
  private
    FGrid: TDCCustomTreeGrid;
    procedure SetGrid(Value: TDCCustomTreeGrid);
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
  protected
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
  public
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure ChoiceClick(Sender:TObject); override;
    property Grid: TDCCustomTreeGrid read FGrid write SetGrid;
  end;
{$ENDIF}

implementation
uses
  DCEditButton;

{$R *.RES}

type
  TDCHackChoiceEdit = class(TDCCustomChoiceEdit)
  end;

  PHintWindowParam_tag  = ^THintWindowParam;
  THintWindowParam = record
    HMode: Integer;
    HLeft: Integer;
    HTop : Integer;
    HOff : Integer;
    HCol : Integer;
    HRow : Integer;
    PHint: PChar;
  end;

const
  NE_EMPTY_KNOT = '$Empty Knot';
  NE_ROOT_KNOT  = '$DC.sp_ROOT';
  TreeIconWidth = 20;

const
  bmArrow      = 'DC_DBGARROW'    ; nbmArrow      = 0;
  bmEdit       = 'DC_DBEDIT'      ; nbmEdit       = 1;
  bmInsert     = 'DC_DBINSERT'    ; nbmInsert     = 2;
  bmMultiDot   = 'DC_DBMULTIDOT'  ; nbmMultiDot   = 3;
  bmMultiArrow = 'DC_DBMULTIARROW'; nbmMultiArrow = 4;
  bmCheck      = 'DC_DBCHECK'     ; nbmCheck      = 5;
  bmMain       = 'DC_DBMAIN'      ; nbmMain       = 6;
  bmIndexAsc   = 'DC_DBINDEXASC'  ; nbmIndexAsc   = 7;
  bmIndexDesc  = 'DC_DBINDEXDESC' ; nbmIndexDesc  = 8;
  bmIndexNone  = 'DC_DBINDEXNONE' ; nbmIndexNone  = 9;
  bmExpand     = 'DC_TGEXPAND'    ; nbmExpand     = 0;
  bmCollapse   = 'DC_TGCOLLAPSE'  ; nbmCollapse   = 1;

var
  DrawBitmap, TempBitmap: TBitmap;
  UserCount: Integer;

procedure UsesBitmap;
begin
  if UserCount = 0 then
  begin
    DrawBitmap := TBitmap.Create;
    TempBitmap := TBitmap.Create;
  end;
  Inc(UserCount);
end;

procedure ReleaseBitmap;
begin
  Dec(UserCount);
  if UserCount = 0 then begin
    DrawBitmap.Free;
    TempBitmap.Free;
  end;
end;

procedure KillMessage(Wnd: HWnd; Msg: Integer);
// Delete the requested message from the queue, but throw back
// any WM_QUIT msgs that PeekMessage may also return
var
  M: TMsg;
begin
  M.Message := 0;
  if PeekMessage(M, Wnd, Msg, Msg, pm_Remove) and (M.Message = WM_QUIT) then
    PostQuitMessage(M.wparam);
end;

procedure InplaceUpdateLoc(Sender: TDCCustomChoiceEdit; R: TRect; Canvas: TCanvas);
begin
  Sender.SetBounds(R.Left, R.Top, R.Right-R.Left, R.Bottom-R.Top);
  Canvas.Brush.Color := Sender.Color;
  R.Right := R.Right - Sender.ButtonWidth;
  Canvas.FillRect(R);
  Sender.Show;
  Sender.SetFocus;
end;

procedure InplaceKeyDown(Sender:  TDCCustomChoiceEdit; Grid: TDCCustomTreeGrid;
  var Key: Word; Shift: TShiftState);

  procedure SendToParent;
  begin
    Grid.KeyDown(Key, Shift);
  end;

  procedure ParentEvent;
  var
    GridKeyDown: TKeyEvent;
  begin
    if Assigned(Grid) then
    begin
      GridKeyDown := Grid.OnKeyDown;
      if Assigned(GridKeyDown) then GridKeyDown(Grid, Key, Shift);
    end;
  end;

  function ForwardMovement: Boolean;
  begin
    Result := tgAlwaysShowEditor in Grid.Options;
  end;

  function Ctrl: Boolean;
  begin
    Result := ssCtrl in Shift;
  end;

  function Selection: TSelection;
  begin
    SendMessage(Sender.Handle, EM_GETSEL, Longint(@Result.StartPos), Longint(@Result.EndPos));
  end;

  function RightSide: Boolean;
  begin
    with Selection do
      Result := ((StartPos = 0) or (EndPos = StartPos)) and
        (EndPos = Sender.GetTextLen);
   end;

  function LeftSide: Boolean;
  begin
    with Selection do
      Result := (StartPos = 0) and ((EndPos = 0) or (EndPos = Sender.GetTextLen));
  end;
begin
  case Key of
    VK_UP, VK_DOWN, VK_PRIOR, VK_NEXT:
      begin
        if not(ssAlt in Shift) then
        begin
          SendToParent;
          Key := 0;
        end;
      end;
    VK_ESCAPE:
      begin
        SendToParent;
        Key := 0;
      end;
    VK_INSERT:
      if Shift = [] then SendToParent
      else if (Shift = [ssShift]) and not Grid.CanEditModify then Key := 0;
    VK_LEFT : if ForwardMovement and (Ctrl or LeftSide ) then SendToParent;
    VK_RIGHT: if ForwardMovement and (Ctrl or RightSide) then SendToParent;
    VK_HOME : if ForwardMovement and (Ctrl or LeftSide ) then SendToParent;
    VK_END  : if ForwardMovement and (Ctrl or RightSide) then SendToParent;
    VK_F2:
      begin
        ParentEvent;
        if Key = VK_F2 then
        begin
          Sender.Deselect;
          Exit;
        end;
      end;
    VK_TAB:
      if not (ssAlt in Shift) then
      begin
        SendToParent;
        Key := 0;
      end;
  end;
  if (Key = VK_DELETE) and not Grid.CanEditModify then Key := 0;
  if Key <> 0 then ParentEvent;
end;

{ TKnotColumn }
procedure TKnotColumn.Assign(Source: TPersistent);
begin
  if Source is TKnotColumn then
  begin
    try
      RestoreDefaults;
      Name := TKnotColumn(Source).Name;
      if cvColor in TKnotColumn(Source).AssignedValues then
        Color := TKnotColumn(Source).Color;
      if cvWidth in TKnotColumn(Source).AssignedValues then
        Width := TKnotColumn(Source).Width;
      if cvFont in TKnotColumn(Source).AssignedValues then
        Font := TKnotColumn(Source).Font;
      if cvAlignment in TKnotColumn(Source).AssignedValues then
        Alignment := TKnotColumn(Source).Alignment;
      Title    := TKnotColumn(Source).Title;
      Options  := TKnotColumn(Source).Options;
      ItemIndex:= TKnotColumn(Source).ItemIndex;
      DisplayFormat := TKnotColumn(Source).DisplayFormat;
    finally
    end;
  end
  else
    inherited Assign(Source);
end;

constructor TKnotColumn.Create(Collection: TCollection);
var
  Grid: TDCCustomTreeGrid;
begin
  Grid := nil;
  if Assigned(Collection) and (Collection is TKnotColumns) then
    Grid := TKnotColumns(Collection).Grid;
  if Assigned(Grid) then Grid.BeginLayout;
  try
    inherited Create(Collection);
    FWidth := 50;
    FAlignment := taLeftJustify;
    FMaxWidth  := 0;
    FMinWidth  := 0;
    FItemIndex := -1;
    FFont := TFont.Create;
    FFont.Assign(DefaultFont);
    FFont.OnChange := FontChanged;
    FTitle   := TKnotColumnTitle.Create(Self);
    FOptions := [kcVisible, kcShowEdit, kcSizing];
  finally
    if Assigned(Grid) then Grid.EndLayout;
  end;
end;

function TKnotColumn.DefaultAlignment: TAlignment;
begin
  Result := taLeftJustify;
end;

function TKnotColumn.DefaultColor: TColor;
begin
  if Assigned(Grid) then
    Result := Grid.Color
  else
    Result := clWindow;
end;

function TKnotColumn.DefaultFont: TFont;
begin
  if Assigned(Grid) then
    Result := Grid.Font
  else
    Result := FFont;
end;

function TKnotColumn.DefaultWidth: Integer;
begin
  if Assigned(Grid) then
    Result := Grid.DefaultColWidth
  else
    Result := 64;
end;

destructor TKnotColumn.Destroy;
begin
  FTitle.Free;
  FFont.Free;
  inherited Destroy;
end;

procedure TKnotColumn.FontChanged(Sender: TObject);
begin
  Include(FAssignedValues, cvFont);
  Title.RefreshDefaultFont;
  Changed(False);
end;

function TKnotColumn.GetAlignment: TAlignment;
begin
  if cvAlignment in FAssignedValues then
    Result := FAlignment
  else
    Result := DefaultAlignment;
end;

function TKnotColumn.GetColor: TColor;
begin
  if cvColor in FAssignedValues then
    Result := FColor
  else
    Result := DefaultColor;
end;

function TKnotColumn.GetDisplayName: string;
begin
  Result := FTitle.Caption;
  if Result = '' then Result := 'TKnotColumn';
end;

function TKnotColumn.GetFont: TFont;
var
  Save: TNotifyEvent;
begin
  if not (cvFont in FAssignedValues) and (FFont.Handle <> DefaultFont.Handle) then
  begin
    Save := FFont.OnChange;
    FFont.OnChange := nil;
    FFont.Assign(DefaultFont);
    FFont.OnChange := Save;
  end;
  Result := FFont;
end;

function TKnotColumn.GetGrid: TDCCustomTreeGrid;
begin
  if Assigned(Collection) and (Collection is TKnotColumns) then
    Result := TKnotColumns(Collection).Grid
  else
    Result := nil;
end;

function TKnotColumn.GetWidth: TWidth;
begin
  if not(kcVisible in Options) then
    Result := -1
  else if cvWidth in FAssignedValues then
    Result := FWidth
  else
    Result := DefaultWidth;
end;

function TKnotColumn.IsAlignmentStored: Boolean;
begin
  Result := (cvAlignment in FAssignedValues) and (FAlignment <> DefaultAlignment);
end;

function TKnotColumn.IsColorStored: Boolean;
begin
  Result := (cvColor in FAssignedValues) and (FColor <> DefaultColor);
end;

function TKnotColumn.IsFontStored: Boolean;
begin
  Result := (cvFont in FAssignedValues);
end;

function TKnotColumn.IsWidthStored: Boolean;
begin
  Result := (cvWidth in FAssignedValues) and (FWidth <> DefaultWidth);
end;

procedure TKnotColumn.RefreshDefaultFont;
var
  Save: TNotifyEvent;
begin
  if cvFont in FAssignedValues then Exit;
  Save := FFont.OnChange;
  FFont.OnChange := nil;
  try
    FFont.Assign(DefaultFont);
  finally
    FFont.OnChange := Save;
  end;
end;

procedure TKnotColumn.RestoreDefaults;
var
  FontAssigned: Boolean;
begin
  FontAssigned := cvFont in FAssignedValues;
  FTitle.RestoreDefaults;
  FAssignedValues := [];
  RefreshDefaultFont;
  Changed(FontAssigned);
end;

procedure TKnotColumn.SetAlignment(const Value: TAlignment);
begin
  if (cvAlignment in FAssignedValues) and (Value = FAlignment) then Exit;
  FAlignment := Value;
  Include(FAssignedValues, cvAlignment);
  Changed(False);
end;

procedure TKnotColumn.SetColor(const Value: TColor);
begin
  if (cvColor in FAssignedValues) and (Value = FColor) then Exit;
  FColor := Value;
  Include(FAssignedValues, cvColor);
  Changed(False);
end;

procedure TKnotColumn.SetName(const Value: string);
begin
  FName := Value;
  Changed(False);
end;

procedure TKnotColumn.SetFont(const Value: TFont);
begin
  FFont.Assign(Value);
  Include(FAssignedValues, cvFont);
  Changed(False);
end;

procedure TKnotColumn.SetIndexStyle(const Value: TColumnIndexStyle);
begin
  if Value <> FIndexStyle then
  begin
    FIndexStyle := Value;
    Changed(False);
  end;
end;

procedure TKnotColumn.SetItemIndex(const Value: integer);
begin
  if Value <> FItemIndex then
  begin
    FItemIndex := Value;
    Changed(False);
  end;
end;

procedure TKnotColumn.SetMaxWidth(const Value: TWidth);
begin
  FMaxWidth := Value;
end;

procedure TKnotColumn.SetMinWidth(const Value: TWidth);
begin
  FMinWidth := Value;
end;

procedure TKnotColumn.SetOptions(const Value: TKnotOptions);
begin
  if FOptions <> Value then
  begin
    FOptions := Value;
    Changed(True);
  end;
end;

procedure TKnotColumn.SetTitle(const Value: TKnotColumnTitle);
begin
  FTitle.Assign(Value);
end;

procedure TKnotColumn.SetWidth(const Value: TWidth);
begin
  if ((cvWidth in FAssignedValues) or (Value <> DefaultWidth))
    and (Value <> -1) then
  begin
    FWidth := Value;
    Include(FAssignedValues, cvWidth);
  end;
  Changed(True);
end;

procedure TKnotColumn.SetComment(const Value: string);
begin
  FComment := Value;
  Include(FAssignedValues, cvComment);
end;

function TKnotColumn.IsCommentStored: Boolean;
begin
  Result := (cvComment in FAssignedValues);
end;

function TKnotColumn.DefaultComment: string;
begin
  Result := FName;
end;

function TKnotColumn.GetComment: string;
begin
  if cvComment in FAssignedValues then
    Result := FComment
  else
    Result := DefaultComment;
end;

procedure TKnotColumn.SetDisplayFormat(const Value: string);
begin
  if Value <> FDisplayFormat then
  begin
    FDisplayFormat := Value;
    Changed(False);
  end;
end;

{ TKnotColumns }

function TKnotColumns.Add: TKnotColumn;
begin
  Result := TKnotColumn(inherited Add);
end;

constructor TKnotColumns.Create(AOwner: TDCCustomTreeGrid);
begin
  inherited Create(TKnotColumn);
  FOwner := AOwner;
end;

function TKnotColumns.GetItem(Index: Integer): TKnotColumn;
begin
  Result := TKnotColumn(inherited GetItem(Index));
end;

function TKnotColumns.GetOwner: TPersistent;
begin
  Result := TPersistent(FOwner);
end;

procedure TKnotColumns.SetItem(Index: Integer; Value: TKnotColumn);
begin
  inherited SetItem(Index, Value);
end;

procedure TKnotColumns.Update(Item: TCollectionItem);
var
  Raw: Integer;
begin
  if (FOwner = nil) or (csLoading in FOwner.ComponentState) then Exit;
  if Item = nil then
  begin
    FOwner.LayoutChanged;
  end
  else
  begin
    Raw := Grid.DataToRawColumn(Item.Index);
    Grid.InvalidateCol(Raw);
    Grid.ColWidths[Raw] := TKnotColumn(Item).Width;
  end;
end;

{ TKnotItem }

procedure TKnotItem.Clear;
begin
  {  }
  while ChildCount > 0 do
    TKnotItem(FChildKnots.Items[FChildKnots.Count-1]).Free;
end;

procedure TKnotItem.DeleteChildKnot(KnotIndex: integer);
begin
  {   child  }
  if KnotIndex < ChildCount then
  begin
    FChildKnots.Delete(KnotIndex);
    FOwner.RebuildIndexes(Self, KnotIndex);
  end;
end;

procedure TKnotItem.Collapse(Recurse: boolean);
 var
  i: integer;
begin
  Expanded := False;
  if Recurse then
    for i := 0 to ChildCount-1 do
       TKnotItem(FChildKnots.Items[i]).Collapse(Recurse);

  Owner.UpdateTreeGrid;
end;

constructor TKnotItem.Create(AOwner: TKnotItems; AParent: TKnotItem; AName: string);
begin
  inherited Create;
  FOwner  := AOwner;
  FParent := AParent;

  Expanded := False;

  FName := AName;

  FNormalImage   := -1;
  FSelectImage   := -1;
  FVisible       := True;
end;

destructor TKnotItem.Destroy;
 var
  Apply: boolean;
begin
  if (Grid <> nil) and (KnotID <> 0) and (Data <> nil)
  then begin
    Apply := True;
    Grid.DoDelete(Self, Apply, [csDestroying]);
  end;
  Data := nil;
  { }
  Clear;

  if Assigned(FParent) then
    FParent.DeleteChildKnot(FIndex);

  if FChildKnots <> nil then FChildKnots.Free;
  FChildKnots := nil;  
  inherited Destroy;
end;

procedure TKnotItem.Expand(Recurse: boolean);
 var
  i: integer;
begin
  Expanded := True;
  if Recurse then
    for i := 0 to ChildCount-1 do
       TKnotItem(FChildKnots.Items[i]).Expand(Recurse);

  Owner.UpdateTreeGrid;
end;

function TKnotItem.GetChild(Index: integer): TKnotItem;
 var
  i: integer;
begin
  i := ChildCount;
  if (Index <= i-1) and (Index >= 0) then
    Result := TKnotItem(FChildKnots.Items[Index])
  else
    Result := nil;
end;

function TKnotItem.GetChildCount: integer;
begin
  if FChildKnots <> nil then
    Result := FChildKnots.Count
  else
    Result := 0;
end;

procedure TKnotItem.SetChild(Index: integer; const Value: TKnotItem);
begin
  if Index < ChildCount then FChildKnots.Items[Index] := Value;
end;

procedure TKnotItem.SetData(const Value: Pointer);
begin
  FData := Value;
end;

function TKnotItem.GetVisibleKnotCount: integer;
 var
  i: integer;
begin
  if FVisible then
  begin
    Result := 1;
    if Expanded then
    begin
      for i := 0 to ChildCount-1 do
        Result := Result + Childs[i].VisibleKnotCount;
    end
  end
  else
    Result := 0;
end;

function TKnotItem.GetExpanded: boolean;
begin
  Result := (FFlag and $80)= $80;
end;

procedure TKnotItem.SetExpanded(const Value: boolean);
begin
  FFlag := (FFlag and $FF7F) or (integer(Value) shl 7);
end;

function TKnotItem.GetNext: TKnotItem;
 var
  ParentKnot: TKnotItem;
begin
  if (ChildCount > 0) then
    Result := Childs[0]
  else begin
    Result := GetNextSibling;
    if Result = nil then
    begin
      ParentKnot := Parent;
      Result     := ParentKnot.GetNextSibling;
      while (Result=nil) and (ParentKnot.Level>0) do
      begin
        ParentKnot := ParentKnot.Parent;
        Result     := ParentKnot.GetNextSibling
      end;
    end;
  end;
end;

function TKnotItem.GetNextVisible: TKnotItem;
 var
  ParentKnot: TKnotItem;
  i: integer;
  FoundNext: boolean;
begin
  FoundNext := False;
  Result    := nil;
  if (ChildCount > 0) and Expanded then
  begin
    i := 0;
    while (i < ChildCount) and not Childs[i].Visible do Inc(i);
    if i < ChildCount then
    begin
      Result    := Childs[i];
      FoundNext := True;
    end;
  end;
  if not FoundNext then
  begin
    Result :=  GetNextSibling;
    if Result = nil then
    begin
      ParentKnot := Parent;
      Result     := ParentKnot.GetNextSibling;
      while (Result=nil) and (ParentKnot.Level>0) do
      begin
        ParentKnot := ParentKnot.Parent;
        Result     := ParentKnot.GetNextSibling
      end;
    end;
    while Assigned(Result) and not Result.Visible do
      Result := Result.GetNextSibling;
  end;
end;

function TKnotItem.GetNextSibling: TKnotItem;
begin
  if (FIndex>=0) and (Parent <> nil) and (FIndex<(Parent.ChildCount-1)) then
    Result := Parent.Childs[FIndex+1]
  else
    Result := nil;
end;

function TKnotItem.GetPrev: TKnotItem;
begin
  Result := GetPrevSibling;
  if Result = nil then
    Result  := Parent
  else begin
    if Result <> nil then
      while Result.ChildCount>0 do
        Result := Result.Childs[Result.ChildCount-1]
  end;
end;

function TKnotItem.GetPrevSibling: TKnotItem;
begin
  if (FIndex>0) and (FIndex<Parent.ChildCount) then
    Result := Parent.Childs[FIndex-1]
  else
    Result := nil
end;

function TKnotItem.GetPrevVisible: TKnotItem;
 var
  Knot: TKnotItem;
begin
  Result := GetPrevSibling;
  if Result = nil then
    Result  := Parent
  else begin
    while Assigned(Result) and not Result.Visible do
    begin
      Knot := Result.GetPrevSibling;
      if Knot = nil then
      begin
        Result := Result.Parent;
        Exit;
      end;
    end;
    if Result <> nil then
    begin
      while (Result.ChildCount>0) and Result.Expanded do
      begin
        Knot := Result.Childs[Result.ChildCount-1];
        if Knot.Visible then
          Result := Knot
        else
          Break;
      end;
    end;
  end;
end;

procedure TKnotItem.SetNormalImage(const Value: smallint);
begin
  if FNormalImage <> Value then
  begin
    FNormalImage := Value;
    FOwner.UpdateTreeGrid;
  end;
end;

procedure TKnotItem.SetSelectImage(const Value: smallint);
begin
  if FSelectImage <> Value then
  begin
    FSelectImage := Value;
    FOwner.UpdateTreeGrid;
  end;
end;

procedure TKnotItem.SetName(const Value: string);
begin
  if FName <> Value then
  begin
    FName := Value;
    FOwner.UpdateTreeGrid;
  end;
end;

function TKnotItem.GetGrid: TDCCustomTreeGrid;
begin
  Result := FOwner.Grid;
end;

procedure TKnotItem.SetVisible(const Value: boolean);
begin
  if FVisible <> Value then
  begin
    FVisible := Value;
    FOwner.UpdateTreeGrid;
  end;
end;

function TKnotItem.GetVisibleChildCount: integer;
 var
  i: integer;
begin
 Result := 0;
 for i := 0 to ChildCount-1 do
   if Childs[i].Visible then Inc(Result);
end;

{ TKnotItems }

function TKnotItems.Add(Name: string; Position: integer = KNOT_END): TKnotItem;
begin
  Result := AddChild(FRootKnot, Name, Position)
end;

function TKnotItems.AddChild(ParentKnot: TKnotItem; Name: string;
  Position: integer = KNOT_END): TKnotItem;
 var
  KnotItem: TKnotItem;
  Apply: boolean;
begin
  KnotItem := TKnotItem.Create(Self, ParentKnot, Name);
  Inc(FLastKnotID);
  KnotItem.FKnotID := FLastKnotID;
  if ParentKnot.ChildCount > 0 then
    KnotItem.FIndex  := ParentKnot.Childs[ParentKnot.ChildCount-1].FIndex+1
  else
    KnotItem.FIndex  := 0;
  KnotItem.FLevel  := ParentKnot.FLevel+1;

  Apply := True;
  if (Grid <> nil) then Grid.DoInsert(KnotItem, Apply);

  if Apply then
  begin
    if ParentKnot.FChildKnots = nil then ParentKnot.FChildKnots := TList.Create;
    case Position of
      KNOT_BEGIN  :
       begin
         ParentKnot.FChildKnots.Insert(0, KnotItem);
         RebuildIndexes(ParentKnot, 0);
       end;
      KNOT_END    :
       ParentKnot.FChildKnots.Add(KnotItem);
      else begin
        ParentKnot.FChildKnots.Insert(Position, KnotItem);
        RebuildIndexes(ParentKnot, Position);
      end;
    end;
    Result := KnotItem;
    UpdateTreeGrid;
  end
  else begin
    Result := nil;
    KnotItem.Free;
  end;
end;

procedure TKnotItems.Clear;
begin
  SetState(ksUpdate);
  FRootKnot.Clear;
  if FOwner <> nil then with FOwner do
  begin
    FFirstIndex   := 0;
    FFirstVisible := SelectKnot(FKnots.Items[0], FFirstIndex);
    TopRow := FTitleOffset;
    Row    := FTitleOffset;
  end;
  SetState(ksBrowse);
  UpdateTreeGrid;
end;

constructor TKnotItems.Create(AOwner: TDCCustomTreeGrid);
begin
  inherited Create;
  FOwner := AOwner;

  FRootKnot := TKnotItem.Create(Self, nil, NE_ROOT_KNOT);
  FRootKnot.FLevel := -1;

  FLastKnotID  := 0;
  FUpdateCount := 0;

  SetState(ksBrowse);
end;

function TKnotItems.Delete(Knot: TKnotItem): boolean;
 var
  Apply: boolean;
begin
  Apply := True;
  if (Grid <> nil) then Grid.DoDelete(Knot, Apply, []);
  if Apply then
  begin
    Knot.Free;
    UpdateTreeGrid;
  end;
  Result := Apply;
end;

destructor TKnotItems.Destroy;
begin
  FState := ksUpdate;
  FRootKnot.Free;
  inherited;
end;

function TKnotItems.GetCount: integer;
begin
  Result := FRootKnot.ChildCount;
end;

function TKnotItems.GetItem(Index: integer): TKnotItem;
begin
  Result := FRootKnot.Childs[Index];
end;

function TKnotItems.GetKnotFromChild(ParentKnot: TKnotItem; KnotID: integer;
  var KnotItem: TKnotItem): boolean;
 var
  i: integer;
begin
  Result := False;
  i := 0;
  while (i <= ParentKnot.ChildCount-1) and not Result do
  begin
    if ParentKnot.Childs[i].KnotID = KnotID then
    begin
      Result   := True;
      KnotItem := ParentKnot.Childs[i];
    end
    else
      Result := GetKnotFromChild(ParentKnot.Childs[i], KnotID, KnotItem);
    Inc(i);
  end;
end;

function TKnotItems.GetKnot(KnotID: integer; var KnotItem: TKnotItem): boolean;
begin
  Result := GetKnotFromChild(FRootKnot, KnotID, KnotItem);
end;

procedure TKnotItems.SetItem(Index: integer; const Value: TKnotItem);
begin
  FRootKnot.Childs[Index] := Value;
end;

procedure TKnotItems.Move(KnotItem, DestKnot: TKnotItem;
  Position: integer);
 var
  ParentKnot: TKnotItem;
begin
  if DestKnot  = nil then DestKnot := FRootKnot;
  ParentKnot := KnotItem.Parent;
  ParentKnot.DeleteChildKnot(KnotItem.FIndex);

  if DestKnot.FChildKnots = nil then DestKnot.FChildKnots := TList.Create;
  case Position of
    KNOT_BEGIN  :
     begin
       DestKnot.FChildKnots.Insert(0, KnotItem);
       RebuildIndexes(DestKnot, 0);
     end;
    KNOT_END    :
      DestKnot.FChildKnots.Add(KnotItem);
    else begin
      DestKnot.FChildKnots.Insert(Position, KnotItem);
      if Position > 0 then
        RebuildIndexes(DestKnot, Position-1)
      else
        RebuildIndexes(DestKnot, 0);
    end;
  end;
  KnotItem.Parent := DestKnot;
  UpdateTreeGrid;
end;

function TKnotItems.GetVisibleKnotCount: integer;
 var
  i: integer;
begin
  Result := 0;
  for i := 0 to Count-1 do
  begin
    Result := Result + Items[i].VisibleKnotCount;
  end;
end;

procedure TKnotItems.BeginUpdate(LockScreen: boolean = False);
begin
  if FUpdateCount = 0 then
  begin
    SetUpdateState(True);
  end;
  Inc(FUpdateCount);
  if LockScreen then
  begin
    FOwner.FLockScreen := LockScreen;
    FOwner.Refresh;
    ShowScrollBar(FOwner.Handle, SB_BOTH, False);
    ProcessPaintMessages;
  end;
end;

procedure TKnotItems.EndUpdate;
 var
  ScrollInfo: TScrollInfo;
begin
  if FUpdateCount > 0 then begin
    Dec(FUpdateCount);
    if FUpdateCount = 0 then begin
      SetUpdateState(False);
      if FOwner.FLockScreen then
      begin
        with FOwner do
        begin
          FLockScreen := False;
          with ScrollInfo do
          begin
            cbSize := SizeOf(ScrollInfo);
            fMask  := SIF_ALL;
            nMin   := 0;
            nMax   := 0;
            nPage  := 0;

            nPos      := 0;
            nTrackPos := 0;
          end;
          SetScrollInfo(Handle, SB_HORZ, ScrollInfo, True);
          SetScrollInfo(Handle, SB_VERT, ScrollInfo, True);
          ColWidthsChanged;
          RowHeightsChanged;
          Refresh;
        end;
        ProcessPaintMessages;
      end;
    end;
    UpdateTreeGrid;
  end;
end;

procedure TKnotItems.UpdateTreeGrid;
begin
  if (FUpdateCount = 0) and (FOwner <> nil) then
    FOwner.Perform(CM_KNOTCHANGED, 0, 0);
end;

function TKnotItems.SelectKnot(KnotItem: TKnotItem;
  Offset: integer): TKnotItem;
begin
  Result := KnotItem;
  if Offset > 0 then
  begin
    while (Result <> nil) and (Offset>0) do
    begin
      Result := Result.GetNextVisible;
      Dec(Offset);
    end;
  end
  else begin
    while (Result <> nil) and (Offset<0) do
    begin
      Result := Result.GetPrevVisible;
      Inc(Offset);
    end;
  end;
  while Assigned(Result) and not Result.Visible do
    Result := Result.GetNextSibling;
end;

procedure TKnotItems.RebuildIndexes(ParentKnot: TKnotItem; FirstIndex: integer);
 var
  i: integer;
begin
  if ParentKnot = nil then ParentKnot := FRootKnot;
  for i := FirstIndex to ParentKnot.ChildCount-1 do
    ParentKnot.Childs[i].FIndex := i;
end;

procedure TKnotItems.SetState(Value: TKnotState);
begin
  if Value <> FState then
  begin
    FState := Value;
    with Grid do
      if tgIndicator in Options then InvalidateCell(0,Row)
  end;
end;

function TKnotItems.First: TKnotItem;
begin
  if FRootKnot.ChildCount > 0 then
    Result := FRootKnot.Childs[0]
  else
    Result := nil;
end;

procedure TKnotItems.Exchange(KnotItem1, KnotItem2: TKnotItem);
 var
  ParentKnot1, ParentKnot2: TKnotItem;
begin
  ParentKnot1 := KnotItem1.Parent;
  ParentKnot2 := KnotItem2.Parent;

  ParentKnot1.Childs[KnotItem1.Index] := KnotItem2;
  ParentKnot2.Childs[KnotItem2.Index] := KnotItem1;

  RebuildIndexes(ParentKnot1, KnotItem1.Index);
  RebuildIndexes(ParentKnot2, KnotItem2.Index);

  UpdateTreeGrid;
end;

function TKnotItems.GetUpdateingState: boolean;
begin
  Result := FUpdateCount <> 0;
end;

procedure TKnotItems.SetUpdateState(Updating: Boolean);
begin
  {}
end;

{ TKnotColumnTitle }

procedure TKnotColumnTitle.Assign(Source: TPersistent);
begin
  if Source is TKnotColumnTitle then
  begin
    if cvTitleAlignment in TKnotColumnTitle(Source).FColumn.FAssignedValues then
      Alignment := TKnotColumnTitle(Source).Alignment;
    if cvTitleColor in TKnotColumnTitle(Source).FColumn.FAssignedValues then
      Color     := TKnotColumnTitle(Source).Color;
    if cvTitleCaption in TKnotColumnTitle(Source).FColumn.FAssignedValues then
      Caption   := TKnotColumnTitle(Source).Caption;
    if cvTitleFont in TKnotColumnTitle(Source).FColumn.FAssignedValues then
      Font      := TKnotColumnTitle(Source).Font;
  end
  else
    inherited Assign(Source);
end;

constructor TKnotColumnTitle.Create(Column: TKnotColumn);
begin
  inherited Create;

  FColumn  := Column;
  FCaption := 'DefaultCaption';
  FFont    := TFont.Create;
  FFont.Assign(DefaultFont);
  FFont.OnChange := FontChanged;
end;

function TKnotColumnTitle.DefaultAlignment: TAlignment;
begin
  Result := taLeftJustify;
end;

function TKnotColumnTitle.DefaultCaption: string;
begin
  Result  := FColumn.FName;
end;

function TKnotColumnTitle.DefaultColor: TColor;
 var
  TreeGrid: TDCCustomTreeGrid;
begin
  TreeGrid := FColumn.GetGrid;
  if Assigned(TreeGrid) then
    Result := TreeGrid.FixedColor
  else
    Result := clBtnFace;
end;

function TKnotColumnTitle.DefaultFont: TFont;
 var
  TreeGrid: TDCCustomTreeGrid;
begin
  TreeGrid := FColumn.GetGrid;
  if Assigned(TreeGrid) then
    Result := TreeGrid.Font
  else
    Result := FColumn.Font;
end;

destructor TKnotColumnTitle.Destroy;
begin
  FFont.Free;
  inherited Destroy;
end;

procedure TKnotColumnTitle.FontChanged(Sender: TObject);
begin
  FColumn.Changed(True);
end;

function TKnotColumnTitle.GetAlignment: TAlignment;
begin
  if cvTitleAlignment in FColumn.FAssignedValues then
    Result := FAlignment
  else
    Result := DefaultAlignment;
end;

function TKnotColumnTitle.GetCaption: string;
begin
  if cvTitleCaption in FColumn.FAssignedValues then
    Result := FCaption
  else
    Result := DefaultCaption;
end;

function TKnotColumnTitle.GetColor: TColor;
begin
  if cvTitleColor in FColumn.FAssignedValues then
    Result := FColor
  else
    Result := DefaultColor;
end;

function TKnotColumnTitle.GetFont: TFont;
var
  Save: TNotifyEvent;
  Def: TFont;
begin
  if not (cvTitleFont in FColumn.FAssignedValues) then
  begin
    Def := DefaultFont;
    if (FFont.Handle <> Def.Handle) or (FFont.Color <> Def.Color) then
    begin
      Save := FFont.OnChange;
      FFont.OnChange := nil;
      FFont.Assign(DefaultFont);
      FFont.OnChange := Save;
    end;
  end;
  Result := FFont;
end;

function TKnotColumnTitle.IsAlignmentStored: Boolean;
begin
  Result := (cvTitleAlignment in FColumn.FAssignedValues) and
    (FAlignment <> DefaultAlignment);
end;

function TKnotColumnTitle.IsCaptionStored: Boolean;
begin
  Result := (cvTitleCaption in FColumn.FAssignedValues) and
    (FCaption <> DefaultCaption);
end;

function TKnotColumnTitle.IsColorStored: Boolean;
begin
  Result := (cvTitleColor in FColumn.FAssignedValues) and
    (FColor <> DefaultColor);
end;

function TKnotColumnTitle.IsFontStored: Boolean;
begin
  Result := (cvTitleFont in FColumn.FAssignedValues);
end;

procedure TKnotColumnTitle.RefreshDefaultFont;
var
  Save: TNotifyEvent;
begin
  if (cvTitleFont in FColumn.FAssignedValues) then Exit;
  Save := FFont.OnChange;
  FFont.OnChange := nil;
  try
    FFont.Assign(DefaultFont);
  finally
    FFont.OnChange := Save;
  end;
end;

procedure TKnotColumnTitle.RestoreDefaults;
var
  FontAssigned: Boolean;
begin
  FontAssigned := cvTitleFont in FColumn.FAssignedValues;
  FColumn.FAssignedValues := FColumn.FAssignedValues - ColumnTitleValues;
  FCaption := '';
  RefreshDefaultFont;
  FColumn.Changed(FontAssigned);
end;

procedure TKnotColumnTitle.SetAlignment(Value: TAlignment);
begin
  if (cvTitleAlignment in FColumn.FAssignedValues) and (Value = FAlignment) then Exit;
  FAlignment := Value;
  Include(FColumn.FAssignedValues, cvTitleAlignment);
  FColumn.Changed(False);
end;

procedure TKnotColumnTitle.SetCaption(const Value: string);
var
  Grid: TDCCustomTreeGrid;
begin
  if not(cvTitleCaption in FColumn.FAssignedValues) or (Value <> FCaption) then
  begin
    Grid := Column.GetGrid;
    FCaption := Value;
    Include(Column.FAssignedValues, cvTitleCaption);
    Column.Changed(False);
    if Assigned(Grid) then Grid.InternalLayout;
  end;
end;

procedure TKnotColumnTitle.SetColor(Value: TColor);
begin
  if (cvTitleColor in FColumn.FAssignedValues) and (Value = FColor) then Exit;
  FColor := Value;
  Include(FColumn.FAssignedValues, cvTitleColor);
  FColumn.Changed(False);
end;

procedure TKnotColumnTitle.SetFont(Value: TFont);
begin
  FFont.Assign(Value);
end;

{ TDCCustomTreeGrid }

function TDCCustomTreeGrid.AcquireFocus: Boolean;
begin
  Result := True;
  if CanFocus and not (csDesigning in ComponentState) then
  begin
    SetFocus;
    Result := Focused;
  end;
end;

function TDCCustomTreeGrid.AcquireLayoutLock: Boolean;
begin
  Result := (FUpdateLock = 0) and (FLayoutLock = 0);
  if Result then BeginLayout;
end;

procedure TDCCustomTreeGrid.BeginLayout;
begin
  BeginUpdate;
  if FLayoutLock = 0 then Columns.BeginUpdate;
  Inc(FLayoutLock);
end;

procedure TDCCustomTreeGrid.BeginUpdate;
begin
  Inc(FUpdateLock);
end;

procedure TDCCustomTreeGrid.CellClick(Column: TKnotColumn);
begin
  if Assigned(FOnCellClick) then FOnCellClick(Column);
end;

procedure TDCCustomTreeGrid.ClipClick;
begin
  if FClipPopupVisible then
    HideClipPopup
  else
    ShowClipPopup(FClipPopup);
end;

procedure TDCCustomTreeGrid.CMCancelMode(var Message: TCMCancelMode);
begin
  inherited;
  if (Message.Sender <> Self) and FClipPopupVisible and
     (Message.Sender <> FClipPopup)
  then HideClipPopup;
end;

procedure TDCCustomTreeGrid.CMExit(var Message: TMessage);
begin
  try
    if (tgCancelOnExit in Options) then
    begin
      with FKnots do
      begin
        if (State = ksInsert) and not Modified then Delete(FSelectedKnot);
        if not HideEditor then
        begin
          SetFocus;
          Exit;
        end;
        SetState(ksBrowse);
      end;
    end;
    HideClipPopup;
    HideHintWindow;
    DoColumnComment(MODE_HIDEWINDOW, nil);
  except
    SetFocus;
    raise;
  end;
  inherited;
end;

procedure TDCCustomTreeGrid.CMKnotChanged(var Message: TMessage);
begin
  DataChanged;
end;

procedure TDCCustomTreeGrid.CMParentFontChanged(var Message: TMessage);
begin
  inherited;
  if ParentFont then
  begin
    FSelfChangingTitleFont := True;
    try
      TitleFont := Font;
    finally
      FSelfChangingTitleFont := False;
    end;
    LayoutChanged;
  end;
end;

procedure TDCCustomTreeGrid.ColumnMoved(FromIndex, ToIndex: Integer);
begin
  FromIndex := RawToDataColumn(FromIndex);
  ToIndex   := RawToDataColumn(ToIndex);
  Columns[FromIndex].Index := ToIndex;
  if Assigned(FOnColumnMoved) then FOnColumnMoved(Self, FromIndex, ToIndex);
end;

procedure TDCCustomTreeGrid.ColWidthsChanged;
var
  I: Integer;
begin
  if FSetTreePath then Exit;
  inherited ColWidthsChanged;
  if AcquireLayoutLock then
  try
    if FColumns.Count  > 0 then
      for I := FIndicatorOffset to ColCount - 1 do
        FColumns[I - FIndicatorOffset].Width := ColWidths[I];
    if FEditorMode then
      InplaceUpdateLoc(FInplaceEdit, CellRect(FInplaceCol, FInplaceRow), Canvas);    
  finally
    EndLayout;
  end;
end;

constructor TDCCustomTreeGrid.Create(AOwner: TComponent);
var
  Bmp: TBitmap;
begin
  inherited Create(AOwner);
  inherited DefaultDrawing := False;
  Bmp := TBitmap.Create;
  try
    Bmp.LoadFromResourceName(HInstance, bmArrow);
    FIndicators := TImageList.CreateSize(Bmp.Width, Bmp.Height);
    FIndicators.AddMasked(Bmp, clWhite);
    Bmp.LoadFromResourceName(HInstance, bmEdit);
    FIndicators.AddMasked(Bmp, clWhite);
    Bmp.LoadFromResourceName(HInstance, bmInsert);
    FIndicators.AddMasked(Bmp, clWhite);
    Bmp.LoadFromResourceName(HInstance, bmMultiDot);
    FIndicators.AddMasked(Bmp, clWhite);
    Bmp.LoadFromResourceName(HInstance, bmMultiArrow);
    FIndicators.AddMasked(Bmp, clWhite);
    Bmp.LoadFromResourceName(HInstance, bmCheck);
    FIndicators.AddMasked(Bmp, clBtnFace);
    Bmp.LoadFromResourceName(HInstance, bmMain);
    FIndicators.AddMasked(Bmp, clBtnFace);
    Bmp.LoadFromResourceName(HInstance, bmIndexAsc);
    FIndicators.AddMasked(Bmp, clBtnFace);
    Bmp.LoadFromResourceName(HInstance, bmIndexDesc);
    FIndicators.AddMasked(Bmp, clBtnFace);
    Bmp.LoadFromResourceName(HInstance, bmIndexNone);
    FIndicators.AddMasked(Bmp, clBtnFace);
    Bmp.LoadFromResourceName(HInstance, bmExpand);
    FTreeImages := TImageList.CreateSize(Bmp.Width, Bmp.Height);
    FTreeImages.AddMasked(Bmp, clBtnFace);
    Bmp.LoadFromResourceName(HInstance, bmCollapse);
    FTreeImages.AddMasked(Bmp, clBtnFace);
  finally
    Bmp.Free;
  end;
  FTitleOffset := 1;
  FIndicatorOffset := 1;
  FOptions := [tgEditing, tgTitles, tgIndicator, tgColumnResize,
    tgColLines, tgRowLines, tgTabs, tgConfirmDelete, tgCancelOnExit,
    tgTreePathResize, tgFixedLines, tgColMoving];

  DesignOptionsBoost := [goColSizing];
  VirtualView := True;
  UsesBitmap;

  inherited Options := [goFixedHorzLine, goFixedVertLine, goHorzLine,
    goVertLine, goColSizing, goTabs];

  FKnots   := TKnotItems.Create(Self);
  FColumns := TKnotColumns.Create(Self);

  inherited RowCount := 2;
  inherited ColCount := 2;

  Color := clWindow;
  ParentColor := False;
  FTitleFont := TFont.Create;
  FTitleFont.OnChange := TitleFontChanged;
  FSaveCellExtents := False;
  FDefaultDrawing := True;

  FBookmarks := TKnotBookmarkList.Create(Self);

  FClickedCol := -1;
  FCurrentCol := -1;
  FMousePoint := Point(-1,-1);
  FClipDown   := False;
  FFirstGridCell := 0;
  FTreepathWidth := 0;

  FFirstVisible  := FKnots.FRootKnot;
  FFirstIndex    := 0;

  FInplaceEdit   := nil;
  FEditorMode    := False;
  FInplaceCol    := -1;
  FInplaceRow    := -1;
  FIsESCKey      := False;
  FIsModified    := False;
  FRowUpdated    := False;
  FSetTreePath   := False;

  FHintRow       := -1;
  FShadowFill    := True;

  FImageChangeLink :=  TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;
  FBookmarkSize  := 20;
   
end;

procedure TDCCustomTreeGrid.CreateWnd;
begin
  BeginUpdate;   { prevent updates in WMSize message that follows WMCreate }
  try
    inherited CreateWnd;
  finally
    EndUpdate;
  end;
  UpdateActive;
  UpdateRowCount;

  FClipPopup := TKNClipPopup.Create(Self);
end;

procedure TDCCustomTreeGrid.DataChanged;
begin
  if not HandleAllocated then Exit;
  UpdateActive;
  UpdateRowCount;
  InvalidateRect(Handle, nil, False);
end;

function TDCCustomTreeGrid.DataToRawColumn(ACol: Integer): Integer;
begin
  Result := ACol + FIndicatorOffset;
end;

procedure TDCCustomTreeGrid.DblClick;
 var
  Cell: TGridCoord;
  P: TPoint;
  R: TRect;
  ARow: integer;
begin
  if not AcquireFocus or FKnots.Updating then Exit;

  GetCursorPos(P);
  P := ScreenToClient(P);
  Cell := MouseCoord(P.X, P.Y);
  R := CellRect(Cell.X, Cell.Y);

  if (FKnots.Count > 0) and (Cell.Y >= FTitleOffset) then
    with Cell do
    begin
      BeginUpdate;
      try
        if (Y >= FTitleOffset) and (Y - Row <> 0) then
        begin
          ARow := Row;
          Row  := Cell.Y;
          if (ARow<>Cell.Y) and (Row<>Cell.Y) and (ARow=Row) then Exit;
        end;
        if Cell.X < FIndicatorOffset then
          with FSelectedKnot do
          begin
            case GetFixedCellType(Cell.X, 0) of
              fcTreePath:
                if tgEditing in Options then
                begin
                  case GetHitTestInfoAt(FSelectedKnot, P.X-R.Left, P.Y-R.Top) of
                    htOnButton,
                    htOnIcon  :
                      if ChildCount > 0 then
                      begin
                         if Expanded then
                           Collapse(False)
                         else
                           Expand(False);
                      end;
                    htOnLabel :;
                  end
                end
                else
                  if ChildCount > 0 then
                  begin
                     if Expanded then
                       Collapse(False)
                     else
                       Expand(False);
                  end;
            end
          end
        else begin
          ShowEditor;
        end;
      finally
        EndUpdate;
      end;
    end
    else
      if (Cell.X >= FIndicatorOffset) and (FKnots.Count = 0) and
         (Cell.Y >= FTitleOffset)
      then begin
         ShowEditor;
      end;

  inherited;
end;

destructor TDCCustomTreeGrid.Destroy;
begin

  if Assigned(FCurrentPos[1]) then FreeMem(FCurrentPos[1]);
  if Assigned(FCurrentPos[2]) then FreeMem(FCurrentPos[2]);

  if Assigned(FClipPopup) then
     TKNClipPopup(FClipPopup).Free;

  FColumns.Free;
  FIndicators.Free;
  FTreeImages.Free;
  FTitleFont.Free;
  FBookmarks.Free;
  FKnots.Free;
  ReleaseBitmap;
  FImageChangeLink.Free;
  inherited;
end;

procedure TDCCustomTreeGrid.DrawCell(ACol, ARow: Integer; ARect: TRect;
  AState: TGridDrawState);
var
  FrameOffs: Byte;
  BorderState: TDrawBorerState;
  BorderStyle: TEdgeBorderStyle;
  DrawKnot: TKnotItem;
  DrawColumn: TKnotColumn;
  Highlight, KnotFound: boolean;
  ALeft, ATop, KnotIndex, Indicator: integer;
  CellType: TFixedCell;
  DrawRect: TRect;

  procedure DrawTitleCell(ARect: TRect; Column: TKnotColumn; var AState: TGridDrawState);
  const
    ColumnIndexStyle : array [TColumnIndexStyle] of Integer =
     (nbmIndexNone,nbmIndexAsc,nbmIndexDesc);
    AlignFlags : array [TAlignment] of Integer =
      ( DT_LEFT   or DT_NOPREFIX or DT_END_ELLIPSIS,
        DT_RIGHT  or DT_NOPREFIX or DT_END_ELLIPSIS,
        DT_CENTER or DT_NOPREFIX or DT_END_ELLIPSIS);

   var
    TitleRect, TextRect, DrawRect: TRect;
  begin
    TitleRect := ARect;

    with TitleRect do if Right-Left = 0 then Exit;

    DrawBitmap.Width  := TitleRect.Right  - TitleRect.Left;
    DrawBitmap.Height := TitleRect.Bottom - TitleRect.Top;

    with DrawBitmap do
    begin
      DrawRect := Rect(0,0, Width, Height);
      TextRect := DrawRect;

      Canvas.Font := Column.Title.Font;
      Canvas.Brush.Color := Column.Title.Color;

      FillRect(Canvas.Handle, TextRect, Canvas.Brush.Handle);

      if BorderState = dsDown then
      begin
        TextRect.Left   := TextRect.Left + 3;
        TextRect.Top    := TextRect.Top  + 1;
        TextRect.Right  := TextRect.Right+ 1;
      end
      else
        TextRect.Left := TextRect.Left + 2;

      if (kcIndexed in Column.Options) and
        ((TextRect.Right - TextRect.Left) > 0)
      then begin
        FIndicators.Draw(Canvas, TextRect.Left, TextRect.Top, ColumnIndexStyle[Column.IndexStyle]);
        TextRect.Left := TextRect.Left + IndexTitleWidth - 2;
      end;

      if (Column.Grid.Images <> nil) and (Column.ItemIndex <> -1) and
         ((TextRect.Right - TextRect.Left) > 0)
      then begin
        Column.Grid.Images.Draw(Canvas, TextRect.Left, TextRect.Top, Column.ItemIndex);
        TextRect.Left := TextRect.Left + Column.Grid.Images.Width+2;
      end;

      if TextRect.Left < TextRect.Right then
      begin
        SetTextColor(Canvas.Handle, Canvas.Font.Color);
        with Column.Title do
          DrawText(Canvas.Handle, PChar(Caption), Length(Caption), TextRect,
            AlignFlags[Alignment])
        //DrawHighLightText(Canvas, Column.Title.Caption, TextRect, 1);
      end;

    end;
    Canvas.Draw(TitleRect.Left, TitleRect.Top, DrawBitmap);
  end;

  procedure DrawTreePathCell(ARect: TRect; var AState: TGridDrawState;
    KnotFound: boolean; DrawKnot: TKnotItem);
   var
    DrawRect, TextRect: TRect;
    ATop: integer;
    Text: string;
  begin
    if KnotFound then with DrawBitmap, DrawKnot do
    begin
      DrawBitmap.Width  := ARect.Right  - ARect.Left;
      DrawBitmap.Height := ARect.Bottom - ARect.Top;

      DrawRect := Rect(0,0, Width, Height);
      TextRect := DrawRect;

      Canvas.Brush.Color := FixedColor;
      Canvas.Font        := Self.Font;
      FillRect(Canvas.Handle, TextRect, Canvas.Brush.Handle);

      ATop := (DrawRect.Top + DrawRect.Bottom - FTreeImages.Height) shr 1;

      if BorderState = dsDown then
      begin
        TextRect.Left   := TextRect.Left + 3;
        TextRect.Top    := TextRect.Top  + 1;
        Inc(ATop);
      end
      else
        TextRect.Left := TextRect.Left + 2;

      TextRect.Left := TextRect.Left + Level*FTreeImages.Width;

      if VisibleChilds > 0  then
      begin
        if DrawKnot.Expanded then
          FTreeImages.Draw(Canvas, TextRect.Left, ATop, nbmExpand)
        else
          FTreeImages.Draw(Canvas, TextRect.Left, ATop, nbmCollapse);
      end;
      TextRect.Left := TextRect.Left + FTreeImages.Width + 1;

      if (Images <> nil) then
      begin
        if (ARow = (Row-FTitleOffset)) then
        begin
           if(SelectImage <> -1) then
           begin
             FImages.Draw(Canvas, TextRect.Left, TextRect.Top, SelectImage);
             TextRect.Left := TextRect.Left + FImages.Width + 2
           end
        end
        else begin
           if(NormalImage <> -1) then
           begin
             FImages.Draw(Canvas, TextRect.Left, TextRect.Top, NormalImage);
             TextRect.Left := TextRect.Left + FImages.Width + 2
           end;
        end;
      end;
      GetTreePathCaption(DrawKnot, Text);
      DrawHighLightText(Canvas, PChar(Text), TextRect, 1, 0, FImages);

      Self.Canvas.Draw(ARect.Left, ARect.Top, DrawBitmap);
    end;
  end;

begin
  if (csLoading in ComponentState) then
  begin
    Canvas.Brush.Color := Color;
    Canvas.FillRect(ARect);
    Exit;
  end;

  if not((tgColLines in Options) and (tgRowLines in Options)) or
     not(tgFixedLInes in Options) then
    if (tgFlatButtons in Options) and (tgFixedLInes in Options) then
      BorderStyle := ebsShadowFlat
    else
      BorderStyle := ebsNone
  else begin
    if tgFlatButtons in Options then
      BorderStyle := ebsFlat
    else
      BorderStyle := ebsNormal;
  end;

  if (FClickedCol <> -1) and (FCurrentCol <> -1) and (ARow = 0) and
     (ACol= FClickedCol) and (FCurrentCol = FClickedCol)
    then BorderState := dsDown
    else BorderState := dsUp;

  Dec(ARow, FTitleOffset);
  Dec(ACol, FIndicatorOffset);

  if (gdFixed in AState) and ([tgRowLines, tgColLines] * Options =
    [tgRowLines, tgColLines])
  then begin
    InflateRect(ARect, -1, -1);
    FrameOffs := 1;
  end
  else
    FrameOffs := 2;

  DrawKnot := FActiveKnot;
  if ARow >= 0 then
  begin
    KnotIndex := FFirstIndex;
    DrawKnot  := FFirstVisible;

    while (KnotIndex <> ARow) and (DrawKnot <> nil) do
    begin
      DrawKnot := DrawKnot.GetNextVisible;
      Inc(KnotIndex);
    end;

    FActiveKnot := DrawKnot;

    if (DrawKnot <> nil) and (DrawKnot.FLevel >= 0) then
      KnotFound   := True
    else
      KnotFound := False;
  end
  else
    KnotFound := False;

  if (gdFixed in AState) and (ACol < 0)
  then begin
    CellType := GetFixedCellType(ACol, FIndicatorOffset);
    Canvas.Brush.Color := FixedColor;
    if (CellType <> fcTreePath) or (ARow<0) or not KnotFound then
      Canvas.FillRect(ARect);

    case CellType of
      fcIndicator:
        begin
          ALeft := (ARect.Right + ARect.Left - FIndicators.Width - FrameOffs) shr 1 + 1;
          ATop  := (ARect.Top + ARect.Bottom - FIndicators.Height) shr 1;
          if ARow = (Row-FTitleOffset) then
          begin
            case FKnots.State of
              ksInsert: Indicator := nbmInsert;
              ksEdit  : Indicator := nbmEdit;
              ksBrowse: Indicator := nbmArrow;
              else
                Indicator := nbmArrow;
            end;
            FIndicators.Draw(Canvas, ALeft, ATop, Indicator, True);
          end;
          if ARow < 0 then begin
             FIndicators.BkColor := FixedColor;
             if FClipDown then
             begin
               if tgFixedLines in Options then
                 FIndicators.Draw(Canvas, ALeft, ATop+1, nbmMain)
               else
                 FIndicators.Draw(Canvas, ALeft-1, ATop, nbmMain);
               if BorderStyle <> ebsNone then
               begin
                 InflateRect(ARect, 1, 1);
                 DrawGridFrameBorder(Canvas, ARect, BorderStyle, dsDown, FixedColor);
               end;
             end
             else begin
               FIndicators.Draw(Canvas, ALeft-1, ATop, nbmMain);
               if BorderStyle <> ebsNone then
               begin
                 InflateRect(ARect, 1, 1);
                 DrawGridFrameBorder(Canvas, ARect, BorderStyle, dsUp, FixedColor);
               end;
             end;
             Exit;
          end;
        end;
      fcMarker   :
        begin
          if (ARow>=0) and KnotFound and
             FBookmarks.KnotSelected(DrawKnot.KnotID)
          then begin
            ALeft := ARect.Right - FIndicators.Width - FrameOffs;
            ATop  := (ARect.Top + ARect.Bottom - FIndicators.Height) shr 1;
           FIndicators.Draw(Canvas, ALeft-1, ATop, nbmCheck);
          end;
        end;
      fcTreePath :
        begin
          if ARow >= 0 then
             DrawTreePathCell(ARect, AState, KnotFound, DrawKnot);
        end;
    end;
  end
  else with Canvas do
  begin
    if FColumns.Count > ACol then
    begin
      DrawColumn := Columns[ACol];
      if not (gdFixed in AState) then
      begin
        Font := DrawColumn.Font;
        Brush.Color := DrawColumn.Color;
      end;
      if (ARow < 0) then
      begin
        if not(kcVisible in DrawColumn.Options) then Exit;
        DrawTitleCell(ARect, DrawColumn, AState);
      end
      else begin
        if not(kcVisible in DrawColumn.Options) or
           ((ARow=(FInplaceRow-FTitleOffset    ))   and
            (ACol=(FInplaceCol-FIndicatorOffset)))
        then Exit;

        DrawBitmap.Width  := ARect.Right  - ARect.Left;
        DrawBitmap.Height := ARect.Bottom - ARect.Top;

        with DrawBitmap, DrawBitmap.Canvas do
        begin
          DrawRect := Rect(0,0, Width, Height);
          if (gdFixed in AState) then
          begin
             Font := DrawColumn.Title.Font;
             Brush.Color := DrawColumn.Title.Color;
          end
          else
          begin
            Font := DrawColumn.Font;
            Brush.Color := DrawColumn.Color;
          end;

          Highlight := HighlightCell(ACol, ARow, AState);

          //New 18041999
          if (tgHighlightRow in Options) and
             ((tgAlwaysShowSelection in Options) or
              Focused or (Row=FInplaceRow))
          then begin
            if ((tgTitles in Options) and (ARow=(Row-FTitleOffset))) or
               (([tgTitles]*Options=[]) and (ARow=Row))
            then  begin
              if not Focused and ShadowFill then
                Brush.Color := clShadowed
              else begin
                Brush.Color := clHighlight;
                Font.Color := clHighlightText;
              end;
              AState := AState + [gdFocused];
            end;
            if Highlight then
            begin
              if not Focused and ShadowFill then
                Brush.Color := clShadowed
              else begin
                Brush.Color := clRowHighlight;
                Font.Color  := clTextHighlight;
              end;
              AState := AState + [gdSelected];
            end;
          end
          else if Highlight then
          begin
            if not Focused and ShadowFill then
              Brush.Color := clShadowed
            else begin
              Brush.Color := clHighlight;
              Font.Color := clHighlightText;
            end;
            AState := AState + [gdFocused];
          end;
          if not Enabled then
             Font.Color := clGrayText;

          FillRect(DrawRect);
          if KnotFound and (DrawKnot.Data <> nil) then
            DoDrawColumnCell(Canvas, DrawRect, ACol, DrawColumn, DrawKnot, AState);
        end;
        Canvas.Draw(ARect.Left, ARect.Top, DrawBitmap);
      end;
    end
    else begin
      if not (gdFixed in AState) then
        Brush.Color := Color
      else
        Brush.Color := FixedColor;
      Canvas.FillRect(ARect);
    end;
  end;
  if (gdFixed in AState) and (BorderStyle <> ebsNone) then
  begin
    InflateRect(ARect, 1, 1);
    DrawGridFrameBorder(Canvas, ARect, BorderStyle, BorderState, FixedColor);
  end;
end;

procedure TDCCustomTreeGrid.EndLayout;
begin
  if FLayoutLock > 0 then
  begin
    try
      try
        if FLayoutLock = 1 then
        begin
          InternalLayout;
        end;
      finally
        if FLayoutLock = 1 then
          FColumns.EndUpdate;
      end;
    finally
      Dec(FLayoutLock);
      EndUpdate;
    end;
  end;
end;

procedure TDCCustomTreeGrid.EndUpdate;
begin
  if FUpdateLock > 0 then
    Dec(FUpdateLock);
end;

function TDCCustomTreeGrid.GetFixedCellType(ACol, AOffset: integer): TFixedCell;
 var
  i: integer;
begin
  Result := fcColumn;
  ACol := ACol + AOffset;
  i := 0;
  if tgIndicator in Options then Inc(i,4);
  if tgMarker    in Options then Inc(i,2);
  if tgTreePath  in Options then Inc(i,1);

  if (ACol=0)and((i=7)or(i=6)or(i=5)or(i=4)) then
    Result := fcIndicator
  else
  if (ACol=0)and((i=2)or(i=3)) or (ACol=1)and((i=7)or(i=6)) then
    Result := fcMarker
  else
  if (ACol=0)and(i=1) or (ACol=1)and((i=3)or(i=5)) or (ACol=2)and(i=7) then
    Result := fcTreePath
end;

function TDCCustomTreeGrid.GetHitTestInfoAt(KnotItem: TKnotItem;
  X, Y: integer): TTreeGridHitTest;
 var
  BP: TPoint;
begin
  Result := htNowere;

  with KnotItem do
  begin
    if ChildCount > 0 then
    begin
      BP.X := Level*FTreeImages.Width;
      BP.Y := (Level+1)*FTreeImages.Width+1;

      if (X >= BP.X) and (X <= BP.Y) then begin
        Result := htOnButton;
        Exit;
      end;

    end
    else begin
      BP.X := (Level+1)*FTreeImages.Width;
      BP.Y := BP.X;
    end;

    if (X < BP.X) then
       Exit;

    if (Images<>nil) and
       ((KnotItem.KnotID =  SelectedKnot.KnotID)and(SelectImage>-1) or
       (KnotItem.KnotID <> SelectedKnot.KnotID)and(NormalImage>-1))
    then begin
      BP.X := BP.Y + 1;
      BP.Y := BP.Y + Images.Width+2;

      if (X >= BP.X) and (X <= BP.Y) then begin
        Result := htOnIcon;
        Exit;
      end;

    end;

    Result := htOnLabel;

  end;
end;

function TDCCustomTreeGrid.GetSelectedIndex: Integer;
begin
  Result := RawToDataColumn(Col);
end;

function TDCCustomTreeGrid.GetTreePathWidth: integer;
begin
  if not(tgTreePath in Options) then
    Result := 0
  else begin
    if FTreePathWidth <> 0
    then
      Result := FTreePathWidth
    else
      Result := TreeIconWidth;
  end;
end;

procedure TDCCustomTreeGrid.HideClipPopup;
begin
  FClipPopupVisible := False;
  TDCClipPopup(FClipPopup).Hide;
  SetClipDown(False);
end;

function TDCCustomTreeGrid.HighlightCell(DataCol, DataRow: Integer;
  AState: TGridDrawState): Boolean;
begin
  Result := False;
  if (tgMultiSelect in Options) and (FKnots.Count>0) then
    Result := FBookmarks.KnotSelected(FSelectedKnot.KnotID);
  if not Result then
    Result := (gdSelected in AState)
      and ((tgAlwaysShowSelection in Options) or Focused{ or (FInplaceEdit<>nil)})
      and ((UpdateLock = 0) or (tgRowSelect in Options));
end;

procedure TDCCustomTreeGrid.InternalLayout;

  procedure MeasureTitleHeights;
  var
    K: Integer;
    RestoreCanvas: Boolean;
  begin
    RestoreCanvas := not HandleAllocated;
    if RestoreCanvas then
      Canvas.Handle := GetDC(0);
    try
      Canvas.Font := Font;
      K := Canvas.TextHeight('Wg') + 3;
      if tgRowLines in Options then
        Inc(K, GridLineWidth);
      if not(tgUserRowHeight in Options) then
        DefaultRowHeight := K;
      SetTitleHeight;
    finally
      if RestoreCanvas then
      begin
        ReleaseDC(0,Canvas.Handle);
        Canvas.Handle := 0;
      end;
    end;
  end;

begin
  if (csLoading in ComponentState) then Exit;

  if HandleAllocated then KillMessage(Handle, CM_DEFERLAYOUT);

  FIndicatorOffset := 0;

  if tgIndicator in Options then Inc(FIndicatorOffset);
  if tgMarker in Options then Inc(FIndicatorOffset);
  if tgTreePath in Options then Inc(FIndicatorOffset);

  DoubleBuffered := False;
  ColCount := FColumns.Count + FIndicatorOffset;

  if FColumns.Count = 0 then ColCount := ColCount + 1;

  inherited FixedCols := FIndicatorOffset;

  FFirstVisible  := FKnots.FRootKnot;
  FFirstIndex    := 0;

  if tgTitles in Options then
    FTitleOffset := 1
  else
    FTitleOffset := 0;

  MeasureTitleHeights;
  SetColumnAttributes;
  UpdateActive;
  UpdateRowCount;
  Invalidate;
end;

procedure TDCCustomTreeGrid.InvalidateTitles;
var
  R, R1: TRect;
  DrawInfo: TGridDrawInfo;
begin
  if HandleAllocated and (tgTitles in Options) then
  begin
    CalcFixedInfo(DrawInfo);
    R := Rect(0, 0, Width, DrawInfo.Vert.FixedBoundary);
    InvalidateRect(Handle, @R, False);
  end;
  if HandleAllocated and (tgTitles in Options) then
  begin
    CalcDrawInfo(DrawInfo);
    with DrawInfo.Horz do
    begin
      R1 := CellRect(LeftCol+VisibleColCount, 0);
      if not IsRectEmpty(R1) and (FFirstGridCell > FirstGridCell) then
      begin
        R  := Rect(R1.Left, 0, R1.Right, DrawInfo.Vert.FixedBoundary);
        InvalidateRect(Handle, @R, False);
      end;
      FFirstGridCell := FirstGridCell;
    end;
  end;
end;

procedure TDCCustomTreeGrid.KeyDown(var Key: Word; Shift: TShiftState);
 var
  KeyDownEvent: TKeyEvent;
  DrawInfo: TGridDrawInfo;
  PageWidth, PageHeight: Integer;

  procedure CalcPageExtents;
  begin
    CalcDrawInfo(DrawInfo);
    PageWidth := DrawInfo.Horz.LastFullVisibleCell - LeftCol;
    if PageWidth < 1 then PageWidth := 1;
    PageHeight := DrawInfo.Vert.LastFullVisibleCell - TopRow;
    if PageHeight < 1 then PageHeight := 1;
  end;

  procedure Tab(GoForward: Boolean);
  var
    ACol, Original: Integer;
  begin
    ACol     := Col;
    Original := ACol;
    BeginUpdate;
    try
      while True do
      begin
        if GoForward then
          Inc(ACol) else
          Dec(ACol);
        if ACol >= ColCount then
        begin
          NextRow(False, True, Shift);
          ACol := FIndicatorOffset;
        end
        else if ACol < FIndicatorOffset then
        begin
          PrevRow(False);
          ACol := ColCount - FIndicatorOffset;
        end;
        if (ACol = Original) or
           (Assigned(FInplaceEdit) and TDCCustomEdit(FInplaceEdit).ShowError) then Exit;
        if TabStops[ACol] then
        begin
          MoveCol(ACol, 0);
          Exit;
        end;
      end;
    finally
      EndUpdate;
    end;
  end;

 const
  RowMovementKeys = [VK_UP, VK_PRIOR, VK_DOWN, VK_NEXT, VK_HOME, VK_END];
begin
  if not DataVisible then Exit;
  
  if FClipPopupVisible then
  begin
    if Key = VK_ESCAPE then
      HideClipPopup
    else
      TKNClipPopup(FClipPopup).KeyDown(Key, Shift);
    Key := 0;
    Exit;
  end;

  KeyDownEvent := OnKeyDown;
  if Assigned(KeyDownEvent) then KeyDownEvent(Self, Key, Shift);
  if not CanGridAcceptKey(Key, Shift) or FKnots.Updating then Exit;

  with FKnots do
    if ssCtrl in Shift then
    begin
      if (Key in RowMovementKeys) then ClearSelection;
      case Key of
        VK_DELETE:
          DeleteRecords(not(tgConfirmDelete in Options) or False);
        VK_INSERT:
          begin
            if tgEditing in Options then
              InsertKnot(FSelectedKnot, True, Shift);
          end;
        VK_LEFT: MoveCol(FIndicatorOffset, 1);
        VK_RIGHT: MoveCol(ColCount - 1, -1);
        VK_HOME:
          begin
            Row := FTitleOffset;
            MoveCol(FIndicatorOffset, 1);
          end;
        VK_END:
          begin
            Row := RowCount-1;
            MoveCol(ColCount - 1, -1);
          end;
        VK_NEXT, VK_PRIOR: inherited;
      end
    end
    else
    if not(ssAlt in Shift) then
    begin
      case Key of
        VK_DOWN:
          begin
            if ssShift in Shift then
            begin
              MarkKnot;
              NextRow(False, False, Shift);
            end
            else
              NextRow(True, True, Shift);
            Key := 0;
          end;
        VK_UP:
          begin
            PrevRow(True);
            if ssShift in Shift then MarkKnot;
            Key := 0;
          end;
        VK_LEFT:
          begin
            if tgRowSelect in Options then
              PrevRow(False)
            else
              MoveCol(Col - 1, -1);
          end;
        VK_RIGHT:
          begin
            if tgRowSelect in Options then
              NextRow(False, False, Shift)
            else
              MoveCol(Col + 1, 1);
          end;
        VK_INSERT:
          begin
            if tgEditing in Options then
              InsertKnot(FSelectedKnot, False, Shift)
            else begin
              MarkKnot;
              NextRow(True, True, Shift);
            end;
          end;
        VK_TAB:
          begin
            if not (ssAlt in Shift) then Tab(not (ssShift in Shift));
            Key := 0;
          end;
        VK_ESCAPE:
          begin
            FIsESCKey := True;
            if not (tgAlwaysShowEditor in Options) and FEditorMode then
            begin
              FIsModified := False;
              HideEditor;
            end
            else
              if (State = ksInsert) then
              begin
                FRowUpdated := False;
                PrevRow(True);
              end;
          end;
        VK_HOME:
          if (ColCount = FIndicatorOffset+1) or (tgRowSelect in Options) then
          begin
            Row := FTitleOffset;
            MoveCol(FIndicatorOffset, 1);
          end
          else
            MoveCol(FIndicatorOffset, 1);
        VK_END:
          if (ColCount = FIndicatorOffset+1) or (tgRowSelect in Options) then
          begin
            Row := RowCount-1;
            MoveCol(ColCount - 1, -1);
          end
          else
            MoveCol(ColCount - 1, -1);
        VK_NEXT:
          begin
            CalcPageExtents;
            NextRow(False, False, Shift, PageHeight);
          end;
        VK_PRIOR:
          begin
            CalcPageExtents;
            PrevRow(False, PageHeight);
          end;
        VK_F2: ShowEditor;
        VK_DELETE:
          DeleteRecords(True);
      end;
    end;
end;

procedure TDCCustomTreeGrid.KeyPress(var Key: Char);
begin
  if not DataVisible then Exit;
  FIsESCKey := False;
  if (FKnots.Count > 0) and not(FEditorMode or FKnots.Updating) then
    with FSelectedKnot do
    begin
      if ChildCount > 0 then
      begin
        case Key of
          '-':
            begin
              Collapse(False);
              Key := #0;
            end;
          '+':
            begin
              Expand(False);
              Key := #0;
            end;
          '*':
            begin
              Expand(True);
              Key := #0;
            end;
        end;
      end;
    end;
  if not (tgAlwaysShowEditor in Options) and (Key = Chr(VK_RETURN)) then
  begin
    if FEditorMode then
      HideEditor else
      ShowEditor;
    Key := #0;
  end;
  if Key = Chr(VK_TAB) then Key := #0;

  inherited KeyPress(Key);
end;

procedure TDCCustomTreeGrid.LayoutChanged;
begin
  if AcquireLayoutLock then
    EndLayout;
end;

procedure TDCCustomTreeGrid.Loaded;
begin
  inherited Loaded;
  if FColumns.Count > 0 then
    ColCount := FColumns.Count;
  LayoutChanged;
end;

procedure TDCCustomTreeGrid.MouseDown(Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
 var
  Cell, ACell: TGridCoord;
  GridOptions: TGridOptions;
  R: TRect;
  ARow: integer;
begin
  if not AcquireFocus or FKnots.Updating or not DataVisible then Exit;

  Cell := MouseCoord(X, Y);
  R    := CellRect(Cell.X, Cell.Y);

  if (ssDouble in Shift) and (Button = mbLeft) then
  begin
    if (Cell.Y  >=  FTitleOffset) and
       ((Cell.X >= FIndicatorOffset)or(GetFixedCellType(Cell.X, 0) = fcTreePath))
    then begin
      DblClick;
      Exit;
    end;
    Shift := Shift - [ssDouble];
  end;

  FMousePoint := Point(X,Y);

  if (tgTitleClicked in Options) and (Button = mbLeft) and not Sizing(X, Y)
     and (Cell.Y=0) and (GetFixedCellType(Cell.X, 0) = fcColumn)
  then begin
    FClickedCol := Cell.X;
    if not(tgColMoving in Options) then InvalidateCell(Cell.X, 0);
  end;

  if (Button = mbLeft) and
     (Cell.Y=0) and (GetFixedCellType(Cell.X, 0) = fcIndicator) and
     (tgTitles in Options)
  then begin
    ClipClick;
    Exit;
  end;

  if FClipPopupVisible then HideClipPopup;

  if Sizing(X, Y) then
  begin
    HideEditor;
    if not FEditorMode then
      inherited MouseDown(Button, Shift, X, Y);
    Exit;
  end;

  if (DragKind = dkDock) and (Cell.X < FIndicatorOffset) and
    (Cell.Y < FTitleOffset) and (not (csDesigning in ComponentState)) then
  begin
    BeginDrag(false);
    Exit;
  end;

  if ((csDesigning in ComponentState) or (tgColumnResize in Options)) and
    (Cell.Y < FTitleOffset) then
  begin
    if (tgTitleClicked in Options) and
       (Button = mbLeft) and (GetFixedCellType(Cell.X, 0) = fcColumn)
    then begin
      HideEditor;
      if tgColMoving in Options then
      begin
        GridOptions := inherited Options;
        inherited Options := inherited Options - [goColMoving];
        inherited MouseDown(Button, Shift, X, Y);
        inherited Options := GridOptions;
      end
      else
       inherited MouseDown(Button, Shift, X, Y);
    end
    else inherited MouseDown(Button, Shift, X, Y);
    Exit;
  end;

  with Cell do
  begin
    BeginUpdate;
    try
      ARow := 0; ACell.X := 0; ACell.Y := 0;
      if (Y >= FTitleOffset) and (Y - Row <> 0) then
      begin
        ARow := Row;
        with FKnots do
          if (State = ksInsert) and not Modified then Delete(FSelectedKnot);
        ACell.Y := Y;
      end;
      if (X >= FixedCols) then ACell.X := X;

      if (ACell.X <> 0) and (ACell.Y <> 0) then
        MoveColRow(ACell.X, ACell.Y, True, True)
      else begin
        if (ACell.Y <> 0) then Row := Y;
        if (ACell.X <> 0) then MoveCol(X, 0);
      end;

      if (ACell.Y <> 0) and (ARow <> Y) and (Row <> Y) and (ARow=Row) then Exit;

      if FKnots.Count > 0 then
      with FSelectedKnot do
      begin
        if tgMultiSelect in Options then
          with FBookmarks do
          begin
            if ssCtrl in Shift then
              Select(KnotID, not KnotSelected(KnotID))
            else
            begin
              Clear;
              Select(KnotID, True);
            end;
          end;
        case GetFixedCellType(Cell.X, 0) of
          fcMarker:
            with FBookmarks do
            begin
              Select(KnotID, not KnotSelected(KnotID));
              InvalidateCell(Cell.X, Cell.Y);
            end;
          fcTreePath:
            if (ChildCount > 0) and
               (GetHitTestInfoAt(FSelectedKnot,
                 FMousePoint.X-R.Left, FMousePoint.Y-R.Top) = htOnButton) then
            begin
               if Expanded then
                 Collapse(False)
               else
                 Expand(False);
            end
        end;
      end;
    finally
      EndUpdate;
    end;
  end;

end;

procedure TDCCustomTreeGrid.MouseMove(Shift: TShiftState; X, Y: Integer);
var
  Cell: TGridCoord;
  OldCurrentCol, LabelOffset: integer;
  R: TRect;
  KnotItem: TKnotItem;
  P: TPoint;
  Text: string;
  CellX, CellY: integer;
begin
  if FKnots.Updating or not DataVisible then Exit;
  Cell := MouseCoord(X,Y);
  OldCurrentCol := FCurrentCol;
  if Cell.Y = 0
    then FCurrentCol := Cell.X
    else FCurrentCol := -1;

    if (Cell.X >= FixedCols) and (FClickedCol=FCurrentCol) and (FClickedCol <> -1) and
     (FGridState <> gsColMoving) and (tgColMoving in Options) and
     ((Abs(FMousePoint.X - X) > 5) or (Abs(FMousePoint.Y - Y) > 5) ) then
  begin
     FGridState := gsColMoving;
     inherited MouseDown(mbLeft, Shift, FMousePoint.X, FMousePoint.Y);
     Exit;
  end;

  inherited MouseMove(Shift, X, Y);

  if (FClickedCol <> -1) and (FCurrentCol <> OldCurrentCol) and
     (FGridState <> gsColMoving) and
     (GetFixedCellType(FClickedCol, 0) = fcColumn)
  then begin
    InvalidateCell(FClickedCol, 0);
  end;

  if not FKnots.Updating then
  begin
    if (GetFixedCellType(Cell.X, 0) = fcTreePath) and (Cell.Y >= FTitleOffset)
    then begin
      R := CellRect(Cell.X, Cell.Y);
      KnotItem := FKnots.SelectKnot(FFirstVisible, Cell.Y-FTitleOffset-FFirstIndex);
      if Assigned(KnotItem) then
        case GetHitTestInfoAt(KnotItem, X-R.Left, Y-R.Top) of
          htOnIcon ,
          htOnLabel :
            begin
              LabelOffset := GetHintTreeOffset(KnotItem, htOnLabel);
              GetTreePathCaption(KnotItem, Text);
              P := DrawHighLightText(Canvas, PChar(Text), Rect(0,0,0,0), 0);
              Canvas.Font := Self.Font;
              if ((R.Left + LabelOffset + P.X + 2) > R.Right) and (X < R.Right)
              then begin
                if FHintRow <> -1 then
                begin
                  if FHintRow = Cell.Y then Exit;
                  HideHintWindow;
                end;
                CellX := Cell.X;
                CellY := Cell.Y;
                if not(goHorzLine in (inherited Options)) then
                  R.Top := R.Top - GridLineWidth;
                if not(goVertLine in (inherited Options)) then
                  R.Left := R.Left - GridLineWidth;
                ShowHintWindow(CellX, CellY, R.Left-1, R.Top, LabelOffset, Text);
              end
              else
                HideHintWindow;
            end;
          else
            HideHintWindow;
        end;
    end
    else begin
      HideHintWindow;
      if (Cell.Y < FTitleOffset) and (RawToDataColumn(Cell.X)>=0) and
         (Columns.Count > 0)
      then
        DoColumnComment(MODE_SHOWWINDOW, Columns[RawToDataColumn(Cell.X)])
      else
        DoColumnComment(MODE_HIDEWINDOW, nil);
    end;
  end;

end;

procedure TDCCustomTreeGrid.MouseUp(Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  Cell  : TGridCoord;
  SaveState: TGridState;
  I: Integer;
  MouseClick: boolean;
  OldClickedCol: integer;
  R: TRect;
begin
  SaveState := FGridState;
  MouseClick := (FClickedCol <> -1) and (FClickedCol=FCurrentCol);

  inherited MouseUp(Button, Shift, X, Y);

  Cell := MouseCoord(X,Y);

  if FTreePathSizing and (SaveState = gsColSizing) then
  begin
    R := CellRect(FIndicatorOffset-1, Cell.Y);
    if (X-R.Left+FSizingOff) < TreeIconWidth then
      TreePathWidth := TreeIconWidth
    else
      TreePathWidth := X-R.Left+FSizingOff;
  end;

  if (Button = mbLeft) and (FClickedCol <> -1) then
  begin
    OldClickedCol := FClickedCol;
    FClickedCol := -1;
    InvalidateCell(OldClickedCol, 0);
  end;

  if (SaveState = gsRowSizing) or (SaveState = gsColSizing) or
    ((InplaceEditor <> nil) and (InplaceEditor.Visible) and
     (PtInRect(InplaceEditor.BoundsRect, Point(X,Y)))) then Exit;

  if (Button = mbLeft) and
     (Cell.X >= FIndicatorOffset) and (Cell.Y <  FTitleOffset) and
     MouseClick and (SaveState <> gsColMoving)
  then
  begin
    if ((Cell.X-IndicatorOffset) < Columns.Count) and
       (kcIndexed in Columns[Cell.X-IndicatorOffset].Options) then
      for i := 0 to Columns.Count-1 do
      begin
        if i = Cell.X-IndicatorOffset then
        begin
          if Columns[i].IndexStyle < High(TColumnIndexStyle)
            then Columns[i].IndexStyle := Succ(Columns[i].IndexStyle)
            else Columns[i].IndexStyle := Pred(Columns[i].IndexStyle);
          InvalidateCell(i+IndicatorOffset,0);
        end
        else
          if not(ssShift in Shift) then
          begin
            if (kcIndexed in Columns[i].Options) and
               (Columns[i].IndexStyle <> Low(TColumnIndexStyle))
            then begin
              Columns[i].IndexStyle := Low(TColumnIndexStyle);
              InvalidateCell(i+IndicatorOffset,0);
            end;
          end;
      end;
  end;

  if (Button = mbLeft) and (Cell.X >= FIndicatorOffset) and (Cell.Y >= 0) and
     (SaveState <> gsColMoving) and ((Cell.X-IndicatorOffset) < Columns.Count)
  then
    if (Cell.Y < FTitleOffset) and MouseClick then
      TitleClick(Columns[RawToDataColumn(Cell.X)])
    else
      CellClick(Columns[SelectedIndex]);
end;

procedure TDCCustomTreeGrid.MoveCol(RawCol, Direction: Integer);
var
  OldCol: Integer;
begin
  if RawCol >= ColCount then
    RawCol := ColCount - 1;
  if RawCol < FixedCols then RawCol := FixedCols;
  if Direction <> 0 then
  begin
    while (RawCol < ColCount) and (RawCol >= FIndicatorOffset) and
      (ColWidths[RawCol] <= 0) do
      Inc(RawCol, Direction);
    if (RawCol >= ColCount) or (RawCol < FIndicatorOffset) then Exit;
  end;
  OldCol := Col;
  if RawCol <> OldCol then
    Col := RawCol;
end;

function TDCCustomTreeGrid.RawToDataColumn(ACol: Integer): Integer;
begin
  Result := ACol - FIndicatorOffset;
end;

procedure TDCCustomTreeGrid.RowHeightsChanged;
var
  i,ThisHasChanged,Def : Integer;
begin
  ThisHasChanged:=-1;
  Def:=DefaultRowHeight;
  for i:=Ord(tgTitles in Options) to RowCount do
    if RowHeights[i]<>Def then begin
      ThisHasChanged:=i;
      Break;
    end;
  if ThisHasChanged<>-1 then begin
    DefaultRowHeight:=RowHeights[i];
    InternalLayout;
  end;
  inherited;
  SetTitleHeight;
end;

function TDCCustomTreeGrid.SelectCell(ACol, ARow: Integer): Boolean;
 var
  OldRect, NewRect: TRect;
  DrawInfo: TGridDrawInfo;
begin
  Result := inherited SelectCell(ACol, ARow);
  DoSelectCell(Self, ACol, ARow, Result);
  if FEditorMode and Result  then
  begin
    SendMessage(FInplaceEdit.Handle, CM_EXIT, 0, 0);
    if FInplaceEdit.ShowError then Result := False;
  end;

  if Result and ((ARow<>Row)or(ACol<>Col)) then
    if not (tgAlwaysShowEditor in Options) and FEditorMode then HideEditor;

  if Result and (ARow<>Row) then
  begin
    CalcDrawInfo(DrawInfo);
    FRowUpdated   := False;
    SetSelectedKnot(FKnots.SelectKnot(FFirstVisible, ARow-FFirstIndex-FTitleOffset));
    OldRect := BoxRectEx(0 , Row , ColCount-1, Row );
    if ARow <= DrawInfo.Vert.LastFullVisibleCell then
      NewRect := BoxRectEx(0 , ARow, ColCount-1, ARow)
    else begin
      with DrawInfo.Vert do
        NewRect := BoxRectEx(0 , LastFullVisibleCell+1, ColCount-1, LastFullVisibleCell+1);
    end;
    ValidateRect(Handle, @OldRect);
    InvalidateRect(Handle, @OldRect, False);
    InvalidateRect(Handle, @NewRect, False);
    FKnots.SetState(ksBrowse);
  end;
end;

procedure TDCCustomTreeGrid.SetClipDown(const Value: boolean);
begin
  if FClipDown <> Value then
  begin
    FClipDown := Value;
    if (tgIndicator in Options) then  InvalidateCell(0,0);
  end;
end;

procedure TDCCustomTreeGrid.SetColumnAttributes;
var
  I, J: Integer;

begin
  for I := 0 to FColumns.Count-1 do
  with FColumns[I] do
  begin
    TabStops[I + FIndicatorOffset]  := ([kcVisible,kcReadOnly]*Options=[kcVisible]);
    ColWidths[I + FIndicatorOffset] := Width;
  end;

  J := 0;
  if (tgIndicator in Options) then
  begin
    ColWidths[J] := IndicatorWidth;
    Inc(J);
  end;
  if (tgMarker in Options) then
  begin
    ColWidths[J] := MarkerWidth;
    Inc(J);
  end;
  if (tgTreePath  in Options) then
    ColWidths[J] := TreePathWidth;

end;

procedure TDCCustomTreeGrid.SetColumns(const Value: TKnotColumns);
begin
  Columns.Assign(Value);
end;

procedure TDCCustomTreeGrid.SetKnots(const Value: TKnotItems);
begin
  FKnots.Assign(Value);
  DataChanged;
end;

procedure TDCCustomTreeGrid.SetOptions(Value: TTreeGridOptions);
const
  LayoutOptions = [tgEditing, tgAlwaysShowEditor, tgTitles, tgIndicator,
    tgColLines, tgRowLines, tgRowSelect, tgAlwaysShowSelection, tgMarker,
    tgTitleClicked, tgHighlightRow, tgFlatButtons, tgTreePath, tgFixedLines,
    tgCompleteLines];
var
  NewGridOptions: TGridOptions;
  ChangedOptions: TTreeGridOptions;
begin
  if FOptions <> Value then
  begin
    NewGridOptions := [];
    if tgColLines in Value then
      NewGridOptions := NewGridOptions + [goFixedVertLine, goVertLine];
    if tgRowLines in Value then
      NewGridOptions := NewGridOptions + [goFixedHorzLine, goHorzLine];
    if tgColumnResize in Value then
      NewGridOptions := NewGridOptions + [goColSizing];
    if tgColMoving in Value then
      NewGridOptions := NewGridOptions + [goColMoving];
    if tgRowMoving in Value then
      NewGridOptions := NewGridOptions + [goRowMoving];
    if tgTabs in Value then Include(NewGridOptions, goTabs);
    if tgRowSelect in Value then
    begin
      Include(NewGridOptions, goRowSelect);
      Exclude(Value, tgAlwaysShowEditor);
      Exclude(Value, tgEditing);
    end;

    if tgHighlightRow in Value then
    begin
      Exclude(Value, tgRowSelect);
    end;

    if tgMultiSelect in (FOptions - Value) then ;

    if tgMultiSelect in Value then Value := Value - [tgMarker];

    if tgRowSizing in Value  then
    begin
       NewGridOptions := NewGridOptions + [goRowSizing];
       Value := Value +[tgUserRowHeight];
    end;

    if tgFlatButtons in Value then
      NewGridOptions := NewGridOptions - [goFixedHorzLine, goFixedVertLine];

    inherited Options := NewGridOptions;

    ChangedOptions := (FOptions + Value) - (FOptions * Value);
    FOptions := Value;
    if ChangedOptions * LayoutOptions <> [] then  LayoutChanged;
  end;
end;

procedure TDCCustomTreeGrid.SetSelectedIndex(Value: Integer);
begin
  MoveCol(DataToRawColumn(Value), 0);
end;

procedure TDCCustomTreeGrid.SetTitleFont(const Value: TFont);
begin
  FTitleFont.Assign(Value);
  if tgTitles in Options then LayoutChanged;
end;

procedure TDCCustomTreeGrid.SetTitleHeight;
var
  I: Integer;
  Heights: array of Integer;
  P: TPoint;
begin
  Canvas.Font := Font;
  if tgTitles in Options then
  begin
    SetLength(Heights, FTitleOffset);
    for I := 0 to FColumns.Count-1 do
    begin
      Canvas.Font := FColumns[I].Title.Font;
      P := DrawHighLightText(Canvas, PChar(FColumns[I].Title.Caption), Rect(0,0,0,0), 0);
      if P.Y > 0 then Inc(P.Y, 4);
      if (Images <> nil) and (FColumns[I].ItemIndex <> -1) then
         if P.Y < (Images.Height + 3) then P.Y := Images.Height+3;
      Heights[0] := Max(P.Y, Heights[0]);
    end;
    if Heights[0] = 0 then
    begin
      Canvas.Font := FTitleFont;
      Heights[0] := Canvas.TextHeight('Wg') + 4;
    end;
    RowHeights[0] := Heights[0];
  end;
end;

procedure TDCCustomTreeGrid.SetTreePathWidth(const Value: integer);
 var
  J: integer;
begin
  if Value > 0 then
  begin
    FTreePathWidth := Value;
    J := 0;
    if (tgIndicator in Options) then Inc(J);
    if (tgMarker    in Options) then Inc(J);
    if (tgTreePath  in Options) then
      if J < ColCount then begin
         FSetTreePath := True;
         ColWidths[J] := TreePathWidth;
         FSetTreePath := False;
      end;
  end;
end;

procedure TDCCustomTreeGrid.ShowClipPopup(AClipPopup: TObject);
 var
  Show: boolean;
  R: TRect;

begin
  Show := True;
  FClipPopupVisible := True;

  R := CellRect(0,0);

  TDCClipPopup(AClipPopup).Hide;
  TDCClipPopup(AClipPopup).SetBoundsEx(R.Left, R.Bottom,
    TDCClipPopup(AClipPopup).Width, TDCClipPopup(AClipPopup).Height);

  if Assigned(FOnClipClick) then
    FOnClipClick(AClipPopup, TDCClipPopup(AClipPopup).Left,
      TDCClipPopup(AClipPopup).Top, Show);

  if Show then
  begin
    ClipDown := not ClipDown;
    TKNClipPopup(AClipPopup).OnButtonClick := ClipButtonClick;
    TKNClipPopup(AClipPopup).Show;
  end
  else
    HideClipPopup;
end;

procedure TDCCustomTreeGrid.TitleClick(Column: TKnotColumn);
begin
  if Assigned(FOnTitleClick) then FOnTitleClick(Column);
end;

procedure TDCCustomTreeGrid.TitleFontChanged(Sender: TObject);
begin
  if (not FSelfChangingTitleFont) and not (csLoading in ComponentState) then
    ParentFont := False;
  if tgTitles in Options then LayoutChanged;
end;

procedure TDCCustomTreeGrid.TopLeftChanged;
begin
  if not FKnots.Updating then
  begin
    FFirstVisible := FKnots.SelectKnot(FFirstVisible, TopRow-FTitleOffset-FFirstIndex);
    FFirstIndex   := TopRow-FTitleOffset;
    if FEditorMode and (FInplaceEdit <> nil) then
      InplaceUpdateLoc(FInplaceEdit, CellRect(FInplaceCol, FInplaceRow), Canvas);
  end;
  HideHintWindow;
  inherited;
  if Assigned(FOnTopLeftChanged) then FOnTopLeftChanged(Self);
end;


procedure TDCCustomTreeGrid.UpdateActive;
begin
  FFirstVisible := FKnots.SelectKnot(FKnots.Items[0], FFirstIndex);
  SetSelectedKnot(FKnots.SelectKnot(FFirstVisible, Row-TopRow));
end;

procedure TDCCustomTreeGrid.UpdateRowCount;
var
  OldRowCount: integer;
begin
  OldRowCount := RowCount;
  if RowCount <= FTitleOffset then RowCount := FTitleOffset + 1;
  FixedRows := FTitleOffset;
  FKnotCount := FKnots.VisibleKnotCount;
  if FKnotCount = 0 then
    RowCount := 1 + FTitleOffset
  else begin
    RowCount := FKnotCount + FTitleOffset;
    if (tgRowSelect in Options) then  TopRow := FixedRows;
    UpdateActive;
  end;
  if OldRowCount <> RowCount then Invalidate;
end;

procedure TDCCustomTreeGrid.WMKillFocus(var Message: TMessage);
begin
  inherited;
  if FClipPopupVisible then HideClipPopup;
  InvalidateSelected;
end;

procedure TDCCustomTreeGrid.WMSetFocus(var Message: TWMSetFocus);
begin
  inherited;
  if FClipPopupVisible then HideClipPopup;
  MoveCol(Col, 1);
  InvalidateSelected;
end;

procedure TDCCustomTreeGrid.WMSize(var Message: TWMSize);
begin
  inherited;
  if UpdateLock = 0 then UpdateRowCount;
  InvalidateTitles;
end;

function TDCCustomTreeGrid.HideEditor: boolean;
 var
  UpdateRect: TRect;
begin
  if Assigned(FInplaceEdit) then
  begin
    if FIsModified then
    begin
      Result := FInplaceEdit.ValueCorrect;
      if not Result then
      begin
         FInplaceEdit.ShowErrorMessage;
         Exit;
       end;
      if FInplaceEdit.ErrorCode = ERR_EDIT_NONE then UpdateEditData;
    end;
    if GetFocus = FInplaceEdit.Handle then Windows.SetFocus(Handle);

    FInplaceEdit.Free;
    FInplaceEdit := nil;
    FEditorMode  := False;

    UpdateRect := BoxRectEx(0, FInplaceRow , ColCount - 1, FInplaceRow );
    ValidateRect(Handle, @UpdateRect);
    InvalidateRect(Handle, @UpdateRect, False);
    FInplaceCol  := -1;
    FInplaceRow  := -1;
    FIsESCKey    := False;
    FRowUpdated  := FRowUpdated or FIsModified;

    DoDestroyCellEdit;

  end;

  FIsModified := False;
  Result      := True;
end;

procedure TDCCustomTreeGrid.ShowEditor;

  procedure UpdateEditor;
  begin
    FInplaceCol := Col;
    FInplaceRow := Row;
    FInplaceEdit.SelectAll;
  end;

var
  Column: TKnotColumn;
  Key: Word;
  CanCreate: boolean;
begin
  if not(tgEditing in Options) or (Columns.Count=0) then Exit;
  Column := Columns[Col-FIndicatorOffset];
  if not(kcShowEdit in Column.Options) then Exit;

  with FKnots do
    if Count=0 then begin
      Key := VK_DOWN;
      KeyDown(Key, []);
      if FSelectedKnot = nil then Exit;
    end;

  if FEditorMode then HideEditor;

  DoCreateCellEdit(Column, FInplaceEdit, CanCreate);

  if Assigned(FInplaceEdit) then
  begin
    FEditorMode  := True;
    FIsModified  := False;
    with TDCHackChoiceEdit(FInplaceEdit) do
    begin
      Visible   := False;
      ReadOnly  := kcReadOnly in Column.Options ;
      DrawStyle := fsNone;
    end;

    UpdateEditor;
    InplaceUpdateLoc(FInplaceEdit, CellRect(Col, Row), Canvas);
  end;
end;

procedure TDCCustomTreeGrid.DoCreateCellEdit(Column: TKnotColumn;
  var Edit: TDCCustomChoiceEdit; var CanCreate: boolean);
begin
  CanCreate := True;
  if Assigned(FOnCreateCellEdit) then
    FOnCreateCellEdit(SelectedKnot, Edit, Column, CanCreate)
  else
    Edit := nil;
end;

procedure TDCCustomTreeGrid.CMInvalidValue(var Message: TMessage);
begin
  if FIsESCKey then
    Message.Result := Integer(True)
  else
    Message.Result := Integer(False);
end;

function TDCCustomTreeGrid.Modified: boolean;
begin
  Result := FIsModified or FRowUpdated;
end;

procedure TDCCustomTreeGrid.SetModified(Value: boolean);
begin
  if FIsModified <> Value then
  begin
    FIsModified := Value;
    if FKnots.State <> ksInsert then
      FKnots.SetState(ksEdit);
  end;
end;

procedure TDCCustomTreeGrid.UpdateEditData;
begin
  if (FInplaceCol >= FIndicatorOffset) then
    DoUpdate(SelectedKnot, FInplaceEdit, FColumns[FInplaceCol-FIndicatorOffset])
  else
    DoUpdate(SelectedKnot, FInplaceEdit, nil);
end;

procedure TDCCustomTreeGrid.WMChar(var Msg: TWMChar);
begin
  if not DataVisible then Exit;
  if (tgEditing in Options) and (Char(Msg.CharCode) in [^H, #32..#255]) then
    if not FEditorMode and (Char(Msg.CharCode) in ['+', '-', '*']) then
      inherited
    else begin
      if not ShowEditorChar(Char(Msg.CharCode)) then inherited
    end
  else
    inherited;
end;

function TDCCustomTreeGrid.ShowEditorChar(Ch: Char): boolean;
begin
  Result := True;
  if not FEditorMode then
  begin
    ShowEditor;
    if FInplaceEdit <> nil then
      PostMessage(FInplaceEdit.Handle, WM_CHAR, Word(Ch), 0)
    else
      Result := False;
  end;
end;

procedure TDCCustomTreeGrid.CalcSizingState(X, Y: Integer;
  var State: TGridState; var Index, SizingPos, SizingOfs: Integer;
  var FixedInfo: TGridDrawInfo);
var
  EffectiveOptions: TGridOptions;
  ACol, AWidth: integer;

  procedure CalcAxisState(const AxisInfo: TGridAxisDrawInfo; Pos: Integer;
    NewState: TGridState);
  var
    I, Line, Back, Range, J: Integer;
  begin
    if UseRightToLeftAlignment then
      Pos := ClientWidth - Pos;
    with AxisInfo do
    begin
      Range := EffectiveLineWidth;
      Back := 0;
      if Range < 7 then
      begin
        Range := 7;
        Back := (Range - EffectiveLineWidth) shr 1;
      end;

      if tgTreePath in Options then
      begin
        Line := FixedBoundary;
        if not(Line > GridBoundary) and
          (Pos >= Line - Back) and (Pos <= Line - Back + Range) then
        begin
          State := NewState;
          SizingPos := Line;
          SizingOfs := Line - Pos;
          Index := -1;
          Exit;
        end;
      end;

      Line := FixedBoundary;
      J := FirstGridCell;
      for I := J to GridCellCount - 1 do
      begin
        Inc(Line, GetExtent(I));
        if Line > GridBoundary then Break;
        if (Pos >= Line - Back) and (Pos <= Line - Back + Range) then
        begin
          State := NewState;
          SizingPos := Line;
          SizingOfs := Line - Pos;
          Index := I;
          Exit;
        end;
        Inc(Line, EffectiveLineWidth);
      end;
      if (GridBoundary = GridExtent) and (Pos >= GridExtent - Back)
        and (Pos <= GridExtent) then
      begin
        State := NewState;
        SizingPos := GridExtent;
        SizingOfs := GridExtent - Pos;
        Index := I;
//        Index := LastFullVisibleCell + 1;
      end;
    end;
  end;

  function XOutsideHorzFixedBoundary: Boolean;
  begin
    with FixedInfo do
      if not UseRightToLeftAlignment then
        Result := X > (Horz.FixedBoundary-AWidth)
      else
        Result := X < ClientWidth - (Horz.FixedBoundary-AWidth);
  end;

  function XOutsideOrEqualHorzFixedBoundary: Boolean;
  begin
    with FixedInfo do
      if not UseRightToLeftAlignment then
        Result := X >= (Horz.FixedBoundary-AWidth)
      else
        Result := X <= ClientWidth - (Horz.FixedBoundary-AWidth);
  end;


begin
  if not(tgTitles in Options) then Y := -1;

  ACol := 0; AWidth := 0;

  FTreePathSizing := False;
  if tgTreePath in Options then
  begin
    AWidth := TreePathWidth;
    with FixedInfo do
      if not(tgTreePathResize in Options) then
        FTreePathSizing := False
      else
        if not UseRightToLeftAlignment then
          FTreePathSizing := (X > (Horz.FixedBoundary-AWidth)) and
                             (X < Horz.FixedBoundary)
        else
          FTreePathSizing := (X < ClientWidth - (Horz.FixedBoundary-AWidth)) and
                             (X < ClientWidth - Horz.FixedBoundary);
  end;

  State := gsNormal;
  Index := -1;
  EffectiveOptions := inherited Options;
  if csDesigning in ComponentState then
    EffectiveOptions := EffectiveOptions + DesignOptionsBoost;
  if [goColSizing, goRowSizing] * EffectiveOptions <> [] then
    with FixedInfo do
    begin
      Vert.GridExtent := ClientHeight;
      Horz.GridExtent := ClientWidth;
      if (XOutsideHorzFixedBoundary) and (goColSizing in EffectiveOptions) then
      begin
        if Y >= Vert.FixedBoundary then Exit;
        CalcAxisState(Horz, X, gsColSizing);
      end
      else if (Y > Vert.FixedBoundary) and (goRowSizing in EffectiveOptions) then
      begin
        if XOutsideOrEqualHorzFixedBoundary then Exit;
        CalcAxisState(Vert, Y, gsRowSizing);
      end;
    end;

  if (State = gsColSizing) then
  begin
    ACol := RawToDataColumn(Index);
    if (ACol >= 0) and (ACol < Columns.Count) and not(kcSizing in Columns[ACol].Options)
       or
       ((ACol < 0) and not FTreePathSizing) then
     State := gsNormal;
  end;

  if (tgTreePath in Options) and (State = gsColSizing) and FTreePathSizing
  then
    if SizingPos < FixedInfo.Horz.FixedBoundary then
      FTreePathSizing := GetFixedCellType(ACol, FIndicatorOffset-1) = fcTreePath
    else
      FTreePathSizing := ((ACol+FIndicatorOffset)= -1);
  FSizingOff := SizingOfs;
end;

procedure TDCCustomTreeGrid.SetImages(const Value: TImageList);
begin
  if Images <> nil then
    Images.UnRegisterChanges(FImageChangeLink);
  FImages := Value;
  if Images <> nil then
  begin
    Images.RegisterChanges(FImageChangeLink);
    Images.FreeNotification(Self);
  end;
  LayoutChanged;
end;

function TDCCustomTreeGrid.GetHintTreeOffset(KnotItem: TKnotItem;
  Hint: TTreeGridHitTest): integer;
begin
  with KnotItem do
    case Hint of
      htNowere  :
        Result := 1;
      htOnButton:
        begin
          Result := GetHintTreeOffset(KnotItem, htNowere);
          Result := Result + Level*FTreeImages.Width+1;
        end;
      htOnIcon  :
        begin
          Result := GetHintTreeOffset(KnotItem, htOnButton);
          Result := Result + FTreeImages.Width + 1;
        end;
      htOnLabel :
        begin
          Result := GetHintTreeOffset(KnotItem, htOnIcon);
          if (Images<>nil) and
             ((KnotID =  SelectedKnot.KnotID)and(SelectImage>-1) or
              (KnotID <> SelectedKnot.KnotID)and(NormalImage>-1))
          then
            Result := Result+Images.Width+2;
        end;
      else
        Result := 0;
    end;
end;

procedure TDCCustomTreeGrid.HideHintWindow;
 var
  pHintWindow: PHintWindowParam_tag;
begin
  GetMem(pHintWindow, SizeOf(THintWindowParam));
  with pHintWindow^ do
  begin
    HMode := 0;
    PHint := nil;
  end;
  PostMessage(Handle, CM_POPUPWINDOW, Integer(pHintWindow), 0);
end;

procedure TDCCustomTreeGrid.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  DoColumnComment(MODE_HIDEWINDOW, nil);
  HideHintWindow;
end;

procedure TDCCustomTreeGrid.ShowHintWindow(X, Y, ALeft, ATop, AOff: integer;
  Text: string);
 var
  pHintWindow: PHintWindowParam_tag;
begin
  if not ShowHint then
  begin
    GetMem(pHintWindow, SizeOf(THintWindowParam));
    with pHintWindow^ do
    begin
      HMode := 1;
      HLeft := ALeft;
      HTop  := ATop;
      HOff  := AOff;
      HCol  := X;
      HRow  := Y;
      GetMem(PHint, (Length(Text)+1)*SizeOf(Char));
      StrPCopy(PHint, Text);
    end;
    PostMessage(Handle, CM_POPUPWINDOW, Integer(pHintWindow), 1);
  end;
end;

procedure TDCCustomTreeGrid.InvalidateSelected;
 var
  Rect: TRect;
begin
  if not HandleAllocated then Exit;
  Rect := BoxRectEx(0, Row , ColCount-1, Row );
  InvalidateRect(Handle, @Rect, False);
end;

procedure TDCCustomTreeGrid.GetTreePathCaption(KnotItem: TKnotItem;
  var Text: string);
begin
  Text := KnotItem.Name;
  if Assigned(FOnTreeCellText) then
     FOnTreeCellText(Self, KnotItem, Text);
end;

procedure TDCCustomTreeGrid.RowMoved(FromIndex, ToIndex: Integer);
begin
  inherited;
  if Assigned(FOnRowMoved) then FOnRowMoved(Self, FromIndex, ToIndex);
end;

procedure TDCCustomTreeGrid.ShowTreePathEditor;
 var
  R: TRect;
  CanCreate: boolean;

  procedure UpdateEditor;
  begin
    FInplaceCol := FIndicatorOffset-1;
    FInplaceRow := Row;
    FInplaceEdit.SelectAll;
  end;

begin
  if not(tgEditing in Options) or (Columns.Count=0) or
     (FKnots.Count=0) then Exit;

  if FEditorMode then HideEditor;

  DoCreateCellEdit(nil, FInplaceEdit, CanCreate);

  if Assigned(FInplaceEdit) then
  begin
    FEditorMode  := True;
    FIsModified  := False;
    with TDCHackChoiceEdit(FInplaceEdit) do
    begin
      Visible   := False;
      Parent    := Self;
      DrawStyle := fsNone;
    end;

    UpdateEditor;

    R := CellRect(FIndicatorOffset-1, Row);
    InplaceUpdateLoc(FInplaceEdit, R, Canvas);
  end;
end;

procedure TDCCustomTreeGrid.ClipButtonClick(Sender: TObject);
begin
  HideClipPopup;
  if Assigned(FOnClipButtonClick) then FOnClipButtonClick(Sender);
end;

procedure TDCCustomTreeGrid.WMNCLButtonDown(var Message: TWMNCLButtonDown);
begin
  inherited;
  if FClipPopupVisible then HideClipPopup;
end;

procedure TDCCustomTreeGrid.WMHScroll(var Message: TWMHScroll);
begin
  if not(FEditorMode or FKnots.Updating) then inherited;
end;

procedure TDCCustomTreeGrid.WMVScroll(var Message: TWMVScroll);
begin
  if not(FEditorMode or FKnots.Updating) then inherited;
end;

procedure TDCCustomTreeGrid.SetPopupTitle(const Value: TPopupMenu);
begin
  FPopupTitle := Value;
end;

function TDCCustomTreeGrid.GetPopupMenu: TPopupMenu;
 var
  P: TPoint;
  Cell: TGridCoord;
begin
  GetCursorPos(P);
  P := ScreenToClient(P);
  Cell := MouseCoord(P.X, P.Y);
  with Cell do
    if (Y < FTitleOffset) and (X > 0) and (X >= FIndicatorOffset) and
       Assigned(FPopupTitle)
    then
      Result := FPopupTitle
    else
      Result := inherited GetPopupMenu;
end;

procedure TDCCustomTreeGrid.DoDelete(KnotItem: TKnotItem; var Apply: boolean;
  ComponentState: TComponentState);
begin
  if KnotItem.Owner.State <> ksInsert then
  begin
    if Assigned(FOnDelete) then FOnDelete(KnotItem, Apply, ComponentState);
  end
  else
    Apply := True;  
end;

procedure TDCCustomTreeGrid.DoInsert(KnotItem: TKnotItem; var Apply: boolean);
begin
  if Assigned(FOnInsert) then FOnInsert(KnotItem, Apply);
end;

procedure TDCCustomTreeGrid.DoUpdate(KnotItem: TKnotItem; var Edit: TDCCustomChoiceEdit;
  Column: TKnotColumn);
begin
  if Assigned(FOnUpdate) then FOnUpdate(KnotItem, Edit, Column);
end;

function TDCCustomTreeGrid.DeletePrompt: boolean;
 var
  Msg: string;
  nCount: integer;
begin
  nCount := FBookmarks.Count;
  if (nCount > 1) then
    Msg := Format(LoadStr(RES_GRID_STR_MSEL),[nCount, RecordCount2Str(nCount)])
  else
    Msg := LoadStr(RES_GRID_STR_SSEL);
  Result := (MessageDlg(Msg, mtConfirmation, mbOKCancel, 0) <> idCancel);
end;

procedure TDCCustomTreeGrid.DeleteRecords(AtOnce: boolean);
begin
  if (tgEditing in FOptions) and (AtOnce or DeletePrompt) and
     Assigned(FSelectedKnot)
  then
    if FBookmarks.Count > 0 then
      FBookmarks.Delete
    else
      FKnots.Delete(FSelectedKnot);
end;

procedure TDCCustomTreeGrid.DoSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
  if Assigned(FOnSelectCell) then FOnSelectCell(Sender, ACol, ARow+1, CanSelect);
end;

procedure TDCCustomTreeGrid.DoDrawColumnCell(Canvas: TCanvas; ARect: TRect;
  ACol: integer; AColumn: TKnotColumn; AKnot: TKnotItem; AState: TGridDrawState);
begin
  if Assigned(FOnDrawColumnCell) then
    FOnDrawColumnCell(Self, ARect, Canvas, ACol, AColumn, AKnot, AState);
end;

procedure TDCCustomTreeGrid.DoDestroyCellEdit;
begin
  if Assigned(FOnDestroyCellEdit) then FOnDestroyCellEdit(Self);
end;

procedure TDCCustomTreeGrid.DoColumnComment(Mode: integer;
  Column: TKnotColumn);
begin
  if Assigned(FOnColumnComment) then FOnColumnComment(Self, Mode, Column);
end;

procedure TDCCustomTreeGrid.CMPopupWindow(var Message: TMessage);
 var
  pHintWindow: PHintWindowParam_tag;
begin
  pHintWindow := PHintWindowParam_tag(Message.WParam);
  with pHintWindow^ do
  begin
    case HMode of
      0:
       if (FHintRow <> - 1) and (FHintWindow <> nil) then
       begin
         FHintRow := -1;
         FHintWindow.Free;
         FHintWindow := nil;
       end;
      1:
       begin
         FHintWindow := TDCMessageWindow.Create(Self);
         with FHintWindow do
         begin
           Parent := Self;
           Font   := Self.Font;
           DialogStyle := dsSimple;
           Caption := Format('/ow{-2}/oh{-2}%s', [PHint]);
           PopupAlignment := wpOffset;
           Left   := HLeft + HOff;
           Top    := HTop;
           Height := RowHeights[HRow]+2;
           Width  := Width;
           Show;
           FHintRow := HRow;
         end;
       end;
    end;
  end;
  if Assigned(pHintWindow^.PHint) then FreeMem(pHintWindow^.PHint);
  FreeMem(pHintWindow);
end;

function TDCCustomTreeGrid.DoMouseWheelDown(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 var
  MouseWheelDownEvent: TMouseWheelUpDownEvent;
begin
  Result := False;
  MouseWheelDownEvent := OnMouseWheelDown;
  if Assigned(MouseWheelDownEvent) then
    MouseWheelDownEvent(Self, Shift, MousePos, Result);

  if not Result and PtInRect(ClientRect, ScreenToClient(MousePos)) and not FKnots.Updating then
  begin
    NextRow(True, False, Shift);
    Result := True;
  end;
end;

function TDCCustomTreeGrid.DoMouseWheelUp(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 var
  MouseWheelUpEvent: TMouseWheelUpDownEvent;
begin
  Result := False;
  MouseWheelUpEvent := OnMouseWheelDown;
  if Assigned(MouseWheelUpEvent) then
    MouseWheelUpEvent(Self, Shift, MousePos, Result);

  if not Result and PtInRect(ClientRect, ScreenToClient(MousePos)) and not FKnots.Updating then
  begin
    PrevRow(True);
    Result := True;
  end;
end;

procedure TDCCustomTreeGrid.InsertKnot(ParentKnot: TKnotItem;
  lChild: boolean; Shift: TShiftState);
 var
  NewKnot, NextKnot: TKnotItem;
  Delta: integer;
  CanSelect: boolean;
begin
  if not(tgEditing in Options) then Exit;
  with FKnots do
  begin
    if State = ksInsert then begin
      CanSelect := True;
      DoSelectCell(Self, Col, Row+1, CanSelect);
      if CanSelect then
        SetState(ksBrowse)
      else
        Exit;
    end;
    BeginUpdate;
    if ParentKnot = nil then
    begin
      NewKnot := FKnots.Add(NE_EMPTY_KNOT);
      if NewKnot <> nil then SetSelectedKnot(NewKnot);
    end
    else begin
      if lChild then
      begin
        NewKnot := FKnots.AddChild(ParentKnot, NE_EMPTY_KNOT);
        ParentKnot.Expand(False);
      end
      else
        if ssShift in Shift then
        begin
          NewKnot := FKnots.AddChild(ParentKnot.Parent, NE_EMPTY_KNOT,
            ParentKnot.FIndex);
          if NewKnot <> nil then SetSelectedKnot(NewKnot);
        end
        else
          NewKnot := FKnots.AddChild(ParentKnot.Parent, NE_EMPTY_KNOT,
            ParentKnot.FIndex+1)
    end;
    EndUpdate;
    if NewKnot = nil then Exit;
    Delta := 0;
    NextKnot := FSelectedKnot;
    while (NewKnot.KnotID<>NextKnot.KnotID) and (NextKnot<>nil) do
    begin
      Inc(Delta);
      NextKnot := NextKnot.GetNextVisible;
    end;
    if not Eof  then Row := Row + Delta;
    FKnots.SetState(ksInsert);
  end;
end;

procedure TDCCustomTreeGrid.MarkKnot;
begin
  if (tgMarker in Options) and (FKnots.Count>0) then
  begin
    try
      BeginUpdate;
      with FSelectedKnot, FBookmarks do
        Select(KnotID, not KnotSelected(KnotID));
    finally
      EndUpdate;
    end;
  end;
end;

procedure TDCCustomTreeGrid.NextRow(Select, Insert: boolean; Shift: TShiftState;
   AOffset: integer = 1);
begin
  with FKnots do
  begin
    if (State = ksInsert) then
    begin
      if not Modified then
      begin
        if not Eof then
        begin
          if FEditorMode then HideEditor;
          if FInplaceEdit = nil then
          begin
            Delete(FSelectedKnot);
            SetState(ksBrowse);
          end;
        end;
        Exit;
      end
    end;
    if FEditorMode then HideEditor;
    if not Assigned(FInplaceEdit) then
    begin
      if Eof then
      begin
        if Focused and Insert then InsertKnot(FSelectedKnot, False, Shift);
      end
      else
        if (Row + AOffset) < RowCount then
          Row := Row + AOffset
        else
          Row := RowCount - 1;
    end;
  end;
end;

procedure TDCCustomTreeGrid.PrevRow(Select: Boolean; AOffset: integer = 1);
 var
  AEof: boolean;
begin
  AEof := False;
  with FKnots do
  begin
    if FEditorMode then HideEditor;
    if (State = ksInsert) then
    begin
      AEof := Eof and not Modified;
      if (FInplaceEdit = nil) and not Modified then
      begin
        Delete(FSelectedKnot);
        SetState(ksBrowse);
      end;
    end;
    if (FInplaceEdit = nil) and (Row > FTitleOffset) and not(AEof) then
      Row := Row - AOffset;
  end;
end;

procedure TDCCustomTreeGrid.ClearSelection;
begin
  if (tgMultiSelect in Options) then
  begin
    FBookmarks.Clear;
  end;
end;

function TDCCustomTreeGrid.Eof: boolean;
begin
  Result := Row = (RowCount-1);
end;

function TDCCustomTreeGrid.BoxRectEx(ALeft, ATop, ARight,
  ABottom: Integer): TRect;
begin
  Result := BoxRect(ALeft, ATop, ARight, ABottom);
  if tgCompleteLines in Options then Result.Right := Width;
end;

procedure TDCCustomTreeGrid.Paint;
 var
  DrawInfo: TGridDrawInfo;
  CurRow, Flags: integer;
  ARect, BRect: TRect;
  BorderStyle: TEdgeBorderStyle;
  LineColor: TColor;
  UpdateRect: TRect;
  UpdateRgn: HRGN;
  UpdateMessage: string;
  MessageType: TTreeGridMessageType;
begin
  if tgCompleteLines in Options  then
  begin
    CalcDrawInfo(DrawInfo);

    UpdateRect := Canvas.ClipRect;
    with UpdateRect do
    begin
      Left  := DrawInfo.Horz.GridBoundary;
      Right := DrawInfo.Horz.GridExtent;
      ExcludeClipRect(Canvas.Handle, Left, Top, Right, Bottom);
    end;
    inherited;
    with UpdateRect do
    begin
      UpdateRgn := CreateRectRgn(Left, Top, Right, Bottom);
      SelectClipRgn(Canvas.Handle, UpdateRgn);
    end;
    with DrawInfo do
    begin
      if Horz.GridBoundary < Horz.GridExtent then
      begin
        CurRow := 0;

        if ColorToRGB(Color) = clSilver then
          LineColor := clGray
        else
          LineColor := clSilver;

        if not((tgColLines in Options) and (tgRowLines in Options)) then
        begin
          if tgFlatButtons in Options then
            BorderStyle := ebsShadowFlat
          else
            BorderStyle := ebsNone
        end
        else begin
          if tgFlatButtons in Options then
            BorderStyle := ebsFlat
          else
            BorderStyle := ebsNormal;
        end;

        ARect := Rect(Horz.GridBoundary, 0, Horz.GridExtent, 0);
        if FTitleOffset > 0 then
        begin
          Canvas.Brush.Color := FixedColor;
          while CurRow < FTitleOffset do
          begin
            ARect.Bottom := ARect.Bottom + RowHeights[CurRow];
            if RectVisible(Canvas.Handle, ARect) then
            begin
              Canvas.FillRect(ARect);
              if BorderStyle <> ebsNone then
              begin
                if BorderStyle = ebsShadowFlat then
                begin
                  InflateRect(ARect, 1, 1);
                  ARect.Right := ARect.Right + 1;
                  DrawGridFrameBorder(Canvas, ARect, BorderStyle, dsUp, FixedColor);
                  ARect.Right := ARect.Right - 1;
                  InflateRect(ARect, -1, -1);
                end
                else
                  DrawGridFrameBorder(Canvas, ARect, BorderStyle, dsUp, FixedColor);
              end;

              if tgRowLines in FOptions then
              begin
                if tgFlatButtons in FOptions then
                  Canvas.Pen.Color := FixedColor
                else
                  Canvas.Pen.Color := clBlack;

                Canvas.MoveTo(ARect.Left, ARect.Bottom);
                Canvas.LineTo(ARect.Right, ARect.Bottom);
              end;
            end;
            Inc(CurRow);
            ARect.Top := ARect.Bottom;
          end;

        end
        else begin
          ARect.Top    := ARect.Top - 1;
          ARect.Bottom := ARect.Bottom - 1;
        end;

        if tgRowLines in FOptions then
        begin
          while (CurRow < Vert.GridCellCount) and
                (ARect.Top < UpdateRect.Bottom) do
          begin
            ARect.Bottom := ARect.Bottom + RowHeights[CurRow]+1;
            ARect.Top    := ARect.Top    + 1;

            if RectVisible(Canvas.Handle, ARect) and
               ((tgRowSelect in Options) or (tgHighlightRow in Options)) and
               ((tgAlwaysShowSelection in Options) or Focused)
            then begin
              if Row = (CurRow + Vert.FirstGridCell - FTitleOffset) then
              begin
                if FColumns.Count = 0 then
                   Canvas.Brush.Color := Self.Color
                else begin
                  if Focused or not ShadowFill then
                    Canvas.Brush.Color := clHighlight
                  else
                    if (tgAlwaysShowSelection in Options) then
                      Canvas.Brush.Color := clShadowed;
                 end;
              end
              else
                Canvas.Brush.Color := Self.Color;
              Canvas.FillRect(ARect);
            end else begin
              Canvas.Brush.Color := Self.Color;
              Canvas.FillRect(ARect);
            end;

            ARect.Top    := ARect.Top - 1;
            ARect.Bottom := ARect.Bottom;

            if (tgRowLines in FOptions) and RectVisible(Canvas.Handle, ARect) then
            begin
              Canvas.Pen.Color := LineColor;
              Canvas.MoveTo(ARect.Left, ARect.Bottom);
              Canvas.LineTo(ARect.Right, ARect.Bottom);
            end;

            Inc(CurRow);
            ARect.Top := ARect.Bottom;
          end;
        end;
        if ARect.Top < UpdateRect.Bottom then
        begin
          BRect := ClientRect;
          if Vert.GridBoundary < Vert.GridExtent   then
          begin
            ARect.Top    := Vert.GridBoundary;
            ARect.Bottom := Vert.GridExtent;
            Canvas.Brush.Color := Self.Color;
            Canvas.FillRect(ARect);
          end;
        end;
      end;
    end;

    DeleteObject(UpdateRgn);
  end
  else
    inherited;
end;

procedure TDCCustomTreeGrid.WMEraseBkgnd(var Message: TWmEraseBkgnd);
begin
  Message.Result := 1;
end;

procedure TDCCustomTreeGrid.ImageListChange(Sender: TObject);
begin
  LayoutChanged;
end;

procedure TDCCustomTreeGrid.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) then
  begin
    if (AComponent = FImages) then
    begin
      FImages := nil;
      LayoutChanged;
      Exit;
    end;
  end;
end;

procedure TDCCustomTreeGrid.CMFontChanged(var Message: TMessage);
begin
  inherited;
  LayoutChanged;
end;

procedure TDCCustomTreeGrid.SetSelectedKnot(KnotItem: TKnotItem);
begin
  FSelectedKnot := KnotItem;
  if Assigned(FOnSelectKnot) then FOnSelectKnot(Self, FSelectedKnot);
end;

procedure TDCCustomTreeGrid.SetSelected(const Value: TKnotItem);
 var
  KnotItem: TKnotItem;
  i: integer;
begin
  KnotItem := FKnots.First;
  while Assigned(KnotItem) and not KnotItem.Visible do
    KnotItem := KnotItem.GetNextSibling;
  i := FTitleOffset;
  while (KnotItem <> nil) and (KnotItem <> Value) do
  begin
    KnotItem := FKnots.SelectKnot(KnotItem, 1);
    inc(i);
  end;

  if (KnotItem <> nil) and (RowCount >= i) then Row := i;
end;

function TDCCustomTreeGrid.GetPosition: TBookMark;
begin
  Result := FCurrentPos[2];
end;

procedure TDCCustomTreeGrid.RestPosition;
begin
  if FCurrentPos[2] = nil
  then begin
    if Assigned(FCurrentPos[1])  then
       GotoBookmark(FCurrentPos[1])
    else
       SelectedKnot := FKnots.First;
  end
  else GotoBookmark(FCurrentPos[2])
end;

procedure TDCCustomTreeGrid.SavePosition;
 var
  KnotItem: TKnotItem;
begin
  if FKnots.Count > 0 then
  begin
    with FKnots do
    begin

      if Assigned(FCurrentPos[1]) then FreeMem(FCurrentPos[1]);
      if Assigned(FCurrentPos[2]) then FreeMem(FCurrentPos[2]);

      KnotItem := SelectedKnot;

      if KnotItem <> nil then
        FCurrentPos[2] := GetBookmark(KnotItem)
      else
        FCurrentPos[2] := nil;

      KnotItem := KnotItem.GetPrevVisible;
      if (KnotItem <> nil) and (KnotItem.FLevel <> -1) then
        FCurrentPos[1] := GetBookmark(KnotItem)
      else
        FCurrentPos[1] := nil;
    end;
  end;
end;

procedure TDCCustomTreeGrid.SetPosition(const Value: TBookMark);
begin
  FCurrentPos[2] := Value;
end;

function TDCCustomTreeGrid.GetBookmark(KnotItem: TKnotItem): TBookmark;
begin
  GetMem(Result, FBookMarkSize);
  GetBookmarkData(KnotItem, Result)
end;

procedure TDCCustomTreeGrid.GetBookmarkData(KnotItem: TKnotItem;
  Data: Pointer);
begin
  StrPLCopy(PChar(Data), KnotItem.Name, FBookMarkSize-1);
end;

procedure TDCCustomTreeGrid.GotoBookMark(Bookmark: TBookmark);
 var
  i: integer;
  KnotItem: TKnotItem;
  Bookmark1: Pointer;
  FindEqual: boolean;
begin
  KnotItem  := FKnots.First;
  FindEqual := False;
  while Assigned(KnotItem) and not KnotItem.Visible do
    KnotItem := KnotItem.GetNextSibling;
  i := FTitleOffset;
  while (KnotItem <> nil) and not FindEqual  do
  begin
    Bookmark1 := GetBookmark(KnotItem);
    try
      FindEqual := BookmarksEqual(Bookmark1,Bookmark);
    finally
      FreeMem(Bookmark1);
    end;
    if not FindEqual then
    begin
      KnotItem := FKnots.SelectKnot(KnotItem, 1);
      inc(i);
    end;
  end;

  if (KnotItem <> nil) and (RowCount >= i) then Row := i else Row := FTitleOffset;
end;

function TDCCustomTreeGrid.BookmarksEqual(Bookmark1,
  Bookmark2: TBookmark): boolean;
begin
  Result := StrComp(PChar(Bookmark1), PChar(Bookmark2)) = 0;
end;

function TDCCustomTreeGrid.DataVisible: boolean;
begin
  Result := (csDesigning in ComponentState) or (FColumns.Count <> 0);
end;

procedure TDCCustomTreeGrid.WMSetCursor(var Msg: TWMSetCursor);
begin
  if not DataVisible then
    Windows.SetCursor(LoadCursor(0, IDC_ARROW))
  else
    inherited;
end;

procedure TDCCustomTreeGrid.WMPaint(var Message: TWMPaint);
 var
  DC, MemDC: HDC;
  MemBitmap, OldBitmap: HBITMAP;
  PS: TPaintStruct;
  UpdateMessage: string;
  R: TRect;
  MessageType: TTreeGridMessageType;
  Flags: integer;
begin
  if FLockScreen or not DataVisible then
  begin
    BeginPaint(Handle, PS);
    Canvas.Handle := GetWindowDC(Handle);
    GetWindowRect(Handle, R);  OffsetRect(R, -R.Left, -R.Top);

    Canvas.Brush.Color := Self.Color;
    Canvas.Font := Self.Font;

    if FLockScreen then
    begin
      UpdateMessage := LoadStr(RES_STRN_MSG_ONLOAD);
      MessageType   := mtLoadData;
      Flags         := DT_END_ELLIPSIS;
    end
    else begin
      if not DataVisible then
      begin
        UpdateMessage := LoadStr(RES_STRN_MSG_DBGCEM);
        MessageType   := mtEmptyColumns;
        Flags         := DT_END_ELLIPSIS;
      end;
    end;

    if BorderStyle = bsSingle then InflateRect(R, -2, -2);

    if Assigned(FOnPaintMessage) then
      FOnPaintMessage(Self, Canvas, R, MessageType, UpdateMessage)
    else begin
      Canvas.FillRect(R);
      InflateRect(R, -5, -5);
      DrawHighLightText(Canvas, Pchar(UpdateMessage), R, 1, Flags);
    end;

    EndPaint(Handle, PS);
  end
  else
   inherited;
end;

{ TKnotBookmarkList }

procedure TKnotBookmarkList.Clear;
begin
  if FList.Count = 0 then Exit;
  FList.Clear;
  FGrid.Invalidate;
end;

function TKnotBookmarkList.Compare(const KnotID1,
  KnotID2: integer): Integer;
begin
  if KnotID1 = KnotID2 then Result := 0
  else
   if KnotID1 > KnotID2 then Result := 1
   else
     Result := -1;
end;

constructor TKnotBookmarkList.Create(AGrid: TDCCustomTreeGrid);
begin
  inherited Create;
  FList := TList.Create;
  FGrid := AGrid;
  FSortItems := True;
  ListChanged;
end;

procedure TKnotBookmarkList.Delete;
var
  I: Integer;
  KnotItem: TKnotItem;
begin
  with FGrid.FKnots do
  begin
    BeginUpdate;
    try
      for I := FList.Count-1 downto 0 do
      begin
        if GetKnot(Integer(FList.Items[I]^), KnotItem) then
          if Delete(KnotItem) then FList.Delete(I);
      end;
    finally
      EndUpdate;
    end;
  end;
end;

destructor TKnotBookmarkList.Destroy;
begin
  Clear;
  FList.Free;
  inherited Destroy;
end;

function TKnotBookmarkList.Find(const KnotID: integer;
  var Index: Integer): Boolean;
var
  L, H, I, C: Integer;
begin
  if (KnotID = FCache) and (FCacheIndex >= 0) then
  begin
    Index  := FCacheIndex;
    Result := FCacheFind;
    Exit;
  end;
  Result := False;
  L := 0;
  H := FList.Count - 1;
  while L <= H do
  begin
    I := (L + H) shr 1;
    C := Compare(Integer(FList[I]^), KnotID);
    if C < 0 then L := I + 1 else
    begin
      H := I - 1;
      if C = 0 then
      begin
        Result := True;
        L := I;
      end;
    end;
  end;
  Index       := L;
  FCache      := KnotID;
  FCacheIndex := Index;
  FCacheFind  := Result;
end;

function TKnotBookmarkList.GetCount: integer;
begin
  Result := FList.Count;
end;

function TKnotBookmarkList.GetItem(Index: Integer): integer;
begin
  Result := Integer(FList[Index]^);
end;

function TKnotBookmarkList.IndexOf(const KnotID: integer): Integer;
begin
  if not Find(KnotID, Result) then Result := -1;
end;

function TKnotBookmarkList.KnotSelected(const KnotID: integer): Boolean;
 var
  Index: integer;
begin
  Result := Find(KnotID, Index);
end;

procedure TKnotBookmarkList.ListChanged;
begin
  FCache      := -1;
  FCacheIndex := -1;
end;


function CompareKnotID(Item1, Item2: Pointer): Integer;
begin
  if Integer(Item1^) = Integer(Item2^) then Result := 0
  else
   if Integer(Item1^) > Integer(Item2^) then Result := 1
   else
     Result := -1;
end;

procedure TKnotBookmarkList.Select(const KnotID: integer; Value: boolean);
 var
  Index: integer;
  pKnotID: ^Integer;
begin
  if (Find(KnotID, Index) = Value) or (FGrid.FKnots.State = ksInsert) then Exit;
  if Value then
  begin
    New(pKnotID); pKnotID^ := KnotID;
    FList.Add(pKnotID);
    if FSortItems then FList.Sort(CompareKnotID);
  end
  else
    FList.Delete(Index);
  ListChanged;
  FGrid.InvalidateRow(FGrid.Row);
end;

{ TDCInplaceEdit }

procedure TDCInplaceChoiceEdit.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

function TDCInplaceChoiceEdit.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

procedure TDCInplaceChoiceEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  HideErrorMessage;
  if not DropDownVisible then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceChoiceEdit.KeyPress(var Key: Char);
begin
  if not DropDownVisible then Grid.KeyPress(Key);
  if Key <> #0 then
  begin
    if not(Key in [#27, #8, #0]) then
      if not ReadOnly then Grid.SetModified(True);
    inherited KeyPress(Key);
  end;
end;

procedure TDCInplaceChoiceEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DropDownVisible then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceChoiceEdit.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceChoiceEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

procedure TKnotBookmarkList.Sort;
begin
  FList.Sort(CompareKnotID);
end;

{ TDCInplaceDateEdit }

procedure TDCInplaceDateEdit.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

function TDCInplaceDateEdit.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

procedure TDCInplaceDateEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  HideErrorMessage;
  if not DropDownVisible then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceDateEdit.KeyPress(var Key: Char);
begin
  if not DropDownVisible or (PerformCloseUp and (Key = Char(VK_RETURN))) then Grid.KeyPress(Key);
  if Key <> #0 then
  begin
    if not(Key in [#27, #8, #0]) then
      if not ReadOnly then Grid.SetModified(True);
    inherited KeyPress(Key);
  end;
end;

procedure TDCInplaceDateEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DropDownVisible then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceDateEdit.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceDateEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

{ TDCInplaceGridEdit }

procedure TDCInplaceGridEdit.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

function TDCInplaceGridEdit.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

procedure TDCInplaceGridEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  HideErrorMessage;
  if not DropDownVisible then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceGridEdit.KeyPress(var Key: Char);
begin
  if not DropDownVisible or (PerformCloseUp and (Key = Char(VK_RETURN))) then Grid.KeyPress(Key);
  if Key <> #0 then
  begin
    if not(Key in [#27, #8, #0]) then
      if not ReadOnly then Grid.SetModified(True);
    inherited KeyPress(Key);
  end;
end;

procedure TDCInplaceGridEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DropDownVisible then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceGridEdit.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceGridEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

{ TDCInplaceTreeEdit }

procedure TDCInplaceTreeEdit.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

function TDCInplaceTreeEdit.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

procedure TDCInplaceTreeEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  HideErrorMessage;
  if not DropDownVisible then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceTreeEdit.KeyPress(var Key: Char);
begin
  if not DropDownVisible or (PerformCloseUp and (Key = Char(VK_RETURN))) then Grid.KeyPress(Key);
  if Key <> #0 then
  begin
    if not(Key in [#27, #8, #0]) then
      if not ReadOnly then Grid.SetModified(True);
    inherited KeyPress(Key);
  end;
end;

procedure TDCInplaceTreeEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DropDownVisible then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceTreeEdit.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceTreeEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

{ TDCInplaceComboBox }

procedure TDCInplaceComboBox.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

function TDCInplaceComboBox.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

procedure TDCInplaceComboBox.KeyDown(var Key: Word; Shift: TShiftState);
begin
  HideErrorMessage;
  if not DropDownVisible then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceComboBox.KeyPress(var Key: Char);
begin
  if not DropDownVisible or (PerformCloseUp and (Key = Char(VK_RETURN))) then Grid.KeyPress(Key);
  if Key <> #0 then
  begin
    if not(Key in [#27, #8, #0]) then
      if not ReadOnly then Grid.SetModified(True);
    inherited KeyPress(Key);
  end;
end;

procedure TDCInplaceComboBox.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DropDownVisible then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceComboBox.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceComboBox.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

{ TDCInplaceFloatEdit }

procedure TDCInplaceFloatEdit.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

function TDCInplaceFloatEdit.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

procedure TDCInplaceFloatEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  HideErrorMessage;
  if not DropDownVisible then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceFloatEdit.KeyPress(var Key: Char);
begin
  if not DropDownVisible or (PerformCloseUp and (Key = Char(VK_RETURN))) then Grid.KeyPress(Key);
  if Key <> #0 then
  begin
    if not(Key in [#27, #8, #0]) then
      if not ReadOnly then Grid.SetModified(True);
    inherited KeyPress(Key);
  end;
end;

procedure TDCInplaceFloatEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DropDownVisible then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceFloatEdit.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceFloatEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

{ TDCInplaceADOGridEdit }

{$IFDEF DELPHI_V5}

procedure TDCInplaceADOGridEdit.ChoiceClick(Sender: TObject);
begin
  Grid.SetModified(True);
  inherited;
end;

function TDCInplaceADOGridEdit.DoMouseWheel(Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint): Boolean;
begin
  Result := Grid.DoMouseWheel(Shift, WheelDelta, MousePos);
end;

procedure TDCInplaceADOGridEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  HideErrorMessage;
  if not DropDownVisible then InplaceKeyDown(Self, Grid, Key, Shift);
  if Key <> 0 then
  begin
    if not ReadOnly then Grid.SetModified(True);
    inherited KeyDown(Key, Shift);
  end;
end;

procedure TDCInplaceADOGridEdit.KeyPress(var Key: Char);
begin
  if not DropDownVisible or (PerformCloseUp and (Key = Char(VK_RETURN))) then Grid.KeyPress(Key);
  if Key <> #0 then
  begin
    if not(Key in [#27, #8, #0]) then
      if not ReadOnly then Grid.SetModified(True);
    inherited KeyPress(Key);
  end;
end;

procedure TDCInplaceADOGridEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if not DropDownVisible then Grid.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited KeyUp(Key, Shift);
end;

procedure TDCInplaceADOGridEdit.SetGrid(Value: TDCCustomTreeGrid);
begin
  FGrid := Value;
end;

procedure TDCInplaceADOGridEdit.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if tgTabs in Grid.Options then
    Message.Result := Message.Result or DLGC_WANTTAB;
end;

{$ENDIF}

end.
