{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCGridDataEdit;

interface
uses DsgnIntf, Classes;

type
  TDBGridDataField = class(TStringProperty)
  public
    function  GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings);
    procedure GetValues(Proc: TGetStrProc); override;
  end;

implementation
uses DCDBGrids;

type
 TPrivateDCDBGrid = class(TDCCustomDBGrid)
 end;

{DataField Property Editor}
function TDBGridDataField.GetAttributes: TPropertyAttributes;
 var
  gs: TColumn;
begin
  Result := [paValueList, paSortList, paMultiSelect];
  gs := GetComponent(0) as TColumn;
  try
    if not ((gs <> Nil) and (gs.Grid <> nil) and
      (TPrivateDCDBGrid(gs.Grid).DataSource <> nil) and
      (TPrivateDCDBGrid(gs.Grid).DataSource.DataSet <> nil))
    then
      Result :=  Result - [paValueList];
  except
    Result :=  Result - [paValueList];
  end;
end;

procedure TDBGridDataField.GetValueList(List: TStrings);
 var
  gs: TColumn;
begin
  gs := GetComponent(0) as TColumn;
  if (gs <> Nil) and (gs.Grid <> nil) and
     (TPrivateDCDBGrid(gs.Grid).DataSource <> nil) and
     (TPrivateDCDBGrid(gs.Grid).DataSource.DataSet <> nil)
  then
    TPrivateDCDBGrid(gs.Grid).DataSource.DataSet.GetFieldNames(List);
end;

procedure TDBGridDataField.GetValues(Proc: TGetStrProc);
 var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

end.
