{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCGridColEdit;

interface
{$I DCConst.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ImgList, ComCtrls, ToolWin, DCDBGrids, DsgnIntf, DsgnWnds,
  ActnList, Menus, StdActns;

type
  TGridColEditForm = class(TDesignWindow)
    ToolBar: TToolBar;
    tbNew: TToolButton;
    tbDelete: TToolButton;
    tbSeparator: TToolButton;
    imToolBar: TImageList;
    tbAll: TToolButton;
    tbDefault: TToolButton;
    ColumnsActionList: TActionList;
    aNew: TAction;
    aDelete: TAction;
    aAll: TAction;
    aDefault: TAction;
    PopupMenu: TPopupMenu;
    aToolBar: TAction;
    AddField1: TMenuItem;
    Delete1: TMenuItem;
    aSelectAll: TAction;
    SelectAll1: TMenuItem;
    N1: TMenuItem;
    AddAllFields1: TMenuItem;
    RestoreDefault1: TMenuItem;
    lvColumns: TListView;
    ToolBar1: TMenuItem;
    aDeleteAll: TAction;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure aNewExecute(Sender: TObject);
    procedure aDeleteExecute(Sender: TObject);
    procedure aDeleteAllExecute(Sender: TObject);
    procedure aAllExecute(Sender: TObject);
    procedure aToolBarExecute(Sender: TObject);
    procedure aDefaultExecute(Sender: TObject);
    procedure UpdateColumns;
    procedure lvColumnsChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure aSelectAllExecute(Sender: TObject);
    function CheckCollection: Boolean;
    procedure FormResize(Sender: TObject);
    procedure lvColumnsDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure lvColumnsDragDrop(Sender, Source: TObject; X, Y: Integer);
  protected
    function UniqueName(Component: TComponent): string; override;
    procedure Activated; override;
  private
    { Private declarations }
    FDCDBGrid: TDCDBGrid;
    procedure SetDCDBGrid(const Value: TDCDBGrid);
  public
    destructor Destroy; override;
    property DCDBGrid: TDCDBGrid read FDCDBGrid  write SetDCDBGrid;
    procedure FormModified; override;
    procedure FormClosed(Form: TCustomForm); override;
    procedure ComponentDeleted(Component: IPersistent); override;
  end;

  TGridColProperty = class(TClassProperty)
  public
    procedure Edit; override;
    function GetValue: string; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TGridColEditor = class(TDefaultEditor)
  protected
    procedure EditProperty(PropertyEditor: TPropertyEditor;
      var Continue, FreeEditor: Boolean); override;
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

  TDCGridFieldEdit = class(TStringProperty)
  public
    function  GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings);
    procedure GetValues(Proc: TGetStrProc); override;
  end;

var
  GridColEditForm: TGridColEditForm;

implementation
uses DCChoice;

{$R *.DFM}
{$R DCCOlEdit.RES}

const
 bmNew    = 'DBC_NEW';
 bmDelete = 'DBC_DELETE';
 bmAll    = 'DBC_ALL';
 bmDefault= 'DBC_DEFAULT';

 fmtListViewItem = '%2.2d - TColumn: %s';

// TDBGridColumns Component Property
procedure TGridColProperty.Edit;
var
  ColumnsEditor: TGridColEditForm;
  ADCDBGrid: TDCDBGrid;
  I: integer;
begin
  ColumnsEditor := nil;
  ADCDBGrid :=  TDCDBGrid(GetComponent(0));

  if ADCDBGrid = nil then Exit;

  {  If ColumnsEditor fo ADCDBGrid not found create it
    esle SetFocus }

  {Attempt to Find it}
  for I := 0 to Screen.FormCount - 1 do begin
    if Screen.Forms[I] is TGridColEditForm then
      if TGridColEditForm(Screen.Forms[I]).DCDBGrid = ADCDBGrid then
      begin
        { Great!. Find }
        ColumnsEditor := TGridColEditForm(Screen.Forms[I]);
        Break;
      end;
  end;

  if ColumnsEditor = nil then
  begin
    ColumnsEditor := TGridColEditForm.Create(Application);
    try
      ColumnsEditor.Designer := IFormDesigner(Designer);
      ColumnsEditor.DCDBGrid := ADCDBGrid;
      with ColumnsEditor do
        Caption := 'Editing ' + DCDBGrid.Name + '.' + GetName;
      ColumnsEditor.Show;
    except
      ColumnsEditor.Free;
      raise;
    end;
  end
  else begin
    ColumnsEditor.Show;
    if ColumnsEditor.WindowState = wsMinimized then
      ColumnsEditor.WindowState := wsNormal;
  end;
end;

function TGridColProperty.GetValue: string;
begin
  Result := Format('(%s)', [GetPropType^.Name]);
end;

function TGridColProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] - [paSubProperties];
end;

procedure TGridColEditor.EditProperty(PropertyEditor: TPropertyEditor;
  var Continue, FreeEditor: Boolean);
var
  PropName: string;
begin
  PropName := PropertyEditor.GetName;
  if (CompareText(PropName, 'COLUMNS') = 0) then
  begin
    PropertyEditor.Edit;
    Continue := False;
  end;
end;

function TGridColEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TGridColEditor.GetVerb(Index: Integer): string;
begin
  if Index = 0 then
    Result := 'Co&lumns Editor ...'
  else Result := '';
end;

procedure TGridColEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 0 then Edit;
end;

function TGridColEditForm.CheckCollection: Boolean;
begin
  Result := (DCDBGrid <> nil) and (DCDBGrid.Columns <> nil)
    and (Designer.Form <> nil);
end;

procedure TGridColEditForm.SetDCDBGrid(const Value: TDCDBGrid);
begin
  if FDCDBGrid <> Value then begin
    FDCDBGrid := Value;
    if FDCDBGrid <> nil then UpdateColumns;
  end;
end;

procedure TGridColEditForm.FormCreate(Sender: TObject);
 var
  Bmp: TBitmap;
begin
  {Initialize Images}
  inherited;
  Bmp := TBitmap.Create;
  imToolBar.Clear;

  Bmp.LoadFromResourceName(HInstance, bmNew);    // 0
  imToolBar.AddMasked(Bmp, clBtnFace);
  Bmp.LoadFromResourceName(HInstance, bmDelete); // 1
  imToolBar.AddMasked(Bmp, clBtnFace);
  Bmp.LoadFromResourceName(HInstance, bmAll);    // 2
  imToolBar.AddMasked(Bmp, clBtnFace);
  Bmp.LoadFromResourceName(HInstance, bmDefault);// 3
  imToolBar.AddMasked(Bmp, clBtnFace);

  aNew.ImageIndex     := 0;
  aDelete.ImageIndex  := 1;
  aAll.ImageIndex     := 2;
  aDefault.ImageIndex := 3;

  Bmp.Free;
end;

procedure TGridColEditForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TGridColEditForm.aNewExecute(Sender: TObject);
begin
  {Add New Field}
  DCDBGrid.Columns.Add;
  UpdateColumns;
  Designer.Modified;
  lvColumns.Items[lvColumns.Items.Count-1].Selected := True;
  lvColumnsChange(nil,nil,ctState);
end;

procedure TGridColEditForm.aDeleteAllExecute(Sender: TObject);
 var
  I:Integer;
  {$IFDEF DELPHI_V5}
    FComponents: IDesignerSelections;
  {$ELSE}
    FComponents: TComponentList;
  {$ENDIF}
begin
  {Delete All Fiedls}

  {$IFNDEF DELPHI_V5}
     FComponents := TComponentList.Create;
  {$ELSE}
     FComponents := CreateSelectionList;
  {$ENDIF}
  try
    DCDBGrid.Columns.BeginUpdate;
    lvColumns.Items.BeginUpdate;

    for I := lvColumns.Items.Count - 1 downto 0 do
     if Assigned(lvColumns.Items[i].Data)
     then begin
      {$IFDEF DELPHI_V5}
         FComponents.Add(MakeIPersistent(TColumn(lvColumns.Items[i].Data)));
      {$ELSE}
         FComponents.Add(TColumn(lvColumns.Items[i].Data));
      {$ENDIF}
     end;
    lvColumns.Items.Clear;

    for I := 0 to FComponents.Count - 1 do
      {$IFDEF DELPHI_V5}
         ExtractPersistent(FComponents[i]).Free;
      {$ELSE}
         FComponents[i].Free;
      {$ENDIF}
  finally
    lvColumns.Items.EndUpdate;
    DCDBGrid.Columns.EndUpdate;
    {$IFNDEF DELPHI_V5}
      FComponents.Free;
    {$ENDIF}
    Designer.Modified;
  end;
end;

procedure TGridColEditForm.aDeleteExecute(Sender: TObject);
 var
  I, SelectedItem:Integer;
  {$IFDEF DELPHI_V5}
    FComponents: IDesignerSelections;
  {$ELSE}
    FComponents: TComponentList;
  {$ENDIF}
begin
  {Delete Selected Fiedls}
  SelectedItem := -1;
  if (lvColumns.SelCount > 0) then begin
    {$IFNDEF DELPHI_V5}
       FComponents := TComponentList.Create;
    {$ELSE}
       FComponents := CreateSelectionList;
    {$ENDIF}
    try
      DCDBGrid.Columns.BeginUpdate;
      lvColumns.Items.BeginUpdate;
      SelectedItem := lvColumns.Items.IndexOf(lvColumns.Selected);

      for I := lvColumns.Items.Count - 1 downto 0 do
        if (lvColumns.Items[i].Selected = True) and
            Assigned(lvColumns.Items[i].Data)
        then begin
          {$IFDEF DELPHI_V5}
             FComponents.Add(MakeIPersistent(TColumn(lvColumns.Items[i].Data)));
          {$ELSE}
             FComponents.Add(TColumn(lvColumns.Items[i].Data));
          {$ENDIF}
        end;

      lvColumns.Items.Clear;

      for I := 0 to FComponents.Count - 1 do
      begin
        {$IFDEF DELPHI_V5}
           TColumn(ExtractPersistent(FComponents[i])).Free;
        {$ELSE}
           FComponents[i].Free;
        {$ENDIF}
       end;
    finally
      lvColumns.Items.EndUpdate;
      DCDBGrid.Columns.EndUpdate;
      {$IFNDEF DELPHI_V5}
        FComponents.Free;
      {$ENDIF}
      Designer.Modified;
      if (lvColumns.Items.Count > 0) then
        if (SelectedItem > lvColumns.Items.Count - 1) then
           lvColumns.Items[lvColumns.Items.Count-1].Selected := True
        else
           lvColumns.Items[SelectedItem].Selected := True;
        lvColumnsChange(nil,nil,ctState);
    end;
   end;
end;

procedure TGridColEditForm.aAllExecute(Sender: TObject);
 var
   I: Integer;
   Column: TColumn;
begin
  {Add All Fields}
  if (DCDBGrid.Columns.State = csDefault) then
     DCDBGrid.Columns.State := csCustomized
  else begin
    for I := 0 to DCDBGrid.DataSource.DataSet.FieldCount - 1 do
    begin
      Column := DCDBGrid.Columns.Add;
      Column.FieldName := DCDBGrid.DataSource.DataSet.Fields[i].FieldName;
    end;
  end;
  UpdateColumns;
  Designer.Modified;
end;

procedure TGridColEditForm.aToolBarExecute(Sender: TObject);
begin
  aToolBar.Checked := not aToolBar.Checked;
  ToolBar.Visible  := aToolBar.Checked
end;

procedure TGridColEditForm.aDefaultExecute(Sender: TObject);
 var
  I:Integer;
  ListItem: TListItem;
begin
  {Restore Default}
  if (lvColumns.SelCount > 0) then begin
    ListItem := lvColumns.Selected;
    for i := 0 to lvColumns.SelCount - 1 do begin
      TColumn(ListItem.Data).RestoreDefaults;
      ListItem := lvColumns.GetNextItem(ListItem,sdBelow,[isSelected]);
    end;
    lvColumnsChange(nil,nil,ctState);
    Designer.Modified;
  end;
end;

procedure TGridColEditForm.UpdateColumns;
 var
  I: longint;
  UpdateColumns: boolean;
  ListItem: TListItem;
begin
  if not CheckCollection then
  begin
    lvColumns.Items.Clear;
    lvColumnsChange(nil,nil,ctState);
    Exit;
  end;

  if not Assigned(DCDBGrid) then Exit;

  lvColumns.StateImages := DCDBGrid.Images;

  UpdateColumns := (lvColumns.Items.Count <> DCDBGrid.Columns.Count );
  I := 0;
  while not(UpdateColumns) and (I <= DCDBGrid.Columns.Count - 1) do
  begin
    UpdateColumns := (lvColumns.Items[I].Data <> DCDBGrid.Columns[I]);
    Inc(I);
  end;

  if UpdateColumns then
  begin
    lvColumns.Items.BeginUpdate;
    lvColumns.Items.Clear;
      try
        if (DCDBGrid.Columns.State = csCustomized) then
           for I := 0 to DCDBGrid.Columns.Count - 1 do
           begin
             ListItem := lvColumns.Items.Add;
             ListItem.Caption := Format(fmtListViewItem,[I,DCDBGrid.Columns[i].DisplayName]);
             ListItem.Data := DCDBGrid.Columns[i];
             ListItem.StateIndex := DCDBGrid.Columns[i].ItemIndex;
           end;
      finally
        lvColumns.Items.EndUpdate;
      end;
  end else
    for I := 0 to DCDBGrid.Columns.Count - 1 do
    begin
        lvColumns.Items[i].Caption    := Format(fmtListViewItem,[I,DCDBGrid.Columns[i].DisplayName]);
        lvColumns.Items[i].StateIndex := DCDBGrid.Columns[i].ItemIndex;
    end;
  lvColumnsChange(nil,nil,ctState);
end;


procedure TGridColEditForm.lvColumnsChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
 var
  {$IFDEF DELPHI_V5}
    FComponents: TDesignerSelectionList;
  {$ELSE}
    FComponents: TComponentList;
  {$ENDIF}
  I: Integer;
begin
  if (csDestroying in ComponentState) then Exit;
  {Check Caption Staus}
  aDelete.Enabled    := lvColumns.SelCount > 0;
  aAll.Enabled       := Assigned(DCDBGrid) and
                        Assigned(DCDBGrid.DataSource) and
                        Assigned(DCDBGrid.DataSource.DataSet) and
                        (DCDBGrid.DataSource.DataSet.FieldCount > 0) and
                        (lvColumns.Items.Count = 0);
  aDefault.Enabled   := (lvColumns.SelCount > 0);
  aSelectAll.Enabled := (lvColumns.Items.Count > 0);

  if CheckCollection and Active then
  begin
    {$IFNDEF DELPHI_V5}
       FComponents := TComponentList.Create;
    {$ELSE}
       FComponents := TDesignerSelectionList.Create;
    {$ENDIF}
    if (lvColumns.SelCount > 0) then begin
      for i := lvColumns.Items.Count - 1 downto 0 do
        if (lvColumns.Items[i].Selected = True) and
           Assigned(lvColumns.Items[i].Data)
        then
          FComponents.Add(TColumn(lvColumns.Items[i].Data));
    end
    else
      if Assigned(FDCDBGrid) then
         FComponents.Add(DCDBGrid.Columns);
    SetSelection(FComponents);
  end;

end;

procedure TGridColEditForm.Activated;
begin
  if (csDestroying in ComponentState) then Exit;
  lvColumnsChange(nil,nil,ctState);
end;

function TGridColEditForm.UniqueName(Component: TComponent): string;
 var
  Temp: string;
begin
  if (Component <> nil) then Temp := Component.ClassName
  else Temp := TColumn.ClassName;
  if (UpCase(Temp[1]) = 'T') and (Length(Temp) > 1) then
    System.Delete(Temp, 1, 1);
  Result := Designer.UniqueName(Temp);
end;

procedure TGridColEditForm.FormModified;
begin
  if not (csDestroying in ComponentState) then UpdateColumns;
end;

procedure TGridColEditForm.FormClosed(Form: TCustomForm);
begin
  if (Form = Designer.Form) then Close;
end;

procedure TGridColEditForm.ComponentDeleted(Component: IPersistent);
begin
  if ExtractPersistent(Component) = DCDBGrid then
  begin
    FDCDBGrid := nil;
    Close;
  end;
end;

procedure TGridColEditForm.aSelectAllExecute(Sender: TObject);
 var
  I: integer;
begin
  for I := 0 to lvColumns.Items.Count - 1 do
      lvColumns.Items[i].Selected := True;
end;

procedure TGridColEditForm.FormResize(Sender: TObject);
begin
  if (csDestroying in ComponentState) then Exit;
  lvColumns.Columns[0].Width := lvColumns.ClientWidth;
end;

procedure TGridColEditForm.lvColumnsDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := True;
end;

procedure TGridColEditForm.lvColumnsDragDrop(Sender, Source: TObject; X,
  Y: Integer);
 var
  ColumnTarget, Column: TColumn;
  i, j, k: integer; 
begin
  { Move Column                           }
  { lvColumns.Selected   - Dragged Column }
  { lvColumns.DropTarget                  }

  if not Assigned(Sender) or not Assigned(Source) or
     not Assigned(lvColumns.DropTarget) or
     not Assigned(lvColumns.Selected) or
    (lvColumns.Selected.Index =  lvColumns.DropTarget.Index) then Exit;

  Column := TColumn.Create(nil);
  j := lvColumns.Selected.Index;
  k := lvColumns.DropTarget.Index;

  ColumnTarget:= DCDBGrid.Columns[k];
  Column.Assign(DCDBGrid.Columns[j]);
  try
    if j > k then
    begin
      for i := j - 1 downto k do
        DCDBGrid.Columns[i+1].Assign(DCDBGrid.Columns[i]);
    end
    else begin
      for i := j + 1 to k do
        DCDBGrid.Columns[i-1].Assign(DCDBGrid.Columns[i]);
    end;
    ColumnTarget.Assign(Column);
  finally
    Column.Free;
  end;
  UpdateColumns;
  Designer.Modified;
  lvColumnsChange(nil,nil,ctState);
end;

{ TDCGridFieldEdit }

function TDCGridFieldEdit.GetAttributes: TPropertyAttributes;
 var
  gs : TDCCustomGridEdit;
begin
  Result := [paValueList, paSortList, paMultiSelect];
  gs := GetComponent(0) as TDCCustomGridEdit;
  try
    if not((gs <> nil) and (gs.DataSet <> nil))
    then
      Result :=  Result - [paValueList];
  except
    Result :=  Result - [paValueList];
  end;
end;

procedure TDCGridFieldEdit.GetValueList(List: TStrings);
 var
  gs : TDCCustomGridEdit;
begin
  gs := GetComponent(0) as TDCCustomGridEdit;
  if (gs <> nil) and (gs.DataSet <> nil) then
  begin
    gs.DataSet.GetFieldNames(List);
  end;
end;

procedure TDCGridFieldEdit.GetValues(Proc: TGetStrProc);
 var
  i: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for i := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

destructor TGridColEditForm.Destroy;
begin
  inherited;
end;

end.


