{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCFileCtrl;

interface

uses
  Windows, Classes, SysUtils, Controls, Forms, ShellAPI, ShlObj, CommCtrl,
  ComCtrls, ActiveX, ComObj, Graphics, DCConst, DCChoice, DCPopupWindow;

type
  PFolderItem_tag = ^TFolderItem;
  TFolderItem = record
     SPIDL: PItemIDList;
     FPIDL: PItemIDList;
     DisplayName: string;
     DisplayPath: string
  end;

  TDCBrowseFolder = class(TDCCustomTreeEdit)
  private
    FIDesktopFolder: IShellFolder;
    FImages: TImageList;
    procedure LoadIDList(Node: TTreeNode);
    function GetTreeView: TTreeView;
    procedure DoCreate(Sender: TObject);
    procedure DoCancel(Sender: TObject);
  protected
    procedure DefineBtnChoiceStyle; override;
    procedure SetText(Value: string); override;
    procedure SetParent(AParent: TWinControl); override;
    procedure Expanding(Sender: TObject; Node: TTreeNode; var AllowExpansion: Boolean); override;
    procedure GetHintOnError; override;
    procedure DoShowError(AErrorWindow: TDCMessageWindow); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function GetNode(Value: string; var Node: TTreeNode): boolean; override;
    procedure InitTree; override;
    property TreeView: TTreeView read GetTreeView;
  end;

function CreateDirectoryEx(FilePath:PChar; SecurityAttributes: PSECURITYATTRIBUTES): boolean;

implementation

var
 AIShellFolder: IShellFolder;

function CreateDirectoryEx(FilePath:PChar; SecurityAttributes: PSECURITYATTRIBUTES): boolean;
 var
  APath, CreatedPath: string;
  i, Code: integer;
begin
  APath := FilePath;
  CreatedPath := '';
  i := Pos(':\', APath);

  if i <> 0 then
  begin
    Inc(i,2);
    CreatedPath := Copy(APath, 1, i-2);
    APath := Copy(APath, i, Length(APath)-i+1);
  end;

  i := 1;
  while i > 0 do
  begin
    i := Pos('\',APath);
    if i > 0 then
      CreatedPath := CreatedPath + '\' + Copy(APath, 1, i-1)
    else
      CreatedPath := CreatedPath + '\' + APath;
    APath := Copy(APath, i+1, Length(APath)-i);

    Code   := GetFileAttributes(PChar(CreatedPath));
    if not (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0) then
      if not CreateDirectory(PChar(CreatedPath),SecurityAttributes) then
      begin
        Result := False;
        Exit;
      end;
  end;

  Result := True;
end;

{ TDCDirectoryEdit }
function NextPIDL(IDList: PItemIDList): PItemIDList;
begin
  Result := IDList;
  Inc(PChar(Result), IDList^.mkid.cb);
end;

function GetPIDLSize(IDList: PItemIDList): Integer;
begin
  Result := 0;
  if Assigned(IDList) then
  begin
    Result := SizeOf(IDList^.mkid.cb);
    while IDList^.mkid.cb <> 0 do
    begin
      Result := Result + IDList^.mkid.cb;
      IDList := NextPIDL(IDList);
    end;
  end;
end;

function CreatePIDL(Size: Integer): PItemIDList;
var
  Malloc: IMalloc;
  HR: HResult;
begin
  Result := nil;

  HR := SHGetMalloc(Malloc);
  if Failed(HR) then
    Exit;

  try
    Result := Malloc.Alloc(Size);
    if Assigned(Result) then
      FillChar(Result^, Size, 0);
  finally
  end;
end;

function ConcatPIDL(IDList1, IDList2: PItemIDList): PItemIDList;
var
  cb1, cb2: Integer;
begin
  if Assigned(IDList1) then
    cb1 := GetPIDLSize(IDList1) - SizeOf(IDList1^.mkid.cb)
  else
    cb1 := 0;

  cb2 := GetPIDLSize(IDList2);

  Result := CreatePIDL(cb1 + cb2);
  if Assigned(Result) then
  begin
    if Assigned(IDList1) then
      CopyMemory(Result, IDList1, cb1);
    CopyMemory(PChar(Result) + cb1, IDList2, cb2);
  end;
end;


function GetDisplayName(ShellFolder: IShellFolder; PIDL: PItemIDList;
  lType: integer = SHGDN_NORMAL): string;
 var
  StrRet: TStrRet;
  P: PChar;
begin
  Result := '';
  ShellFolder.GetDisplayNameOf(PIDL, lType, StrRet);
  case StrRet.uType of
    STRRET_CSTR:
      SetString(Result, StrRet.cStr, lStrLen(StrRet.cStr));
    STRRET_OFFSET:
      begin
        P := @PIDL.mkid.abID[StrRet.uOffset - SizeOf(PIDL.mkid.cb)];
        SetString(Result, P, PIDL.mkid.cb - StrRet.uOffset);
      end;
    STRRET_WSTR:
      Result := StrRet.pOleStr;
  end;
end;

function GetImageIndex(PIDL: PItemIDList): integer;
 var
  FileInfo: TShFileInfo;
begin
  SHGetFileInfo(PChar(PIDL), 0, FileInfo, SizeOf(TSHFileInfo),
    SHGFI_PIDL or SHGFI_SYSICONINDEX or SHGFI_SMALLICON);
  Result := FileInfo.iIcon;
end;

function GetSelectedIndex(PIDL: PItemIDList): integer;
 var
  FileInfo: TShFileInfo;
begin
  SHGetFileInfo(PChar(PIDL), 0, FileInfo, SizeOf(TSHFileInfo),
    SHGFI_PIDL or SHGFI_SYSICONINDEX or SHGFI_SMALLICON or SHGFI_OPENICON);
  Result := FileInfo.iIcon;
end;

function CustomSortProc(Node1, Node2: TTreeNode; Data: Longint): integer; stdcall;

begin
  Result := SmallInt(AIShellFolder.CompareIDs(
                  0,
                  PFolderItem_tag(Node1.Data).SPIDL,
                  PFolderItem_tag(Node2.Data).SPIDL));
end;

constructor TDCBrowseFolder.Create(AOwner: TComponent);
begin
  inherited;
  Style := teDropDown;
  OLECheck(SHGetDesktopFolder(FIDesktopFolder));
  AIShellFolder := FIDesktopFolder;
  FImages := TImageList.Create(nil)
end;

procedure TDCBrowseFolder.DefineBtnChoiceStyle;
begin
  if BtnChoiceAssigned then
  begin
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNFOLDER');
    ButtonStyle := esDropDown;
    ButtonChoiceStyle := btsCustom;
  end;
end;

destructor TDCBrowseFolder.Destroy;
begin
  FImages.Handle := 0;
  FImages.Free;
  inherited;
end;

procedure TDCBrowseFolder.DoCancel(Sender: TObject);
begin
  HideErrorMessage;
end;

procedure TDCBrowseFolder.DoCreate(Sender: TObject);
begin
  CreateDirectoryEx(PChar(Text), nil);
  HideErrorMessage;
end;

procedure TDCBrowseFolder.DoShowError(AErrorWindow: TDCMessageWindow);
begin
  if ErrorCode = ERR_TREE_ILLIGALVALUE then
  begin
    AErrorWindow.AddButton('#Create', '', LoadStr(RES_STRN_VAL_CREATE), DoCreate);
    AErrorWindow.AddButton('#Cancel', '', LoadStr(RES_STRN_VAL_CANCEL), DoCancel);
  end;
  inherited;
end;

procedure TDCBrowseFolder.Expanding(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
begin
  with TreeView do
  begin
    Items.BeginUpdate;
    try
      if Node.HasChildren and (Node.GetFirstChild = nil) then
      begin
        Node.HasChildren := False;
        LoadIDList(Node);
      end;
    finally
      Items.EndUpdate;
    end;
  end;
  inherited;
end;

procedure TDCBrowseFolder.GetHintOnError;
begin
  case ErrorCode of
    ERR_TREE_ILLIGALVALUE:
      begin
        ErrorHint := Format(LoadStr(RES_FOLD_ERR_WRONG), [Text]);
        Exit;
      end;  
  else
    ErrorHint := '';
  end;
  inherited;
end;

function TDCBrowseFolder.GetNode(Value: string;
  var Node: TTreeNode): boolean;
var
  Code: Integer;
begin
  Node   := nil;
  Code   := GetFileAttributes(PChar(Value));
  Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;

function TDCBrowseFolder.GetTreeView: TTreeView;
begin
  Result := inherited GetTreeView;
end;

procedure TDCBrowseFolder.InitTree;
 var
  RootPIDL: PItemIDList;
  DesktopNode, FolderNode, NetworkNode: TTreenode;
  PFolderItem: PFolderItem_tag;
begin
  with TreeView do
  begin
    Items.BeginUpdate;

    {Desktop}
    OLECheck(SHGetSpecialFolderLocation(Application.Handle, CSIDL_DESKTOP, RootPIDL));
    PFolderItem := New(PFolderItem_tag);
    PFolderItem.SPIDL := RootPIDL;
    PFolderItem.FPIDL := ConcatPIDL(nil, RootPIDL);
    PFolderItem.DisplayName := GetDisplayName(AIShellFolder, RootPIDL);
    PFolderItem.DisplayPath := '';

    DesktopNode := Items.AddFirst(nil, PFolderItem.DisplayName);
    DesktopNode.ImageIndex    := GetImageIndex(RootPIDL);
    DesktopNode.SelectedIndex := DesktopNode.ImageIndex;
    DesktopNode.Data := PFolderItem;

    {Drivers}
    OLECheck(SHGetSpecialFolderLocation(Application.Handle, CSIDL_DRIVES, RootPIDL));
    PFolderItem := New(PFolderItem_tag);
    PFolderItem.SPIDL := RootPIDL;
    PFolderItem.FPIDL := ConcatPIDL(nil, RootPIDL);
    PFolderItem.DisplayName := GetDisplayName(AIShellFolder, RootPIDL);
    PFolderItem.DisplayPath := '';

    FolderNode := Items.AddChild(DesktopNode, PFolderItem.DisplayName);
    FolderNode.ImageIndex    := GetImageIndex(RootPIDL);
    FolderNode.SelectedIndex := FolderNode.ImageIndex;
    FolderNode.HasChildren   := True;
    FolderNode.Data := PFolderItem;

    {Network}
    OLECheck(SHGetSpecialFolderLocation(Application.Handle, CSIDL_NETWORK, RootPIDL));
    PFolderItem := New(PFolderItem_tag);
    PFolderItem.SPIDL := RootPIDL;
    PFolderItem.FPIDL := ConcatPIDL(nil, RootPIDL);
    PFolderItem.DisplayName := GetDisplayName(AIShellFolder, RootPIDL);
    PFolderItem.DisplayPath := '';

    NetworkNode := Items.AddChild(DesktopNode, PFolderItem.DisplayName);
    NetworkNode.ImageIndex    := GetImageIndex(RootPIDL);
    NetworkNode.SelectedIndex := NetworkNode.ImageIndex;
    NetworkNode.Data := PFolderItem;
    NetworkNode.HasChildren   := True;
    DesktopNode.Expand(False);
    FolderNode.Expand(False);

    TreeView.Selected := FolderNode;
    Items.EndUpdate;
  end;
  inherited;
end;

procedure TDCBrowseFolder.LoadIDList(Node: TTreeNode);
 var
  SaveCursor: TCursor;
  EnumList: IEnumIDList;
  PIDL: PItemIDList;
  PFolderItem: PFolderItem_tag;
  NumIDCount: DWORD;
  ChildNode: TTreeNode;
begin
  SaveCursor := Screen.Cursor;
  try
    Screen.Cursor := crHourglass;

    PIDL := PFolderItem_tag(Node.Data).FPIDL;

    OLECheck(FIDesktopFolder.BindToObject(PIDL, nil, IID_IShellFolder, Pointer(AIShellFolder)));
    try
      OLECheck(AIShellFolder.EnumObjects(Application.Handle, SHCONTF_FOLDERS, EnumList));
    except
      Exit;
    end;
    with TreeView do
    begin
      while EnumList.Next(1, PIDL, NumIDCount) = S_OK do
      begin

        PFolderItem := New(PFolderItem_tag);
        PFolderItem.SPIDL := PIDL;
        PFolderItem.FPIDL := ConcatPIDL(PFolderItem_tag(Node.Data).FPIDL, PIDL);
        PFolderItem.DisplayName := GetDisplayName(AIShellFolder, PIDL);
        PFolderItem.DisplayPath := GetDisplayName(AIShellFolder, PIDL, SHGDN_FORPARSING);

        ChildNode := Items.AddChild(Node, PFolderItem.DisplayName);
        ChildNode.Data := PFolderItem;
        ChildNode.ImageIndex := GetImageIndex(PFolderItem.FPIDL);
        ChildNode.SelectedIndex := GetSelectedIndex(PFolderItem.FPIDL);
        ChildNode.HasChildren := True;
      end;
    end;
  finally
    Node.CustomSort(@CustomSortProc, 0);
    Screen.Cursor := SaveCursor;
  end;
end;

procedure TDCBrowseFolder.SetParent(AParent: TWinControl);
 var
  FileInfo: TShFileInfo;
begin
  inherited;
  if AParent <> nil then
  begin
    FImages.Handle := SHGetFileInfo('C:\', 0, FileInfo, SizeOf(FileInfo),
      SHGFI_SYSICONINDEX or SHGFI_SMALLICON);

    FImages.ShareImages := True;
    FImages.BlendColor := clHighLight;

    Images := FImages;
  end;
end;

procedure TDCBrowseFolder.SetText(Value: string);
begin
  if TreeView.Selected <> nil then
    Value := PFolderItem_tag(TreeView.Selected.Data).DisplayPath;
  inherited;
end;

end.
