{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCEditButton;

interface

uses
  Windows, SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Dialogs, StdCtrls, DCEditTools, Forms, ComCtrls, DCConst;

type
  PButtonInfo = ^TButtonInfo;
  TButtonInfo = packed record
    Allignment : WORD;
    Tag        : integer;
    Style      : WORD;
    EvtStyle   : WORD;
    Top        : smallint;
    Left       : smallint;
    Height     : smallint;
    Width      : smallint;
    ImageIndex : integer;
    Enabled    : boolean;
    Grouped    : boolean;
    AncStyle   : WORD;
    DisStyle   : WORD;
    AbsolutePos: boolean;
    ResetOnExit: boolean;
  end;

  TEBHintEvent  = procedure (Sender: TObject; Mode:integer) of object;
  TEBCheckArea  = procedure (Sender: TObject; X, Y: integer; var Selected: boolean) of object;
  TEBGetRegion  = procedure (Sender: TObject; var Rgn: HRGN) of object;
  TEBSetState  =  procedure (Sender: TObject; var State: TButtonState) of object;

  TDCEditButtons = class;

  TDCEditButton = class(TPersistent)
  private
    FName: string;
    FLeft: integer;
    FTop: integer;
    FWidth: integer;
    FHeight: integer;
    FStyle: TButtonStyle;
    FOwner: TWinControl;
    FEditButtons: TDCEditButtons;
    FButtonState: TButtonState;
    FGlyph: TBitmap;
    FEnabled: boolean;
    FCanvas: TCanvas;
    FBrushColor: TColor;
    FDown: boolean;
    FDownButton: boolean;
    FDownClick: boolean;
    FEventStyle: TEventStyle;
    FText: string;
    FAllignment: TAllignment;
    FFont: TFont;
    FHint: string;
    FMouseInControl: boolean;
    FOnClick: TNotifyEvent;
    FDisableStyle: TDisableStyle;
    FVisible: boolean;
    FVisibleWidth: integer;
    FOnDrawHint: TEBHintEvent;
    FOnCheckArea: TEBCheckArea;
    FGrouped: boolean;
    FAnchorStyle: TAnchorStyle;
    FAbsolutePos: boolean;
    FImages: TImageList;
    FImageIndex: integer;
    FIndex: integer;
    FResetOnExitControl: boolean;
    FTextSize: TPoint;
    FOnSetButtonState: TEBSetState;
    FTag: integer;
    FDrawText: boolean;
    FHighlight: boolean;
    FFlatPattern: boolean;
    function GetGlyph: TBitmap;
    procedure SetGlyph(Value: TBitmap);
    procedure DrawBitmap(ImageRect: TRect);
    procedure DrawEditText(var TextRect: TRect);
    procedure DrawHint(Mode: integer);
    procedure DrawLiteDisableBitmap(ImageRect: TRect);
    procedure DrawNormDisableBitmap(ImageRect: TRect);
    procedure DrawTransformBitmap(ImageRect: TRect; Style: TTransformStyle);
    procedure SetText(Value:string);
    procedure SetAllignment(Value:TAllignment);
    procedure SetButtonState(Value:TButtonState);
    procedure SetMouseInControl(Value:boolean);
    procedure SetCanvas(Value:TCanvas);
    procedure SetEnabled(const Value: boolean);
    procedure SetVisible(const Value: boolean);
    function GetWidth: integer;
    procedure SetImages(const Value: TImageList);
    procedure SetImageIndex(const Value: integer);
    function AsignedImages: boolean;
    function GetTextSize: TPoint;
    procedure SetFont(const Value: TFont);
    function IsEqual(Button: TDCEditButton): Boolean;
    procedure SetWidth(const Value: integer);
    procedure SetHighlight(const Value: boolean);
    procedure SetDownClick(const Value: boolean);
  public
    procedure Paint(Clip: HRGN = 0); virtual;
    procedure DrawBorder; virtual;
    constructor Create(AOwner: TComponent); virtual;
    destructor Destroy; override;
    procedure SetBounds(ARect: TRect);
    function UpdateButtonState(X, Y: integer; ADown, AMove: boolean): boolean;
    function  MouseInRect(X, Y: integer): boolean;
    procedure ResetProperties;
    function GetImageRect: TRect;
    function GetTextRect(IRect: TRect): TRect;
    function GetImageOffset: TPoint;
    function GetTextOffset: TPoint;
    procedure Invalidate;
    procedure Click;
    function GetGlyphHeight: integer;
    function GetGlyphWidth: integer;
    function GetBounds: TRect;
    procedure ReadData(Stream: TStream; Info: PButtonInfo);
    procedure WriteData(Stream: TStream; Info: PButtonInfo);
    property AbsolutePos: boolean read FAbsolutePos write FAbsolutePos;
    property Images: TImageList read FImages write SetImages;
    property Index: integer read FIndex;
    property ResetOnExitControl: boolean read FResetOnExitControl
                                        write FResetOnExitControl;
    property OnCheckArea: TEBCheckArea read FOnCheckArea write FOnCheckArea;
    property Name: string read FName write FName;
    property Glyph: TBitmap read GetGlyph write SetGlyph;
    property ButtonState: TButtonState read FButtonState write SetButtonState;
    property Style: TButtonStyle read FStyle write FStyle;
    property Enabled: boolean read FEnabled write SetEnabled;
    property BrushColor: TColor read FBrushColor write FBrushColor;
    property EventStyle: TEventStyle read FEventStyle write FEventStyle;
    property Width: integer read GetWidth write SetWidth;
    property Height: integer read FHeight write FHeight;
    property Left: integer read FLeft write FLeft;
    property Top: integer read FTop write FTop;
    property Tag: integer read Ftag write FTag;
    property Text: string read FText write SetText;
    property Caption: string read FText write SetText;
    property Allignment: TAllignment read FAllignment write SetAllignment;
    property Font: TFont read FFont write SetFont;
    property Hint: string read FHint write FHint;
    property MouseInControl: boolean read FMouseInControl write SetMouseInControl;
    property Canvas: TCanvas read FCanvas write SetCanvas;
    property OnClick: TNotifyEvent read FOnClick write FOnClick;
    property DisableStyle: TDisableStyle read FDisableStyle write FDisableStyle;
    property Visible: boolean read FVisible write SetVisible;
    property OnDrawHint: TEBHintEvent read FOnDrawHint write FOnDrawHint;
    property Owner: TWinControl read FOwner;
    property Grouped: boolean read FGrouped write FGrouped;
    property AnchorStyle: TAnchorStyle read FAnchorStyle write FAnchorStyle;
    property ImageIndex: integer read FImageIndex write SetImageIndex;
    property OnSetButtonState: TEBSetState read FOnSetButtonState write FOnSetButtonState;
    property DownClick: boolean read FDownClick write SetDownClick;
    property DownButton: boolean read FDownButton write FDownButton;
    property DrawText: boolean read FDrawText write FDrawText;
    property Highlight: boolean read FHighlight write SetHighlight;
    property TextSize: TPoint read FTextSize;
    property FlatPattern: boolean read FFlatPattern write FFlatPattern;
  end;

  TDCEditButtons = class(TPersistent)
  private
    FOwner: TWinControl;
    FButtons: TList;
    FMouseDown: boolean;
    FMouseInControl: boolean;
    FProcClear: boolean;
    FNewWndProc: Pointer;
    FDefWndProc: Pointer;
    FAnchorStyle: TAnchorStyle;
    FAbsolutePos: boolean;
    FActiveButton: TDCEditButton;
    FImages: TImageList;
    FOnGetRegion: TEBGetRegion;
    FColor: TColor;
    FPaintOnSizing: boolean;
    FUpdateCount: integer;
    function GetRegion: HRGN;
    procedure EditWndProc(var Message: TMessage);
    procedure SetButton(Index: integer; const Value: TDCEditButton);
    function GetButton(Index: integer): TDCEditButton;
    function UpdateButtonsOnClick(X, Y: integer; AMove: boolean): boolean;
    function GetCount: integer;
    procedure OffsetButtons(Pos: TPoint);
    function GetEnabled: boolean;
    procedure SetEnabled(const Value: boolean);
    procedure SetImages(const Value: TImageList);
    procedure UpdateIndex;
    procedure SetColor(const Value: TColor);
    function GetSelectedButton: TDCEditButton;
    procedure SetActiveButton(const Value: TDCEditButton);
  private
    procedure ReadData(Stream: TStream);
    procedure WriteData(Stream: TStream);
  protected
    procedure DefineProperties(Filer: TFiler); override;
  public
    constructor Create(AOwner: TWinControl);
    destructor Destroy; override;
    function AddButton: TDCEditButton;
    procedure DeleteButton(Index: integer);
    procedure MoveButton(CurIndex, NewIndex: integer);
    function FindButton(AName: string): TDCEditButton;
    function UpdateButtons(XPos, YPos: integer; ADown, AMove: boolean): boolean;
    function MouseInButtonArea(XPos, YPos: integer; var Button: TDCEditButton): boolean;
    function GetButtonsRect: TRect;
    procedure ResetProperties;
    procedure UpdateDeviceRegion(DC: HDC);
    procedure UpdateMouseInControl(Value: boolean);
    procedure SetWndProc;
    procedure ClrWndProc;
    procedure RepaintButtons(Clip: HRGN =0);
    procedure Clear;
    procedure Invalidate;
    procedure BeginUpdate;
    procedure EndUpdate;
    function IsButtonAccel(VK: Word; var Button: TDCEditButton): Boolean;
    property Buttons[Index: integer]: TDCEditButton read GetButton write SetButton;
    property Items[Index: integer]: TDCEditButton read GetButton write SetButton;
    property Count: integer read GetCount;
    property Owner: TWinControl read FOwner;
    property ActiveButton: TDCEditButton read FActiveButton write SetActiveButton;
    property MouseDown: boolean read FMouseDown write FMouseDown;
    property AbsolutePos: boolean read FAbsolutePos write FAbsolutePos;
    property Images: TImageList read FImages write SetImages;
    property AnchorStyle: TAnchorStyle read FAnchorStyle write FAnchorStyle;
    property Enabled: boolean read GetEnabled write SetEnabled;
    property OnGetRegion: TEBGetRegion read FOnGetRegion write FOnGetRegion;
    property Color: TColor read FColor write SetColor;
    property PaintOnSizing: boolean read FPaintOnSizing write FPaintOnSizing;
    property SelectedButton: TDCEditButton read GetSelectedButton;
  end;

const
  ButtonOffset  = 3;   //       
  TextBtnOffset = 3;   //      

implementation
uses
  DCResource;

type
  TEditControl = class(TWinControl)
  end;

var
  UserBitmap, GlypBitmap: TBitmap;

constructor TDCEditButton.Create(AOwner: TComponent);
begin
  inherited Create;
  FName  := 'Button';

  FGlyph := TBitmap.Create;
  FGlyph.Transparent := True;

  FEnabled := True;
  FOwner := AOwner as TWinControl;

  FCanvas := TControlCanvas.Create;
  TControlCanvas(FCanvas).Control := AOwner as TWinControl;
  FFont := FCanvas.Font;

  FButtonState   := btRest;
  FGlyph.LoadFromResourceName(HInstance, 'DC_BTNPOPUP');
  FDown          := False;
  FDownButton    := False;
  FDownClick     := False;
  FEventStyle    := esNormal;
  FAllignment    := abCentr;
  FMouseInControl:= False;
  FDisableStyle  := deLite;
  FVisible       := True;
  FGrouped       := False;
  FImageIndex    := -1;
  FDrawText      := True;

  FResetOnExitControl := True;
  FEditButtons        := nil;
  FHighlight          := True;
  FFlatPattern        := False;
end;


destructor TDCEditButton.Destroy;
begin
  FGlyph.Free;
  FCanvas.Free;
  inherited;
end;

procedure TDCEditButton.SetBounds(ARect: TRect);
begin
  Left  := ARect.Left;
  Top   := ARect.Top;
  Width := ARect.Right{-ARect.Left};
  Height:= ARect.Bottom{-ARect.Top};
end;

function TDCEditButton.MouseInRect(X, Y: integer): boolean;
begin
  if Visible and Enabled then
    Result := PtInRect(Rect(FLeft,FTop,FLeft+FWidth,FTop+FHeight), Point(X,Y))
  else
    Result := False;

  {         }
  {AE 31.05.1999}
  if Assigned(FOnCheckArea) then  FOnCheckArea(Self, X, Y, Result)
end;

function TDCEditButton.UpdateButtonState( X, Y: integer; ADown, AMove: boolean): boolean;
 var
  OButtonState: TButtonState;
  ClickButton: boolean;
begin
  OButtonState := FButtonState;
  ClickButton  := False;
  if not Enabled then
  begin
    if MouseInRect(X, Y) then
      ButtonState := btRestMouseInRect
    else
      ButtonState := btRest;
  end
  else begin
    case FEventStyle of
      esNormal  :
        begin
          if MouseInRect(X, Y)
          then
            if not AMove then
            begin
              if ADown then
              begin
                 ButtonState := btDownMouseInRect;
                 FDown := True;
              end
              else begin
                ButtonState := btRestMouseInRect;
                if FDown or (FStyle = stAssist) then
                  if ButtonState <> OButtonState then ClickButton := True;
              end
            end
            else begin
              if ADown and FDown
               then ButtonState := btDownMouseInRect
               else begin
                 ButtonState := btRestMouseInRect;
                 FDown := False;
               end;
            end
          else begin
            ButtonState := btRest;
          end;
          if not ADown and not AMove then FDown:= False;
        end;
      esDropDown:
        begin
          if FDownClick then
          begin
            if MouseInRect(X, Y)
            then
              if not AMove then
              begin
                if ADown then
                begin
                   ButtonState := btDownMouseInRect;
                   FDown := True;
                end
                else begin
                  if FDown or (FStyle = stAssist) then
                  begin
                    FDownButton := not FDownButton;
                    if FDownButton then
                    begin
                      ButtonState := btDownMouseInRect;
                      if ButtonState = btDownMouseInRect then Click
                      else
                        FDownButton := not FDownButton;
                    end
                    else begin
                      ButtonState := btRestMouseInRect;
                      if ButtonState = btRestMouseInRect then Click
                      else
                        FDownButton := not FDownButton;
                    end;
                  end;
                end
              end
              else begin
                if (ADown and FDown) or FDownButton
                 then ButtonState := btDownMouseInRect
                 else begin
                   if not ADown then
                     ButtonState := btRestMouseInRect
                   else
                     ButtonState := btRest;
                   FDown := False;
                 end;
              end
            else begin
              if FDownButton then
                ButtonState := btDownMouseInRect
              else begin
                if FDown then begin
                  if FDownButton then
                    ButtonState := btDownMouseInRect
                  else
                    ButtonState := btRestMouseInRect
                end
                else
                  ButtonState := btRest;
              end;
            end;
            if not ADown and not AMove then FDown:= False;
          end
          else begin
            if MouseInRect(X,Y)
            then begin
              if ADown then
              begin
                if not AMove then
                begin
                  case FButtonState of
                      btDownMouseInRect :
                        begin
                          ButtonState := btRestMouseInRect;
                          if Buttonstate = btRestMouseInRect then ClickButton := True;
                        end;
                      btRestMouseInRect,
                      btRest :
                        begin
                          ButtonState := btDownMouseInRect;
                          if Buttonstate = btDownMouseInRect then ClickButton := True;
                        end;
                  end;
                end
              end
              else if FButtonState <> btDownMouseInRect then
              begin
                ButtonState := btRestMouseInRect;
              end
            end
            else if FButtonState <> btDownMouseInRect then
            begin
              ButtonState := btRest;
            end
          end;
        end;
    end;
  end;
  if OButtonState <> FButtonState then
  begin
    if not( (OButtonState in [btRestMouseInRect, btRest]) and
            (FButtonState in [btRestMouseInRect, btRest]) and
            ((FStyle = stNormal) or FMouseInControl)
          )
    then begin
      Paint;
      Result := True;
    end
    else
      Result := False;

  end else
    Result := False;

  if ClickButton then Click;

end;

procedure TDCEditButton.SetGlyph( Value: TBitmap );
begin
  FGlyph.Assign(Value);
  Paint;
end;

function TDCEditButton.GetGlyph: TBitmap;
begin
  Result := FGlyph;
end;

procedure TDCEditButton.Paint(Clip: HRGN = 0);
 var
  ImageRect, TextRect: TRect;
  DC: HDC;
begin
  if (not Visible) or not FOwner.HandleAllocated or
     (FWidth<0) or (FHeight<0)
    then Exit;
  DC := GetWindowDC(FOwner.Handle);
  if Assigned(FEditButtons) then Clip := FEditButtons.GetRegion;
  if (Clip <> 0) then  SelectClipRgn(DC, Clip);

  {
  if not RectVisible(DC, GetBounds) then
  begin
    ReleaseDC(FOwner.Handle, DC);
    Exit;
  end;
  }

  try
    FCanvas.Handle := DC;
    UserBitmap.Width  := FWidth;
    UserBitmap.Height := FHeight;
    ImageRect := GetImageRect;
    TextRect  := GetTextRect(ImageRect);

    if not Enabled then
       case FDisableStyle of
         deLite  :
           if FStyle = stHint then
             UserBitmap.Canvas.Brush.Color := FBrushColor
           else
             UserBitmap.Canvas.Brush.Bitmap := AllocPatternBitmap(clLite, clBtnFace);
         deNormal:
           UserBitmap.Canvas.Brush.Color  := FBrushColor;
         deNone  :
          UserBitmap.Canvas.Brush.Color  := FBrushColor;
       end
    else
      case FStyle of
        stAssist:
          case FButtonState of
            btRest:
              UserBitmap.Canvas.Brush.Color := FBrushColor;
            btDownMouseInRect:
              UserBitmap.Canvas.Brush.Color := clHighlight;
            btRestMouseInRect:
              UserBitmap.Canvas.Brush.Color := clHighlight;
          end;
        stOutBar:
          begin
            if FEventStyle = esDropDown then
            begin
              case FButtonState of
                btRest, btRestMouseInRect:
                  UserBitmap.Canvas.Brush.Color := FBrushColor;
                btDownMouseInRect:
                   if (ColorToRGB(FBrushColor) = clSilver) or (FBrushColor = clBtnFace) then
                     UserBitmap.Canvas.Brush.Bitmap := AllocPatternBitmap(clWhite, clBtnFace)
                   else
                     UserBitmap.Canvas.Brush.Color := FBrushColor;
              end;
            end
            else
              UserBitmap.Canvas.Brush.Color := FBrushColor;
          end;
        stSelect:
          case FButtonState of
            btRest, btRestMouseInRect:
              UserBitmap.Canvas.Brush.Color := FBrushColor;
            btDownMouseInRect:
              if (ColorToRGB(FBrushColor) = clSilver) or (FBrushColor = clBtnFace) then
                UserBitmap.Canvas.Brush.Bitmap := AllocPatternBitmap(clWhite, clBtnFace)
              else
                UserBitmap.Canvas.Brush.Color := clBtnFace;
          end;
        stShadowFlat:
          case FButtonState of
            btRest:
              if (csDesigning in (FOwner as TComponent).ComponentState) and
                 (ColorToRGB(FBrushColor) = clWhite) then
                UserBitmap.Canvas.Brush.Bitmap := AllocPatternBitmap(clWhite, clBtnFace)
              else
                UserBitmap.Canvas.Brush.Color := FBrushColor;
            btDownMouseInRect, btRestMouseInRect:
              if (ColorToRGB(FBrushColor) = clWhite)  or
                 ((ColorToRGB(FBrushColor) = clSilver) or (FBrushColor = clBtnFace)) and FFlatPattern then
                UserBitmap.Canvas.Brush.Bitmap := AllocPatternBitmap(clWhite, clBtnFace)
              else
                UserBitmap.Canvas.Brush.Color := FBrushColor;
          end;
        else
          UserBitmap.Canvas.Brush.Color := FBrushColor;
      end;

    FillRect(UserBitmap.Canvas.Handle,
             Rect(0,0,FWidth,FHeight),
             UserBitmap.Canvas.Brush.Handle);

    DrawBorder;
    DrawBitmap(ImageRect);
    if (FText <> '') and FDrawText then DrawEditText(TextRect);
    FCanvas.Draw(FLeft,FTop,UserBitmap);
  finally
    ReleaseDC(FOwner.Handle, DC);
  end;

end;

procedure TDCEditButton.DrawEditText(var TextRect: TRect);
 var
  AText: string;
  ATextRect: TRect;
  Offs: TPoint;
  DrawFlag: WORD;
begin
  Offs := GetTextOffset;
  ATextRect := TextRect;
  OffsetRect(ATextRect, Offs.X, Offs.Y);

  if ATextRect.Right >Width then ATextRect.Right := Width;

  DrawFlag :=DT_END_ELLIPSIS;

  if (FAllignment = abCentr)      or
     (FAllignment = abImageTop)   or
     (FAllignment = abImageBottom)
  then
    DrawFlag := DrawFlag or DT_CENTER;

  with UserBitmap.Canvas do
  begin
    Font := FFont;
    case FStyle of
      stAssist:
        case FButtonState of
          btRest:;
          btDownMouseInRect:
            Font.Color := clHighlightText;
          btRestMouseInRect:
            Font.Color := clHighlightText;
        end;
      stIcon:
        case FButtonState of
          btRest:;
          btDownMouseInRect:
            begin
              Brush.Color := clHighlight;
              Font.Color  := clHighlightText;
              FillRect(ATextRect);
              Windows.DrawFocusRect(UserBitmap.Canvas.Handle, ATextRect);
            end;
          btRestMouseInRect:
        end;
    end;
    AText := FText;
    SetBkMode(Handle, TRANSPARENT);

    if not Enabled and (FDisableStyle <> deNone) then begin
      if FDisableStyle = deNormal then
      begin
        OffsetRect(ATextRect, 1, 1);
        Font.Color := clWindow;
        if AText <> '' then
          if FHighlight then
            DrawHighLightText(UserBitmap.Canvas, PChar(AText), ATextRect, 1,
              DrawFlag, FImages)
          else
            Windows.DrawText(UserBitmap.Canvas.Handle, PChar(AText), Length(AText),
              ATextRect, DrawFlag);
        OffsetRect(ATextRect, -1, -1);
      end;
      Font.Color := clBtnShadow;
      if AText <> '' then
        if FHighlight then
          DrawHighLightText(UserBitmap.Canvas, PChar(AText), ATextRect, 1,
            DrawFlag, FImages)
        else
          Windows.DrawText(UserBitmap.Canvas.Handle, PChar(AText), Length(AText),
            ATextRect, DrawFlag);
    end
    else
      if AText <> '' then
      begin
        if FHighlight then
          DrawHighLightText(UserBitmap.Canvas, PChar(AText), ATextRect, 1,
            DrawFlag, FImages)
        else
          Windows.DrawText(UserBitmap.Canvas.Handle, PChar(AText), Length(AText),
            ATextRect, DrawFlag);
      end;
  end;
end;

procedure TDCEditButton.DrawBitmap(ImageRect: TRect);
 var
  Offs: TPoint;
  AImageRect: TRect;
begin
  AImageRect := ImageRect;
  Offs := GetImageOffset;
  OffsetRect(AImageRect, Offs.X, Offs.Y);
  if (Enabled or (FDisableStyle = deNone)) and
     not ((FStyle = stIcon) and (FButtonState = btDownMouseInRect)) then
  begin
    with UserBitmap.Canvas, UserBitmap do
      if AsignedImages then
      begin
        with AImageRect do
          FImages.Draw(Canvas, Left, Top, FImageIndex, True);
      end
      else
        Canvas.StretchDraw(AImageRect, FGlyph);
  end
  else begin
     case FDisableStyle of
       deLite  : DrawLiteDisableBitmap(ImageRect);
       deNormal: DrawNormDisableBitmap(ImageRect);
     end
  end;

  case FStyle of
    stOutbar:
      if (EventStyle <> esDropDown) and (GetGlyphWidth > 0) and (GetGlyphHeight > 0) then
      with UserBitmap.Canvas do
      begin
        InflateRect(ImageRect, 2, 2);
        if (csDesigning in (FOwner as TComponent).ComponentState) then
        begin
          if ColorToRGB(FBrushColor) <> clSilver then
          begin
            DrawEdge(Handle, ImageRect, BDR_RAISEDINNER, BF_TOPLEFT);
            DrawEdge(Handle, ImageRect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
          end
          else
            DrawEdge(Handle, ImageRect, BDR_RAISEDINNER, BF_RECT);
        end
        else
          if Enabled then
          begin
            case FButtonState of
              btRest:
                ;
              btDownMouseInRect:
                if ColorToRGB(FBrushColor) <> clSilver then
                begin
                  DrawEdge(Handle, ImageRect, BDR_SUNKENINNER, BF_TOPLEFT);
                  DrawEdge(Handle, ImageRect, BDR_SUNKENOUTER, BF_BOTTOMRIGHT);
                end
                else
                  DrawEdge(Handle, ImageRect, BDR_SUNKENOUTER, BF_RECT);
              btRestMouseInRect:
                if ColorToRGB(FBrushColor) <> clSilver then
                begin
                  DrawEdge(Handle, ImageRect, BDR_RAISEDINNER, BF_TOPLEFT);
                  DrawEdge(Handle, ImageRect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
                end
                else
                  DrawEdge(Handle, ImageRect, BDR_RAISEDINNER, BF_RECT);
            end
          end
      end;
    stIcon:
      if (GetGlyphWidth > 0) and (GetGlyphHeight > 0) and Enabled then
      begin
        case FButtonState of
          btRest:
            {DrawTransformBitmap(ImageRect, tsTransparent)};
          btDownMouseInRect:
            DrawTransformBitmap(ImageRect, tsShadow);
          btRestMouseInRect:
            ;
        end
      end;
  end;
end;

procedure TDCEditButton.DrawLiteDisableBitmap(ImageRect: TRect);
 var
  ARect: TRect;
begin
  try
    ARect := Rect(0,0,GetGlyphWidth, GetGlyphHeight);
    if (GetGlyphHeight > 0) and (GetGlyphWidth > 0) then
    begin
      if AsignedImages then
      begin
        with GlypBitmap.Canvas do
        begin
          Brush.Color := clWhite;
          FillRect(ARect);
        end;
        FImages.GetBitmap(FImageIndex, GlypBitmap);
        TransformBitmap(GlypBitmap, GlypBitmap, tsDisable);
      end
      else begin
        GlypBitmap.Assign(FGlyph);
        TransformBitmap(Glyph, GlypBitmap, tsDisable);
      end;

      with UserBitmap.Canvas do  StretchDraw(ImageRect, GlypBitmap);
    end;
  finally
    {};
  end;

end;

procedure TDCEditButton.DrawTransformBitmap(ImageRect: TRect; Style: TTransformStyle);
 var
  ARect: TRect;
begin
  try
    ARect := Rect(0,0,GetGlyphWidth, GetGlyphHeight);
    if (GetGlyphHeight > 0) and (GetGlyphWidth > 0) then
    begin
      if AsignedImages then
      begin
        with GlypBitmap.Canvas do
        begin
          Brush.Color := clFuchsia;
          FillRect(ARect);
        end;
        FImages.GetBitmap(FImageIndex, GlypBitmap);
        TransformBitmap(GlypBitmap, GlypBitmap, Style);
      end
      else begin
        GlypBitmap.Assign(FGlyph);
        TransformBitmap(Glyph, GlypBitmap, Style);
      end;

      with UserBitmap.Canvas do  StretchDraw(ImageRect, GlypBitmap);
    end;
  finally
    {};
  end;

end;


procedure TDCEditButton.DrawNormDisableBitmap(ImageRect: TRect);
 const
  ROP_DSPDxax = $00E20746;
begin
  try
    with GlypBitmap do
    begin
      if AsignedImages then
      begin
        Canvas.Brush.Color := clWhite;
        Canvas.FillRect(Rect(0,0,GetGlyphWidth, GetGlyphHeight));
        FImages.GetBitmap(FImageIndex, GlypBitmap);
      end
      else
        Assign(Glyph);
      HandleType := bmDDB;
      Canvas.Brush.Color := clBlack;
      Width := GetGlyphWidth;
      if Monochrome then
      begin
        Canvas.Font.Color := clWhite;
        Monochrome := False;
        Canvas.Brush.Color := clWhite;
      end;
      Monochrome := True;
    end;
    with UserBitmap.Canvas do
    begin
      Brush.Color := clBtnShadow;
      SetTextColor(Handle, clBlack);
      SetBkColor(Handle, clWhite);
      BitBlt(Handle, ImageRect.Left,ImageRect.Top, GetGlyphWidth, GetGlyphHeight,
             GlypBitmap.Canvas.Handle, 0, 0, ROP_DSPDxax);

    end;
  finally
    {}
  end;
end;

procedure TDCEditButton.DrawBorder;
 const
  HintEllipseRadius = 3;

 var
  ARect: TRect;
  AButtonState: TButtonState;
  ABrush, BBrush: HBRUSH;
  ARGB: integer;

  procedure DrawNormalHintButton(ACanvas: TCanvas; ARect: TRect);
   var
    Rgn: HRgn;
    nEllipse: integer;
   begin
    nEllipse := HintEllipseRadius;
    InflateRect(ARect, -1,-1);
    with ARect do
      Rgn := CreateRoundRectRgn(Left, Top, Right, Bottom, nEllipse, nEllipse);

    ACanvas.Pen.Style := psSolid;
    ACanvas.Brush.Color := clHintBackground;
    PaintRgn(ACanvas.Handle, Rgn);

    ACanvas.Brush.Color := clHintNormal;
    FrameRgn(ACanvas.Handle, Rgn, ACanvas.Brush.Handle, 1, 1);
  end;

  procedure DrawUpHintButton(ACanvas: TCanvas; ARect: TRect);
   var
    Rgn: HRgn;
    nEllipse: integer;
  begin
    nEllipse := HintEllipseRadius+1;
    with ARect do
      Rgn := CreateRoundRectRgn(Left, Top, Right, Bottom, nEllipse, nEllipse);

    ACanvas.Pen.Style := psSolid;
    ACanvas.Brush.Color := clHintBackground;
    PaintRgn(ACanvas.Handle, Rgn);

    ACanvas.Brush.Color := clHintLight;
    FrameRgn(ACanvas.Handle, Rgn, ACanvas.Brush.Handle, 1, 1);

    ACanvas.Pen.Color   := clHintDark;
    with ARect do
    begin
      ACanvas.PolyLine([Point(Right-3, Top+3), Point(Right-3, Bottom-5),
                        Point(Right-4, Bottom-4), Point(Right-5, Bottom-3),
                        Point(Left+2, Bottom-3)]);
      ACanvas.Pixels[Right-3, Top+2]    := clHintNormal;
      ACanvas.Pixels[Left+2 , Bottom-4] := clHintNormal;
    end;
  end;

  procedure DrawDownHintButton(ACanvas: TCanvas; ARect: TRect);
  var
   Rgn: HRgn;
   nEllipse: integer;
  begin
    nEllipse := HintEllipseRadius+1;
    with ARect do
      Rgn := CreateRoundRectRgn(Left, Top, Right, Bottom, nEllipse, nEllipse);

    ACanvas.Pen.Style := psSolid;
    ACanvas.Brush.Color := clHintBackground;
    PaintRgn(ACanvas.Handle, Rgn);

    ACanvas.Brush.Color := clHintLight;
    FrameRgn(ACanvas.Handle, Rgn, ACanvas.Brush.Handle, 1, 1);

    ACanvas.Pen.Color   := clHintDark;
    with ARect do
    begin
      ACanvas.PolyLine([Point(Left+1, Bottom-5),
                        Point(Left+1, Top+3), Point(Left+2, Top+2),
                        Point(Left+3, Top+1), Point(Right-4,Top+1)]);
      ACanvas.Pixels[Right-4, Top+2]    := clHintNormal;
      ACanvas.Pixels[Left+1 , Bottom-4] := clHintNormal;
    end;
  end;

begin
  ARect := Rect(0,0,FWidth,FHeight);
  AButtonState := FButtonState;
  if not Enabled then AButtonState := btRest;

  with UserBitmap do
    case AButtonState of
      btRest:
        begin
          if (csDesigning in (FOwner as TComponent).ComponentState) then
          begin
            case FStyle of
              stNormal    :
                begin
                  DrawEdge(Canvas.Handle, ARect, BDR_RAISEDOUTER, BF_RECT);
                  InflateRect(ARect, -1, -1);
                  DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
                end;
              stFlat :
                DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
              stControlFlat :
                if Enabled then
                  DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT)
                else
                  FrameRect(Canvas.Handle, ARect, GetSysColorBrush(COLOR_WINDOW));
              stAssist:
                begin
                  FrameRect(Canvas.Handle, ARect, GetSysColorBrush(COLOR_BTNFACE));
                  InflateRect(ARect, -1, -1);
                  FrameRect(Canvas.Handle, ARect, GetSysColorBrush(COLOR_BTNSHADOW));
                end;
              stShadowFlat:
                begin
                  DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_TOPLEFT);
                  ARGB := ColorToRGB(BrushColor);
                  case ARGB of
                    $808080: {clGray}
                      DrawEdge(Canvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
                    $C0C0C0: {clSilver}
                      DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                    else
                      DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                  end;
                end;
              stHint:
                DrawNormalHintButton(Canvas, ARect);
              stSelect:
                begin
                  ABrush := CreateSolidBrush(ColorToRGB(clBlack));
                  FrameRect(Canvas.Handle, ARect, ABrush);
                  DeleteObject(ABrush);
                end;
              stNone:;
              stIcon:;
            end;
          end
          else
            case FStyle of
              stNormal :
                begin
                  if Enabled then
                  begin
                    DrawEdge(Canvas.Handle, ARect, BDR_RAISEDOUTER, BF_RECT);
                    InflateRect(ARect, -1, -1);
                    DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
                  end
                  else begin
                    DrawEdge(Canvas.Handle, ARect, BDR_RAISEDOUTER, BF_TOPLEFT);
                    DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                    InflateRect(ARect, -1, -1);
                    DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_TOPLEFT);
                    DrawEdge(Canvas.Handle, ARect, BDR_SUNKENINNER, BF_BOTTOMRIGHT);
                  end;
                end;
              stFlat   :
              if FMouseInControl then
                  DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
              stControlFlat :
                if FMouseInControl then
                  DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT)
                else begin
                  if Assigned(FOwner) and (FOwner is TWinControl) then
                  begin
                    BBrush := CreateSolidBrush(ColorToRGB(TEditControl(FOwner).Color));
                    FrameRect(Canvas.Handle, ARect, BBrush);
                    DeleteObject(BBrush);
                  end
                  else
                    FrameRect(Canvas.Handle, ARect, GetSysColorBrush(COLOR_WINDOW));
                end;
              stAssist:
                begin
                  FrameRect(Canvas.Handle, ARect, GetSysColorBrush(COLOR_BTNFACE));
                  InflateRect(ARect, -1, -1);
                  FrameRect(Canvas.Handle, ARect, GetSysColorBrush(COLOR_BTNSHADOW));
                end;
              stShadowFlat:
                if FMouseInControl then
                begin
                  DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_TOPLEFT);
                  ARGB := ColorToRGB(BrushColor);
                  case ARGB of
                    $808080: {clGray}
                      DrawEdge(Canvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
                    $C0C0C0: {clSilver}
                      DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                    else
                      DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                  end;
                end;
              stHint:
                DrawNormalHintButton(Canvas, ARect);
              stNone:;
              stIcon:;
            end;
        end;
      btDownMouseInRect:
        begin
          case FStyle of
            stNormal:
              begin
                FrameRect(Canvas.Handle, ARect, GetSysColorBrush(COLOR_BTNSHADOW));
              end;
            stFlat,
            stControlFlat   :
              DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT);
            stAssist:
              begin
                FrameRect(Canvas.Handle, ARect, GetSysColorBrush(COLOR_BTNFACE));
                InflateRect(ARect, -1, -1);
                FrameRect(Canvas.Handle, ARect, GetSysColorBrush(COLOR_BTNSHADOW));
              end;
            stShadowFlat:
              begin
                DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_BOTTOMRIGHT);
                ARGB := ColorToRGB(BrushColor);
                case ARGB of
                  $808080: {clGray}
                    DrawEdge(Canvas.Handle, ARect, BDR_SUNKENINNER, BF_TOPLEFT);
                  $C0C0C0: {clSilver}
                    DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_TOPLEFT);
                  else
                    DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_TOPLEFT);
                end;
              end;
            stOutBar:
              if (GetGlyphHeight=0) or (GetGlyphWidth=0) or
                 (EventStyle=esDropDown)
              then
                if ColorToRGB(FBrushColor) <> clSilver then
                begin
                  DrawEdge(Canvas.Handle, ARect, BDR_SUNKENINNER, BF_TOPLEFT);
                  DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_BOTTOMRIGHT);
                end
                else
                  DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT);
            stHint:
              DrawDownHintButton(Canvas, ARect);
            stNone:;
            stIcon:;
          end;
        end;
      btRestMouseInRect:
        begin
          case FStyle of
            stNormal        :
              begin
                DrawEdge(Canvas.Handle, ARect, BDR_RAISEDOUTER, BF_RECT);
                InflateRect(ARect, -1, -1);
                DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
              end;
            stFlat,
            stControlFlat   :
              DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
            stAssist:
              begin
                FrameRect(Canvas.Handle, ARect, GetSysColorBrush(COLOR_BTNFACE));
                InflateRect(ARect, -1, -1);
                FrameRect(Canvas.Handle, ARect, GetSysColorBrush(COLOR_BTNSHADOW));
              end;
            stShadowFlat:
              begin
                DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_TOPLEFT);
                ARGB := ColorToRGB(BrushColor);
                case ARGB of
                  $808080: {clGray}
                    DrawEdge(Canvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
                  $C0C0C0: {clSilver}
                    DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                  else
                    DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
                end;
              end;
            stOutBar:
              if (GetGlyphHeight=0) or (GetGlyphWidth=0) or
                 (EventStyle=esDropDown)
              then
                if ColorToRGB(FBrushColor) <> clSilver then
                begin
                  DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_TOPLEFT);
                  DrawEdge(Canvas.Handle, ARect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);
                end
                else
                  DrawEdge(Canvas.Handle, ARect, BDR_RAISEDINNER, BF_RECT);
            stHint:
              DrawUpHintButton(Canvas, ARect);
            stSelect:
              begin
                ABrush := CreateSolidBrush(ColorToRGB(clBlack));
                FrameRect(Canvas.Handle, ARect, ABrush);
                DeleteObject(ABrush);
              end;
            stNone:;
            stIcon:;
         end;
        end;
    end;
end;

procedure TDCEditButton.ResetProperties;
var
  P: TPoint;
begin
  GetCursorPos(P);
  P := (FOwner as TControl).ScreenToClient(P);
  if ResetOnExitControl or (FEventStyle <> esDropDown) then
  begin
    if MouseInRect( P.X, P.Y ) then
      FButtonState := btRestMouseInRect
    else
      FButtonState := btRest;

    FDown       := False;
    FDownButton := False;
    Paint;
  end;
end;

procedure TDCEditButton.SetText(Value:string);
begin
  FText     := Value;
  FTextSize := GetTextSize;
end;

procedure TDCEditButton.SetAllignment(Value:TAllignment);
begin
  if Value <>  FAllignment then
  begin
    FAllignment := Value;
  end;
end;

procedure TDCEditButton.SetButtonState(Value:TButtonState);
begin
  if Assigned(FOnSetButtonState) then FOnSetButtonState(Self, Value);
  if Value <> FButtonState then
  begin
    FButtonState := Value;
    if FDownClick and (FButtonState <> btDownMouseInRect) then FDownButton := False;
  end;
end;

procedure TDCEditButton.SetMouseInControl(Value:boolean);
begin
  if Value <>  FMouseInControl then
  begin
    if not Value then FButtonState := btRest;
    FMouseInControl := Value;
  end;
end;

procedure TDCEditButton.SetCanvas(Value:TCanvas);
begin
  FCanvas := Value;
end;

procedure TDCEditButton.SetEnabled(const Value: boolean);
begin
  if Value <> FEnabled then
  begin
    FEnabled := Value;
    Paint;
  end;
end;

{ TDCEditButtons }

function TDCEditButtons.AddButton: TDCEditButton;
 var
  Button: TDCEditButton;
  AIndex: integer;
begin
  Button := TDCEditButton.Create(FOwner);
  AIndex := FButtons.Add(Button);
  Button.Name  := Format('%s%d', [Button.Name,AIndex]);
  Button.Glyph := nil;
  Button.Grouped  := True;
  Button.AnchorStyle := AnchorStyle;
  Button.AbsolutePos := AbsolutePos;
  Button.Images      := FImages;
  Button.FIndex      := AIndex;
  Button.FEditButtons:= Self;
  Button.BrushColor  := FColor;

  Result := Button;
end;

procedure TDCEditButtons.Clear;
 var
  i: integer;
begin
  for i := 0 to FButtons.Count-1 do
    TDCEditButton(FButtons.Items[i]).Free;
  FButtons.Clear;
end;

procedure TDCEditButtons.ClrWndProc;
begin
  if not FProcClear and Assigned(FDefWndProc) then
  begin
    FProcClear := True;
    if (FOwner <> nil) then
      SetWindowLong(FOwner.Handle, GWL_WNDPROC, LongInt(FDefWndProc));
  end;
end;

constructor TDCEditButtons.Create(AOwner: TWinControl);
begin
  inherited Create;
  FOwner   := AOwner;
  FButtons := TList.Create;

  FMouseInControl := False;
  FPaintOnSizing  := True;
  FMouseDown   := False;
  FAbsolutePos := True;
  FActiveButton:= nil;

  FProcClear  := True;
  FNewWndProc := MakeObjectInstance(EditWndProc);
  FUpdateCount:= 0;
end;

procedure TDCEditButtons.DefineProperties(Filer: TFiler);
  function WriteButtons: Boolean;
  var
    I: Integer;
    Items: TDCEditButtons;
  begin
    Items := TDCEditButtons(Filer.Ancestor);
    if Items = nil then
      Result := Count > 0
    else if Items.Count <> Count then
      Result := True
    else
    begin
      Result := False;
      for I := 0 to Count - 1 do
      begin
        Result := not Buttons[I].IsEqual(Items.Buttons[I]);
        if Result then Break;
      end
    end;
  end;

begin
  inherited DefineProperties(Filer);
  Filer.DefineBinaryProperty('Data', ReadData, WriteData, WriteButtons);
end;

procedure TDCEditButtons.DeleteButton(Index: integer);
begin
  TDCEditButton(FButtons.Items[Index]).Free;
  FButtons.Delete(Index);
  UpdateIndex;
end;

destructor TDCEditButtons.Destroy;
begin
  ClrWndProc;
  FreeObjectInstance(FNewWndProc);
  Clear;
  FButtons.Free;
  inherited;
end;

procedure TDCEditButtons.EditWndProc(var Message: TMessage);
 var
  lInherited: boolean;
  Pos: TPoint;
  WndPos: TWindowPos;
  Offset: TPoint;
  Button: TDCEditButton;
begin
  lInherited := True;

  try
    with Message do
    begin
      case Msg of
        WM_NCHITTEST:
          begin
           if not(csDesigning in FOwner.ComponentState) then
           begin
             GetCursorPos(Pos);
             if MouseInButtonArea(Pos.X, Pos.Y, Button) then
             begin
               lInherited := False;
               Message.Result := HTCLIENT;
             end;
           end;
          end;
        WM_DESTROY:
         ClrWndProc;
        WM_WINDOWPOSCHANGED:
         begin
           WndPos := PWindowPos(Message.LParam)^;
           if WndPos.Flags = SWP_SHOWWINDOW then RepaintButtons;
         end;
        WM_WINDOWPOSCHANGING:
         begin
           WndPos := PWindowPos(Message.LParam)^;
           if (WndPos.CX <> 0) or (WndPos.CY <> 0)
           then begin
             Offset := Point(WndPos.CX-FOwner.Width, WndPos.CY-FOwner.Height);
             if (Offset.X <> 0) or (Offset.Y <> 0) then
                OffsetButtons(Offset);
           end;
         end;
        WM_NCPAINT:
         begin
           lInherited :=  False;
           Result := CallWindowProc(FDefWndProc, FOwner.Handle, Msg, WParam, LParam);
           if PaintOnSizing then RepaintButtons(HRGN(WParam));
         end;
        WM_PAINT:
         begin
           lInherited :=  False;
           Result := CallWindowProc(FDefWndProc, FOwner.Handle, Msg, WParam, LParam);
           RepaintButtons;
         end;
        WM_ERASEBKGND:
           if PaintOnSizing then UpdateDeviceRegion(HDC(WParam));
        WM_MOUSEMOVE, WM_NCMOUSEMOVE:
         begin
           GetCursorPos(Pos);
           UpdateButtonsOnClick(Pos.X, Pos.Y, True);
         end;
        WM_LBUTTONDOWN, WM_LBUTTONDBLCLK,
        WM_NCLBUTTONDOWN, WM_NCLBUTTONDBLCLK:
         begin
           if not(csDesigning in FOwner.ComponentState) then
           begin
             GetCursorPos(Pos);
             if MouseInButtonArea(Pos.X, Pos.Y, Button) then
             begin
               FMouseDown := True;
               lInherited := False;
               Result := CallWindowProc(FDefWndProc, FOwner.Handle, Msg, WParam, LParam);
             end;
             UpdateButtonsOnClick(Pos.X, Pos.Y, False);
           end;
         end;
        WM_LBUTTONUP, WM_NCLBUTTONUP:
         begin
           FMouseDown := False;
           GetCursorPos(Pos);
           if MouseInButtonArea(Pos.X, Pos.Y, Button) then
           begin
             Result := CallWindowProc(FDefWndProc, FOwner.Handle, Msg, WParam, LParam);
             lInherited := False;
           end;
           UpdateButtonsOnClick(Pos.X, Pos.Y, False);
         end;
      end;
      if lInherited then
        Result := CallWindowProc(FDefWndProc, FOwner.Handle, Msg, WParam, LParam);
    end;
  except
    {}
  end;
end;

function TDCEditButtons.FindButton(AName: string): TDCEditButton;
 var
  i: integer;
begin
  Result := nil;
  for i := 0 to FButtons.Count-1 do
  begin
    if AnsiCompareText(AName, TDCEditButton(FButtons.Items[i]).Name) = 0 then
    begin
      Result := TDCEditButton(FButtons.Items[i]);
      Break;
    end;
  end;
end;

function TDCEditButtons.GetButton(Index: integer): TDCEditButton;
begin
  Result := TDCEditButton(FButtons.Items[Index]);
end;

function TDCEditButtons.GetButtonsRect: TRect;
 var
  i: integer;
  Button: TDCEditButton;
  R: TRect;
begin
  SetRectEmpty(Result);
  for i := 0 to Count-1 do
  begin
    Button := Buttons[i];
    with Button do
      if Visible then begin
        R := Rect(Left, Top, Left+Width, Top+Height);
        UnionRect(Result,Result,R);
      end;
  end;
end;

function TDCEditButtons.GetCount: integer;
begin
  Result := FButtons.Count;
end;

function TDCEditButtons.GetEnabled: boolean;
 var
  i: integer;
begin
  Result := False;
  for i := 0 to Count-1 do
  begin
    if Result then Break;
    Result := Buttons[i].Enabled;
  end;
end;

procedure TDCEditButtons.Invalidate;
begin
  RepaintButtons;
end;

function TDCEditButtons.MouseInButtonArea(XPos, YPos: integer; var Button: TDCEditButton): boolean;
 var
  i, X, Y: integer;
  P: TPoint;
begin
  Result := False;
  for i := 0 to Count-1 do
  begin
    if Buttons[i].AbsolutePos then
    begin
      P := Point(FOwner.Left,FOwner.Top);
      X := XPos - P.X;
      Y := YPos - P.Y;
    end
    else begin
      P := FOwner.ScreenToClient(Point(XPos, YPos));
      X := P.X;
      Y := P.Y;
    end;
    Result := Buttons[i].MouseInRect(X, Y);
    if Result then begin
      Button := Buttons[i];
      Break;
    end;
  end;
end;

procedure TDCEditButtons.MoveButton(CurIndex, NewIndex: integer);
begin
  FButtons.Move(CurIndex, NewIndex);
  UpdateIndex;
end;

procedure TDCEditButtons.OffsetButtons(Pos: TPoint);
 var
  i: integer;
  Button: TDCEditButton;
begin
  for i := 0 to Count-1 do
  begin
     Button := Buttons[i];
     with Button do
       case AnchorStyle of
         asNone:;
         asTR  :
           SetBounds(Rect(Left+Pos.X, Top, Width, Height));
         asBL  :
           SetBounds(Rect(Left, Top+Pos.Y, Width, Height));
         asBR  :
           SetBounds(Rect(Left+Pos.X, Top+Pos.Y, Width, Height));
         asTBL :
           SetBounds(Rect(Left, Top, Width, Height+Pos.Y));
         asTBR :
           SetBounds(Rect(Left+Pos.X, Top, Width, Height+Pos.Y));
         asTBLR:
           SetBounds(Rect(Left, Top, Width+Pos.X, Height+Pos.Y));
         asTLR :
           SetBounds(Rect(Left, Top, Width+Pos.X, Height));
         asBLR :
           SetBounds(Rect(Left, Top+Pos.Y, Width+Pos.X, Height));
         asTCn:
           SetBounds(Rect(Left+Pos.X div 2, Top, Width, Height));
         asCnR:
           SetBounds(Rect(Left+Pos.X, Top + Pos.Y div 2, Width, Height));
       end;
     if FPaintOnSizing then Button.Paint;
  end;
end;

procedure TDCEditButtons.ReadData(Stream: TStream);
var
  I, Count: Integer;
  ButtonInfo: TButtonInfo;
  Button: TDCEditButton;
begin
  Stream.ReadBuffer(Count, SizeOf(Count));
  for I := 0 to Count - 1 do
  begin
    Button := AddButton;
    Button.ReadData(Stream, @ButtonInfo);
  end;
end;

procedure TDCEditButtons.WriteData(Stream: TStream);
var
  i: Integer;
  ButtonInfo: TButtonInfo;
begin
  i := Count;
  Stream.WriteBuffer(i, SizeOf(Integer));
  for i :=0 to Count-1 do
    Buttons[i].WriteData(Stream, @ButtonInfo);
end;

procedure TDCEditButtons.RepaintButtons(Clip: HRGN =0);
 var
  i: integer;
  Button: TDCEditButton;
begin
  if FUpdateCount = 0 then
  begin
    for i := 0 to Count-1 do
    begin
      Button := Buttons[i];
      Button.Paint(Clip);
    end;
  end;
  //if ActiveButton <> nil then ActiveButton.DrawHint(0);
end;

procedure TDCEditButtons.ResetProperties;
 var
  i: integer;
begin
  for i := 0 to Count-1 do Buttons[i].ResetProperties;
  ActiveButton := nil;
end;

procedure TDCEditButtons.SetButton(Index: integer;
  const Value: TDCEditButton);
begin
  FButtons.Items[Index] := Value;
end;

procedure TDCEditButtons.SetEnabled(const Value: boolean);
 var
  i: integer;
begin
  for i := 0 to Count-1 do Buttons[i].Enabled := Value;
end;

procedure TDCEditButtons.SetImages(const Value: TImageList);
 var
  i: integer;
begin
  FImages := Value;
  for i := 0 to Count-1 do
    Buttons[i].Images := Value;
  RepaintButtons;
end;

procedure TDCEditButtons.SetWndProc;
begin
  if not Assigned(FDefWndProc) then
     FDefWndProc := Pointer(GetWindowLong(FOwner.Handle, GWL_WNDPROC));
  SetWindowLong(FOwner.Handle, GWL_WNDPROC, LongInt(FNewWndProc));
  FProcClear := False;
end;

function TDCEditButtons.UpdateButtons(XPos, YPos: integer; ADown, AMove: boolean): boolean;
 var
  X, Y, i: integer;
  AActiveButton: TDCEditButton;
  P: TPoint;
begin
  Result := False;
  if (csDesigning in FOwner.ComponentState) or (Count =0 ) then  Exit;
  AActiveButton := FActiveButton;
  FActiveButton := nil;
  for i := 0 to Count-1 do
  begin
    if Buttons[i].AbsolutePos then
    begin
      P := Point(FOwner.Left, FOwner.Top);
      X := XPos - P.X;
      Y := YPos - P.Y;
    end
    else begin
      P := FOwner.ScreenToClient(Point(XPos, YPos));
      X := P.X;
      Y := P.Y;
    end;
    if Buttons[i].MouseInRect(X, Y) then FActiveButton := Buttons[i];
    Result := Buttons[i].UpdateButtonState(X, Y, ADown, AMove);
  end;

  if (FActiveButton <> nil) and
     ((AActiveButton <> nil) and (FActiveButton.Index <> AActiveButton.Index) or
      (AActiveButton = nil)) then
    FActiveButton.DrawHint(0);

  if (FActiveButton = nil) and (AActiveButton <> nil) then
    AActiveButton.DrawHint(1);
end;

function TDCEditButtons.UpdateButtonsOnClick(X, Y: integer; AMove: boolean): boolean;
 var
  ButtonUpdate: boolean;
  Button: TDCEditButton;
begin
  Result := False;
  if FOwner = nil then Exit;
  if Count > 0 then
  begin
    ButtonUpdate := UpdateButtons(X, Y, FMouseDown, AMove);
    if ButtonUpdate and MouseInButtonArea(X, Y, Button) then Result := True
  end;
end;

procedure TDCEditButtons.UpdateDeviceRegion(DC: HDC);
 var
  i: integer;
  Button: TDCEditButton;
  HP: TPoint;
  HC: TRect;
begin
  HP := Point(0,0);
  with FOwner do
  begin
    HP := ClientToScreen(Point(0,0));
    GetWindowRect(Handle, HC);
    HP.X := HP.X - HC.Left;
    HP.Y := HP.Y - HC.Top;
  end;

  for i := 0 to Count-1 do
  begin
    Button := Buttons[i];
    with Button do
      if Visible then ExcludeClipRect(DC, Left-HP.X, Top-HP.Y, Left+Width-HP.X,
        Top+Height-HP.Y);
  end;
end;

procedure TDCEditButtons.UpdateIndex;
 var
  i: integer;
begin
  for i:=0 to FButtons.Count-1 do
    TDCEditButton(FButtons[i]).FIndex := i;
end;

procedure TDCEditButtons.UpdateMouseInControl(Value: boolean);
 var
  i: integer;
begin
  if (FMouseInControl <> Value) then
  begin
    FMouseInControl := Value;
    for i := 0 to FButtons.Count-1 do Buttons[i].MouseInControl := Value;
  end;
end;

procedure TDCEditButton.SetVisible(const Value: boolean);
 var
  R: TRect;
begin
  if FVisible <> Value then
  begin
    FVisible := Value;
    if Value then
      FWidth := FVisibleWidth
    else begin
      FVisibleWidth := FWidth;
      FWidth := 0;
    end;
    R := Rect(FLeft, FTop, FLeft+FWidth, FTop+FHeight);
    if FOwner.HandleAllocated then
      InvalidateRect(FOwner.Handle, @R, not FVisible);
  end;
end;

function TDCEditButton.GetWidth: integer;
begin
  if Visible then
    Result := FWidth
  else
    Result := FVisibleWidth;
end;

procedure TDCEditButton.DrawHint(Mode: integer);
begin
  if Assigned(FOnDrawHint) then FOnDrawHint(Self, Mode);
end;

procedure TDCEditButton.SetImages(const Value: TImageList);
begin
  FImages   := Value;
  FTextSize := GetTextSize;
  Paint;
end;

procedure TDCEditButton.SetImageIndex(const Value: integer);
begin
  FImageIndex := Value;
  Paint;
end;

function TDCEditButton.GetGlyphHeight: integer;
begin
  if (AsignedImages) and (FImageIndex <> -1) then
    Result := FImages.Height
  else begin
    Result := FGlyph.Height;
  end
end;

function TDCEditButton.GetGlyphWidth: integer;
begin
  if (AsignedImages) and (FImageIndex <> -1) then
    Result := FImages.Width
  else
    Result := FGlyph.Width;
end;

function TDCEditButton.AsignedImages: boolean;
begin
  Result := Assigned(Images) and FGlyph.Empty;
end;

function TDCEditButton.GetImageRect: TRect;
 var
  Pos, ATextSize: TPoint;
  DrawRectX: integer;
  TextOffs: integer;
begin
  if (GetGlyphWidth = 0) or (GetGlyphHeight = 0) then
  begin
    Result := Rect(ButtonOffset, ButtonOffset, ButtonOffset, ButtonOffset);
    Exit;
  end;

  if not DrawText or (Caption = '') then
    ATextSize := Point(0, 0)
  else
    ATextSize := FTextSize;

  if (ATextSize.X = 0) or (GetGlyphWidth = 0) then
    TextOffs := 0
  else
    TextOffs := TextBtnOffset;

  case FAllignment of
     abLeft :
       begin
         Pos.X := ButtonOffset;
         Pos.Y := (FHeight-GetGlyphHeight) div 2;
       end;
     abRight:
       begin
         Pos.X := FWidth-GetGlyphWidth - ButtonOffset;
         Pos.Y := (FHeight-GetGlyphHeight) div 2;
       end;
     abCentr:
       begin
         DrawRectX := GetGlyphWidth+ATextSize.X+(2*ButtonOffset+TextOffs);
         if DrawRectX >= FWidth
            then Pos.X := ButtonOffset
            else Pos.X := ButtonOffset+ (FWidth-GetGlyphWidth-ATextSize.X-
                                   (2*ButtonOffset+TextOffs)) div 2;
         Pos.Y := (FHeight-GetGlyphHeight) div 2;
       end;
     abImageTop:
       begin
         Pos.X := ButtonOffset+(FWidth-GetGlyphWidth-2*ButtonOffset) div 2;
         Pos.Y :=ButtonOffset +
            (FHeight-GetGlyphHeight-ATextSize.Y-
            (2*ButtonOffset+TextOffs)) div 2;
       end;
     abImageBottom:
       begin
         Pos.X := ButtonOffset+(FWidth-GetGlyphWidth-2*ButtonOffset) div 2;
         Pos.Y :=ButtonOffset + ATextSize.Y + TextOffs+
            (FHeight-GetGlyphHeight-ATextSize.Y-
            (2*ButtonOffset+TextOffs)) div 2;
       end;
  end;
  Result := Rect(0, 0, GetGlyphWidth, GetGlyphHeight);
  OffsetRect(Result, Pos.X, Pos.Y);

end;

function TDCEditButton.GetTextRect(IRect: TRect): TRect;
 var
  TextOffs: integer;
begin
  if (FTextSize.X = 0) or (GetGlyphWidth=0) then
    TextOffs := 0
  else
    TextOffs := TextBtnOffset;

  case FAllignment of
    abLeft, abRight, abCentr:
      begin
        case FAllignment of
          abLeft : Result := Rect(IRect.Right+TextOffs, 0, IRect.Right+TextOffs+FTextSize.X, Height);
          abRight: Result := Rect(ButtonOffset, 0, IRect.Left-TextOffs, Height);
          abCentr: Result := Rect(IRect.Right+TextOffs, 0, FWidth-ButtonOffset, Height);
        end;
        if (Result.Bottom-Result.Top) > FTextSize.Y then
        begin
          Result.Top    := (Result.Bottom+Result.Top-FTextSize.Y)shr 1;
          Result.Bottom := Result.Top + FTextSize.Y;
        end;
      end;
    abImageTop:
      begin
        Result := Rect(ButtonOffset, IRect.Bottom+TextOffs, FWidth-ButtonOffset, FHeight);
        if (Result.Right-Result.Left) > FTextSize.X then
        begin
          Result.Left    := (Result.Right+Result.Left-FTextSize.X)shr 1;
          Result.Right   := Result.Left + FTextSize.X;
        end;
      end;
    abImageBottom:
      begin
        Result := Rect(ButtonOffset, 0, FWidth-ButtonOffset, IRect.Left-TextOffs);
        if (Result.Right-Result.Left) > FTextSize.X then
        begin
          Result.Left    := (Result.Right+Result.Left-FTextSize.X)shr 1;
          Result.Right   := Result.Left + FTextSize.X;
        end;
      end;
  end;
  OffsetRect(Result, 1, 1);
  Inflaterect(Result, 1, 1);
end;

function TDCEditButton.GetTextSize: TPoint;
 var
  ARect: TRect;
begin
  UserBitmap.Canvas.Font   := FFont;
  if FHighlight then
    Result := DrawHighLightText(UserBitmap.Canvas, PChar(FText), Rect(0,0,0,0), 0,
      DT_END_ELLIPSIS, FImages)
  else begin
    ARect := Rect(0,0, 500, 500);
    Windows.DrawText(UserBitmap.Canvas.Handle, PChar(FText), Length(FText),
      ARect, DT_END_ELLIPSIS or DT_CALCRECT);
    Result :=  Point(ARect.Right - ARect.Left, ARect.Bottom - ARect.Top);
  end;
end;

procedure TDCEditButton.SetFont(const Value: TFont);
begin
  FFont.Assign(Value);
  FTextSize := GetTextSize;
end;

function TDCEditButton.GetImageOffset: TPoint;
begin
  if (FButtonState = btDownMouseInRect) and
     not((FStyle = stAssist) or (FStyle = stShadowFlat) or (FStyle = stSelect) or
         (FStyle = stNone) or (FStyle = stIcon))
  then
    Result := Point(1, 1)
  else
    Result := Point(0, 0);
end;

function TDCEditButton.GetTextOffset: TPoint;
begin
  if (FButtonState = btDownMouseInRect) and
     not((FStyle = stAssist) or (FStyle = stShadowFlat) or (FStyle = stSelect) or
         (FStyle = stNone) or
         (FStyle = stOutBar) and (FEventStyle <> esDropDown) or
         (FStyle = stIcon))
  then
    Result := Point(1, 1)
  else
    Result := Point(0, 0);
end;

procedure TDCEditButton.Invalidate;
begin
  Paint;
end;

function TDCEditButton.IsEqual(Button: TDCEditButton): Boolean;
begin
  Result := (Text = Button.Text) and (ImageIndex = Button.ImageIndex);
end;

procedure TDCEditButton.ReadData(Stream: TStream; Info: PButtonInfo);
 var
  Size, ALen: LongWord;
  AText: PChar;
  ACLen, AHLen: LongWord;
begin

  Stream.ReadBuffer(Size, SizeOf(Size));
  Stream.ReadBuffer(ALen, SizeOf(Integer));
  Stream.ReadBuffer(Info^, Size);

  ACLen := ALen and $0000FFFF;
  AHLen := (ALen shr 16) and $0000FFFF;

  Tag          := Info^.Tag;
  ImageIndex   := Info^.ImageIndex;
  Enabled      := Info^.Enabled;
  Top          := Info^.Top;
  Left         := Info^.Left;
  Width        := Info^.Width;
  Height       := Info^.Height;
  Allignment   := TAllignment(Info^.Allignment);
  Style        := TButtonStyle(Info^.Style);
  EventStyle   := TEventStyle(Info^.EvtStyle);
  Grouped      := Info^.Grouped;
  AnchorStyle  := TAnchorStyle(Info^.AncStyle);
  DisableStyle := TDisableStyle(Info^.DisStyle);
  AbsolutePos  := Info^.AbsolutePos;
  ResetOnExitControl  := Info^.ResetOnExit;

  GetMem(AText, ACLen);
  try
    Stream.ReadBuffer(AText^, ACLen);
    Text := AText;
  finally
    FreeMem(AText);
  end;

  if AHLen > 0 then
  begin
    GetMem(AText, AHLen);
    try
      Stream.ReadBuffer(AText^, AHLen);
      Hint := AText;
    finally
      FreeMem(AText);
    end;
  end
  else
    Hint := ''
end;

procedure TDCEditButton.WriteData(Stream: TStream; Info: PButtonInfo);
 var
   Size, ALen: LongWord;
   AText: PChar;
   ACLen, AHLen: LongWord;
begin
  Size := SizeOf(TButtonInfo);

  ACLen := (Length(Text) + 1) and $0000FFFF;

  if Hint <> '' then
    AHLen := (Length(Hint) + 1) and $0000FFFF
  else
    AHLen :=  0;
  ALen  := AHLen shl 16 + ACLen;

  Info^.Tag        := Tag;
  Info^.ImageIndex := ImageIndex;
  Info^.Enabled    := Enabled;
  Info^.Top        := Top;
  Info^.Left       := Left;
  Info^.Width      := Width;
  Info^.Height     := Height;
  Info^.Allignment := integer(Allignment);
  Info^.Style      := integer(Style);
  Info^.EvtStyle   := integer(EventStyle);
  Info^.Grouped    := Grouped;
  Info^.AncStyle   := integer(AnchorStyle);
  Info^.DisStyle   := integer(DisableStyle);
  Info^.AbsolutePos:= AbsolutePos;
  Info^.ResetOnExit:= ResetOnExitControl;

  Stream.WriteBuffer(Size , SizeOf(Size));
  Stream.WriteBuffer(ALen , SizeOf(Integer));
  Stream.WriteBuffer(Info^, Size);

  GetMem(AText, ACLen);
  try
    StrPCopy(AText, Text);
    Stream.WriteBuffer(AText^ , ACLen);
  finally
    FreeMem(AText);
  end;

  if AHLen > 0 then
  begin
    GetMem(AText, AHLen);
    try
      StrPCopy(AText, Hint);
      Stream.WriteBuffer(AText^ , AHLen);
    finally
      FreeMem(AText);
    end;
  end;
end;

function TDCEditButtons.GetRegion: HRGN;
 var
  Rgn: HRGN;
begin
  if Assigned(FOnGetRegion) then
    FOnGetRegion(Self, Rgn)
  else
    Rgn := 0;
  Result := Rgn;
end;

function TDCEditButton.GetBounds: TRect;
begin
  Result := Rect(0, 0, Width, Height);
  OffsetRect(Result, Left, Top);
end;

procedure TDCEditButton.Click;
begin
  if Assigned(FEditButtons) then FEditButtons.ActiveButton := TDCEditButton(Self);
  if Assigned(FOnClick) then FOnClick(Self);
end;

procedure TDCEditButton.SetWidth(const Value: integer);
begin
  if Visible then
    FWidth := Value
  else
    FVisibleWidth := Value;  
end;

procedure TDCEditButtons.SetColor(const Value: TColor);
 var
  i: integer;
  Button: TDCEditButton;
begin
  for i := 0 to FButtons.Count-1 do
  begin
    Button := TDCEditButton(Items[i]);
    if Button.BrushColor = FColor then Button.BrushColor := Value; 
  end;
  FColor := Value;
end;

function TDCEditButtons.IsButtonAccel(VK: Word;
  var Button: TDCEditButton): Boolean;
 var
  i: integer;
  eButton: TDCEditButton;
begin
  Result := False;
  Button := nil;
  for i := 0 to FButtons.Count - 1 do
  begin
    eButton := TDCEditButton(FButtons[i]);
    if eButton.Enabled and eButton.Visible and IsAccel(VK, eButton.Caption) then
    begin
      Button := TDCEditButton(FButtons[i]);
      Result := True;
      Break;
    end;
  end;
end;

function TDCEditButtons.GetSelectedButton: TDCEditButton;
 var
  Button: TDCEditButton;
  i: integer;
begin
  Result := ActiveButton;
  if (Result <> nil) and (Result.ButtonState <> btDownMouseInRect) then
  begin
    Result := nil;
    for i := 0 to Count - 1 do
    begin
      Button := Buttons[i];
      if Button.ButtonState = btDownMouseInRect then
      begin
        Result := Button;
        Break;
      end;
    end;
  end;
end;

procedure TDCEditButton.SetHighlight(const Value: boolean);
begin
  if Value <> FHighlight then
  begin
    FHighlight := Value;
    FTextSize  := GetTextSize;
    Invalidate;
  end;
end;

procedure TDCEditButton.SetDownClick(const Value: boolean);
begin
  if not FDownClick and (ButtonState <> btDownMouseInRect) then FDownButton:= False;
  if Value and (FEventStyle = esDropDown) and
     (ButtonState = btDownMouseInRect) then FDownButton:= True;
  FDownClick  := Value;
end;

procedure TDCEditButtons.SetActiveButton(const Value: TDCEditButton);
begin
  FActiveButton := Value;
end;

procedure TDCEditButtons.BeginUpdate;
begin
  Inc(FUpdateCount);
end;

procedure TDCEditButtons.EndUpdate;
begin
  Dec(FUpdateCount);
  if FUpdateCount = 0 then RepaintButtons;
end;

initialization
 UserBitmap      := TBitmap.Create;
 GlypBitmap      := TBitmap.Create;
 GlypBitmap.Transparent := True;
 ShortDateFormat := 'dd.mm.yyyy';

finalization
 UserBitmap.Free;
 GlypBitmap.Free;

end.

