{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCCapProp;

interface

uses DsgnIntf, Dialogs;

type

{ THintProperty }
  TCapProperty = class(TCaptionProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    function GetEditLimit: Integer; override;
    procedure Edit; override;
  end;

{TCaptionProperty}
  TCapEditor = class(TDefaultEditor)
  protected
    procedure EditProperty(PropertyEditor: TPropertyEditor;
      var Continue, FreeEditor: Boolean); override;
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

implementation

uses SysUtils, Classes, TypInfo, Forms, Controls,
     DCCapEdit;

procedure EditCapProperty(PropertyEditor: TPropertyEditor);
var
  PropName, Temp: string;
  Comp: TPersistent;
begin
  PropName := PropertyEditor.GetName;
  with TStringEditDlg.Create(Application) do
  begin
    try
      with PropertyEditor do
      begin
        Comp := GetComponent(0);
        if Comp is TComponent then
          Caption := TComponent(Comp).Name + '.' + GetName
        else Caption := GetName;
        Temp := Value;
        Memo.Text := Temp;
        Memo.MaxLength := GetEditLimit;
        UpdateStatus(nil);
        if ShowModal = mrOk then begin
          Temp := Memo.Text;
          while (Length(Temp) > 0) and (Temp[Length(Temp)] < ' ') do
            System.Delete(Temp, Length(Temp), 1);
          Value := Temp;
        end;
      end;
    finally
      Free;
    end;
  end;
end;


function TCapProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog];
end;

function TCapProperty.GetEditLimit: Integer;
begin
  if GetPropType^.Kind = tkString then
    Result := GetTypeData(GetPropType)^.MaxLength
  else Result := 1024;
end;

procedure TCapProperty.Edit;
begin
  EditCapProperty(Self);
end;

{ TCapEditor }

procedure TCapEditor.EditProperty(PropertyEditor: TPropertyEditor;
  var Continue, FreeEditor: Boolean);
var
  PropName: string;
begin
  PropName := PropertyEditor.GetName;
  if (CompareText(PropName, 'CAPTION') = 0) then
  begin
    EditCapProperty(PropertyEditor);
    Continue := False;
  end;
end;

procedure TCapEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 0 then Edit;
end;

function TCapEditor.GetVerb(Index: Integer): string;
begin
  if Index = 0 then
    Result := '&Caption Editor ...'
  else Result := '';
end;

function TCapEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

end.