{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCCalendar;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  ExtCtrls, DCEditButton, DCEditTools, DCPopupWindow, DCConst;

type
  TDCCustomCalendar = class(TDCPopupWindow)
  private
    { Private declarations }
    FBtnNextYear, FBtnPrevYear  : TDCEditButton;
    FBtnNextMonth, FBtnPrevMonth: TDCEditButton;
    FBtnToday, FBtnCancel: TDCEditButton;
    FMouseDown: boolean;
    { calendar grid property}
    FFirstDay: integer;
    FDate: TDateTime;
    FPoint: TPoint;
    FDatePoint: TPoint;
    FCloseUp: TCloseUpEvent;
    FCloseState: byte;
    FTimer: TTimer;
    FOnTimer: boolean;
    FBorderSize: integer;
    FBrushColor: TColor;
    FHeaderHeight: integer;
    FFooterHeight: integer;
    { Private methods }
    procedure GetFirstDate;
    function DaysThisMonth: Integer;
    function GetDateElement(Index: Integer): Integer;
    { Date functions }
    procedure ChangeDay(Delta: Integer);
    procedure ChangeMonth(Delta: Integer);
    procedure ChangeYear(Delta: Integer);
    { Component Size functions}
    function GetGridSize: TPoint;
    { Draw functions}
    procedure DrawCalendarGrid;
    procedure DrawMonthYear;
    procedure DrawDaysOfWeek;
    procedure DrawButtons;
    procedure DrawCellBorder(ACol,ARow: integer; BorderStyle: TEdgeStyle);
    procedure DrawCell(ARect: TRect; ACol, ARow: integer; BorderStyle: TEdgeStyle);
    procedure UpdateDatePos;
    procedure PaintButtons;

    function GetTextCell(ACol,ARow: integer): integer;
    function GetRectCell(ACol,ARow: integer): TRect;
    function GetCellForPoint(X,Y: integer): TPoint;
    function GetCellForDay(Day: integer): TPoint;
    function GetCellForDate(dDate: TDateTime): TPoint;
    //function GetTextForPoint(X,Y: integer): integer;
    {Mouse functions}
    procedure MouseCellMove(APoint, BPoint: TPoint);
    {}
    procedure NextMonthClick(Sender: TObject);
    procedure NextYearClick(Sender: TObject);
    procedure PrevMonthClick(Sender: TObject);
    procedure PrevYearClick(Sender: TObject);
    procedure TodayClick(Sender: TObject);
    procedure CancelClick(Sender: TObject);

    {HideCalendar}
    procedure CloseUp(State: Byte); virtual;
    procedure UpdateEditButtonsState(X, Y: integer; lMove: boolean);
    procedure TimerEvent(Sender: TObject);

    procedure SetColor(const Value: TColor);
    procedure UpdateSize;
  protected
    procedure CreateButtons;
    function DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    function DoMouseWheelUp(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    procedure WMSize(var Message: TWMSize);
    procedure WMPaint (var Message: TMessage); message WM_PAINT;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonDblClk(var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
    procedure WMLButtonUp(var Message: TWMLButtonUp); message WM_LBUTTONUP;
    procedure WMMouseMove(var Message: TWMMouseMove); message WM_MOUSEMOVE;
    procedure WndProc(var Message: TMessage); override;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
  published
    { Published declarations }
    property OnCloseUp: TCloseUpEvent read FCloseUp write FCloseUp;
    property Date: TDateTime read FDate write FDate;
    property BrushColor: TColor read FBrushColor write SetColor;
  end;

function PointInRect(const P: TPoint; const R: TRect): boolean;

implementation
uses DCResource;

function PointInRect(const P: TPoint; const R: TRect): boolean;
begin
  with R do
    Result := (Left <= P.X) and (Top <= P.Y) and
      (Right >= P.X) and (Bottom >= P.Y);
end;

function ZerroInPoint(const P: TPoint): boolean;
begin
  Result := ( P.X = 0 ) or ( P.Y = 0 );
end;

function EquPoints(APoint, BPoint: TPoint): boolean;
begin
  Result := ( APoint.X = BPoint.X ) and ( APoint.Y = BPoint.Y );
end;

constructor TDCCustomCalendar.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  FBrushColor :=  $00EFFFFF;
  Parent := TWinControl(AOwner);
  PopupAlignment := wpBottomRight;
  Color  := FBrushColor;
  Canvas.Font := Font;

  FDate := SysUtils.Date;
  FMouseDown := False;

  FBorderSize := 2;

  UpdateSize;
  
  GetFirstDate;
  CreateButtons;
  DrawButtons;

  FCloseState := 100;
  FOnTimer := False;

  ShowHint       := False;
  ParentShowHint := False;
end;

procedure TDCCustomCalendar.WMPaint (var Message: TMessage);
 var
  R: TRect;
  xDate:string;
begin
  inherited;
  R := Rect(0,0,ClientWidth,ClientHeight);

  DrawEdge(Canvas.Handle, R, BDR_RAISEDOUTER, BF_RECT);
  InflateRect(R, -1, -1);
  DrawEdge(Canvas.Handle, R, BDR_RAISEDINNER, BF_RECT);
{
  DrawEdge(Canvas.Handle, R, BDR_RAISEDOUTER, BF_TOPLEFT);
  DrawEdge(Canvas.Handle, R, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
  InflateRect(R, -1, -1);
  DrawEdge(Canvas.Handle, R, BDR_RAISEDINNER, BF_TOPLEFT);
  DrawEdge(Canvas.Handle, R, BDR_SUNKENINNER, BF_BOTTOMRIGHT);
}

  DateToStrY2K( SysUtils.Date, xDate);
  FBtnToday.Font := Font;
  FBtnToday.Caption := Format(LoadStr(RES_CALC_FMT_TODAY),[xDate]);

  DrawDaysOfWeek;
  DrawMonthYear;
  PaintButtons;
  DrawCalendarGrid;
  UpdateDatePos;
end;

procedure TDCCustomCalendar.CreateButtons;
begin

  Canvas.Font := Font;
  FBtnNextYear:= TDCEditButton.Create(Self);
  with FBtnNextYear do
  begin
    Enabled:= Self.Enabled;
    Width  := CALC_BTN_WIDTH;
    Height := CALC_BTN_WIDTH;
    Style  := stFlat;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNNEXT_2');
    BrushColor := clBtnFace;
    OnClick := NextYearClick;
  end;

  FBtnPrevYear:= TDCEditButton.Create(Self);
  with FBtnPrevYear do
  begin
    Enabled:= Self.Enabled;
    Width  := CALC_BTN_WIDTH;
    Height := CALC_BTN_WIDTH;
    Style  := stFlat;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNPREV_2');
    BrushColor := clBtnFace;
    OnClick := PrevYearClick;
  end;

  FBtnNextMonth:= TDCEditButton.Create(Self);
  with FBtnNextMonth do
  begin
    Enabled:= Self.Enabled;
    Width  := CALC_BTN_WIDTH;
    Height := CALC_BTN_WIDTH;
    Style  := stFlat;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNNEXT_1');
    BrushColor := clBtnFace;
    OnClick := NextMonthClick;
  end;

  FBtnPrevMonth:= TDCEditButton.Create(Self);
  with FBtnPrevMonth do
  begin
    Enabled:= Self.Enabled;
    Width  := CALC_BTN_WIDTH;
    Height := CALC_BTN_WIDTH;
    Style  := stFlat;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNPREV_1');
    BrushColor := clBtnFace;
    OnClick := PrevMonthClick;
  end;

  FBtnCancel:= TDCEditButton.Create(Self);
  with FBtnCancel do
  begin
    Enabled:= Self.Enabled;
    Width  := CALC_BTN_WIDTH+3;
    Height := Self.Canvas.TextHeight('Wg')+2;
    Style  := stFlat;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNCANCEL');
    BrushColor := clBtnFace;
    OnClick := CancelClick;
  end;

  FBtnToday:= TDCEditButton.Create(Self);
  with FBtnToday do
  begin
    Allignment := abLeft;
    Enabled:= Self.Enabled;
    Style  := stFlat;
    Glyph.LoadFromResourceName(HInstance, 'DC_BTNTODAY');
    Caption := Format(LoadStr(RES_CALC_FMT_TODAY),[DateToStr(SysUtils.Date)]);
    Width := Self.Width-2*FBorderSize-FBtnCancel.Width;
    Height:= Self.Canvas.TextHeight('Wg')+2;
    BrushColor := clBtnFace;
    OnClick := TodayClick;
  end;

end;

procedure TDCCustomCalendar.KeyDown(var Key: Word; Shift: TShiftState);
 var
  AYear, AMonth, ADay: Word;
  NYear, NMonth, NDay: Word;
begin
  DecodeDate(FDate, AYear, AMonth, ADay);

  case Key of
    VK_LEFT : ChangeDay(-1);
    VK_RIGHT: ChangeDay(+1);
    VK_UP   : ChangeDay(-7);
    VK_DOWN : ChangeDay(+7);
    {Month change}
    VK_PRIOR: ChangeMonth(-1);
    VK_NEXT : ChangeMonth(+1);
    {Year chabge}
    VK_HOME : ChangeYear(-1);
    VK_END  : ChangeYear(+1);
  end;

  DecodeDate(FDate, NYear, NMonth, NDay);
  if (NYear <> AYear) or (NMonth <> AMonth) then
  begin
    DrawMonthYear;
    DrawCalendarGrid;
  end
  else
    DrawCellBorder(FDatePoint.X,FDatePoint.Y, esNone);
  UpdateDatePos;
end;

function TDCCustomCalendar.GetDateElement(Index: Integer): Integer;
var
  AYear, AMonth, ADay: Word;
begin
  DecodeDate(FDate, AYear, AMonth, ADay);
  case Index of
    1: Result := AYear;
    2: Result := AMonth;
    3: Result := ADay;
    else Result := -1;
  end;
end;

function TDCCustomCalendar.DaysThisMonth: Integer;
begin
  Result := DaysPerMonth(GetDateElement(1), GetDateElement(2));
end;

procedure TDCCustomCalendar.GetFirstDate;
var
  AYear, AMonth, ADay: Word;
  FirstDate: TDateTime;
begin
  try
    DecodeDate(FDate, AYear, AMonth, ADay);
    FirstDate := EncodeDate(AYear, AMonth, 1);
    FFirstDay := ((DayOfWeek(FirstDate) +6) mod 7);
    if FFirstDay = 0 then FFirstDay := 7;
  finally
  end;
end;

procedure TDCCustomCalendar.ChangeDay(Delta: Integer);
begin
  FDate := FDate + Delta;
end;

procedure TDCCustomCalendar.ChangeMonth(Delta: Integer);
var
  AYear, AMonth, ADay: Word;
  NewDate: TDateTime;
  CurDay: Integer;
begin
  DecodeDate(FDate, AYear, AMonth, ADay);
  CurDay := ADay;
  if Delta > 0 then ADay := DaysPerMonth(AYear, AMonth)
  else ADay := 1;
  NewDate := EncodeDate(AYear, AMonth, ADay);
  NewDate := NewDate + Delta;
  DecodeDate(NewDate, AYear, AMonth, ADay);
  if DaysPerMonth(AYear, AMonth) > CurDay then ADay := CurDay
  else ADay := DaysPerMonth(AYear, AMonth);
  FDate := EncodeDate(AYear, AMonth, ADay);
end;

procedure TDCCustomCalendar.ChangeYear(Delta: Integer);
 var
  AYear, AMonth, ADay: Word;
begin
  DecodeDate(FDate, AYear, AMonth, ADay);
  AYear := AYear + Delta;
  FDate := EncodeDate(AYear, AMonth, ADay);
end;


function TDCCustomCalendar.GetGridSize: TPoint;
begin
  Canvas.Font := Font;
  Result.X := (2 * Canvas.TextWidth('99')) * 7;
  Result.Y := Canvas.TextHeight('99') * 6;
end;

procedure TDCCustomCalendar.DrawButtons;
begin
  with FBtnNextYear do
  begin
    Top := 1+FBorderSize; Left := Self.Width-FBorderSize-Width;
  end;
  with FBtnPrevYear do
  begin
    Top := 1+FBorderSize; Left := FBorderSize;
  end;
  with FBtnNextMonth do
  begin
    Top := 1+FBorderSize; Left:= FBtnNextYear.Left-Width;
  end;
  with FBtnPrevMonth do
  begin
    Top := 1+FBorderSize; Left := FBorderSize+FBtnPrevYear.Width;
  end;
  with FBtnToday do
  begin
    Top := Self.Height-Height-FBorderSize; Left := FBorderSize;
  end;
  with FBtnCancel do
  begin
    Top := Self.Height-Height-FBorderSize; Left := Self.Left+Self.Width-FBorderSize-Width;
  end;
end;

procedure TDCCustomCalendar.DrawCalendarGrid;
 var
  i,j: integer;
  ARect: TRect;
  Top,Left: Integer;
  AYear, AMonth, ADay: Word;
begin
  GetFirstDate;
  Canvas.Font := Font;
  Canvas.Brush.Color := FBrushColor;
  DecodeDate(FDate, AYear, AMonth, ADay);
  Top := Canvas.TextHeight('Wg')+FHeaderHeight+3+FBorderSize;
  for i := 1 to 6 do
  begin
    Left:= FBorderSize;
    for j:= 1 to 7 do
    begin
      ARect := Rect(Left+(j-1)*2*Canvas.TextWidth('99'),Top,
                    Left+j*2*Canvas.TextWidth('99'), Top+Canvas.TextHeight('99'));
      Canvas.FillRect(ARect);
      DrawCellBorder(j,i,esNone);
    end;
    Top := Top+Canvas.TextHeight('99');
  end;

end;

procedure TDCCustomCalendar.DrawMonthYear;
 var
  AYear, AMonth, ADay: Word;
  ARect, LRect, RRect: TRect;
  Text: String;
  Top,Left,Right: integer;
begin
  Canvas.Font := Font;
  Canvas.Brush.Color := clBtnFace;
  Canvas.Pen.Color   := clBtnFace;

  DecodeDate(FDate, AYear, AMonth, ADay);
  Top  := FBorderSize;
  Left := FBorderSize+FBtnPrevMonth.Left+FBtnPrevMonth.Width-2;
  Right:= FBtnNextMonth.Left;
  Text := Format('%s %d',[LongMonthNames[AMonth],AYear]);
  ARect:= Rect(Left,Top, Right,Top+FHeaderHeight);

  Canvas.FillRect(ARect);
  Canvas.MoveTo(FBorderSize, FBorderSize);
  Canvas.LineTo(ClientWidth-FBorderSize, FBorderSize);

  LRect := Rect(FBorderSize, FBtnNextMonth.Top + FBtnNextMonth.Height,
                ARect.Left, ARect.Bottom);
  RRect := Rect(ARect.Right, FBtnNextMonth.Top + FBtnNextMonth.Height,
                ClientWidth-FBorderSize, ARect.Bottom);
  Canvas.FillRect(LRect);
  Canvas.FillRect(RRect);
  ARect.Top := ARect.Top + 1;

  DrawText(Canvas.Handle, PChar(Text), Length(Text), ARect,
           DT_CENTER or DT_WORDBREAK or DT_EXPANDTABS or DT_NOPREFIX);

end;

procedure TDCCustomCalendar.DrawDaysOfWeek;
 var
  i: integer;
  ARect: TRect;
  Text: String;
  Top,Left: integer;
begin
  Canvas.Font := Font;
  Canvas.Brush.Color := FBrushColor;

  Top := 1+FBorderSize+FHeaderHeight;
  Left:= FBorderSize;
  for i:= 1 to 7 do
  begin
    ARect := Rect(Left+(i-1)*2*Canvas.TextWidth('99'),Top,
                  Left+i*2*Canvas.TextWidth('99'), Top+Canvas.TextHeight('Wg'));

    Canvas.FillRect(ARect);
    if i <> 7 then Text := ShortDayNames[i+1] else Text := ShortDayNames[1];

    DrawText(Canvas.Handle, PChar(Text), Length(Text), ARect,
             DT_CENTER or DT_WORDBREAK or DT_EXPANDTABS or DT_NOPREFIX);
  end;
  Top := Top+Canvas.TextHeight('Wg');
  ARect := Rect(Left,Top-1,Width-Left,Top+1);
  DrawEdge(Canvas.Handle, ARect, BDR_SUNKENOUTER, BF_RECT);
end;

procedure TDCCustomCalendar.DrawCellBorder(ACol,ARow: integer; BorderStyle: TEdgeStyle);
 var
  ARect: TRect;
begin
  ARect := GetRectCell(ACol,ARow);
  DrawCell(ARect, ACol, ARow, BorderStyle);
  case BorderStyle of
    esNone   :
      begin
        Canvas.Brush.Color := FBrushColor;
        Canvas.FrameRect(ARect);
      end;
    esRaised :
      begin
        Canvas.Brush.Color := clBlack;
        Canvas.FrameRect(ARect);
      end;
    esSunken :
      begin
        Canvas.Brush.Color := clBtnFace;
        Canvas.FrameRect(ARect);
      end;
  end;
end;

procedure TDCCustomCalendar.PaintButtons;
begin
  FBtnNextYear.Paint;
  FBtnPrevYear.Paint;
  FBtnNextMonth.Paint;
  FBtnPrevMonth.Paint;
  FBtnCancel.Paint;
  FBtnToday.Paint;

  Canvas.Pen.Color := clBtnFace;
  Canvas.MoveTo(FBorderSize, FBtnCancel.Top-1);
  Canvas.LineTo(ClientWidth-FBorderSize, FBtnCancel.Top-1);
end;


procedure TDCCustomCalendar.UpdateDatePos;
 var
  APoint: TPoint;
begin
  GetCursorPos(APoint);
  APoint.X := APoint.X - Self.Left;
  APoint.Y := APoint.Y - Self.Top;
  APoint:= GetCellForPoint(APoint.X,APoint.Y);
  if not ZerroInPoint(APoint) then FPoint := APoint;

  FDatePoint:= GetCellForDate(FDate);
  DrawCellBorder(FDatePoint.X,FDatePoint.Y,esSunken);
  if FMouseDown
     then FPoint := FDatePoint
     else begin
       if GetTextCell(FPoint.X,FPoint.Y) <= 0 then FPoint := Point(0,0);
       MouseCellMove(FDatePoint, FPoint);
     end;
end;

procedure TDCCustomCalendar.WMSize(var Message: TWMSize);
begin
  inherited;
  {}
end;

function TDCCustomCalendar.GetTextCell(ACol,ARow: integer): integer;
var
  DayNum: Integer;
begin
  DayNum := ACol + (ARow - 1) * 7-(FFirstDay-1);
  if (DayNum < 1) or (DayNum > DaysThisMonth)
    then Result := -1
    else Result := DayNum;
end;

function TDCCustomCalendar.GetRectCell(ACol,ARow: integer): TRect;
 var
  ARect: TRect;
begin
  Canvas.Font := Font;
  with ARect do
  begin
    Left  := FBorderSize+2*(ACol-1)*Canvas.TextWidth('99');
    Top   := Canvas.TextHeight('Wg')+FHeaderHeight+3+FBorderSize+(ARow-1)*Canvas.TextHeight('99');
    Right := Left+2*Canvas.TextWidth('99');
    Bottom:= Top+Canvas.TextHeight('99');
  end;
  Result := ARect;
end;

function TDCCustomCalendar.GetCellForPoint(X,Y: integer): TPoint;
 var
  i,j: integer;
begin
  Result := Point(0,0);
  for i := 1 to 7 do
    for j := 1 to 6 do
      if PointInRect(Point(X,Y),GetRectCell(i,j)) then
      begin
        if GetTextCell(i,j) > 0 then
           Result := Point(i,j);
        Break;
      end;
end;

{
function TDCCustomCalendar.GetTextForPoint(X,Y: integer): integer;
 var
  i,j: integer;
begin
  Result := -1;
  for i := 1 to 7 do
    for j := 1 to 6 do
      if PointInRect(Point(X,Y),GetRectCell(i,j)) then
      begin
        Result := GetTextCell(i,j);
        Break;
      end;
end;
}

function TDCCustomCalendar.GetCellForDay(Day: integer): TPoint;
begin
  Inc(Day,FFirstDay-1);
  Result.X := Day - ((Day-1) div 7)*7;
  Result.Y := (Day-1) div 7+1
end;

function TDCCustomCalendar.GetCellForDate(dDate: TDateTime): TPoint;
 var
  AYear, AMonth, ADay: Word;
begin
  DecodeDate(dDate, AYear, AMonth, ADay);
  Result := GetCellForDay(ADay);
end;

procedure TDCCustomCalendar.MouseCellMove(APoint, BPoint: TPoint);
 const
   CellBorder : array[boolean] of TEdgeStyle = (esRaised, esSunken);
begin
  if EquPoints(APoint, FDatePoint)
  then
    if FMouseDown
    then DrawCellBorder(APoint.X,APoint.Y,esNone)
    else DrawCellBorder(APoint.X,APoint.Y,esSunken)
  else
    if not ZerroInPoint(APoint)
    then DrawCellBorder(APoint.X,APoint.Y,esNone);

  if not ZerroInPoint(BPoint)
  then
    if EquPoints(BPoint, FDatePoint)
    then DrawCellBorder(BPoint.X,BPoint.Y,esSunken)
    else DrawCellBorder(BPoint.X,BPoint.Y,CellBorder[FMouseDown])
end;

procedure TDCCustomCalendar.NextMonthClick(Sender: TObject);
begin
  ChangeMonth(+1);
  DrawMonthYear;
  DrawCalendarGrid;
  UpdateDatePos;
end;

procedure TDCCustomCalendar.NextYearClick(Sender: TObject);
begin
  ChangeYear(+1);
  DrawMonthYear;
  DrawCalendarGrid;
  UpdateDatePos;
end;

procedure TDCCustomCalendar.PrevMonthClick(Sender: TObject);
begin
  ChangeMonth(-1);
  DrawMonthYear;
  DrawCalendarGrid;
  UpdateDatePos;
end;

procedure TDCCustomCalendar.PrevYearClick(Sender: TObject);
begin
  ChangeYear(-1);
  DrawMonthYear;
  DrawCalendarGrid;
  UpdateDatePos;
end;

procedure TDCCustomCalendar.TodayClick(Sender: TObject);
begin
  FDate := SysUtils.Date;
  DrawMonthYear;
  DrawCalendarGrid;
  UpdateDatePos;
  FCloseState := 1;
end;

procedure TDCCustomCalendar.CancelClick(Sender: TObject);
begin
  FCloseState := 0;
end;

procedure TDCCustomCalendar.CloseUp(State: Byte);
begin
  if Assigned(FCloseUp) then FCloseUp(State);
end;

destructor TDCCustomCalendar.Destroy;
begin
  FBtnNextYear.Destroy;
  FBtnPrevYear.Destroy;
  FBtnNextMonth.Destroy;
  FBtnPrevMonth.Destroy;
  FBtnCancel.Destroy;
  FBtnToday.Destroy;
  inherited;
end;

procedure TDCCustomCalendar.CMFontChanged(var Message: TMessage);
begin
  inherited;
  UpdateSize;
  Invalidate;
end;

procedure TDCCustomCalendar.UpdateEditButtonsState(X, Y: integer; lMove: boolean);
begin
  FBtnNextYear.UpdateButtonState(X, Y, FMouseDown, lMove);
  FBtnPrevYear.UpdateButtonState(X, Y, FMouseDown, lMove);
  FBtnNextMonth.UpdateButtonState(X, Y, FMouseDown, lMove);
  FBtnPrevMonth.UpdateButtonState(X, Y, FMouseDown, lMove);
  FBtnCancel.UpdateButtonState(X, Y, FMouseDown, lMove);
  FBtnToday.UpdateButtonState(X, Y, FMouseDown, lMove);
end;

procedure TDCCustomCalendar.WMLButtonDown(var Message: TWMLButtonDown);
 var
  ADay: integer;
  APoint: TPoint;
begin
  inherited;
  FMouseDown := True;
  UpdateEditButtonsState(Message.Pos.X, Message.Pos.Y, False);

  APoint:= GetCellForPoint(Message.Pos.X, Message.Pos.Y);
  ADay  := GetTextCell(APoint.X,APoint.Y);
  if (ADay > 0) then
  begin
    FDate := EncodeDate(GetDateElement(1),GetDateElement(2),ADay);
    FPoint     := FDatePoint;
    FDatePoint := APoint;
    MouseCellMove(FPoint, FDatePoint);
  end;

  if (FBtnNextYear.ButtonState  = btDownMouseInRect) or
     (FBtnPrevYear.ButtonState  = btDownMouseInRect) or
     (FBtnNextMonth.ButtonState = btDownMouseInRect) or
     (FBtnPrevMonth.ButtonState = btDownMouseInRect)
  then begin
    FTimer := TTimer.Create(self);
    with FTimer do
    begin
      Interval := 250;
      OnTimer  := TimerEvent;
    end;
  end;

end;

procedure TDCCustomCalendar.WMLButtonDblClk(var Message: TWMLButtonDown);
begin
  FMouseDown := True;
  UpdateEditButtonsState(Message.Pos.X, Message.Pos.Y, False);

  FTimer := TTimer.Create(self);
  with FTimer do
  begin
    Interval := 700;
    OnTimer  := TimerEvent;
  end;
end;

procedure TDCCustomCalendar.WMLButtonUp(var Message: TWMLButtonUp);
 var
  ADay: integer;
  APoint: TPoint;
begin
  inherited;
  FMouseDown := False;
  UpdateEditButtonsState(Message.Pos.X, Message.Pos.Y, False);
  APoint:= GetCellForPoint(Message.Pos.X, Message.Pos.Y);
  ADay  := GetTextCell(APoint.X,APoint.Y);

  if ((FDatePoint.X = APoint.X) and (FDatePoint.Y = APoint.Y) and
      (ADay > 0)) and (FCloseState = 100) then FCloseState := 1;

  if Assigned(FTimer) then begin
     FOnTimer := False;
     FTimer.Free;
     FTimer := nil;
  end;

  if FCloseState <> 100 then
  begin
    CloseUp(FCloseState);
  end;
end;

procedure TDCCustomCalendar.WMMouseMove(var Message: TWMMouseMove);
 var
  APoint: TPoint;
begin
  inherited;
  UpdateEditButtonsState(Message.Pos.X, Message.Pos.Y, True);

  APoint := GetCellForPoint(Message.Pos.X, Message.Pos.Y);
  if not EquPoints(APoint, FPoint) and
    ((FMouseDown and not ZerroInPoint(APoint)) or not FMouseDown) then
  begin
    if ZerroInPoint(FPoint) then FPoint := FDatePoint;
    MouseCellMove(FPoint,APoint);
    FPoint := APoint;
    if FMouseDown then FDatePoint := APoint;
  end;
end;

procedure TDCCustomCalendar.TimerEvent(Sender: TObject);
begin
  FTimer.Interval := 400;
  FOnTimer := True;
  if FBtnNextYear.ButtonState  = btDownMouseInRect then NextYearClick(Self);
  if FBtnPrevYear.ButtonState  = btDownMouseInRect then PrevYearClick(Self);
  if FBtnNextMonth.ButtonState = btDownMouseInRect then NextMonthClick(Self);
  if FBtnPrevMonth.ButtonState = btDownMouseInRect then PrevMOnthClick(Self);
end;


procedure TDCCustomCalendar.WndProc(var Message: TMessage);
begin
  inherited;
end;

procedure TDCCustomCalendar.SetColor(const Value: TColor);
begin
  FBrushColor := Value;
end;

procedure TDCCustomCalendar.UpdateSize;
 var
  Point: TPoint;
begin
  Point := GetGridSize;
  FHeaderHeight := Canvas.TextHeight('Wg')+2;
  if FHeaderHeight <= (CALC_BTN_WIDTH+1) then FHeaderHeight := CALC_BTN_WIDTH+2;
  FFooterHeight := Canvas.TextHeight('Wg')+2;
  Width := Point.X+2*FBorderSize;
  Height:= Point.Y+Canvas.TextHeight('Wg')+FHeaderHeight+FFooterHeight+5+2*FBorderSize;
end;

procedure TDCCustomCalendar.DrawCell(ARect: TRect; ACol, ARow: integer;
  BorderStyle: TEdgeStyle);
 var
  CellValue: integer;
  Text: string;
  dDate: TDateTime;
  AYear, AMonth, ADay: WORD;
begin
  DecodeDate(FDate, AYear, AMonth, ADay);
  CellValue := GetTextCell(ACol,ARow);
  InflateRect(ARect, -1, -1);
  case BorderStyle of
    esNone   :
      begin
        Canvas.Brush.Color := FBrushColor;
        Canvas.Pen.Color   := Font.Color;
      end;
    esRaised :
      begin
        Canvas.Brush.Color := FBrushColor;
        Canvas.Pen.Color   := Font.Color;
      end;
    esSunken :
      begin
        Canvas.Brush.Color := clBtnFace;
        Canvas.Pen.Color   := clCaptionText;
      end;
  end;
  Canvas.FillRect(ARect);
  if CellValue > 0 then
  begin
    Text := IntToStr(CellValue);
    dDate := EncodeDate(AYear, AMonth, CellValue);
    if dDate = SysUtils.Date then Canvas.Font.Color:= $000000A7;
    ARect.Top := ARect.Top - 1;
    DrawText(Canvas.Handle, PChar(Text), Length(Text), ARect,
             DT_CENTER or DT_WORDBREAK or DT_EXPANDTABS or DT_NOPREFIX or DT_VCENTER);
  end;

end;

procedure TDCCustomCalendar.CMMouseEnter(var Message: TMessage);
 var
  APoint: TPoint;
  XPos, YPos: LongInt;
begin
  if IsExistDragging then Exit;
  GetCursorPos(APoint);
  APoint := Self.ScreenToClient(APoint);
  XPos := APoint.X;
  YPos := APoint.Y;
  if FMouseDown then
  begin
    FMouseDown := GetAsyncKeyState(VK_LBUTTON)<0;
    if not FMouseDown then UpdateEditButtonsState(XPos, YPos, True);
  end;
  inherited;
end;

procedure TDCCustomCalendar.CMMouseLeave(var Message: TMessage);
begin
  UpdateEditButtonsState(-1, -1, True);
  inherited;
end;

function TDCCustomCalendar.DoMouseWheelDown(Shift: TShiftState;
  MousePos: TPoint): Boolean;
begin
  Result := inherited DoMouseWheelDown(Shift, MousePos);
  ChangeDay(1);
end;

function TDCCustomCalendar.DoMouseWheelUp(Shift: TShiftState;
  MousePos: TPoint): Boolean;
begin
  Result := inherited DoMouseWheelUp(Shift, MousePos);
  ChangeDay(-1);
end;

procedure TDCCustomCalendar.CMDialogChar(var Message: TCMDialogChar);
begin
  if IsAccel(Message.CharCode, '&Today' ) then
  begin
    FBtnToday.Click;
    CloseUp(FCloseState);
  end;
  if IsAccel(Message.CharCode, '&Cancel') then
  begin
    FBtnCancel.Click;
    CloseUp(FCloseState);
  end;
  inherited;
end;

end.
