{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCCalculator;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  DCEditButton, DCEditTools, DCPopupWindow, DCConst;

type
  TStoredValues  = (svMemoryValue, svVisibleParam, svStoredParam);
  TCalcValues    = array[TStoredValues] of Double;
  TCalcButtons   = (cbDig0, cbDig1, cbDig2, cbDig3, cbDig4, cbDig5, cbDig6,
                    cbDig7, cbDig8, cbDig9, cbDiv , cbSqrt, cbMul , cbPrec,
                    cbSub,  cbInv , cbNeg , cbSep , cbAdd , cbRes , cbBks ,
                    cbDel,  cbC   , cbMemC, cbMemR, cbMemS, cbMemP, cbOk  ,
                    cbCancel);

  TDCCustomCalculator = class(TDCClipPopup)
  private
    FGridOffset : TPoint;
    FElementSize: TPoint;
    FDisplayHeight: integer;
    FButtonsHeight: integer;
    FValues: TCalcValues;
    FVisibleParam: string;
    FErrorCode: integer;
    FOperation: TCalcButtons;
    FClearParam: boolean;
    FCloseUp: TCloseUpEvent;
    procedure CreateGridButtons;
    procedure CreateSpecButtons;
    procedure SetElementSize;
    function AddGridButton(ACol, ARow: integer; AName, ACaption: string;
      ATag: integer): TDCEditButton;
    procedure SetButtonProperty(Button: TDCEditButton; ATag: integer);
    procedure DrawDisplay;
    procedure DrawMemoryStatus;
    procedure DoButtonClick(Sender: TObject);
    procedure ClearValues;
    procedure ClearVisibleParam;
    procedure SetVisibleParam(const Value: string);
    procedure AddToVisibleParam(Value: Char);
    procedure SetOperation(Value: TCalcButtons);
    procedure DoOperation(Value: TCalcButtons);
    procedure AddToMemory;
    procedure DoBackspace;
    function GetMemoryValue: Double;
    procedure SetMemoryValue(const Value: Double);
    procedure FloatToVisibleParam;
  protected
    procedure CloseUp(State: Byte); virtual;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure WMPaint (var Message: TMessage); message WM_PAINT;
    property MemoryValue: Double read GetMemoryValue write SetMemoryValue;
  public
    constructor Create(AOwner: TComponent); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure VisibleParamToFloat;
    property VisibleParam: string read FVisibleParam write SetVisibleParam;
    property OnCloseUp: TCloseUpEvent read FCloseUp write FCloseUp;
    property ErrorCode: integer read FErrorCode;
  end;

implementation

{ TDCCustomCalculator }

function TDCCustomCalculator.AddGridButton(ACol, ARow: integer; AName,
  ACaption: string; ATag: integer): TDCEditButton;
 var
  BoundsRect: TRect;
begin
  BoundsRect := Rect(FGridOffset.X + ARow * FElementSize.X,
                     FGridOffset.Y + ACol * FElementSize.Y,
                     FElementSize.X, FElementSize.Y);
  Result := Buttons.AddButton;
  with Result do
  begin
    Name         := AName;
    Caption      := ACaption;
    SetBounds(BoundsRect);
  end;
  SetButtonProperty(Result, ATag);
end;

procedure TDCCustomCalculator.AddToVisibleParam(Value: Char);
begin
  if (FErrorCode = 0) then
  begin
    if FClearParam then
    begin
      VisibleParam := Value;
      FClearParam  := False;
    end
    else
      VisibleParam := VisibleParam + Value;
  end;
end;

procedure TDCCustomCalculator.ClearValues;
 var
  i: TStoredValues;
begin
  for i := Low(FValues) to High(FValues) do FValues[i] := 0;
end;

procedure TDCCustomCalculator.CMMouseEnter(var Message: TMessage);
 var
  Pos: TPoint;
begin
  inherited;
  GetCursorPos(Pos);
  if Buttons.MouseDown then
  begin
    Buttons.MouseDown := GetAsyncKeyState(VK_LBUTTON)<0;
    if not Buttons.MouseDown then
      Buttons.UpdateButtons(Pos.X, Pos.Y, False, True);
  end;
end;

procedure TDCCustomCalculator.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  Buttons.UpdateButtons(-1, -1, False, True);
end;

constructor TDCCustomCalculator.Create(AOwner: TComponent);
begin
  inherited;

  Options := [coHeader];
  PopupBorderStyle := brRaised;
  Parent   := TWinControl(AOwner);
  PopupAlignment := wpBottomRight;

  Buttons.PaintOnSizing := False;

  Color       := clMessageWindow;
  Canvas.Font := Font;

  SetElementSize;
  FDisplayHeight := FElementSize.Y + 4;
  FButtonsHeight := FElementSize.Y + 1;
  FGridOffset    := Point(Margins.Left + BorderSize + 2,
                          Margins.Top  + BorderSize + 2 + FDisplayHeight + 4);
  CreateSpecButtons;

  FGridOffset.X  := FGridOffset.X + FElementSize.X + 4;
  FGridOffset.Y  := FGridOffset.Y + FElementSize.Y + 4;

  CreateGridButtons;
  ClearValues;

  Width  := Margins.Left + Margins.Right  + FElementSize.X * 6 + 2 * BorderSize + 8;
  Height := Margins.Top  + Margins.Bottom + FElementSize.Y * 5 + 2 * BorderSize +
    FDisplayHeight + 12 + FButtonsHeight + 3;

  FErrorCode   := 0;
  FClearParam  := True;
  Foperation   := cbDig0;
  VisibleParam := FloatToStr(FValues[svVisibleParam]);
end;

procedure TDCCustomCalculator.CreateGridButtons;
begin
  AddGridButton(0, 0, '$BT_7'   , '7'   , Ord(cbDig7));
  AddGridButton(0, 1, '$BT_8'   , '8'   , Ord(cbDig8));
  AddGridButton(0, 2, '$BT_9'   , '9'   , Ord(cbDig9));
  AddGridButton(0, 3, '$BT_DIV' , '/'   , Ord(cbDiv ));
  AddGridButton(0, 4, '$BT_SQRT', 'sqrt', Ord(cbSqrt));
  AddGridButton(1, 0, '$BT_4'   , '4'   , Ord(cbDig4));
  AddGridButton(1, 1, '$BT_5'   , '5'   , Ord(cbDig5));
  AddGridButton(1, 2, '$BT_6'   , '6'   , Ord(cbDig6));
  AddGridButton(1, 3, '$BT_MUL' , '*'   , Ord(cbMul ));
  AddGridButton(1, 4, '$BT_PERC', '%'   , Ord(cbPrec));
  AddGridButton(2, 0, '$BT_1'   , '1'   , Ord(cbDig1));
  AddGridButton(2, 1, '$BT_2'   , '2'   , Ord(cbDig2));
  AddGridButton(2, 2, '$BT_3'   , '3'   , Ord(cbDig3));
  AddGridButton(2, 3, '$BT_SUB' , '-'   , Ord(cbSub ));
  AddGridButton(2, 4, '$BT_INV' , '1|x' , Ord(cbInv ));
  AddGridButton(3, 0, '$BT_0'   , '0'   , Ord(cbDig0));
  AddGridButton(3, 1, '$BT_NEG' , '+|-' , Ord(cbNeg ));
  AddGridButton(3, 2, '$BT_SEP' , DecimalSeparator,  Ord(cbSep));
  AddGridButton(3, 3, '$BT_ADD' , '+'   ,  Ord(cbAdd));
  AddGridButton(3, 4, '$BT_RES' , '='   ,  Ord(cbRes));
end;

procedure TDCCustomCalculator.CreateSpecButtons;
 var
  BoundsRect: TRect;
  Button: TDCEditButton;
begin
  with Buttons do
  begin
    BoundsRect := Rect(FGridOffset.X + FElementSize.X + 4, FGridOffset.Y,
                       FElementSize.X * 3, FElementSize.Y);
    Button := AddButton;
    with Button do
    begin
      Name    := '$BT_BKS';
      Caption := 'Backspase';
      SetBounds(BoundsRect);
      SetButtonProperty(Button, Ord(cbBks));
    end;

    BoundsRect := Rect(BoundsRect.Left + BoundsRect.Right, BoundsRect.Top,
                       FElementSize.X, FElementSize.Y);
    Button := AddButton;
    with Button do
    begin
      Name    := '$BT_DEL';
      Caption := 'CE';
      SetBounds(BoundsRect);
      SetButtonProperty(Button, Ord(cbDel));
    end;

    BoundsRect := Rect(BoundsRect.Left + BoundsRect.Right, BoundsRect.Top,
                       FElementSize.X, FElementSize.Y);
    Button := AddButton;
    with Button do
    begin
      Name    := '$BT_C';
      Caption := 'C';
      SetBounds(BoundsRect);
      SetButtonProperty(Button, Ord(cbC));
    end;

    BoundsRect := Rect(FGridOffset.X, FGridOffset.Y +FElementSize.Y+4,
                       FElementSize.X, FElementSize.Y);
    Button := AddButton;
    with Button do
    begin
      Name    := '$BT_MC';
      Caption := 'MC';
      SetBounds(BoundsRect);
      SetButtonProperty(Button, Ord(cbMemC));
    end;

    BoundsRect := Rect(BoundsRect.Left, BoundsRect.Top+BoundsRect.Bottom,
                       FElementSize.X, FElementSize.Y);
    Button := AddButton;
    with Button do
    begin
      Name    := '$BT_MR';
      Caption := 'MR';
      SetBounds(BoundsRect);
      SetButtonProperty(Button, Ord(cbMemR));
    end;

    BoundsRect := Rect(BoundsRect.Left, BoundsRect.Top+BoundsRect.Bottom,
                       FElementSize.X, FElementSize.Y);
    Button := AddButton;
    with Button do
    begin
      Name    := '$BT_MS';
      Caption := 'MS';
      SetBounds(BoundsRect);
      SetButtonProperty(Button, Ord(cbMemS));
    end;

    BoundsRect := Rect(BoundsRect.Left, BoundsRect.Top+BoundsRect.Bottom,
                       FElementSize.X, FElementSize.Y);
    Button := AddButton;
    with Button do
    begin
      Name    := '$BT_M+';
      Caption := 'M+';
      SetBounds(BoundsRect);
      SetButtonProperty(Button, Ord(cbMemP));
    end;

    BoundsRect := Rect(FGridOffset.X, BoundsRect.Top+BoundsRect.Bottom+4,
                       5*FElementSize.X+4, FButtonsHeight);
    Button := AddButton;
    with Button do
    begin
      Name    := '$BT_OK';
      Caption := '&OK';
      SetBounds(BoundsRect);
      SetButtonProperty(Button, Ord(cbOk));
    end;

    BoundsRect := Rect(BoundsRect.Left + BoundsRect.Right, BoundsRect.Top,
                       FElementSize.X, FButtonsHeight);
    Button := AddButton;
    with Button do
    begin
      Name    := '$BT_Cancel';
      SetBounds(BoundsRect);
      SetButtonProperty(Button, Ord(cbCancel));
      Glyph.LoadFromResourceName(HInstance, 'DC_BTNCANCEL');
    end;
  end;
end;

procedure TDCCustomCalculator.DoButtonClick(Sender: TObject);
 var
  ButtonCode: TCalcButtons;
begin
  if Sender is TDCEditButton then
  begin
    ButtonCode := TCalcButtons(TDCEditButton(Sender).Tag);
    case ButtonCode of
      cbDig0:
        if VisibleParam <> '0' then AddToVisibleParam('0');
      cbDig1..cbDig9:
        AddToVisibleParam(Chr(Ord('0')+Ord(ButtonCode)));
      cbDiv, cbMul, cbSub, cbAdd:
        SetOperation(ButtonCode);
      cbSqrt, cbPrec, cbInv, cbNeg, cbRes:
        DoOperation(ButtonCode);
      cbSep:
        if Pos(DecimalSeparator, VisibleParam) = 0 then
        begin
          FClearParam := False;
          AddToVisibleParam(DecimalSeparator);
        end;
      cbBks:
        DoBackspace;
      cbDel:
        ClearVisibleParam;
      cbC:
        begin
          FErrorCode := 0;
          ClearVisibleParam;
          FValues[svStoredParam] := 0;
        end;
      cbMemC:
        MemoryValue  := 0;
      cbMemR:
        VisibleParam := FloatToStr(MemoryValue);
      cbMemS:
        begin
          VisibleParamToFloat;
          MemoryValue  := FValues[svVisibleParam];
        end;
      cbMemP:
        AddToMemory;
      cbOk:
        CloseUp(1);
      cbCancel:
        CloseUp(0);
    end;
  end;
end;

procedure TDCCustomCalculator.DrawDisplay;
 var
  DisplayRect: TRect;
  ABrush: HBRUSH;
begin
  DisplayRect := Rect(2, 2, ClientWidth - 4, FDisplayHeight);
  Canvas.Brush.Bitmap := AllocPatternBitmap(clWhite, clBtnFace);
  Canvas.FillRect(DisplayRect);

  ABrush := CreateSolidBrush(ColorToRGB(clBtnFace));
  FrameRect(Canvas.Handle, DisplayRect, ABrush);
  DeleteObject(ABrush);

  InflateRect(DisplayRect, -4, -2);
  DrawHighLightText(Canvas, PChar(FVisibleParam), DisplayRect, 1,
    DT_RIGHT or DT_VCENTER or DT_SINGLELINE);

  Canvas.Brush.Color := Color;
end;

procedure TDCCustomCalculator.DrawMemoryStatus;
 var
  DisplayRect: TRect;
  MemoryStatus: string;
  ABrush: HBRUSH;
begin
  DisplayRect := Rect(2, 6 + FDisplayHeight,
                      2 + FElementSize.X, 6 + FDisplayHeight + FElementSize.Y);
  Canvas.Brush.Bitmap := AllocPatternBitmap(clHintBackground, clLite);
  Canvas.FillRect(DisplayRect);

  ABrush := CreateSolidBrush(ColorToRGB(clBtnShadow));
  FrameRect(Canvas.Handle, DisplayRect, ABrush);
  DeleteObject(ABrush);

  InflateRect(DisplayRect, -4, -2);

  if FValues[svMemoryValue] <> 0 then
    MemoryStatus := 'M'
  else
    MemoryStatus := ' ';

  DrawHighLightText(Canvas, PChar(MemoryStatus), DisplayRect, 1,
    DT_CENTER or DT_VCENTER or DT_SINGLELINE);

  Canvas.Brush.Color := Color;
end;

procedure TDCCustomCalculator.DoOperation(Value: TCalcButtons);
begin
  VisibleParamToFloat;
  if FErrorCode = 0 then
  begin
    try
      case Value of
        cbSqrt:
          FValues[svVisibleParam] := Sqrt(FValues[svVisibleParam]);
        cbInv:
          FValues[svVisibleParam] := 1 / FValues[svVisibleParam];
        cbNeg:
          FValues[svVisibleParam] := - FValues[svVisibleParam];
        cbRes:
          if FOperation <> cbDig0 then
          begin
            case FOperation of
              cbDiv:
                FValues[svVisibleParam] := FValues[svStoredParam] / FValues[svVisibleParam];
              cbMul:
                FValues[svVisibleParam] := FValues[svStoredParam] * FValues[svVisibleParam];
              cbSub:
                FValues[svVisibleParam] := FValues[svStoredParam] - FValues[svVisibleParam];
              cbAdd:
                FValues[svVisibleParam] := FValues[svStoredParam] + FValues[svVisibleParam];
            end;
            FOperation := cbDig0;
          end;
        cbPrec:
          FValues[svVisibleParam] := FValues[svStoredParam] * FValues[svVisibleParam] / 100;
      end;
    except
      on E: Exception do
      begin
        FErrorCode   := -1;
        VisibleParam := E.Message;
      end;
    end;
  end;
  FloatToVisibleParam;
  FClearParam := True;
end;

procedure TDCCustomCalculator.SetButtonProperty(Button: TDCEditButton;
  ATag: integer);
begin
  with Button do
  begin
    Visible      := False;
    Tag          := ATag;
    Allignment   := abCentr;
    Glyph        := nil;
    Font         := Self.Font;
    Style        := stSelect;
    DisableStyle := deNormal;
    BrushColor   := Color;
    AnchorStyle  := asNone;
    OnClick      := DoButtonClick;
    Visible      := True;
  end;
end;

procedure TDCCustomCalculator.SetElementSize;
begin
  FElementSize := Point(Canvas.TextWidth('sqrt')+8, Canvas.TextHeight('sqrt')+2);
end;

procedure TDCCustomCalculator.SetOperation(Value: TCalcButtons);
begin
  if Value = FOperation then DoOperation(cbRes);
  FOperation  := Value;
  FClearParam := True;
  VisibleParamToFloat;
  FValues[svStoredParam] := FValues[svVisibleParam];
end;

procedure TDCCustomCalculator.SetVisibleParam(const Value: string);
begin
  if FVisibleParam <> Value then
  begin
    FVisibleParam :=  Value;
    DrawDisplay;
  end;
end;

procedure TDCCustomCalculator.WMPaint(var Message: TMessage);
begin
  inherited;
  DrawDisplay;
  DrawMemoryStatus;
end;

procedure TDCCustomCalculator.DoBackspace;
begin
  if (FErrorCode = 0) and not(FClearParam) then
  begin
    if Length(VisibleParam) > 1 then
      VisibleParam := Copy(VisibleParam, 1, Length(VisibleParam)-1)
    else
      ClearVisibleParam;
  end;
end;

procedure TDCCustomCalculator.ClearVisibleParam;
begin
  if FErrorCode = 0 then
  begin
    VisibleParam := '0';
    FClearParam  := True;
  end;
end;

function TDCCustomCalculator.GetMemoryValue: Double;
begin
  Result := FValues[svMemoryValue];
end;

procedure TDCCustomCalculator.SetMemoryValue(const Value: Double);
 var
  RefreshStatus: boolean;
begin
  if FErrorCode = 0 then
  begin
    FClearParam := True;
    RefreshStatus := (FValues[svMemoryValue] <> 0) and (Value =  0) or
                     (FValues[svMemoryValue] =  0) and (Value <> 0);
    FValues[svMemoryValue] := Value;
    if RefreshStatus then DrawMemoryStatus;
  end;
end;

procedure TDCCustomCalculator.AddToMemory;
begin
  VisibleParamToFloat;
  if FErrorCode = 0 then
  begin
    try
      MemoryValue := MemoryValue + FValues[svVisibleParam];
    except
    end;
  end;
end;

procedure TDCCustomCalculator.VisibleParamToFloat;
begin
  if (FErrorCode = 0) and IsValidFloat(VisibleParam) then
  begin
    try
      FValues[svVisibleParam] := StrToFloat(VisibleParam);
    except
      {}
    end;
  end;
end;

procedure TDCCustomCalculator.FloatToVisibleParam;
begin
  if FErrorCode = 0 then
  begin
    VisibleParam := FloatToStr(FValues[svVisibleParam]);
  end;
end;

procedure TDCCustomCalculator.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited;
  with Buttons do
  begin
    case Key of
      $30{VK_0}: DoButtonClick(FindButton('$BT_0'));
      $31{VK_1}: DoButtonClick(FindButton('$BT_1'));
      $32{VK_2}:
        if ssShift in Shift then
          DoButtonClick(FindButton('$BT_SQRT'))
        else
          DoButtonClick(FindButton('$BT_2'));
      $33{VK_3}: DoButtonClick(FindButton('$BT_3'));
      $34{VK_4}: DoButtonClick(FindButton('$BT_4'));
      $35{VK_5}:
        if ssShift in Shift then
          DoButtonClick(FindButton('$BT_PERC'))
        else
          DoButtonClick(FindButton('$BT_5'));
      $36{VK_6}: DoButtonClick(FindButton('$BT_6'));
      $37{VK_7}: DoButtonClick(FindButton('$BT_7'));
      $38{VK_8}:
        if ssShift in Shift then
          DoButtonClick(FindButton('$BT_MUL'))
        else
          DoButtonClick(FindButton('$BT_8'));
      $39{VK_9}: DoButtonClick(FindButton('$BT_9'));
      $4C{L}:
        if ssCtrl in Shift then
          DoButtonClick(FindButton('$BT_MC'));
      $4D{M}:
        if ssCtrl in Shift then
          DoButtonClick(FindButton('$BT_MS'));
      $51{P}:
        if ssCtrl in Shift then
          DoButtonClick(FindButton('$BT_M+'));
      $52{R}:
        if ssCtrl in Shift then
          DoButtonClick(FindButton('$BT_MR'))
        else
          DoButtonClick(FindButton('$BT_INV'));
      $BB:
        if ssShift in Shift then
          DoButtonClick(FindButton('$BT_ADD'))
        else
          DoButtonClick(FindButton('$BT_RES'));
      $BD: DoButtonClick(FindButton('$BT_SUB'));
      $BC, $BE: {DecimalSeparator}
        if Shift = [] then
           DoButtonClick(FindButton('$BT_SEP'));
      $BF: DoButtonClick(FindButton('$BT_DIV'));
      VK_DECIMAL:
        if ssShift in Shift then
          DoButtonClick(FindButton('$BT_CE'))
        else
          DoButtonClick(FindButton('$BT_SEP'));
      VK_DIVIDE  : DoButtonClick(FindButton('$BT_DIV'));
      VK_MULTIPLY: DoButtonClick(FindButton('$BT_MUL'));
      VK_SUBTRACT: DoButtonClick(FindButton('$BT_SUB'));
      VK_ADD     : DoButtonClick(FindButton('$BT_ADD'));
      VK_NUMPAD0 : DoButtonClick(FindButton('$BT_0'));
      VK_NUMPAD1 : DoButtonClick(FindButton('$BT_1'));
      VK_NUMPAD2 : DoButtonClick(FindButton('$BT_2'));
      VK_NUMPAD3 : DoButtonClick(FindButton('$BT_3'));
      VK_NUMPAD4 : DoButtonClick(FindButton('$BT_4'));
      VK_NUMPAD5 : DoButtonClick(FindButton('$BT_5'));
      VK_NUMPAD6 : DoButtonClick(FindButton('$BT_6'));
      VK_NUMPAD7 : DoButtonClick(FindButton('$BT_7'));
      VK_NUMPAD8 : DoButtonClick(FindButton('$BT_8'));
      VK_NUMPAD9 : DoButtonClick(FindButton('$BT_9'));
      VK_BACK    : DoButtonClick(FindButton('$BT_BKS'));
      VK_DELETE  : DoButtonClick(FindButton('$BT_DEL'));
      VK_F9      : DoButtonClick(FindButton('$BT_INV'));
      VK_RETURN  : DoButtonClick(FindButton('$BT_OK'));
      VK_ESCAPE  : DoButtonClick(FindButton('$BT_Cancel'))
    end;
  end;
end;

procedure TDCCustomCalculator.CloseUp(State: Byte);
begin
  if Assigned(FCloseUp) then FCloseUp(State);
end;

procedure TDCCustomCalculator.CMDialogChar(var Message: TCMDialogChar);
 var
  Button: TDCEditButton;
begin
  Button := Buttons.FindButton('$BT_OK');
  if IsAccel(Message.CharCode, '&Ok' ) then
  begin
    Button.Click;
  end;

  Button := Buttons.FindButton('$BT_Cancel');
  if IsAccel(Message.CharCode, '&Cancel') then
  begin
    Button.Click;
  end;
  inherited;
end;

end.
