{
 BUSINESS CONSULTING
 s a i n t - p e t e r s b u r g

         Components Library for Borland Delphi 4.x, 5.x
         Copyright (c) 1998-2000 Alex'EM

}
unit DCADOCtrl;

interface
{$I DCConst.inc}

{$IFDEF DELPHI_V5}

uses SysUtils, db, ADOdb, DCConst, DCChoice;

type
  TDCADOGridEdit = class(TDCCustomGridEdit)
  private
    procedure SetParameters(const Value: TParameters);
    function GetParameters: TParameters;
    function GetConnection: TADOConnection;
    procedure SetConnection(const Value: TADOConnection);
  protected
    procedure SetInternalDataSet(const Value: TDataSet; var DataSet: TDataSet); override;
    procedure SetInternalSQLText(const Value: string; var SQLText: string); override;
    function CreateQuery: TDataSet; override;
    procedure OpenQuery(Mode: integer); override;
    procedure PrepareDataSet; override;
  public
    property ButtonEnabled;
  published
    property DrawStyle;
    property CheckGlyph;
    property CheckTag;
    property ReadOnly;
    property Parameters: TParameters read GetParameters write SetParameters;
    property Connection: TADOConnection read  GetConnection write SetConnection;
  end;

{$ENDIF}

implementation
{$IFDEF DELPHI_V5}

{ TDCADOGridEdit }
function TDCADOGridEdit.CreateQuery: TDataSet;
begin
  Result := TADOQuery.Create(Self);
end;

function TDCADOGridEdit.GetConnection: TADOConnection;
begin
  Result := TADOQuery(Query).Connection;
end;

function TDCADOGridEdit.GetParameters: TParameters;
begin
  Result := TADOQuery(Query).Parameters;
end;

procedure TDCADOGridEdit.OpenQuery(Mode: integer);
begin
  PrepareDataSet;
  with TADOQuery(Query) do
  begin
    case Mode of
      0: {locate}
        begin
          if Pos(AnsiUpperCase(EDIT_STR_WHERE), AnsiUpperCase(SQL.Text)) = 0 then
            SQL.Add(Format(EDIT_FQW_LOCATE, [SQLDataField, Self.Text]))
          else
            SQL.Add(Format(EDIT_FQA_LOCATE, [SQLDataField, Self.Text]));
          Open;
          SetGridValues;
        end;
      1: {like}
        begin
          if (Length(Self.Text) >= 0) and not FullQuery then
          begin
            if Pos(AnsiUpperCase(EDIT_STR_WHERE), AnsiUpperCase(SQL.Text)) = 0 then
              SQL.Add(Format(EDIT_FQW_LIKE, [SQLDataField, Self.Text]))
            else
              SQL.Add(Format(EDIT_FQA_LIKE, [SQLDataField, Self.Text]));
          end;
          if SQLOrderBy <> '' then SQL.Add(Format('ORDER BY %s', [SQLOrderBy]));
          Open;
          SetGridValues;
        end;
       2: {set KeyValue}
         begin
          if Pos(AnsiUpperCase(EDIT_STR_WHERE), AnsiUpperCase(SQL.Text)) = 0 then
          begin
            if VarType(KeyValue) in [varSmallint, varInteger, varSingle, varDouble, varCurrency, varByte] then
              SQL.Add(Format(EDIT_FNW_LOCATE, [SQLKeyField, VarToStr(KeyValue)]))
            else
              SQL.Add(Format(EDIT_FQW_LOCATE, [SQLKeyField, VarToStr(KeyValue)]))
          end
          else begin
            if VarType(KeyValue) in [varSmallint, varInteger, varSingle, varDouble, varCurrency, varByte] then
              SQL.Add(Format(EDIT_FNA_LOCATE, [SQLKeyField, VarToStr(KeyValue)]))
            else
              SQL.Add(Format(EDIT_FQA_LOCATE, [SQLKeyField, VarToStr(KeyValue)]));
          end;
          Open;
          SetGridValues;
         end;
    end;
  end;
end;

procedure TDCADOGridEdit.PrepareDataSet;
 var
  AParams: TParameters;
begin
  AParams := TParameters.Create(Self, TParameter);
  try
    AParams.Assign(Parameters);
    with TADOQuery(Query) do
    begin
      Close;
      SQL.Clear;
      SQL.Text := SQLText;
      Parameters.Assign(AParams);
    end;
  finally
    AParams.Free;
  end;
end;

procedure TDCADOGridEdit.SetConnection(const Value: TADOConnection);
begin
  TADOQuery(Query).Connection := Value;
end;

procedure TDCADOGridEdit.SetInternalDataSet(const Value: TDataSet; var DataSet: TDataSet);
begin
  DataSet := Value;
  if Query.Active then Query.Close;
  if (DataSet is TADOQuery) and not ListBoxEnabled then
    SetSQLTextPermanet(TADOQuery(DataSet).SQL.Text)
  else
    if not QueryDataSet then SetSQLTextPermanet('');

  if not QueryDataSet then
  begin
    if (DataSet <> nil) and DataSet.Active then
      SetGridValues
    else
      Values.Clear;
  end
end;

procedure TDCADOGridEdit.SetInternalSQLText(const Value: string;
  var SQLText: string);
begin
  if Value <> '' then TADOQuery(Query).SQL.Text := SQLText;
end;

procedure TDCADOGridEdit.SetParameters(const Value: TParameters);
begin
  TADOQuery(Query).Parameters.AssignValues(Value);
end;

{$ENDIF}

end.
