// DbHdrCtrlGrid. Copyright (c) 2000 Altive Software Ltd. http://www.dbaltgrid.com/freeware
unit dhcgReg;
interface
uses Classes, DsgnIntf;
type

  TdhcgControlProperty = class(TComponentProperty) // fo. New property editor.
  public
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  TdhcgComponentEditor = class(TDefaultEditor) // fo. Default property editor, launched when the component is double-clicked.
  protected
    procedure EditProperty(PropertyEditor: TPropertyEditor; var Continue,
      FreeEditor: Boolean); override;
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

procedure Register;

implementation
uses SysUtils, Controls, TypInfo, DbHCGrid;
{--------------------------------------------------------------------------}
{ TdhcgControlProperty }
{--------------------------------------------------------------------------}
procedure TdhcgControlProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
begin
  with TdhcgHeaders(TdhcgSections(TdhcgSection(GetComponent(0)).Collection).Header.Collection).Grid.Panel do
    for I := 0 to ControlCount - 1 do Proc(Controls[I].Name);
end;
{--------------------------------------------------------------------------}
{ TdhcgComponentEditor }
{--------------------------------------------------------------------------}
procedure TdhcgComponentEditor.EditProperty(PropertyEditor: TPropertyEditor; var Continue,
  FreeEditor: Boolean);
var
  PropName: string;
begin
  PropName := PropertyEditor.GetName;
  if (CompareText(PropName, 'Headers') = 0) then begin
    PropertyEditor.Edit;
    Continue := False;
  end;
end;
{--------------------------------------------------------------------------}
procedure TdhcgComponentEditor.ExecuteVerb(Index: Integer);
begin
  if Index = 0 then Edit;
end;
{--------------------------------------------------------------------------}
function TdhcgComponentEditor.GetVerb(Index: Integer): string;
begin
  if Index = 0 then Result := '&Headers Editor...';
end;
{--------------------------------------------------------------------------}
function TdhcgComponentEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;
{--------------------------------------------------------------------------}
{ procedure Register }
{--------------------------------------------------------------------------}
procedure Register;
begin
  RegisterComponents('Samples', [TDbHdrCtrlGrid]);
  RegisterPropertyEditor(TypeInfo(TControl), TdhcgSection, 'Control', TdhcgControlProperty);
  RegisterComponentEditor(TDbHdrCtrlGrid, TdhcgComponentEditor);
end;
{--------------------------------------------------------------------------}


end.

