unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBCtrls, Mask, DbHCGrid, Db, DBTables, Math;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    DbHdrCtrlGrid1: TDbHdrCtrlGrid;
    DBText1: TDBText;
    DBEdit1: TDBEdit;
    DBEdit2: TDBEdit;
    DBEdit3: TDBEdit;
    DBEdit4: TDBEdit;
    DBEdit5: TDBEdit;
    DBImage1: TDBImage;
    DBMemo1: TDBMemo;
    procedure FormShow(Sender: TObject);
    procedure DbHdrCtrlGrid1HeaderClick(DBCtrlGrid: TDbHdrCtrlGrid;
      Header: TdhcgHeader; Section: TdhcgSection);
    procedure DbHdrCtrlGrid1HeaderResize(DBCtrlGrid: TDbHdrCtrlGrid;
      Header: TdhcgHeader; Section: TdhcgSection);
  private
  public
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}
{--------------------------------------------------------------------------}
procedure TForm1.FormShow(Sender: TObject);
begin
  with Table1 do
  try
    Open;
  except
    on Exception do begin
      DatabaseName := '';
      TableName := ExtractFilePath(Application.ExeName) + 'Tables\events.db';
      try
        Open;
      except
        on Exception do
          ShowMessage('  DbHdrCtrlGrid demo program assumes that an alias DBDEMOS exists' + #13
            + 'and that EVENTS.DB and related files are contained within this alias.' + #13
            + '  If this is not the case, this alias and/or table will have to be reinstalled.' + #13
            + 'You can downlod demo table from http://www.dbaltgrid.com/download.htm' + #13
            + 'and place them into ..\Tables directory, alternatively.');
      end;
    end;
  end;
end;
{--------------------------------------------------------------------------}
procedure TForm1.DbHdrCtrlGrid1HeaderClick(DBCtrlGrid: TDbHdrCtrlGrid;
  Header: TdhcgHeader; Section: TdhcgSection);
begin
  beep;
  // MyRow := Header.Index;
// MyColumn := Section.Index;
// MyControl := Section.Control;
// MyFildNameString := Section.DataFieldName;
end;
{--------------------------------------------------------------------------}
procedure TForm1.DbHdrCtrlGrid1HeaderResize(DBCtrlGrid: TDbHdrCtrlGrid;
  Header: TdhcgHeader; Section: TdhcgSection);
begin
  if Section = DbHdrCtrlGrid1.Headers[0].Sections[0] then
    DbHdrCtrlGrid1.Headers[1].Sections[0].Width := Section.Width
  else if Section = DbHdrCtrlGrid1.Headers[1].Sections[0] then
    DbHdrCtrlGrid1.Headers[0].Sections[0].Width := Section.Width
  else if Section = DbHdrCtrlGrid1.Headers[1].Sections[1] then begin
      Section.RightMargin := Max((Section.Width - 153) div 2, 0);
      Section.LeftMargin := Section.RightMargin - 1;
      DBImage1.Height := Min(105, Round(DBImage1.Width * 0.683));
    end;
end;
{--------------------------------------------------------------------------}
end.

