{
This file Copyright 2000 (c) CDF, Inc.
Written By: Edward Flick (Directrix1@yahoo.com)
Use at your own risk!
}

unit DataMover;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, db, ExpressionEval;

//A Class to move data from one dataset into another, like BatchMove but works
//with any dataset and is only an appending class
type
  TDataMover = class(TExpressionEval)
  protected
    { Protected declarations }
    FSource: TDataset;
    FDestination: TDataset;
    FSrcExpr: TStrings;
    FDestFields: TStrings;
    FErrors: TStrings;
    procedure setSrcExpr(ti: TStrings);
    procedure setDestFields(ti: TStrings);
    procedure setErrors(ti: TStrings);
  public
    { Public declarations }
    procedure transfer; virtual;
    constructor create(Owner: TComponent); override;
    destructor destroy; override;
  published
    { Published declarations }
    property Destination: TDataset read FDestination write FDestination;
    property SrcExpressions: TStrings read FSrcExpr write setSrcExpr;
    property DestFields: TStrings read FDestFields write setDestFields;
    property Errors: TStrings read FErrors write setErrors;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Data Access', [TDataMover]);
end;

//Transfer data from Source to Destination, Datasets must already be active
//and Destination should be modifiable
procedure TDataMover.transfer;
var
  j,k: integer;
begin
FSource.First;
if FSrcExpr.count<>FDestFields.count then   //Verify one-to-one mapping
  raise Exception.create('There must be a one-to-one mapping between SourceExpressions and DestinationFields');
FErrors.Clear;
k:=1;
while not source.eof do                   //Iterate through all records in Source
  begin
  FDestination.Append;                    //and append the listed expressions evaluated
  for j:=0 to FSrcExpr.count - 1 do       //to the listed fields, simple.
    FDestination.FieldByName(FDestFields[j]).asString:=evaluate(FSrcExpr[j]);
  try
    FDestination.Post;                    //try to make changes solid
  except
    try
      FDestination.Cancel;                //no can do, so back out
    except
      end;
    FErrors.Add(inttostr(k));             //log this record num for posterity
    end;
  FSource.Next;                           //Move on
  inc(k);
  end;
end;

constructor TDataMover.create(Owner: TComponent);
begin
inherited create(owner);
FSrcExpr:=TStringList.Create();
FDestFields:=TStringList.Create();
FErrors:=TStringList.Create();
end;

destructor TDataMover.destroy;
begin
FSrcExpr.free;
FDestFields.free;
FErrors.free;
inherited destroy;
end;

procedure TDataMover.setSrcExpr(ti: TStrings);
begin
FSrcExpr.Assign(ti);
end;

procedure TDataMover.setDestFields(ti: TStrings);
begin
FDestFields.Assign(ti);
end;

procedure TDataMover.setErrors(ti: TStrings);
begin
//Do nothing READ-ONLY
end;

end.
