program sr32;
{$APPTYPE CONSOLE}
{
  Demo program for Unit getOpts, QuoteStr & ScanFiles
  +cxpos (the extremely high performance Search/Replace SubStr)

  Copyright (c) 2004, aa, Inge DR. & Adrian Hafizh.
  Property of PT SOFTINDO Jakarta.
  All rights reserved.

  mailto:aa|AT|softindo|DOT|net, zero_inge|AT|yahoo|DOT|com
  http://delphi.softindo.net
}
uses
  SysUtils, Classes, Windows,
  //expos in '..\lib\expos.pas'; // modify this acording to your dir layout
  //cxpos in '..\lib\cxpos.pas'; // modify this acording to your dir layout
  //getOpts in '..\lib\getOpts.pas', // modify this acording to your dir layout
  //FileScan in '..\lib\FileScan.pas', // modify this acording to your dir layout
  //QuoteStr in '..\lib\QuoteStr.pas', // modify this acording to your dir layout
  //ACommon,
  //expos,
  cxpos,
  getOpts, FileScan, QuoteStr;

const
  YES = TRUE;

  TAB = #9;
  SPACE = ' ';
  DOT = '.';
  BAR = '|';
  COMMA = ',';

  DOTSPACE = DOT + SPACE;
  SPACE2 = SPACE + SPACE;
  SPACE4 = SPACE2 + SPACE2;
  SWCHAR = DEFAULT_SWITCH_CHAR;
  Error_ = 'Error! ';

  MAXVERBOSE = 3;
  DEFAULT_REPLIST = 'REPLIST.CFG';

  SW_FILES = 'F';
  SW_SEARCH = 'S';
  SW_REPLACE = 'R';
  SW_XFILES = 'X';
  SW_DIRS = 'D';
  SW_RECURSE = 'E';
  //SW_CONFIG = 'C';
  SW_IGNORE = 'I';
  SW_NOTREAL = 'N';
  SW_NOTIME = 'T';
  SW_ARGTEST = 'A';
  SW_HELP = 'H';
  SW_VERBOSE = 'V';
  SW_HELP2 = '?';

  SWC_FILES = SWCHAR + SW_FILES;
  SWC_SEARCH = SWCHAR + SW_SEARCH;
  SWC_REPLACE = SWCHAR + SW_REPLACE;
  SWC_XFILES = SWCHAR + SW_XFILES;
  SWC_DIRS = SWCHAR + SW_DIRS;
  SWC_RECURSE = SWCHAR + SW_RECURSE;
  //SWC_CONFIG = SWCHAR + SW_CONFIG;
  SWC_IGNORE = SWCHAR + SW_IGNORE;
  SWC_NOTREAL = SWCHAR + SW_NOTREAL;
  SWC_NOTIME = SWCHAR + SW_NOTIME;
  SWC_ARGTEST = SWCHAR + SW_ARGTEST;
  SWC_VERBOSE = SWCHAR + SW_VERBOSE;
  SWC_HELP = SWCHAR + SW_HELP;
  SWC_HELP2 = SWCHAR + SW_HELP2;
  SWC_HELPS = SWCHAR + SW_HELP + BAR + SW_HELP2;

  SW_FILES_ARG = SPACE + 'list-file-masks';
  SW_SEARCH_ARG = SPACE + 'pattern';
  SW_REPLACE_ARG = SPACE + 'pattern';
  SW_XFILES_ARG = SPACE + 'list-file-masks';
  SW_DIRS_ARG = SPACE + 'list-dirs';
  SW_CONFIG_ARG = SPACE + 'filename';
  //SW_IGNORE_ARG = 'I';
  //SW_RECURSE_ARG = 'R';
  //SW_ARGTEST_ARG = 'T';
  //SW_HELP_ARG = '?';

const
  SPC = SPACE;
  SPC2 = SPACE2;
  SPC4 = SPACE4;
  msg_about = '[Search and Replace Pattern]';
  msg_about2 = 'Unit cxpos demo - extremely high performance Search and Replace';
  cpr_1 = 'Copyright 2004, D.Sofyan, Adrian Hafizh & Inge DR.';
  cpr_1a = '*Private property of PT SOFTINDO, Jakarta*';
  cpr_2 = 'All right reserved';

procedure ShowHelp;
var
  thisfile: string;

const
  DOT3 = DOT + DOT + DOT;
  ELLIPSIS = DOT3;
  req_ = '(';
  _req = ')' + SPC;
  opt_ = '[';
  _opt = ']' + SPC2;
  _opt1 = ']' + SPC;
  _opt0 = ']';
  _optel = ']' + ELLIPSIS + SPC;
  msg01 = '';
  msg02 = 'Usage:'^j;
  msg02a = SPC2 +
    opt_ + SWC_ARGTEST + '[1-9]' + _opt +
    opt_ + opt_ + SWC_FILES + _opt0 + SW_FILES_ARG + _optel +
    opt_ + SWC_XFILES + SW_XFILES_ARG + _optel;
  msg02b = SPC2 +
    opt_ + SWC_DIRS + SW_DIRS_ARG + _optel +
    req_ + SWC_SEARCH + SW_SEARCH_ARG + _req +
    opt_ + SWC_REPLACE + SW_REPLACE_ARG + _opt1 +
    opt_ + SWC_IGNORE + _opt1 +
    opt_ + SWC_RECURSE + _opt1 +
    opt_ + SWC_NOTREAL + _opt1 +
    opt_ + SWC_NOTIME + _opt1 +
    opt_ + SWC_VERBOSE + '#' + _opt1 +
    opt_ + SWC_HELPS + _opt1;
  msg02c = '';
  msg02d = '';
  //msg02e = '';
  msg03 = //'Notation:'^j +
  SPACE2 + 'Block bracket [] : the switch/argument is optional'^j +
    SPACE2 + 'Parentheses () : the switch/argument MUST be supplied'^j +
    SPACE2 + 'Ellipsis ... : the switch/argument might be supplied more than once'^j; // +
  msg08 = //'List and Pattern:'^j +
  SPACE2 + 'List separator is semicolon (;)'^j +
    SPACE2 + 'Pattern (for ' + SWC_SEARCH + SPC + '&' + SPC + SWC_REPLACE + SPC + 'only) will be interpreted using default-style:'^j +
    SPACE4 + '- Use double-quotes (") to embed inline whitespaces'^j +
    SPACE4 + '- Use backslash (\) followed by decimal number(s) to implies the'^j +
    SPACE4 + SPACE2 + 'corresponding ASCII character. Use \x instead for hexadecimal number'^j +
    SPACE4 + 'note: in the default-style, single quote ('') is NOT a special character'^j +
    SPACE4 + '(see switch' + SPC + SWC_ARGTEST + SPC + 'for example of how the pattern would be interpreted)'^j; // +
  msg04 = //'Switches:'^j +
  SPACE2 + 'Switch is case-insensitive (ie. lower and uppercase are treated equally)'^j +
    SPACE2 + 'Between one switch with another switch, or a switch with it''s argument'^j +
    SPACE4 + '(if any), MUST be separated by whitespaces (SPACES or/and TABS)'^j +
    SPACE2 + 'Switches and their arguments might be appeared anywhere (no precedence)'^j +
    SPACE2 + 'The default value will be taken if one particular switch is omitted'^j +
    SPACE2 + 'Unknown switches will be silently discarded'^j +
    SPACE2 + 'Arguments without any recognizable switch will be assumed as an ' + SWC_FILES + SPC + 'arg.'^j +
    '';
  msg05 = 'Switches which (optionally) need for an argument are:';
  msg06 = 'ON/OFF switches are:';
  msg07 = 'Other switches (independent or high priority) are:';

  msg_F = SPACE2 + SWC_FILES + ': List of file masks, /F may be omitted (ie. switch not used)';
  msg_S = SPACE2 + SWC_SEARCH + ': Search pattern (MUST be supplied)';
  msg_R = SPACE2 + SWC_REPLACE + ': Replace pattern (default: BLANK)';
  msg_X = SPACE2 + SWC_XFILES + ': List of excluded file masks (current program always excluded)';
  msg_D = SPACE2 + SWC_DIRS + ': List of directories (default: current dir)';

  msg_I = SPACE2 + SWC_IGNORE + ': Ignore case (default: case-sensitive)';
  msg_E = SPACE2 + SWC_RECURSE + ': Recursive into subdir (default: not recursive)';
  msg_N = SPACE2 + SWC_NOTREAL + ': Search & count only, NO write (default: write replacement/changes)';
  msg_T = SPACE2 + SWC_NOTIME + ': Do not change file date/time of modified file (default: update)';
  //msg_C = SWCHAR + SW_CONFIG + ': specify config file (replacement list), default is: ' + DEFAULT_REPLIST;
  msg_mightbeoverriden = 'Might be overriden by the "test-mode" (' + SWCHAR + SW_ARGTEST + ') switch';
  msg_H = SPACE2 + SWC_HELP + ',' + SWC_HELP2 + ': Show this HELP. ' + msg_mightbeoverriden;
  msg_V = SPACE2 + SWC_VERBOSE + '#: Verbose level (0 - ' + char(MAXVERBOSE or ord('0')) + '). ' +
    'V0 = quiet, nothing will be displayed at all';
  //' + msg_mightbeoverriden;
  msg_A = SPACE2 + SWC_ARGTEST + ': Test the following arguments for SEARCH/REPLACE Pattern. MUST be the'^j +
    SPACE2 + SPACE4 + 'first switch to take effect, otherwise she treated as usual argument'^j +
    SPACE2 + SPACE4 + 'of the preceding switch (such as an argument for ' + SWC_SEARCH + SPC + 'or' + SPC + SWC_REPLACE + ')';
  msg_A2 = SPACE2 + SWC_ARGTEST + '#: Test sample #n instead (get the highest precedence over any switches)'; // (MUST be the ONLY argument to take effect)';
begin
  thisfile := extractfilename(ParamStr(0));
  writeln; writeln;
  writeln(msg_about);
  writeln(msg_about2);
  writeln(cpr_1);
  writeln(cpr_2);
  writeln(msg01);
  writeln(msg02 + SPC2 + uppercase(extractfilename(ParamStr(0))) + msg02a);
  writeln(msg02b);
  writeln(msg02c);
  //writeln(msg02d);
  writeln(msg03);
  writeln(msg08);
  writeln(msg04);
  writeln(msg05);
  writeln(msg_F);
  writeln(msg_X);
  writeln(msg_D);
  writeln(msg_S);
  writeln(msg_R);
  writeln;
  writeln(msg06);
  writeln(msg_I);
  writeln(msg_E);
  //writeln(msg_C);
  writeln(msg_N);
  writeln(msg_T);
  writeln;
  writeln(msg07);
  writeln(msg_V);
  writeln(msg_H);
  writeln(msg_A);
  writeln(msg_A2);
end;

procedure showTest;

  function bracketed(const S: string): string;
  begin
    Result := '[' + S + ']';
  end;
const
  SCRWIDTH = 80 - 1;
  BLOCKDELTA = 4;
  BLOCKLEN = 28;
  BLOCKLEN1 = BLOCKLEN + BLOCKDELTA;
  BLOCKLEN2 = BLOCKLEN - BLOCKDELTA;
  BLOCKLEN3 = SCRWIDTH - BLOCKLEN1 - BLOCKLEN2;

const
  WHITESPACES = [TAB, SPACE];
  QStyleName: array[TQuoteStyle] of string = ('Default', 'DOS', 'UNIX');
  _Style = '-Style';
type
  TSampleArgument = 1..9;
const
  TESTSTR1 = '/a " \"+''"'''' ''" ''"-'' "" '''' " \1\2\3" ''\x4\XC''" "D" h" "h '' \" """ \""';
  TESTSTR2 = '/a" \"+''"'''' ''" ''"-'' "" '''' " \1\2\3" ''\x4\XC''" "D" h" "h '' \" """ \""';
  TESTSTR3 = '/a \" /\x'' " "''  " ''"\1"23\x\"x"C" ''" \xCCC\"5? /?';
  TESTSTR4 = '/a test "\" "\"xEEE"''''""\r''" \t\\h';
  TESTSTR5 = '/a \" /\x'' " " '' "" '' ''"\3\\"4\"5? /?';
  TESTSTR6 = '" \"A''" ''" ''"B'' '' " \4\567"'' "\xC''\XDEF'' "G" h" "i \''" "''"" \""';
  TESTSTR7 = '\xc''\" " "" "\xC\'' "Xc''" \XC';
  TESTSTR8 = '  " \"a''"'''' ''" ''"b''  " \012\789\xeee''''\5\6"  "+" h" "h ''Q" ''''""" \""';
  TESTSTR9 = '\"A \''"B ''''\''''"C " "D '' ''"'' ''E\''''''" "  "" '''' '' '''' "H\" \''"';

  SAMPLEARGUMENTS: set of TSampleARgument = [low(TSampleArgument)..high(TSampleArgument)];
  TESTSTRS: array[TSampleArgument] of string = (TESTSTR1, TESTSTR2, TESTSTR3,
    TESTSTR4, TESTSTR5, TESTSTR6, TESTSTR7, TESTSTR8, TESTSTR9);
  QUOTEST = 'Unit getOpts, QuoteStr & ScanFiles * test capabilities';
  STRIPPED = 'Double-quotes stripped';
  INTERPRET = 'Interpretation';
var
  fCmdLine, S, arg, argdq: string;
  i: integer;
  index: integer;
  qs: TQuoteStyle;
begin
  writeln; writeln;
  writeln(msg_about);
  writeln(QUOTEST);
  writeln(cpr_1);
  writeln(cpr_2);
  writeln;
  fCmdLine := string(System.CmdLine);
  if length(ParamStr(1)) > 2 then
    index := ord(ParamStr(1)[3]) - ord('0')
  else
    index := 0;
  writeln('CmdLine: [' + CmdLine + ']');
  if (ParamCount > 1) and not (index in SAMPLEARGUMENTS) then begin
    writeln;
    writeln('DOS ParamStr:');
    for i := 0 to ParamCount do begin
      arg := ParamStr(i);
      if i = 0 then
        arg := extractfilename(arg);
      S := format('Param-%0.2u: [%s]', [i, arg]);
      writeln(S);
    end;
  end
  else begin
    writeln;
    if not (index in SAMPLEARGUMENTS) then index := low(TSampleArgument);
    //S := extractfilename(paramstr(0)) + TESTSTRS[index];
    fCmdLine := TESTSTRS[index];
    writeln('Test arguments sample-' + SysUtils.IntToStr(index) + ':'^j'  [' + fCmdLine + ']');
  end;
  for qs := low(TQuoteStyle) to high(TQuoteStyle) do begin
    writeln;
    S := QStyleName[qs] + _Style;
    if qs = low(TQuoteStyle) then
      S := format('%-*s%-*s%s', [BLOCKLEN1, S, BLOCKLEN2, STRIPPED, INTERPRET]);
    writeln(S);
    for i := 1 to quotestr.CountDblQuotedStr(fCmdLine, qs) do begin
      argdq := quotestr.ExtractDblQuotedStr(fCmdLine, i, qs, FALSE);
      arg := quotestr.ExtractDblQuotedStr(fCmdLine, i, qs);
      if qs <> qsUNIX then
        S := quotestr.Interpret(arg)
      else
        S := quotestr.Interpret(arg, DEFAULT_SINGLEQUOTE_UNIX);
      S := bracketed(S);
      arg := bracketed(arg);
      argdq := bracketed(argdq);
      S := format('P%0.2u: %-*s%-*s%s', [i, BLOCKLEN1 - 4, argdq, BLOCKLEN2, arg, S]);
      writeln(S);
    end;
  end;
end;

function beautify(const i: cardinal; subject: string = 'file'; const ZeroAsDigit: boolean = FALSE): string; overload;
const
  UPOFFSET = $20;
  SPACE = ' ';
  WHY = 'Y';
  AY = 'I';
  ii = 'i';
  _s = 's';
  _e = 'e';
  ie = ii + _e;
  es = _e + _s;
  PLURALIES: set of Char = [AY, WHY];
  SINGULARIES: set of Char = ['H', 'S', 'O'];
var
  Ch: Char;
begin
  if (i = 0) and not ZeroAsDigit then
    Result := 'no'
  else
    Result := inttoStr(i);
  subject := trim(subject);
  if (subject) <> '' then begin
    if i > 1 then begin
      Ch := subject[length(subject)];
      if upcase(Ch) in PLURALIES then
        subject := copy(subject, 1, length(subject) - 1) + ie
      else if upcase(Ch) in SINGULARIES then
        subject := subject + _e;
      subject := subject + _s;
      if ord(Ch) < ord('a') then
        subject := upperStr(subject);
    end;
    Result := Result + SPACE + subject
  end;
end;

function beautify(const i: cardinal; const ZeroAsDigit: boolean; subject: string = 'file'): string; overload;
begin
  Result := sr32.beautify(i, Subject, ZeroAsDigit);
end;

var
  FileProcessedCtr: integer;
  FileChangedCtr: integer;
  BytesProcessedCtr: Int64;

  {
  // command for expos version
  // retained for search-replace algorithm exercise
  function SRCommand_old(const filename: string): integer; //; const LS, LR: TStrings);
  var
    SearchPattern, ReplaceWith: string;
    IgnoreCase: boolean;
    TestOnly: boolean;
    RevertFileTime: boolean;

  const
    test_ini = 'test.ini';
  var
    fs: TFileStream;
    p, pv: integer;
    age: integer;
    SLen, RLen: integer;
  var
    S, R, BigStr, SResult: string;
  begin
    FileProcessedCtr := integer(0);
    FileChangedCtr := integer(0);
    IgnoreCase := boolean(FALSE);
    RevertFileTime := boolean(FALSE);
    TestOnly := boolean(TRUE);
    Result := 0;
    if fileexists(filename) then begin
      write(SPACE2 + 'file: ' + extractfilename(filename) + COMMA + SPACE);
      age := FileAge(filename);
      S := quoteStr.Interpret(SearchPattern);
      R := quoteStr.Interpret(ReplaceWith);
      if (S <> '') and ((S <> R) or IgnoreCase) then begin
        expos.Init(S, IgnoreCase);
        fs := TFileStream.Create(filename, fmOpenReadWrite or fmShareDenyNone);
        try
          fs.Position := 0;
          write(SysUtils.IntToStr(fs.size) + SPACE + 'bytes' + COMMA + SPACE);
          SetLength(BigStr, fs.size);
          fs.Read(BigStr[1], fs.size);
          SResult := '';
          SLen := length(S);
          RLen := length(R);
          if SLen = 1 then begin
            p := expos.xPos(BigStr);
            case RLen of
              0: begin
                  SResult := BigStr;
                  while p > 0 do begin
                    inc(Result);
                    System.Delete(SResult, p, 1);
                    p := expos.xPos(SResult, p);
                  end;
                end;
              1: begin
                  SResult := BigStr;
                  while p > 0 do begin
                    inc(Result);
                    SResult[p] := R[1];
                    p := expos.xPos(SResult, p + 1);
                  end;
                end
            else begin
                pv := 1;
                while p > 0 do begin
                  inc(Result);
                  SResult := SResult + Copy(BigStr, pv, p - pv) + R;
                  pv := p + 1;
                  p := expos.xPos(BigStr, pv);
                end;
                SResult := SResult + Copy(BigStr, pv, length(BigStr));
              end;
            end;
          end
          else begin
            p := expos.xPos(BigStr);
            case RLen of
              0: begin
                  SResult := BigStr;
                  while p > 0 do begin
                    inc(Result);
                    System.Delete(SResult, p, SLen);
                    p := expos.xPos(SResult, p);
                  end;
                end;
            else begin
                pv := 1;
                while p > 0 do begin
                  inc(Result);
                  SResult := SResult + Copy(BigStr, pv, p - pv) + R;
                  pv := p + SLen;
                  p := expos.xPos(BigStr, pv);
                end;
                SResult := SResult + Copy(BigStr, pv, length(BigStr));
              end;
            end;
          end;
          if (Result > 0) and not (TestOnly) then begin
            // uncomment on final product
            fs.Size := 0;
            fs.Write(SResult[1], length(SResult));
            if RevertFileTime then
              FileSetDate(fs.Handle, age);
          end;
        finally
          fs.free;
        end;
      end;
      writeln(sr32.beautify(Result, 'changE'));
      inc(FileProcessedCtr);
      if Result > 0 then inc(FileChangedCtr);
    end;
  end;
  }

type
  TSROptions = packed record
    Search, Replace: string;
    FileList, ExcFileList, DirList: string;
    VerboseLevel: integer;
    IgnoreCase, Recursive, TimeRevert, TestOnly: boolean;
  end;

  TCommandArg = record
    Seekfor, Replacement: string;
    VerboseLevel, DiffLen: integer;
    TimeRevert: boolean;
    tx: txSearch;
  end;

function SRCommand(const filename: string; const arg: TCommandArg): integer;
const
  _bytes = 'byte';
  _changes = 'change';
  file_ = {SPACE2 + } 'file: ';
  INVALID = cxpos.INVALID_RETURN_VALUE;
var
  OldSize: integer;
begin
  Result := INVALID;
  inc(FileProcessedCtr);
  OldSize := cxpos.GetFileSize(FileName);
  if OldSize > 0 then begin
    inc(BytesProcessedCtr, OldSize);
    Result := arg.tx.ReplaceInFile(filename, arg.Replacement, 1, YES, arg.TimeRevert);
  end;
  if Result <> INVALID then inc(FileChangedCtr);
  if arg.VerboseLevel > 1 then begin
    if (arg.VerboseLevel > 2) or (Result <> INVALID) then begin
      if arg.VerboseLevel > 2 then
        write({file_ + }filename + ^j + SPACE2 +
          sr32.beautify(OldSize, _bytes, YES) + ' -> ')
      else
        write({file_ + }extractfilename(filename) + COMMA + SPACE +
          sr32.beautify(OldSize, _bytes, YES) + ' -> ');
      if Result = INVALID then
        writeln(sr32.beautify(0, _changes))
      else
        writeln(sr32.beautify(Result, _bytes, YES));
    end;
  end;
end;

function SRCmdTestOnly(const filename: string; const arg: TCommandArg): integer;
const
  _bytes = 'byte';
  _changes = 'change';
  file_ = {SPACE2 + } 'file: ';
var
  Size: integer;
begin
  Result := 0;
  inc(FileProcessedCtr);
  Size := cxpos.getFileSize(FileName);
  if Size > 0 then begin
    inc(BytesProcessedCtr, Size);
    Result := arg.tx.WordCountf(FileName);
  end;
  if Result > 0 then inc(FileChangedCtr);
  if arg.VerboseLevel > 1 then begin
    if (arg.VerboseLevel > 2) or (Result > 0) then begin
      if arg.VerboseLevel > 2 then
        write({file_ + }filename + ^j + SPACE2 +
          sr32.beautify(Size, _bytes, YES) + ' -> ')
      else
        write({file_ + }extractfilename(filename) + COMMA + SPACE +
          sr32.beautify(Size, _bytes, YES) + ' -> ');
      if Result < 1 then
        writeln(sr32.beautify(Result, _changes))
      else
        writeln(sr32.beautify(Size + (Result * arg.DiffLen), _bytes, YES) + ': ' +
          sr32.beautify(Result, _changes));
    end;
  end;
end;

procedure writeOptions(const SROptions: TSROptions); forward;

procedure proceed_sr(const SROptions: TSROptions);
const
  _byte = 'byte';
  _dir = 'directory';
  _file = 'file';
  Proc_ = 'Processing ';
  Exam_ = 'Examining ';
  Found_ = 'Found ';
  _match = 'match';
  Match_ = Found_;
  _processed = ' processed. ';
  Total_ = 'Total ';
  _modified = ' modified';
  _skipped = ' skipped';
  _of_ = ' of ';
  _from_ = ' from ';
  _in_ = ' in ';
  _oftotal_ = ' (total: ';
var
  tx: cxpos.txSearch;
  DirCtr, FileCtr: integer;
  arg: TCommandArg;
  Command: TFilesProcessor;
begin
  FileProcessedCtr := integer(0);
  FileChangedCtr := integer(0);
  BytesProcessedCtr := Int64(0);

  if SROptions.TestOnly = TRUE then
    Command := @SRCmdTestOnly
  else
    Command := @SRCommand;

  arg.Seekfor := quoteStr.interpret(SROptions.Search);
  arg.Replacement := quoteStr.interpret(SROptions.Replace);
  arg.VerboseLevel := SROptions.VerboseLevel;
  with arg do
    DiffLen := length(Replacement) - length(Seekfor);
  //arg.TestOnly := SROptions.TestOnly;
  arg.TimeRevert := SROptions.TimeRevert;

  tx := cxpos.txSearch.Create(arg.Seekfor, SROptions.IgnoreCase);
  arg.tx := tx;
  if SROptions.VerboseLevel > 0 then writeln('Processing...');
  try
    with SROptions do begin
      filescan.ScanFiles(DirCtr, FileCtr, FileList,
        ExcFileList, DirList, Recursive, nil, Command, @arg);
    end;
  finally
    tx.free;
  end;
  if SROptions.VerboseLevel > 0 then begin
    writeln('Done.');
    writeOptions(SROptions);
    writeln(Found_ + sr32.beautify(FileProcessedCtr, _match) + _from_ +
      sr32.beautify(FileCtr, TRUE) + _in_ +
      sr32.beautify(DirCtr, _dir));
    write(Total_ + sr32.beautify(BytesProcessedCtr, _byte, YES) + _processed);
    writeln(sr32.beautify(FileChangedCtr) + _modified + COMMA + SPACE +
      sr32.beautify(FileProcessedCtr - FileChangedCtr) + _skipped);
  end;
end;

procedure writeOptions(const SROptions: TSROptions);
const
  VerboseDescriptions: array[0..MAXVERBOSE] of string =
  ('', 'summary', 'brief list, modified files only', 'verbose list, all processed files');
begin
  with SROptions do begin
    with SROptions do
      writeln('Verbose Level: ' + char(VerboseLevel + ord('0')) +
        ' (' + VerboseDescriptions[VerboseLevel] + ')');
    write('- FileList: ');
    if FileList = '' then write('ALL FILES')
    else writeln(FileList);

    write('- DirList: ');

    if DirList = '' then writeln('CURRENT-DIR')
    else writeln(DirList);

    writeln('- Exclude: ' + ExcFileList);
    writeln('- SEARCH for: ' + '[' + Search + ']');
    writeln('- REPLACE with: ' + '[' + Replace + ']');
    write(SPACE2 + '(case-');
    if IgnoreCase then write('in');
    write('sensitive, ');
    if not Recursive then write('non-');
    write('recursive, ');

    if TestOnly then write('test-only, ')
    else write('write change, ');

    if TimeRevert then write('retain-filetime')
    else write('update-filename');
    writeln(')');
  end;
end;

function testme: boolean;
var
  L: integer;
  S: string;
begin
  S := ParamStr(1); L := length(S);
  Result := (L in [2..3]) and (S[1] = SWCHAR) and (upCase(S[2]) = SW_ARGTEST) and
    ((L = 2) or ((S[3] in ['1'..'9'])));
end;

function helpme: boolean;
var
  h1, h2, S, r: integer;
begin
  h1 := getOpts.SwitchIndex(SW_HELP);
  if h1 = 1 then
    Result := TRUE
  else begin
    h2 := getOpts.SwitchIndex(SW_HELP2);
    if h2 = 1 then
      Result := TRUE
    else begin
      S := getOpts.SwitchIndex(SW_SEARCH);
      if (S > 0) then begin
        if (h1 > 1) and (h1 = S + 1) then h1 := -1;
        if (h2 > 1) and (h2 = S + 1) then h2 := -1;
      end
      else begin
        r := getOpts.SwitchIndex(SW_REPLACE);
        if (r > 0) then begin
          if (h1 > 1) and (h1 = r + 1) then h1 := -1;
          if (h2 > 1) and (h2 = r + 1) then h2 := -1;
        end;
      end;
      Result := (h1 > 1) or (h2 > 1);
    end;
  end;
end;

var
  S: string;
  SROptions: TSROptions;
  i: integer;

const
  MINARGS = 1;
  DELIMITER = filescan.DEFAULT_LIST_DELIMITER;
  OffSwitches = SW_FILES + SW_XFILES + SW_DIRS + SW_SEARCH + SW_REPLACE;

begin //MAIN PROCEDURE
  if (ParamCount < MINARGS) then
    ShowHELP
  else if testme then
    ShowTEST
  else if helpme then
    ShowHelp
  else begin
    fillchar(SROptions, sizeof(TSROptions), #0);
    SROptions.Search := getOpts.GetSwitchValues(SW_SEARCH, BLANK_DELIMITER);
    //with SROptions do Search := quoteStr.interpret(Search);
    //we'll do it later for clarity purpose
    if quoteStr.interpret(SROptions.Search) = '' then begin
      ShowHelp;
      writeln(^j'Error!'^j'Search Pattern must NOT be blank');
    end
    else begin
      with SROptions do begin
        FileList := getOpts.GetUnSwitchedValues(OffSwitches) + DEFAULT_LIST_DELIMITER +
          getOpts.GetSwitchValues(SW_FILES);
        while (length(FileList) > 0) and (FileList[length(FileList)] = DEFAULT_LIST_DELIMITER) do
          delete(FileList, length(FileList), 1);
        while (length(FileList) > 0) and (FileList[1] = DEFAULT_LIST_DELIMITER) do
          delete(FileList, 1, 1);
      end;
      if SROptions.FileList = '' then begin
        ShowHelp;
        writeln(^j'Error!'^j'No file has been specified');
      end
      else begin
        with SROptions do begin
          VerboseLevel := MAXVERBOSE;
          for i := VerboseLevel downto 0 do
            if getOpts.SwitchIndex(SW_VERBOSE + intoStr(i)) > 0 then begin
              VerboseLevel := i;
              break;
            end;
          Replace := getOpts.GetSwitchValues(SW_REPLACE, BLANK_DELIMITER);
          //Replace := quoteStr.interpret(Replace);
          //we'll do it later for clarity purpose
          IgnoreCase := getOpts.SwitchIndex(SW_IGNORE) > 0;
          Recursive := getOpts.SwitchIndex(SW_RECURSE) > 0;
          TimeRevert := getOpts.SwitchIndex(SW_NOTIME) > 0;
          TestOnly := getOpts.SwitchIndex(SW_NOTREAL) > 0;
          //TestOnly := TRUE;
          ExcFileList := getOpts.GetSwitchValues(SW_XFILES);
          if ExcFileList <> '' then
            ExcFileList := DEFAULT_LIST_DELIMITER + ExcFileList;
          ExcFileList := extractfilename(ParamStr(0)) + ExcFileList;
          DirList := getOpts.GetSwitchValues(SW_DIRS);
          S := getOpts.GetSwitchValues('');
          if S <> '' then begin
            if FileList <> '' then
              FileList := FileList + DELIMITER + S
            else
              FileList := S
          end;
          proceed_sr(SROptions);
        end;
      end;
    end;
  end;
end.

