unit u_main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Grids, CTLibGrid, CheckLst, CTLibChkListBox,
  CTLibComboBox, CTLibListBox, CTLibDatabase, CTLibQuery, Menus;

type
  Tf_main = class(TForm)
    Label3: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    btn_connect: TButton;
    e_password: TEdit;
    e_username: TEdit;
    cb_servers: TComboBox;
    btn_close: TButton;
    lb: TListBox;
    ct_lb: TCTLibListBox;
    ct_cb: TCTLibComboBox;
    ct_clb: TCTLibChkListBox;
    btn_about: TButton;
    grid: TCTLibGrid;
    m_sql: TMemo;
    Splitter1: TSplitter;
    btn_execute: TButton;
    query: TCTLibQuery;
    Panel1: TPanel;
    Label4: TLabel;
    lb_databases: TCTLibComboBox;
    MainMenu1: TMainMenu;
    Close1: TMenuItem;
    Execute1: TMenuItem;
    Connect1: TMenuItem;
    BulkCopy1: TMenuItem;
    N7About1: TMenuItem;
    CTTable1: TMenuItem;
    ObjectInfo1: TMenuItem;
    db: TCTLibDatabase;
    CTLibFunctions1: TMenuItem;
    procedure btn_connectClick(Sender: TObject);
    procedure btn_executeClick(Sender: TObject);
    procedure btn_closeClick(Sender: TObject);
    procedure btn_aboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lb_databasesChange(Sender: TObject);
    procedure BulkCopy1Click(Sender: TObject);
    procedure CTTable1Click(Sender: TObject);
    procedure ObjectInfo1Click(Sender: TObject);
    procedure CTLibFunctions1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  f_main: Tf_main;

implementation

uses u_bulkcopy, u_cttable, u_info, u_functions;

{$R *.DFM}

procedure Tf_main.btn_connectClick(Sender: TObject);
begin
  db.ServerName:=cb_servers.text;
  db.UserName:=e_username.text;
  db.Password:=e_password.Text;
  if btn_connect.Caption='Connect' then
    db.Connect
  else
    db.DisConnect;
  if db.Connected then
  begin
    btn_connect.Caption:='DisConnect';
    Caption:='CT-Lib Demo - Connected to ' + db.DbName;
    lb_databases.SqlExec;
    if lb_databases.Items.Count > 0 then
      lb_databases.ItemIndex:=0;
  end
  else
  begin
    btn_connect.Caption:='Connect';
    Caption:='CT-Lib Demo - NOT Connected';
  end;
end;

procedure Tf_main.btn_executeClick(Sender: TObject);
begin
  if db.connected then
  begin
    grid.sql:=m_sql.text;
    grid.SqlExec;
{
    lb.items.clear;
    query.sqlexec;
    while query.Row_Exists do
      lb.Items.add(query.column[1]);

    ct_lb.sqlexec;
    ct_cb.sqlexec;
    ct_clb.sqlexec;}
  end
  else
    MessageBox(GetActiveWindow,PChar('Not connected'),pchar('CT-Lib demo'),mb_ok+mb_iconexclamation);
end;

procedure Tf_main.btn_closeClick(Sender: TObject);
begin
  db.DisConnect;
  close;
end;

procedure Tf_main.btn_aboutClick(Sender: TObject);
begin
  MessageBox(GetActiveWindow,PChar('Open Client CT-Lib components demo. for more intomation contact Stephan Marais at fmarais@idt.net'),pchar('CT-Lib demo'),mb_ok+mb_iconexclamation);
end;

procedure Tf_main.FormCreate(Sender: TObject);
begin
  cb_servers.Items:=db.ServerList;
  if cb_servers.items.count>0 then
    cb_servers.ItemIndex:=0;
end;

procedure Tf_main.lb_databasesChange(Sender: TObject);
begin
  if db.connected then
  begin
    db.DBName:=lb_databases.text;
    Caption:='CT-Lib Demo - Connected to ' + db.DbName;
  end;

end;

procedure Tf_main.BulkCopy1Click(Sender: TObject);
begin
  if not db.connected then
  begin
    MessageBox(GetActiveWindow,PChar('You have to connect first'),pchar('CT-Lib demo'),mb_ok+mb_iconexclamation);
    exit;
  end;
  f_bulkcopy:=Tf_bulkcopy.Create(Self);
  f_bulkcopy.showmodal;
  f_bulkcopy.Free;
end;

procedure Tf_main.CTTable1Click(Sender: TObject);
begin
  if not db.connected then
  begin
    MessageBox(GetActiveWindow,PChar('You have to connect first'),pchar('CT-Lib demo'),mb_ok+mb_iconexclamation);
    exit;
  end;
  f_tcttable:=Tf_tcttable.Create(Self);
  f_tcttable.showmodal;
  f_tcttable.Free;
end;

procedure Tf_main.ObjectInfo1Click(Sender: TObject);
begin
  if not db.connected then
  begin
    MessageBox(GetActiveWindow,PChar('You have to connect first'),pchar('CT-Lib demo'),mb_ok+mb_iconexclamation);
    exit;
  end;
  f_info:=Tf_info.Create(Self);
  f_info.ShowModal;
  f_info.Free;
end;

procedure Tf_main.CTLibFunctions1Click(Sender: TObject);
begin
  if not db.connected then
  begin
    MessageBox(GetActiveWindow,PChar('You have to connect first'),pchar('CT-Lib demo'),mb_ok+mb_iconexclamation);
    exit;
  end;
  f_functions:=Tf_functions.Create(Self);
  f_functions.showmodal;
  f_functions.Free;
end;

end.


