unit u_info;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CTLibObjInfo, Menus, CTLibBase;

type
  Tf_info = class(TForm)
    btn_close: TButton;
    lb_objects: TListBox;
    info: TCTLibObjInfo;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    m_text: TMemo;
    PopupMenu1: TPopupMenu;
    Procedures1: TMenuItem;
    UserTables1: TMenuItem;
    SystemTables1: TMenuItem;
    Views1: TMenuItem;
    Triggers1: TMenuItem;
    Rules1: TMenuItem;
    Button10: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Procedures1Click(Sender: TObject);
    procedure Views1Click(Sender: TObject);
    procedure Triggers1Click(Sender: TObject);
    procedure UserTables1Click(Sender: TObject);
    procedure SystemTables1Click(Sender: TObject);
    procedure Rules1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button10Click(Sender: TObject);
  private
    ObId    :SmallInt;
  public
    { Public declarations }
  end;

var
  f_info: Tf_info;

implementation

{$R *.DFM}

procedure Tf_info.Button1Click(Sender: TObject);
begin
  if (lb_objects.itemindex >=0)
    and (ObId <> 4)
    and (ObId <> -1)
    and (ObId <> 5) then
   m_text.text:=info.GetObjectText(lb_objects.items[lb_objects.itemindex]);

  if (lb_objects.itemindex >=0)
    and ((ObId = 4) or (ObId = 5)) then
   m_text.lines:=info.GetCreateTableText(lb_objects.items[lb_objects.itemindex]);
end;

procedure Tf_info.Button2Click(Sender: TObject);
begin
  PopupMenu1.Popup(f_info.Left + Button2.Left, f_info.Top + Button2.Top);
end;

procedure Tf_info.Button3Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetDatabaseNames;
end;

procedure Tf_info.Button4Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetUserNames;
end;

procedure Tf_info.Button5Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetGroupNames;
end;

procedure Tf_info.Button6Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetSystemDataTypes;
end;

procedure Tf_info.Button7Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetUserDataTypes;
end;

procedure Tf_info.Button8Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetIndexNames;
end;

procedure Tf_info.Button9Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetSegmentNames;
end;

procedure Tf_info.Procedures1Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetObjectNames('P');
  ObId:=1;
end;

procedure Tf_info.Views1Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetObjectNames('V');
  ObId:=2;
end;

procedure Tf_info.Triggers1Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetObjectNames('TR');
  ObId:=3;
end;

procedure Tf_info.UserTables1Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetObjectNames('U');
  ObId:=4;
end;

procedure Tf_info.SystemTables1Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetObjectNames('S');
  ObId:=5;
end;

procedure Tf_info.Rules1Click(Sender: TObject);
begin
  lb_objects.Items:=info.GetObjectNames('R');
  ObId:=6;
end;

procedure Tf_info.FormCreate(Sender: TObject);
begin
  ObId:=-1;
end;

procedure Tf_info.Button10Click(Sender: TObject);
begin
  if (lb_objects.itemindex >=0) then
//    and ((ObId = 4) or (ObId = 5)) then
   m_text.lines:=info.GetIndexColumns(lb_objects.items[lb_objects.itemindex]);
end;

end.
