unit u_cttable;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CTLibComboBox, Db, CTTable, ExtCtrls, DBCtrls, Grids, DBGrids,
  CTDataSet;

type
  Tf_tcttable = class(TForm)
    cb_tables: TCTLibComboBox;
    Label1: TLabel;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    btn_close: TButton;
    btn_openclose: TButton;
    Table1: TCTTable;
    procedure FormCreate(Sender: TObject);
    procedure cb_tablesChange(Sender: TObject);
    procedure btn_opencloseClick(Sender: TObject);
    procedure btn_closeClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  f_tcttable: Tf_tcttable;

implementation

{$R *.DFM}

procedure Tf_tcttable.FormCreate(Sender: TObject);
begin
  cb_tables.SqlExec;
  if cb_tables.Items.Count > 0 then
  begin
    cb_tables.ItemIndex:=0;
    cb_tablesChange(self);
  end;
end;

procedure Tf_tcttable.cb_tablesChange(Sender: TObject);
begin
  Table1.TableName:=cb_tables.Text;
end;

procedure Tf_tcttable.btn_opencloseClick(Sender: TObject);
begin
  Table1.Active:=not Table1.Active;
  if Table1.Active then
    btn_openclose.Caption:='Close DataSet'
  else
    btn_openclose.Caption:='Open DataSet'
end;

procedure Tf_tcttable.btn_closeClick(Sender: TObject);
begin
  Table1.Active:=False;
  Close;
end;

end.
