unit u_bulkcopy;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CTLibComboBox, CTLibBulk, CTLibListBox, ExtCtrls, CTLibDatabase;

type
  Tf_bulkcopy = class(TForm)
    bk: TCTLibBulk;
    lb_tablename: TCTLibListBox;
    Label1: TLabel;
    OpenDialog1: TOpenDialog;
    e_file: TEdit;
    Label2: TLabel;
    btn_file: TButton;
    RadioGroup1: TRadioGroup;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    btn_close: TButton;
    btn_copy: TButton;
    e_cnt: TEdit;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure btn_fileClick(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure e_fileChange(Sender: TObject);
    procedure lb_tablenameClick(Sender: TObject);
    procedure btn_closeClick(Sender: TObject);
    procedure btn_copyClick(Sender: TObject);
    procedure bkAfterRow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    cnt      :integer;
  end;

var
  f_bulkcopy: Tf_bulkcopy;

implementation
uses u_main;

{$R *.DFM}

procedure Tf_bulkcopy.FormCreate(Sender: TObject);
begin
  lb_tablename.SqlExec;
  if lb_tablename.items.Count>0 then
    lb_tablename.ItemIndex:=0;
end;

procedure Tf_bulkcopy.btn_fileClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
    e_file.Text:=OpenDialog1.FileName;
end;

procedure Tf_bulkcopy.RadioButton1Click(Sender: TObject);
begin
  if RadioButton1.Checked then
    bk.Direction:=bdIn;
end;

procedure Tf_bulkcopy.RadioButton2Click(Sender: TObject);
begin
  if RadioButton2.Checked then
    bk.Direction:=bdOut;
end;

procedure Tf_bulkcopy.e_fileChange(Sender: TObject);
begin
  bk.DataFile:=e_file.text;
end;

procedure Tf_bulkcopy.lb_tablenameClick(Sender: TObject);
begin
  bk.TableName:=lb_tablename.Items[lb_tablename.ItemIndex];
end;

procedure Tf_bulkcopy.btn_closeClick(Sender: TObject);
begin
  close;
end;

procedure Tf_bulkcopy.btn_copyClick(Sender: TObject);
begin
  cnt:=0;
  if trim(e_file.text)='' then
  begin
    MessageBox(GetActiveWindow,PChar('Invalid filename'),pchar('CT-Lib demo'),mb_ok+mb_iconexclamation);
    exit;
  end;
  if lb_tablename.itemindex=-1 then
  begin
    MessageBox(GetActiveWindow,PChar('Invalid tablename'),pchar('CT-Lib demo'),mb_ok+mb_iconexclamation);
    exit;
  end;

  bk.DataFile:=e_file.text;
  bk.TableName:=lb_tablename.Items[lb_tablename.ItemIndex];
  try
    screen.cursor:=crSQLWait;
    bk.BulkCopy;
  finally
    screen.cursor:=crDefault;
//    MessageBox(GetActiveWindow,PChar(inttostr(bk.RowsCopied) + ' rows copied'),pchar('CT-Lib demo'),mb_ok+mb_iconexclamation);
  end;  

end;

procedure Tf_bulkcopy.bkAfterRow(Sender: TObject);
begin
  inc(cnt);
  e_cnt.Text:=inttostr(cnt);
  e_cnt.refresh;
end;

end.
