unit CMYKTst;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, PGCMYK, StdCtrls;

type
  TCMYKForm = class(TForm)
    PgCMYKImage1: TPgCMYKImage;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    LoadImage1: TMenuItem;
    Exit1: TMenuItem;
    SaveCImage1: TMenuItem;
    SaveMImage1: TMenuItem;
    SaveYImage1: TMenuItem;
    SaveKImahe1: TMenuItem;
    CImage: TImage;
    MImage: TImage;
    YImage: TImage;
    KImage: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Effects1: TMenuItem;
    Convert1: TMenuItem;
    procedure FormActivate(Sender: TObject);
    procedure LoadImage1Click(Sender: TObject);
    procedure SaveCImage1Click(Sender: TObject);
    procedure SaveMImage1Click(Sender: TObject);
    procedure SaveYImage1Click(Sender: TObject);
    procedure SaveKImahe1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Convert1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CMYKForm: TCMYKForm;

implementation

{$R *.DFM}

procedure TCMYKForm.FormActivate(Sender: TObject);
begin
  PgCMYKImage1.CBitMap := CImage.Picture.Bitmap;
  PgCMYKImage1.MBitMap := MImage.Picture.Bitmap;
  PgCMYKImage1.YBitMap := YImage.Picture.Bitmap;
  PgCMYKImage1.KBitMap := KImage.Picture.Bitmap;
end;

procedure TCMYKForm.LoadImage1Click(Sender: TObject);
begin
  IF OpenDialog1.Execute Then
    PgCMYKImage1.Picture.LoadFromFile(OpenDialog1.FileName);
end;

procedure TCMYKForm.SaveCImage1Click(Sender: TObject);
begin
  IF SaveDialog1.Execute Then
    CImage.Picture.SaveToFile(SaveDialog1.FileName);
end;

procedure TCMYKForm.SaveMImage1Click(Sender: TObject);
begin
  IF SaveDialog1.Execute Then
    MImage.Picture.SaveToFile(SaveDialog1.FileName);
end;

procedure TCMYKForm.SaveYImage1Click(Sender: TObject);
begin
  IF SaveDialog1.Execute Then
    YImage.Picture.SaveToFile(SaveDialog1.FileName);
end;

procedure TCMYKForm.SaveKImahe1Click(Sender: TObject);
begin
  IF SaveDialog1.Execute Then
    KImage.Picture.SaveToFile(SaveDialog1.FileName);
end;

procedure TCMYKForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TCMYKForm.Convert1Click(Sender: TObject);
begin
  PgCMYKImage1.Convert;
  CImage.Refresh;
  MImage.Refresh;
  YImage.Refresh;
  KImage.Refresh;
end;

end.
