
{========================================================================================)
  Component DhCheckFolder Version 1.1, Dec. 2000
{========================================================================================)


    Description:
    ============
    Displays all System-Folder and Drives ( Network too ). All folder with State-Icons
    and you can check them and save the checks to disk.


    Author:
    =======
    (c) Hubert Indetzki 1998, 2000
    Dammer Hof 12
    49088 Osnabrueck
    Germany


    V 1.0:
     - now running under Delphi 4.0
     - changed Component-Name from SystemFolderList to DhCheckFolder
     - added Desktop-Icon
     - added property ChangeFolder
     - removed property StateBoxes
     - changed procedure CreateStates               r1
     - added property CheckBoxes                    r1
     - added CheckDriveList                         r1
     - procedure KeyDown changed (better Ergonomy)  r1
     - changed CheckDriveList to public             r1
    V 1.1:
     - Network supported
     - added procedure SaveCheckedFolder
     - added public procedure SetInitialDir
     - added RefreshNode                            r1
     - whole Network supported                      r1
     - Desktop-Folder supported                     r2

{========================================================================================}


unit DhCheckFolder11;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ShellApi, ShlObj, ComObj, Commctrl, ActiveX, StdCtrls, ExtCtrls,
  Menus, FileCtrl;


const
  NOT_CHECKED = $01;
  CHECKED = $02;
  GRAY_CHECKED = $03;
  NEUTRAL = $04;
  crPencil = $05;
  TIMER_INTERVALL = 100;
const
  DEFAULT_INITIAL_DIR = 'C:\';
  WINDOWS_DRIVE = 'C:\';
  DESKTOP_PATH = 'C:\Windows\Desktop';
  DOUBLE_SLASH = '\\';
const
  // Peter Stotz says : All-Attributes is passed to an IShellFolder when creating or
  // updating a node. The remarked attributes cause on some systems an access to the
  // drives A and B.
  ALL_ATRIBUTES =  SFGAO_HASPROPSHEET or SFGAO_DROPTARGET or SFGAO_CAPABILITYMASK or
                   SFGAO_LINK or SFGAO_SHARE or SFGAO_GHOSTED or SFGAO_FILESYSANCESTOR or
                   SFGAO_FOLDER or SFGAO_FILESYSTEM or SFGAO_HASSUBFOLDER or
                   SFGAO_CONTENTSMASK or SFGAO_REMOVABLE or SFGAO_COMPRESSED;
                   {SFGAO_CANRENAME or SFGAO_CANDELETE or SFGAO_READONLY or SFGAO_VALIDATE
                    or SFGAO_DISPLAYATTRMASK}

const
  WEB_ATTR_DOS = $14;             // "C:\Windows\Web";                            SysFile
  COOKIES_ATTR_DOS = $14;         // "C:\Windows\Cookies";                        SysFile
  TI_FILES_ATTR_DOS = $16;        // "C:\Windows\Temporary Internet Files";       SysFile
  HIS6_ATTR_DOS = $16;            // "C:\Windows\His6;                            SysFile
  RECYCLED_ATTR_DOS = $17;        // virtual folder;                              SysFile
  HISTORY_ATTR_DOS = $14;         // virtual folder;                              SysFile
  DPF_ATTR_DOS = $14;             // virtual folder ( Downloaded Program Files ); SysFile
  OW_ATTR_DOS =  $11;             // virtual folder ( Offline Webpages )

  DESKTOP_ATTR = $F0000050;       // Desktop-Icon (items[0])
  WORKSTATION_ATTR = $B0000154;   // Workstation-Icon (items[1])
  NETWORK_MAIN_ATTR = $B0000144;  // Network-Root-Main-Icon
  NETWORK_SUB_ATTR = $B0000044;   // whole network + workgroup + client, server

  WHOLE_NETWORK_ICON = $0D;       // Whole-Network-Icon ( tested on my machine !!! )
                                  // If not the same on yours, then you must change it.
  WORKSTATION_ICON = $32;         // local Workstation
  NETWORK_MAIN_ICON = $12;        // Network-MainIcon
  WORKGROUP_ICON = $12;           // WorkGroup-Icon
  HOST_ICON = $0F;                // RootIcon for the Network-Drives
  NORMAL_FOLDER_ICON = $03;

  DESKTOP_FOLDER : array[1..2] of integer = ( CSIDL_DRIVES, CSIDL_NETWORK );


type
  TOnChangeFolderEvent = procedure ( path : string ) of object;    // added
  TStateClickEvent = procedure ( StateChecked : boolean ) of object;
  TDhCheckFolder = class(TCustomTreeView)
  private
   fNode : tTreeNode;
   fNetworkMainAttr : ULONG;
   fNetworkSubAttr : ULONG;
   fDesktopIcon : integer;
   fWorkstationIcon : integer;
   fNetWorkIcon : integer;
   fSortFolder : boolean;
   fInitialDir : string;
   fCountCheckedFolder : integer;
   fCheckBoxes : boolean;
   fRootShellFolder : iShellFolder;
   fSomeFolderChecked : boolean;
   fOnChangeFolder : tOnChangeFolderEvent;
   fDirectory : string;
   fPidlPath : PItemIdList;
   fCanExpand : boolean;
   fItemsCount : integer;
   fStateClickEvent : tStateClickEvent;
   fListCheckedFolder : tStringList;
   fStateImageList : tImageList;
   fFullPidlPathList : tList;
  protected
   procedure RecreatePathInTree ( path : string; node : tTreeNode );
   procedure MakeDriveVisible ( list : tStringList );
   procedure CheckFolder ( node : tTreeNode );
   procedure CreateWnd; override;
   procedure DestroyWnd; override;
   procedure Loaded; override;
   procedure SetCheckBoxes ( value : boolean );
   function GetStateChecked : boolean;
   procedure SetStateChecked ( value : boolean );
   function GetListCheckedFolder : tStringList;
   procedure AddCheckedFolderToList ( folder : string );
   procedure InitialisizeComponent;
   procedure AddSubNodesWithFolder ( path : string );
   procedure AddSubNodesWithNode ( node : tTreeNode );
   function FindNodeInTreeView ( node : tTreeNode; path : string ): integer;
   function ExploreNetwork : boolean;
   procedure SwitchStateIndex ( node : tTreeNode; attr : ULONG );
   procedure EnumerateFolder (  ShellFolder: IShellFolder; mask : DWORD; node : tTreeNode );
   procedure ClearAllItems;
   procedure RefreshNode ( node : tTreeNode );
   //procedure CNNotify ( var message: tWMNotify ); message CN_NOTIFY;
   function ProofStates ( node : tTreeNode ) : boolean;
   procedure MouseMove( Shift: TShiftState; X, Y: Integer); override;
   procedure DblClick; override;
   procedure click; override;
   procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
   procedure Changing ( Sender: TObject; Node: TTreeNode; var AllowChange: Boolean ); //override;
   procedure Change ( Node: TTreeNode ); override;  //tCustomTreeView

   procedure KeyDown (  var Key: Word; Shift: TShiftState ); override;
   function CanExpand ( node: tTreeNode ) : boolean; override;
   function CanCollapse ( node: tTreeNode ) : boolean; override;
   function CheckSibling ( node : tTreeNode ) : boolean;
   procedure CheckParentFolder ( node : tTreeNode );
   procedure CheckSubFolder ( node : tTreeNode );
   procedure CreateImages;
   procedure CreateStates;
  public
   constructor create (aOwner: tComponent); override;
   destructor destroy; override;
   property PidlPath : PItemIdList read fPidlPath;  // changed
   procedure ClearAllChecks;
   procedure SetInitialDir ( path : string );
   procedure SaveCheckedFolder ( FileName : string );
   procedure LoadCheckedFolder ( FileName : string );
  published
   //property InitialDir : string read fInitialDir write SetInitialDir;
   property CountCheckedFolder : integer read fCountCheckedFolder;
   property CheckBoxes : boolean read FCheckBoxes write SetCheckBoxes
    default true;
   property OnChangeFolder : tOnChangeFolderEvent read fOnChangeFolder
                                                          write fOnChangeFolder;
   property NodeChecked : boolean read GetStateChecked write SetStateChecked
    default false;
   property OnStateClick : tStateClickEvent read fStateClickEvent
                                             write fStateClickEvent;
   property ListCheckedFolder : tStringList read GetListCheckedFolder
                                            write fListCheckedFolder;
   property AutoExpand;
   property ReadOnly;
   property Align;
   property Enabled;
   property Font;
   property HideSelection;
   property Items;
   property ParentColor;
   property PopupMenu;
   property Selected;
   property TabOrder;
   property TabStop default true;
   property Visible;
   //property OnMouseMove;
  end;


{ *************************** SUBROUTINES ************************************* }
function CountCharsInString ( s : string; c : char ) : integer;
function GetPidlFileAttribut ( path : string ) : boolean;
function CombinePidls ( id1, id2 : PItemIDList ) : PItemIDList;

function GetPidlSize ( pidl: PItemIdList ) : integer;
function GetDirectory ( ShellFolder : IShellFolder; idList : PItemIDList; Flags : DWORD ) :
                                                                                   string;
function GetSelectedIcon ( list : PItemIdList ) : integer;
function GetNormalIcon ( list : PItemIdList ) : integer;
function RemoveSlash ( s : string ) : string;


procedure Register;

implementation

{$R DhCheckFolder11.res}



var
  ShellMalloc : iMalloc;


function CountCharsInString ( s : string; c : char ) : integer;
var
  i : integer;
begin
  result := 0;
  i := pos ( c, s );
  while i > 0 do
   begin
    inc(result);
    s := copy ( s, i+1, pred(length(s)) );
    i := pos ( c, s );
   end;
end;


function IsItADrive ( path : string ) : boolean;
var
  info : tShFileInfo;
  HexAttr : string;
begin
  result := false;
  FillChar ( info.szTypeName, 80, ' ' );
  SHGetFileInfo ( PChar( path), 0, info, sizeof ( info ), SHGFI_ATTRIBUTES or//);
                                                                         SHGFI_TYPENAME );
  HexAttr := IntToHex (info.dwAttributes, 4);
  //if ( info.dwAttributes = DRIVE_ATTR ) then
  if ( info.szTypeName = 'Hallo' ) then
   result := true;
end;


function GetPidlFileAttribut ( path : string ) : boolean;
var
  info : tShFileInfo;
begin
  result := false;
  SHGetFileInfo ( PChar( path), 0, info, sizeof ( info ), SHGFI_ATTRIBUTES );
  if ( info.dwAttributes and SFGAO_FILESYSTEM ) > 0 then
   result := true;
end;


function RemoveSlash ( s : string ) : string;
begin
  if (length(s) > 0) and (s[length(s)] = '\') then
   result := copy ( s, 1, pred(length(s)) )
    else
     result := s;
end;


function AddSlash ( s : string ) : string;
begin
  if ( length(s) > 0 ) and ( s[length(s)] <> '\' ) then
   result := s + '\'
    else
     result := s;
end;


procedure SplitPathToList ( path : string; list : tStringList );
var
  index : integer;
  dir : string;
  temp : string;
begin
  path := AddSlash ( path );
  temp := path;
  index := pos ( '\', temp  );
  while index > 0 do
   begin
    dir := copy ( path, 1, pred(index) );
    if length(dir) > 1 then list.add ( dir );
    temp[index] := ' ';
    index := pos ( '\', temp  );
   end;
end;


function GetPidlSize ( pidl: PItemIdList ): integer;
begin
  result := 0;
  if pidl <> nil then
   begin
    inc ( result, SizeOf(pidl^.mkid.cb) );
    while pidl^.mkid.cb <> 0 do
     begin
      inc ( result, pidl^.mkid.cb );
      inc ( longint(pidl), pidl^.mkid.cb );
     end;
   end;
end;


function CreatePIDL ( size: UINT): PItemIDList;
begin
  result := ShellMalloc.Alloc(size);
  if result <> nil then
   FillChar ( result^, size, #0 );
end;


function CombinePIDLs ( id1, id2: PItemIDList ): PItemIDList;
var
  s1, s2 : UINT;
begin
  if (id1 <> nil) then
   s1 := GetPIDLSize(id1) - SizeOf(id1.mkid.cb)
   else
    s1 := 0;
  s2 := GetPIDLSize(id2);

  result := CreatePIDL(s1 + s2);
  if result <> nil then
   begin
    if (id1 <> nil) then
     move ( id1^, result^, s1 );
    move ( id2^, PChar(result)[s1], s2 );
   end;
end;


function GetDirectory ( ShellFolder : iShellFolder;
                                 IdList : pItemIdList; flags : DWORD ) : string;
var
  str : tStrRet;
  name : string;
begin
  name := '';
  if ShellFolder.GetDisplayNameOf ( IdList, flags, str ) = NOERROR then
  begin
    case str.uType of
     STRRET_WSTR :
      name := WideCharToString(str.pOleStr);
     STRRET_OFFSET :
      name := PChar(ULONG(IdList) + str.uOffset);
     STRRET_CSTR :
      name := str.cStr;
    end;
  end;
  result := RemoveSlash ( name );
end;


function GetFolderAttribut ( list : pItemIdList ) : integer;
var
  info : tShFileInfo;
  HexAttr : string;
begin
  FillChar ( info.szDisplayName, MAX_PATH, ' ' );
  info.dwAttributes := $00000000;
  ShGetFileInfo ( PChar(list), 0, info, SizeOf(tShFileInfo), SHGFI_PIDL or
                                                   SHGFI_DISPLAYNAME or SHGFI_ATTRIBUTES );
  HexAttr := IntToHex ( info.dwAttributes, 4 );
  result := info.dwAttributes;
end;


function GetNormalIcon ( list : pItemIdList ) : integer;
var
  info : tShFileInfo;
begin
  ShGetFileInfo ( PChar(list), 0, info, SizeOf(tShFileInfo), SHGFI_PIDL or
                                             SHGFI_SYSICONINDEX or SHGFI_SMALLICON );
    result := info.iIcon;
end;


function GetSelectedIcon ( list : pItemIdList ) : integer;
var
  info : tShFileInfo;
begin
  ShGetFileInfo ( PChar(list), 0, info, SizeOf(tShFileInfo), SHGFI_PIDL or
                            SHGFI_SYSICONINDEX or SHGFI_SMALLICON or SHGFI_OPENICON );
  result := info.iIcon;
end;


constructor TDhCheckFolder.create;
begin
  inherited create(aOwner);
  width := 220;
  height := 140;
  CreateStates;
  CreateImages;
  fCheckBoxes := true;
  fCanExpand := true;
  fNode := nil;
  fDesktopIcon := -1;
  FWorkstationIcon := -1;
  FNetWorkIcon := -1;
  fNetworkMainAttr := 0;
  fNetworkSubAttr := 0;
  fSortFolder := true;
  fInitialDir := DEFAULT_INITIAL_DIR;
  OnChanging := Changing;
  fFullPidlPathList := tList.create;
  fListCheckedFolder := tStringList.create;
  fListCheckedFolder.sorted := true;
  fListCheckedFolder.duplicates := dupIgnore; 
end;


destructor TDhCheckFolder.destroy;
Begin
  ClearAllItems;
  fFullPidlPathList.free;
  fListCheckedFolder.free;
  images.free;
  if assigned ( StateImages ) then
   fStateImageList.free;
  inherited;
End;


procedure TDhCheckFolder.CreateWnd;
var
  index : integer;
begin
  inherited CreateWnd;

  font.size := 8;
  font.name := 'arial';

  if not ( csLoading in ComponentState ) then
   begin
    InitialisizeComponent;
    // select InitialDir
    index := FindNodeInTreeview ( items[0], fInitialDir );
    if index > 0 then items[index].selected := true;
   end;
end;


procedure TDhCheckFolder.DestroyWnd;
begin
  inherited DestroyWnd;
end;


procedure TDhCheckFolder.Loaded;
var
  index : integer;
begin
  inherited Loaded;
  InitialisizeComponent;
  // select InitialDir
  index := FindNodeInTreeview ( items[0], fInitialDir );
  if index > 0 then items[index].selected := true;
end;


procedure TDhCheckFolder.SetCheckBoxes ( value : boolean );
begin
  fCheckBoxes := value;
  if value then
   StateImages := fStateImageList
    else
     StateImages := nil;
end;


function TDhCheckFolder.GetStateChecked : boolean;
var
  node : tTreeNode;
begin
  fCanExpand := false;
  result := false;
  node := selected;
  if node <> nil then
   if node.StateIndex = CHECKED then result := true;
end;


procedure TDhCheckFolder.SetStateChecked ( value : boolean );
var
  node : tTreeNode;
begin
  fCanExpand := false;
  node := selected;
  if ( node <> nil ) and ( Node.AbsoluteIndex <> 0 )then
   if value then node.StateIndex := CHECKED
    else
     Node.StateIndex := NOT_CHECKED;
end;


procedure TDhCheckFolder.SetInitialDir ( path : string );
var
  SplitPathList : tStringList;
  index : integer;
  i : integer;
  SplitPath : string;
Begin
  fInitialDir := path;
  if items.count = 0 then exit;
  SplitPathList := tStringList.create;
  screen.cursor := crHourGlass;
  if DirectoryExists ( path ) then
   begin
    SplitPathToList ( path, SplitPathList );
    // if there is a Network-Drive choosed
    for i:=0 to SplitPathList.count-2 do
     begin
      if pos ( DOUBLE_SLASH, path ) > 0 then
       begin
        if not ExploreNetwork then
         begin
          screen.cursor := crDefault;
          exit;
         end;
       end;
      SplitPath := SplitPathList[i];
      //if pos ( 'Windows', SplitPath ) > 0 then
      // beep;
      AddSubNodesWithFolder ( SplitPath );
     end;

    index := FindNodeInTreeView ( items[0], path );
    if index > 0 then
     begin
      fCanExpand := true;
      items[index].selected := true;
     end;
   end;
  screen.cursor := crDefault;
  SplitPathList.free;
End;


procedure TDhCheckFolder.SaveCheckedFolder ( FileName : string ); //tTreeView
var
  list : tStringList;
  i : integer;
  node : tTreeNode;
  path : string;

Begin
  list := tStringList.create;
  // store checked folder
  for i:=0 to items.count-1 do
   begin
    node := items[i];
    if node.level >= 1 then
     begin
      if Node.StateIndex = CHECKED then
       begin
        if Node.GetFirstChild <> nil then
         if Node.GetFirstChild.StateIndex = CHECKED then
          continue;
        path := GetDirectory ( FRootShellFolder, node.data, SHGDN_FORPARSING );
        list.add ( path );
       end;
     end;
    //if pos ( 'X:', node.text ) > 0  then
    //beep;
   end;
  list.SaveToFile ( FileName );
  list.free;
End; { SaveCheckedFolder }


procedure TDhCheckFolder.LoadCheckedFolder ( FileName : string );
var
  CheckedPathList : tStringList;
  i, k : integer;
  SplitPathList : tStringList;
  path : string;
  node : tTreeNode;
  index : integer;
  SplitPath : string;
  OldPath : string;
  DoBreak : boolean;

Begin
  screen.cursor := crHourGlass;
  SplitPathList := tStringList.create;
  CheckedPathList := tStringList.create;
  CheckedPathList.LoadFromFile ( FileName );
  // add nodes if necessary
  //items.BeginUpdate;
  ClearAllChecks;
  OldPath := '';
  DoBreak := false;
  for i:=0 to CheckedPathList.count-1 do
   begin
    if DoBreak then break;
    SplitPathList.clear;
    path := CheckedPathList[i];
    SplitPathToList ( path, SplitPathList );
    // add nodes without Sub-Nodes
    for k:=0 to SplitPathList.count-2 do
     begin
      SplitPath := SplitPathList[k];
      // add network drives
      if pos ( DOUBLE_SLASH, SplitPath ) > 0 then
       if not ExploreNetwork then DoBreak := true;
      if DoBreak then break;
      if OldPath <> SplitPath then
       AddSubNodesWithFolder ( SplitPath );
      OldPath := SplitPath;
     end;
   end;
  // check nodes if necessary
  if not DoBreak then
   begin
    node := items[0];
    for i:=0 to CheckedPathList.count-1 do
     begin
      index := FindNodeInTreeView ( node, CheckedPathList[i] );
      if index > 0 then CheckFolder ( items[index] );
      // if Desktop-Folder is checked
      if pos ( LowerCase(DESKTOP_PATH), LowerCase(CheckedPathList[i]) ) > 0 then
       begin
        node := items[index];
        index := FindNodeInTreeView ( Node.GetNext, CheckedPathList[i] );
        if index > 0 then
         CheckFolder ( items[index] );
        node := items[0];
       end;
     end;
   end;
  Application.ProcessMessages;
  // make drive visible
  if CheckedPathList.count > 0 then
   MakeDriveVisible ( CheckedPathList );
  //items.EndUpdate;
  screen.cursor := crDefault;
  fCountCheckedFolder := CheckedPathList.count;
  SplitPathList.free;
  CheckedPathList.free;
End; { LoadCheckedFolder }


procedure TDhCheckFolder.CheckFolder ( node : tTreeNode );
begin
  Node.StateIndex := CHECKED;
  CheckParentFolder ( node );
  CheckSubFolder ( node );
end;


procedure TDhCheckFolder.MakeDriveVisible ( list : tStringList );
var
  drive : string;
  node : tTreeNode;
  index : integer;
begin
  FCanExpand := true;
  drive := ExtractFileDrive ( list[0] );
  node := items[0];
  index := FindNodeInTreeView ( node, drive );
  node := items[index];
  node.MakeVisible;
end;


Function TDhCheckFolder.GetListCheckedFolder : tStringList;
var
  node : tTreeNode;
  path : string;
  AddPath : boolean;

Begin
  fListCheckedFolder.clear;
  node := items[1];
  AddPath := true;
  while node <> nil do
   begin
    if ( Node.StateIndex = CHECKED ) then
     begin
      fPidlPath := node.data;
      path := GetDirectory ( FRootShellFolder, fPidlPath, SHGDN_FORPARSING );
      if AddPath then
       begin
        fListCheckedFolder.add ( path );
        AddCheckedFolderToList ( path );
        AddPath := false;
       end;
      if Node.GetNext <> nil then
       begin
        Node := Node.GetNext;
        if Node.Parent.StateIndex <> CHECKED then
         AddPath := true;
       end
        else break;
     end
      else Node := Node.GetNext;
   end; // end while do ..
  result := fListCheckedFolder;
End;


Procedure TDhCheckFolder.AddCheckedFolderToList ( folder : string );
var
   result : integer;
   f : tSearchRec;
   SubFolder : string;
   index : integer;

Begin
  result := FindFirst ( folder + '\*.*', faAnyFile, f );
  while result = 0 do
   begin
    if ( f.name[1] <> '.' ) then
     if ( f.attr and faDirectory > 0 ) then  { if folder then.. }
      begin
       SubFolder := f.name;
       folder := folder + '\' + SubFolder;
       if ( f.attr <> RECYCLED_ATTR_DOS ) then
        begin
         fListCheckedFolder.add ( folder );
         AddCheckedFolderToList ( folder );
        end;
       index := length(folder) - length(SubFolder);
       system.delete ( folder, index, length(SubFolder) + 1 );
      end;
    result := FindNext( f );
   end; { end while do.. }
  FindClose ( F );
End;


procedure TDhCheckFolder.ClearAllChecks;
var
  node : tTreeNode;
begin
  node := items[0];
  while node <> nil do
   begin
    if ( Node.StateIndex > 0 ) and ( Node.StateIndex <> NEUTRAL ) then
     Node.StateIndex := NOT_CHECKED;
    node := node.GetNext;
   end;
end;


Procedure TDhCheckFolder.InitialisizeComponent;
var
  FolderName : string;
  RootId : pItemIDList;
  ShellFolder : iShellFolder;
  node : tTreeNode;
  IdList : pItemIDList;
  i : integer;

Begin
  ClearAllItems;
  ShGetDesktopFolder ( FRootShellFolder );
  // Get the Desktop-Main-Icon
  ShGetSpecialFolderLocation ( handle, CSIDL_DESKTOP, RootId );
  FolderName := GetDirectory ( FRootShellFolder, RootId, SHGDN_NORMAL );
  Node := items.AddChildObject ( nil, FolderName, RootId );
  Node.ImageIndex := GetNormalIcon ( RootId );
  fDesktopIcon := Node.ImageIndex;
  Node.SelectedIndex := GetSelectedIcon ( RootId );
  Node.StateIndex := -1;
  node.data := RootId;
  fFullPidlPathList.add ( RootId );
  // Add Workstation and Network-Icon
  for i:=1 to 2 do
   begin
    ShGetSpecialFolderLocation ( handle, DESKTOP_FOLDER[i], RootId );
    FolderName := GetDirectory ( FRootShellFolder, RootId, SHGDN_NORMAL );
    Node := items.AddChildObject ( node, FolderName, RootId );
    Node.HasChildren := true;
    Node.ImageIndex := GetNormalIcon ( RootId );
    if i = 1 then FWorkstationIcon := Node.ImageIndex
     else FNetWorkIcon := Node.ImageIndex;
    Node.SelectedIndex := GetSelectedIcon ( RootId );
    Node.StateIndex := -1;
    node.data := RootId;
    fFullPidlPathList.add ( RootId );
    node := node.parent;
   end;
  // Add all dragged Folder on Desktop
  EnumerateFolder ( FRootShellFolder, SFGAO_FILESYSTEM, node );

  // Add Whole-Network-Icon
  node := items[2];
  fNetworkMainAttr := GetFolderAttribut ( node.data );
  if node <> nil then
   begin
    IdList := node.data;
    FRootShellFolder.BindToObject ( IdList, nil, IID_IShellFolder, pointer(ShellFolder));
    EnumerateFolder ( ShellFolder, SFGAO_FOLDER, node );
    node := Node.GetNext;
    if node <> nil then
     fNetworkSubAttr := GetFolderAttribut ( node.data );  // Whole-Network-Icon
   end;

  // Add local drives
  node := items[1];
  IdList := node.data;
  FRootShellFolder.BindToObject ( IdList, nil, IID_IShellFolder, pointer(ShellFolder));
  EnumerateFolder ( ShellFolder, SFGAO_FILESYSTEM, node );

  if fInitialDir <>  DEFAULT_INITIAL_DIR then
   SetInitialDir ( fInitialDir );
End; { InitialisizeComponent }


procedure TDhCheckFolder.AddSubNodesWithFolder ( path : string );
var
  PidlPath : pItemIDList;
  ShellFolder : iShellFolder;
  node : tTreeNode;
  index : integer;

Begin
  node := items[0];
  // Search current path in TreeView.
  index := FindNodeInTreeView ( node, path );
  if index > 0 then
   node := items[index]
    else exit;
  if ( node.GetFirstChild = nil ) then
   if ( node.HasChildren ) then
    begin
     PidlPath := node.data;
     // Get System-Folder in TreeView.
     FRootShellFolder.BindToObject ( PidlPath, nil, IID_IShellFolder, pointer(ShellFolder));
     EnumerateFolder ( ShellFolder, SFGAO_FOLDER, node );
     if fSortFolder then
      TreeView_SortChildren ( handle, node.ItemId, 0 );
    end;
End;


procedure TDhCheckFolder.SwitchStateIndex ( node : tTreeNode; attr : ULONG );
var
  path : string;
begin
  // This is for the virtual Folder
  if ( attr and SFGAO_FILESYSTEM = 0 )  then
   begin
    path := GetDirectory ( FRootShellFolder, node.data, SHGDN_FORPARSING );
    if path <> '' then
     if ( FileGetAttr ( path ) and RECYCLED_ATTR_DOS > 0 ) then
      Node.StateIndex := NEUTRAL
       else if pos ( '\', path ) = 0 then
        begin
         Node.StateIndex := -1;
        fSortFolder := false;
       end;
       //else Node.StateIndex := NEUTRAL;
   end
    else if Node.StateIndex <> NEUTRAL then
     if node.parent.StateIndex = CHECKED then
      Node.StateIndex := CHECKED
       else Node.StateIndex := NOT_CHECKED;
end;


Procedure TDhCheckFolder.EnumerateFolder ( ShellFolder: IShellFolder; mask : DWORD;
                                                                       node : tTreeNode );
var
  flags : DWORD;
  EnumList : IEnumIdList;
  FQ_PIDL, PidlPath, list : PItemIdList;
  fetched : ULONG;
  FolderName: string;
  attr : ULONG;
  HexAttr : string;
  ImageIndex : integer;

Begin
  PidlPath := node.data;
  fSortFolder := true;
  flags := SHCONTF_FOLDERS or SHCONTF_INCLUDEHIDDEN;
  if ( ShellFolder.EnumObjects ( handle, flags, EnumList )) = NOERROR then
   begin
    while EnumList.Next ( 1, list, fetched ) = S_OK do
     begin
      ImageIndex := -1;
      FolderName := GetDirectory ( ShellFolder, list, SHGDN_NORMAL );
      attr := ALL_ATRIBUTES;
      ShellFolder.GetAttributesOf ( 1, list, attr );

      HexAttr := IntToHex (attr, 4);
      //if pos ( 'Web', FolderName ) > 0 then   // if attr = NETWORK_ATTR then
      // beep;

      if ( attr and mask > 0 ) then
       begin
        FQ_PIDL := CombinePidls ( PidlPath, list );
        fFullPidlPathList.add ( FQ_PIDL );
        ImageIndex := GetNormalIcon ( FQ_PIDL );

        node := items.AddChildObject ( node, FolderName, FQ_PIDL );
        if ( attr and SFGAO_HASSUBFOLDER > 0 ) then
         Node.HasChildren := true;
        Node.ImageIndex := ImageIndex;
        Node.SelectedIndex := GetSelectedIcon ( FQ_PIDL );
        // image with hand-icon
        if ( SFGAO_SHARE and attr ) > 0 then
         Node.OverlayIndex := 0;
        // switch State-Icon
        SwitchStateIndex ( node, attr );

        node := node.parent;
       end;
      ShellMalloc.free ( list );
      // filter out client + server
      if ( ImageIndex = WHOLE_NETWORK_ICON ) and ( fCheckBoxes ) then
       break;
     end; // end while do ..
   end;
End;


procedure TDhCheckFolder.Change ( Node: TTreeNode );
begin
  node := selected;
  fPidlPath := node.data;
  if fPidlPath <> nil then
   begin
    fDirectory := GetDirectory ( FRootShellFolder, fPidlPath, SHGDN_FORPARSING );
    if fDirectory = '' then fDirectory := node.text;
    if ( assigned(FOnChangeFolder)) then FOnChangeFolder ( fDirectory );
   end;
  inherited;
end;


procedure TDhCheckFolder.Click;
var
  StateChecked : boolean;
Begin
  //if system.pos ( 'A', fnode.text ) > 0 then
   //beep;
  if fNode <> nil then
   begin
    if fCanExpand then
     AddSubNodesWithNode ( fNode )  // node clicked
      else
       begin
        StateChecked := ProofStates ( fNode );      // state cliccked
        if assigned (fStateClickEvent) then fStateClickEvent ( StateChecked );
       end;
   end;
  inherited;
end;


procedure TDhCheckFolder.MouseMove ( Shift: TShiftState; X, Y: Integer );
var
  ht : THitTests;
begin
  fCanExpand := true;
  if screen.cursor <> crHourGlass then
   begin
    fNode := GetNodeAt ( x, y );
    ht :=  GetHitTestInfoAt ( x, y  );
    if htOnStateIcon in ht then
     begin
      fCanExpand := false;
      screen.cursor := crPencil;
     end
      else
       screen.cursor := crDefault;
   end;
  inherited;
end;


procedure TDhCheckFolder.Changing ( Sender: TObject; Node: TTreeNode;
                                                               var AllowChange: boolean );
begin
  if not fCanExpand
   then AllowChange := false;
end;


function TDhCheckFolder.CanExpand ( node: TTreeNode ) : boolean;
begin
  result := fCanExpand;
end;


function TDhCheckFolder.CanCollapse ( node: TTreeNode ) : boolean;
begin
  result := fCanExpand;
end;


procedure TDhCheckFolder.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  inherited;
end;


procedure TDhCheckFolder.DblClick;
begin
  inherited;
end;


procedure TDhCheckFolder.KeyDown (  var Key : Word; Shift: TShiftState );
var
  node : tTreeNode;
begin
  fCanExpand := false;
  node := selected;
  // if right Cursor-Key is pressed.
  if Key = VK_RIGHT then AddSubNodesWithNode ( node );
  Application.ProcessMessages;
  fCanExpand := true;

  if Key = VK_F5 then
   RefreshNode ( node );
  inherited;
end;


Procedure TDhCheckFolder.AddSubNodesWithNode ( node : tTreeNode );
var
  idList : pItemIDList;
  ShellFolder : iShellFolder;

Begin
  //attr := GetFolderAttribut ( node.data );
  //if ( attr = fNetworkSubAttr ) then
  // Node.HasChildren := true;
  if (( node.HasChildren ) and ( node.GetFirstChild = nil )) then
   begin
    screen.cursor := crHourGlass;
    idList := node.data;
    FRootShellFolder.BindToObject ( idList,  nil, IID_IShellFolder,
                                                       pointer ( ShellFolder ));
    EnumerateFolder ( ShellFolder, SFGAO_FOLDER, node );
    if fSortFolder then TreeView_SortChildren ( handle, node.ItemId, 0 ); // hTreeItem
    if ( node.HasChildren ) and ( node.GetFirstChild = nil ) then
     if ( pos ( DOUBLE_SLASH, fDirectory ) > 0 ) or
      ( pos ( LowerCase(DESKTOP_PATH), LowerCase(fDirectory) ) > 0 ) then
       Node.HasChildren := false;
    screen.cursor := crDefault;
    fItemsCount := items.count;
   end;
End;


function TDhCheckFolder.ProofStates ( node : tTreeNode ) : boolean;
var
  rect : tRect;
  DispRect : tRect;
  ChildNode : tTreeNode;
  NodeVisible : boolean;
Begin
  rect := ClientRect;
  fCanExpand := false;
  NodeVisible := false;
  result := false;
  if Node.StateIndex = NEUTRAL then exit;

  if ( Node.StateIndex = NOT_CHECKED ) or ( Node.StateIndex = GRAY_CHECKED ) then
   begin
    node.StateIndex := CHECKED;
    result := true;
   end
    else
     if ( node.StateIndex = CHECKED ) then Node.StateIndex := NOT_CHECKED;

  ValidateRect ( handle, @rect );
  ChildNode := Node.GetFirstchild;
  if ChildNode <> nil then
   if ChildNode.IsVisible then
    begin
     CheckParentFolder ( node );
     CheckSubFolder ( node );
     NodeVisible := true;
    end;
  if ( ChildNode = nil ) or ( not NodeVisible ) then  // check only one node
   begin
    DispRect := Node.DisplayRect ( true );
    DispRect.top := DispRect.top + 4;
    DispRect.left := DispRect.left - 34;
    DispRect.right := DispRect.left + 16;
    DispRect.Bottom := DispRect.Bottom - 4;
    InvalidateRect ( handle, @DispRect, false );
    CheckParentFolder ( node );
    CheckSubFolder ( node );
   end
    else
     begin
      ValidateRect ( handle, @rect );
      InvalidateRect ( handle, @rect, false );
     end;
End;


procedure TDhCheckFolder.CheckSubFolder ( node : tTreeNode );
var
  state : integer;
  level : integer;
  folder : string;
Begin
  level := node.level;
  state := node.StateIndex;
  node := node.GetFirstChild;
  while node <> nil do
   begin
    if ( node = nil ) or ( node.level <= level ) then
     break;
    folder := node.text;
    if Node.StateIndex <> NEUTRAL then
     begin
      Node.StateIndex := state;
     end;
    Node := Node.GetNext;
   end;
End;


procedure TDhCheckFolder.CheckParentFolder ( node : tTreeNode );
var
  AllFolderChecked : boolean;
  folder : string;

Begin
  while node.parent.level >= 1 do
   begin
    folder := node.parent.text;
    if Node.Parent.StateIndex < 0 then
     begin
      node := node.parent;
      continue;
     end;
    AllFolderChecked := CheckSibling ( node.parent );

    if AllFolderChecked then
     Node.Parent.StateIndex := CHECKED
     else
      if ( not AllFolderChecked ) and ( not FSomeFolderChecked ) then
       Node.Parent.StateIndex := NOT_CHECKED
       else
        if FSomeFolderChecked then
         Node.Parent.StateIndex := GRAY_CHECKED;
    node := node.parent;
   end;
End;


function TDhCheckFolder.CheckSibling ( node : tTreeNode ) : boolean;
var
  folder : string;

Begin
  result := true; // if all folder are checked
  FSomeFolderChecked := false;

  Node := Node.GetFirstChild;
  while node <> nil do
   begin
    folder := node.text;
    if ( Node.StateIndex = CHECKED ) then
     FSomeFolderChecked := true;
    if ( Node.StateIndex = GRAY_CHECKED ) then
     begin
      FSomeFolderChecked := true;
      result := false;
      break;
     end
      else
       if Node.StateIndex = NOT_CHECKED then
        result := false;
    Node := Node.GetNextSibling;
   end;
End;


function TDhCheckFolder.FindNodeInTreeView ( node : tTreeNode; path : string ) : integer;
var
  PidlPath : pItemIdList;
  NodePath : string;
Begin
  result := -1;
  path := RemoveSlash ( path );
  while node <> nil do
   begin
    //if pos ( 'Diagnose', node.text ) > 0 then
    // beep;
    PidlPath := node.data;
    if PidlPath <> nil then
     NodePath := GetDirectory ( FRootShellFolder, PidlPath,  SHGDN_FORPARSING );
     if NodePath = '' then NodePath := node.text;
     if CompareText ( LowerCase(path), Lowercase(NodePath) ) = 0 then
      begin
       result := Node.AbsoluteIndex;
       break;
      end;
    Node := Node.GetNext
   end;
End;


procedure TDhCheckFolder.RefreshNode ( node : tTreeNode );
var
  SelNode : tTreeNode;
  DelNode, LastNode : tTreeNode;
  CreatePath : string;
  attr : UINT;
  HexAttr : string;

begin
  SelNode := node;
  // Refresh only Network-Icon
  if ( node.level = 0 ) or ( node.level = 1 ) and (node.ImageIndex <> FNetWorkIcon ) then
   exit;
  screen.cursor := crHourGlass;
  items.BeginUpdate;
  if node.GetFirstChild <> nil then
   begin
    LastNode := Node;
    node := node.GetFirstChild;
    // Store the most right node from tree
    while node <> nil do
     begin
      if not Node.IsVisible then break;
      LastNode := Node;
      Node := Node.GetFirstChild;
     end;
    CreatePath := GetDirectory ( FRootShellFolder, LastNode.data, SHGDN_FORPARSING );
    if CreatePath = '' then CreatePath := LastNode.text;
    if CreatePath = 'Hallo' then
     beep;
    // delete all childs
    node := SelNode.GetFirstChild;
    while node <> nil do
     begin
      DelNode := node;
      node := node.GetNextSibling;
      DelNode.delete;
     end;
   end; //end if

  // build the deleted path new
  SelNode.HasChildren := true;
  attr := GetFolderAttribut ( SelNode.data );
  HexAttr := IntToHex (attr, 4);
  if HexAttr = '10' then
   beep;
  if (SelNode.ImageIndex = FNetWorkIcon ) or ( attr = fNetworkSubAttr ) then
   ExploreNetwork;
  RecreatePathInTree ( CreatePath, SelNode );
  //FullExpand;
  
  items.EndUpdate;
  screen.cursor := crDefault;
end;


procedure TDhCheckFolder.RecreatePathInTree ( path : string; node : tTreeNode );
var
  SplitPathList : tStringList;
  i : integer;
  SplitPath : string;
  index : integer;
begin
  SplitPathList := tStringList.create;
  if pos ( '\', path ) > 0 then
   begin
    SplitPathToList ( path, SplitPathList );
    for i:=0 to SplitPathList.count-1 do
     begin
      SplitPath := SplitPathList[i];
      AddSubNodesWithFolder ( SplitPath );
     end;
   end;
  // find the path before deletion and make it visible
  index := FindNodeInTreeView ( items[0], path );
  if index > 0 then
   begin
    node := items[index];
    if node.text = 'Hallo' then
     beep;
    items[index].MakeVisible;
   end;
  SplitPathList.free;
end;


function TDhCheckFolder.ExploreNetwork : boolean;
var
  node : tTreeNode;

Begin
  result := false;
  node := items[1];
  // find Network-Main-Icon
  while node <> nil do
   begin
    //if node.text = 'Hallo' then
    // beep;
    if Node.ImageIndex = FNetWorkIcon then
     begin
      result := true;
      break;
     end;
    node := node.GetNextSibling; // Network-Icon
   end;
  if not result then
   begin
    MessageBeep ( MB_ICONASTERISK );
    MessageDlg ( 'There is no Network !', mtInformation, [mbOk], 0);
    exit;
   end;
  // add WholeNetwork-Icon
  //if Node.HasChildren then
   //beep;
  AddSubNodesWithFolder ( node.text );
  // add Workgroup-Icon
  if node.GetFirstChild <> nil then
   node := node.GetFirstChild
    else exit;
  AddSubNodesWithFolder ( node.text );
  // add hosts
  if node.GetFirstChild <> nil then
   node := node.GetFirstChild
    else exit;
  AddSubNodesWithFolder ( node.text );
  // add drives
  if node.GetFirstChild <> nil then
   node := node.GetFirstChild
    else exit;
  while node <> nil do
   begin
    if ( node.GetFirstChild = nil ) then
     if ( node.HasChildren ) then
      AddSubNodesWithFolder ( node.text );
     node := node.GetNextSibling;
   end;
  Application.ProcessMessages;
End; { ExploreNetwork }


procedure TDhCheckFolder.CreateStates;
var
  i : integer;
  bitmap : tBitmap;
  ResName : string;
begin
  bitmap := tBitmap.create;
  fStateImageList := tImageList.create(self);
  for i := 1 to 5 do
   begin
    ResName := 'TV_STATUS' + IntToStr(i);
    Bitmap.LoadFromResourceName ( hInstance, ResName );
    fStateImageList.add ( bitmap, nil );
   end;
  bitmap.free;
  StateImages := fStateImageList;
end;


procedure TDhCheckFolder.CreateImages;
var
 SysIL : uint;
 sfi : tshFileInfo;

begin
  Images := tImageList.Create( self );
  SysIL := ShGetFileInfo ( '', 0, sfi, SizeOf(sfi), SHGFI_SYSICONINDEX or
                                                        SHGFI_SMALLICON );
  if SysIL <> 0 then
   begin
    Images.Handle := SysIL;
    Images.ShareImages := true;
   end;
  screen.cursors[crPencil] := LoadCursor ( HInstance, 'pencil1' );
end;


procedure TDhCheckFolder.ClearAllItems;
var
  i : integer;

begin
  for i := 0 to fFullPidlPathList.count-1 do
  begin
   if fFullPidlPathList[i] <> nil then
    ShellMalloc.free ( fFullPidlPathList[i] );
  end;
  items.clear;
end;


Procedure Register;
Begin
  RegisterComponents ( 'DhComps', [TDhCheckFolder] );
End;


initialization
  ShGetMalloc ( ShellMalloc );


END.
