unit demo_u;

{ ENGLISH:

  It is Main Form of the demo project.  It demonstrate a features of
  "chemical" components ChemLabel, ChemListBox, ChemComboBox, 
  DBChemText, DBChemComboBox, DBChemListBox and of the class ChemString 
  in representation of a string type in the customary chemists style. 
  For successful compilation you need:
    1) Delphi 3 or 4
    2) package CHEM installed in it
    3) registered in PATH or in Library_Path
       (Tools\Environment_Options\Library) path to files chembase.dcu,
       stdchems.dcu, dbchems.dcu. This condition, most likely, was
       already automatically carried out by Delphi, when you
       install CHEM.DPL (if all these files were in one directory).
  The program does not use the module QRChems (component QRChemLabel
  and QRDBChemText) in order to prevent of troubles for developers,
  which resolutely have deleted QuickReport from the environment.
  The form contains some pages:
    Labels - comparison of a behaviour ChemLabel and Label for want
      of various values of common and individual properties. Try change
      them in run-time, using the controls from a right part of page.
    Boxes - also comparison ChemListBox and ListBox, ChemComboBox and
      ComboBox. However here is not submitted of the same broad
      possibilities to change properties in run-time. But you may do it
      in design-time. In run-time it is possible to change "chemical"
      properties (at the bottom) and structure of the lists (ComboBox
      and buttons).
    Edits - comparison of a behaviour ChemEdit and Edit for want
      of various values of common and individual properties. Try change
      them in run-time, using the controls from a right part of page.
    DBChems - data aware "chemical" components are connected to table
      DEMO.DB from the project directory. For navigation DBNavigator
      (at the upper right) is added. The initial filling of the lists
      happens from database for want of discovery of the form.
    Grid Example - simple example of use ChemString in handling of an
      event StringGrid.OnDrawCell for want of various values it of
      "chemical" properties.
    DBGrid Example - practically the same, but for DBGrid, connected
      with the already familiar table, and without a variation of
      "chemical" properties.
    Others - some more very simple solutions, integrated intention
      "chemicalizing" of components VCL.

  For more careful study it is possible to advise an universal method -
  creative processing VCL sources and use of ChemString features.
}

{ RUSSIAN:

    ,   ""
   ChemLabel, ChemListBox, ChemComboBox, DBChemText,
  DBChemComboBox, DBChemListBox   ChemString  
       .  
    ,   ,    
    .        
        .    ,
     .     :
        1) Delphi 3
        2)    package CHEM
        3)   PATH   Library_Path (Tools\Environment_Options\Library)
              chembase.dcu, stdchems.dcu, dbchems.dcu. 
           ,  ,     Delphi,
              CHEM.DPL (      
           ).
      QRChems ( QRChemLabel  QRDBChemText)
       ,   
  QuickReport   .
     :
        Labels -   ChemLabel  Label  
                     . 
                    run-time,   
                    .
        Boxes  -   ChemListBox c ListBox, ChemComboBox c ComboBox.
                        
                    run-time (   ,   
                 ?).      -  ,  
                 ,  design-time.  run-time   ""
                  (  )    (ComboBox  ).
         Edits -   ChemEdit  Edit  
                     . 
                    run-time,   
                    .
       DBChems - data aware -  ""   
                  DEMO.DB   .    
                  DBNavigator ( ).  
                       .
  Grid Example -    ChemString   
                 StringGrid.OnDrawCell     ""
                 .    "" 
                    VCL.  , , 
                     ""
                    TryCorrect  SubPercent.
DBGrid Example -    ,   DBGrid,   
                  ,    "" .
        Others -     ,  
                 ""  VCL.     
                  ,        .
                       -
                   -    VCL 
                   ChemString.
}


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, ExtCtrls, StdCtrls, ComCtrls, Mask, Db, DBTables, DBCtrls, DBGrids,

  ChemBase, StdChems, DBChems;   { "chemical" units }

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Label2: TLabel;
    Splitter1: TSplitter;
    Panel7: TPanel;
    Label4: TLabel;
    Label5: TLabel;
    ComboBox1: TComboBox;
    Label6: TLabel;
    MaskEdit1: TMaskEdit;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    ComboBox2: TComboBox;
    Label13: TLabel;
    ComboBox3: TComboBox;
    CheckBox1: TCheckBox;
    FontDialog1: TFontDialog;
    ColorDialog1: TColorDialog;
    Button1: TButton;
    Button2: TButton;
    Panel8: TPanel;
    Panel9: TPanel;
    CheckBox2: TCheckBox;
    Label14: TLabel;
    MaskEdit2: TMaskEdit;
    Label15: TLabel;
    ComboBox4: TComboBox;
    Label16: TLabel;
    MaskEdit3: TMaskEdit;
    Label17: TLabel;
    MaskEdit4: TMaskEdit;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    Label18: TLabel;
    MaskEdit5: TMaskEdit;
    Label19: TLabel;
    Label3: TLabel;
    Panel6: TPanel;
    ChemLabel1: TChemLabel;
    Label1: TLabel;
    TabSheet2: TTabSheet;
    Panel10: TPanel;
    Splitter2: TSplitter;
    Panel13: TPanel;
    Panel14: TPanel;
    Panel15: TPanel;
    Panel16: TPanel;
    Panel17: TPanel;
    Panel18: TPanel;
    ListBox1: TListBox;
    ChemListBox1: TChemListBox;
    Panel19: TPanel;
    Label30: TLabel;
    Label31: TLabel;
    ComboBox5: TComboBox;
    MaskEdit6: TMaskEdit;
    Label32: TLabel;
    Panel11: TPanel;
    Panel12: TPanel;
    Panel20: TPanel;
    Panel21: TPanel;
    Panel22: TPanel;
    Panel23: TPanel;
    ComboBox6: TComboBox;
    ChemComboBox1: TChemComboBox;
    Splitter3: TSplitter;
    Splitter4: TSplitter;
    BtnAdd: TButton;
    BtnRmv: TButton;
    TabSheet3: TTabSheet;
    Panel24: TPanel;
    Panel25: TPanel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    ComboBox7: TComboBox;
    MaskEdit7: TMaskEdit;
    Panel26: TPanel;
    Panel31: TPanel;
    Splitter6: TSplitter;
    Panel32: TPanel;
    DBNavigator1: TDBNavigator;
    Panel33: TPanel;
    Table1: TTable;
    DataSource1: TDataSource;
    DBChemListBox1: TDBChemListBox;
    Table1Name: TStringField;
    TabSheet4: TTabSheet;
    Panel34: TPanel;
    StringGrid1: TStringGrid;
    TabSheet5: TTabSheet;
    DBGrid1: TDBGrid;
    TabSheet6: TTabSheet;
    Label25: TLabel;
    CheckBox5: TCheckBox;
    ChemLabel2: TChemLabel;
    CheckBox6: TCheckBox;
    RadioButton1: TRadioButton;
    ChemLabel3: TChemLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    RadioButton2: TRadioButton;
    MaskEdit8: TMaskEdit;
    Label29: TLabel;
    CheckBox7: TCheckBox;
    TabSheet7: TTabSheet;
    Panel35: TPanel;
    Panel43: TPanel;
    Panel37: TPanel;
    Label35: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    LCorrect: TLabel;
    Label38: TLabel;
    Panel38: TPanel;
    Splitter7: TSplitter;
    Panel39: TPanel;
    Edit3: TEdit;
    Panel40: TPanel;
    Image3: TImage;
    Image4: TImage;
    Label39: TLabel;
    Panel41: TPanel;
    Splitter8: TSplitter;
    Panel42: TPanel;
    ChemEdit1: TChemEdit;
    Panel44: TPanel;
    Image1: TImage;
    Image2: TImage;
    Label40: TLabel;
    CB_TryCorrect: TComboBox;
    ME_Sub: TMaskEdit;
    SubPos_Edit: TMaskEdit;
    CheckBox8: TCheckBox;
    Splitter9: TSplitter;
    Panel36: TPanel;
    Label33: TLabel;
    Label34: TLabel;
    CB_AutoSize: TCheckBox;
    CB_AutoSelect: TCheckBox;
    CB_Border: TCheckBox;
    ColorBtn: TButton;
    CB_Ctl3D: TCheckBox;
    CB_Enabled: TCheckBox;
    FontBtn: TButton;
    CB_ReadOnly: TCheckBox;
    CB_Visible: TCheckBox;
    EdText: TEdit;
    Timer1: TTimer;
    Label41: TLabel;
    Label42: TLabel;
    MaskEdit9: TMaskEdit;
    CheckBox9: TCheckBox;
    Memo1: TMemo;
    DBChemText1: TDBChemText;
    Splitter5: TSplitter;
    Panel30: TPanel;
    DBChemComboBox1: TDBChemComboBox;
    Splitter10: TSplitter;
    Panel28: TPanel;
    Panel29: TPanel;
    Panel27: TPanel;
    CheckBox10: TCheckBox;
    Label23: TLabel;
    MaskEdit10: TMaskEdit;
    DBChemEdit1: TDBChemEdit;
    ComboBox8: TComboBox;
    Label24: TLabel;
    Splitter11: TSplitter;
    procedure ComboBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MaskEdit1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure MaskEdit2Change(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);
    procedure MaskEdit3Change(Sender: TObject);
    procedure TimerPusk(Sender: TObject);
    procedure MaskEdit4Change(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure MaskEdit5Change(Sender: TObject);
    procedure Panel23Resize(Sender: TObject);
    procedure Panel22Resize(Sender: TObject);
    procedure ComboBox5Change(Sender: TObject);
    procedure MaskEdit6Change(Sender: TObject);
    procedure ComboBox6Change(Sender: TObject);
    procedure BtnAddClick(Sender: TObject);
    procedure BtnRmvClick(Sender: TObject);
    procedure Panel30Resize(Sender: TObject);
    procedure SetDBPage;
    procedure ComboBox7Change(Sender: TObject);
    procedure MaskEdit7Change(Sender: TObject);
    procedure StringGrid1DrawCell(Sender: TObject; Col, Row: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure SetGrid;
    procedure Panel34Resize(Sender: TObject);
    procedure DBGrid1DrawDataCell(Sender: TObject; const Rect: TRect;
      Field: TField; State: TGridDrawState);
    procedure ChemLabel2Click(Sender: TObject);
    procedure ChemLabel3Click(Sender: TObject);
    procedure ChemEdit1Change(Sender: TObject);
    procedure CheckBox7Click(Sender: TObject);
    procedure MaskEdit8Change(Sender: TObject);
    procedure CB_AutoSelectClick(Sender: TObject);
    procedure CB_AutoSizeClick(Sender: TObject);
    procedure CB_BorderClick(Sender: TObject);
    procedure ColorBtnClick(Sender: TObject);
    procedure CB_Ctl3DClick(Sender: TObject);
    procedure CB_EnabledClick(Sender: TObject);
    procedure FontBtnClick(Sender: TObject);
    procedure CB_ReadOnlyClick(Sender: TObject);
    procedure CB_VisibleClick(Sender: TObject);
    procedure EdTextChange(Sender: TObject);
    procedure CB_TryCorrectChange(Sender: TObject);
    procedure ME_SubChange(Sender: TObject);
    procedure SubPos_EditChange(Sender: TObject);
    procedure CheckBox8Click(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure Panel42Resize(Sender: TObject);
    procedure Panel39Resize(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure MaskEdit9Change(Sender: TObject);
    procedure CheckBox9Click(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure CheckBox10Click(Sender: TObject);
    procedure MaskEdit10Change(Sender: TObject);
    procedure Panel28Resize(Sender: TObject);
    procedure ComboBox8Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  LoadLabels, LoadLists : boolean;

implementation

{$R *.DFM}

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  ChemLabel1.TryCorrect:=TChemTryCorrect(ComboBox1.ItemIndex);
  Timer1.Enabled:=True;
end;

procedure TForm1.MaskEdit1Change(Sender: TObject);
begin
  if not MaskEdit1.Focused then exit;
  ChemLabel1.SubPercent:=StrToInt(MaskEdit1.Text);
  Timer1.Enabled:=True;
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
  ChemLabel1.Align:=TAlign(ComboBox2.ItemIndex);
  Label1.Align:=TAlign(ComboBox2.ItemIndex);
  Timer1.Enabled:=True;
end;

procedure TForm1.ComboBox3Change(Sender: TObject);
begin
  ChemLabel1.Alignment:=TAlignment(ComboBox3.ItemIndex);
  Label1.Alignment:=TAlignment(ComboBox3.ItemIndex);
  Timer1.Enabled:=True;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  ChemLabel1.Autosize:=CheckBox1.Checked;
  Label1.Autosize:=CheckBox1.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if ColorDialog1.Execute then begin
    ChemLabel1.Color:=ColorDialog1.Color;
    Label1.Color:=ColorDialog1.Color;
    Button1.Font.Color:=ColorDialog1.Color;
    Timer1.Enabled:=True;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if FontDialog1.Execute then begin
    ChemLabel1.Font:=FontDialog1.Font;
    Label1.Font:=FontDialog1.Font;
    Button2.Font:=FontDialog1.Font;
    Timer1.Enabled:=True;
  end;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  ChemLabel1.Enabled:=CheckBox2.Checked;
  Label1.Enabled:=CheckBox2.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.MaskEdit2Change(Sender: TObject);
begin
  if not MaskEdit2.Focused then exit;
  ChemLabel1.Height:=StrToInt(MaskEdit2.Text);
  Label1.Height:=StrToInt(MaskEdit2.Text);
  Timer1.Enabled:=True;
end;

procedure TForm1.ComboBox4Change(Sender: TObject);
begin
  ChemLabel1.Layout:=TTextLayout(ComboBox4.ItemIndex);
  Label1.Layout:=TTextLayout(ComboBox4.ItemIndex);
  Timer1.Enabled:=True;
end;

procedure TForm1.MaskEdit3Change(Sender: TObject);
begin
  if not MaskEdit3.Focused then exit;
  ChemLabel1.Left:=StrToInt(MaskEdit3.Text);
  Label1.Left:=StrToInt(MaskEdit3.Text);
  Timer1.Enabled:=True;
end;

procedure TForm1.TimerPusk(Sender: TObject);
begin
  Timer1.Enabled:=True;
end;

procedure TForm1.MaskEdit4Change(Sender: TObject);
begin
  if not MaskEdit4.Focused then exit;
  ChemLabel1.Top:=StrToInt(MaskEdit4.Text);
  Label1.Top:=StrToInt(MaskEdit4.Text);
  Timer1.Enabled:=True;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
  ChemLabel1.Transparent:=CheckBox3.Checked;
  Label1.Transparent:=CheckBox3.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
  ChemLabel1.Visible:=CheckBox4.Checked;
  Label1.Visible:=CheckBox4.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.MaskEdit5Change(Sender: TObject);
begin
  if not MaskEdit5.Focused then exit;
  ChemLabel1.Width:=StrToInt(MaskEdit5.Text);
  Label1.Width:=StrToInt(MaskEdit5.Text);
  Timer1.Enabled:=True;
end;

procedure TForm1.SetDBPage;
begin
  Table1.DisableControls;
  while not Table1.EOF do begin
    DBChemComboBox1.Items.Add(Table1Name.AsString);
    Table1.Next;
  end;
  Table1.First;
  DBChemListBox1.Items.Assign(DBChemComboBox1.Items);
  Table1.EnableControls;
end;

procedure TForm1.Panel23Resize(Sender: TObject);
begin
  ComboBox6.Width:=Panel23.ClientWidth;
end;

procedure TForm1.Panel22Resize(Sender: TObject);
begin
  ChemComboBox1.Width:=Panel22.ClientWidth;
end;

procedure TForm1.ComboBox5Change(Sender: TObject);
begin
  ChemListBox1.TryCorrect:=TChemTryCorrect(ComboBox5.ItemIndex);
  ChemComboBox1.TryCorrect:=TChemTryCorrect(ComboBox5.ItemIndex);
  Timer1.Enabled:=True;
end;

procedure TForm1.MaskEdit6Change(Sender: TObject);
begin
  if not MaskEdit6.Focused then exit;
  ChemListBox1.SubPercent:=StrToInt(MaskEdit6.Text);
  ChemComboBox1.SubPercent:=StrToInt(MaskEdit6.Text);
  Timer1.Enabled:=True;
end;

procedure TForm1.ComboBox6Change(Sender: TObject);
begin
  with ComboBox6.Items do
    BtnAdd.Enabled:=(IndexOf(ComboBox6.Text)<0);
  BtnRmv.Enabled:=not BtnAdd.Enabled;
end;

procedure TForm1.BtnAddClick(Sender: TObject);
begin
  ListBox1.Items.Add(ComboBox6.Text);
  ChemListBox1.Items.Add(ComboBox6.Text);
  ChemComboBox1.Items.Add(ComboBox6.Text);
  ComboBox6.Items.Add(ComboBox6.Text);
  ComboBox6Change(NIL);
end;

procedure TForm1.BtnRmvClick(Sender: TObject);
begin
  with ListBox1.Items do Delete(IndexOf(ComboBox6.Text));
  with ChemListBox1.Items do Delete(IndexOf(ComboBox6.Text));
  with ChemComboBox1.Items do Delete(IndexOf(ComboBox6.Text));
  with ComboBox6.Items do Delete(IndexOf(ComboBox6.Text));
  ComboBox6Change(NIL);
end;

procedure TForm1.Panel30Resize(Sender: TObject);
begin
  DBChemComboBox1.Width:=Panel30.ClientWidth;
end;

procedure TForm1.ComboBox7Change(Sender: TObject);
begin
  if not (ComboBox7.ItemIndex in [0..2]) then ComboBox7.ItemIndex:=2;
  DBChemText1.TryCorrect:=TChemTryCorrect(ComboBox7.ItemIndex);
  DBChemEdit1.TryCorrect:=TChemTryCorrect(ComboBox7.ItemIndex);
  DBChemListBox1.TryCorrect:=TChemTryCorrect(ComboBox7.ItemIndex);
  DBChemComboBox1.TryCorrect:=TChemTryCorrect(ComboBox7.ItemIndex);
end;

procedure TForm1.MaskEdit7Change(Sender: TObject);
begin
  if not MaskEdit7.Focused then exit;
  DBChemText1.SubPercent:=StrToInt(MaskEdit7.Text);
  DBChemEdit1.SubPercent:=StrToInt(MaskEdit7.Text);
  DBChemListBox1.SubPercent:=StrToInt(MaskEdit7.Text);
  DBChemComboBox1.SubPercent:=StrToInt(MaskEdit7.Text);
  Timer1.Enabled:=True;
end;

procedure TForm1.SetGrid;
var c,r:integer;
begin
  with StringGrid1 do begin
    Cells[0,0]:='Sub% \ TryCorr.';
    for r:=1 to RowCount-1 do begin
      Cells[0,r]:=IntToStr(30+10*r);
      for c:=1 to ColCount-1 do Cells[c,r]:='La3ba3cu6o13.5';
    end;
    Cells[1,0]:='tchNone';
    Cells[2,0]:='tchCareful';
    Cells[3,0]:='tchAll';
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ChemComboBox1.ItemIndex:=0;
  ComboBox8.ItemIndex:=Ord(ChemEdit1.Alignment);
  Memo1Change(NIL);
  SetDBPage;
  SetGrid;
end;

procedure TForm1.StringGrid1DrawCell(Sender: TObject; Col, Row: Integer;
  Rect: TRect; State: TGridDrawState);
begin
  with TChemString.Create do
  try
    case Col of
      0,1 : TryCorrect:=tchNone;
        2 : TryCorrect:=tchCareful;
        3 : TryCorrect:=tchAll;
    end;
    SubPercent:=30+10*Row;
    Caption:=StringGrid1.Cells[Col,Row];

    with StringGrid1.Canvas do begin
      if gdFixed in State then
        Brush.Color:=StringGrid1.FixedColor
      else if gdSelected in State then
        Brush.Color := clActiveCaption
      else
        Brush.Color:=StringGrid1.Color;
      Brush.Style:=bsSolid;
      Font:=StringGrid1.Font;
      if gdSelected in State then Font.Color:=clWhite;
    end;
    PaintToCanvas(StringGrid1.Canvas,Rect);
    if gdFocused in State then
      StringGrid1.Canvas.DrawFocusRect(Rect);
  finally
    Free;
  end;
end;

procedure TForm1.Panel34Resize(Sender: TObject);
var i:integer;
begin
  with StringGrid1 do begin
    for i:=0 to ColCount-2 do
      ColWidths[i]:=ClientWidth div ColCount;
    ColWidths[ColCount-1]:=ClientWidth-(ColCount-1)*ColWidths[0];
    for i:=0 to RowCount-2 do
      RowHeights[i]:=ClientHeight div RowCount;
    RowHeights[RowCount-1]:=ClientHeight-(RowCount-1)*RowHeights[0];
  end;
end;

procedure TForm1.DBGrid1DrawDataCell(Sender: TObject; const Rect: TRect;
  Field: TField; State: TGridDrawState);
begin
  with TChemString.Create do
  try
    TryCorrect:=tchAll;
    AutoSubscript:=True;
    Caption:=Field.AsString;

    with DBGrid1.Canvas do begin
      if gdFixed in State then
        Brush.Color:=DBGrid1.FixedColor
      else if gdSelected in State then
        Brush.Color := clActiveCaption
      else
        Brush.Color:=DBGrid1.Color;
      Brush.Style:=bsSolid;
      Font:=DBGrid1.Font;
      if gdSelected in State then Font.Color:=clWhite;
    end;
    PaintToCanvas(DBGrid1.Canvas,Rect);
    if gdFocused in State then
      DBGrid1.Canvas.DrawFocusRect(Rect);
  finally
    Free;
  end;
end;

procedure TForm1.ChemLabel2Click(Sender: TObject);
begin
  with CheckBox5 do Checked:=not Checked;
end;

procedure TForm1.ChemLabel3Click(Sender: TObject);
begin
  RadioButton1.Checked:=True;
end;

procedure TForm1.ChemEdit1Change(Sender: TObject);
begin
  if ChemEdit1.Focused then begin
    Edit3.Text:=ChemEdit1.Text;
    EdText.Text:=ChemEdit1.Text;
    Timer1.Enabled:=True;
  end;
end;

procedure TForm1.CheckBox7Click(Sender: TObject);
begin
  ChemLabel1.AutoSubscript:=CheckBox7.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.MaskEdit8Change(Sender: TObject);
begin
  if not MaskEdit8.Focused then exit;
  ChemLabel1.SubPosition:=StrToInt(MaskEdit8.Text);
  Timer1.Enabled:=True;
end;

procedure TForm1.CB_AutoSelectClick(Sender: TObject);
begin
  ChemEdit1.AutoSelect:=CB_AutoSelect.Checked;
  Edit3.AutoSelect:=CB_AutoSelect.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.CB_AutoSizeClick(Sender: TObject);
begin
  ChemEdit1.AutoSize:=CB_AutoSize.Checked;
  Edit3.AutoSize:=CB_AutoSize.Checked;
  if not CB_AutoSize.Checked then begin
    Panel39Resize(NIL);
    Panel42Resize(NIL);
  end;
  Timer1.Enabled:=True;
end;

procedure TForm1.CB_BorderClick(Sender: TObject);
begin
  if CB_Border.Checked then
    ChemEdit1.BorderStyle:=bsSingle
  else
    ChemEdit1.BorderStyle:=bsNone;
  Edit3.BorderStyle:=ChemEdit1.BorderStyle;
  Timer1.Enabled:=True;
end;

procedure TForm1.ColorBtnClick(Sender: TObject);
begin
  ColorDialog1.Color:=Edit3.Color;
  if ColorDialog1.Execute then begin
    Edit3.Color:=ColorDialog1.Color;
    ChemEdit1.Color:=ColorDialog1.Color;
  end;
end;

procedure TForm1.CB_Ctl3DClick(Sender: TObject);
begin
  Edit3.Ctl3D:=CB_Ctl3D.Checked;
  ChemEdit1.Ctl3D:=CB_Ctl3D.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.CB_EnabledClick(Sender: TObject);
begin
  Edit3.Enabled:=CB_Enabled.Checked;
  ChemEdit1.Enabled:=CB_Enabled.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.FontBtnClick(Sender: TObject);
begin
  FontDialog1.Font:=Panel37.Font;
  if FontDialog1.Execute then
    Panel37.Font:=FontDialog1.Font;
  Timer1.Enabled:=True;
end;

procedure TForm1.CB_ReadOnlyClick(Sender: TObject);
begin
  Edit3.ReadOnly:=CB_ReadOnly.Checked;
  ChemEdit1.ReadOnly:=CB_ReadOnly.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.CB_VisibleClick(Sender: TObject);
begin
  Edit3.Visible:=CB_Visible.Checked;
  ChemEdit1.Visible:=CB_Visible.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.EdTextChange(Sender: TObject);
begin
  if EdText.Focused then begin
    Edit3.Text:=EdText.Text;
    ChemEdit1.Text:=EdText.Text;
    Timer1.Enabled:=True;
  end;
end;

procedure TForm1.CB_TryCorrectChange(Sender: TObject);
begin
  ChemEdit1.TryCorrect:=TChemTryCorrect(CB_TryCorrect.ItemIndex);
  Timer1.Enabled:=True;
end;

procedure TForm1.ME_SubChange(Sender: TObject);
begin
  if not ME_Sub.Focused then exit;
  ChemEdit1.SubPercent:=StrToInt(ME_Sub.Text);
  CheckBox1.Checked:=ChemEdit1.AutoSubscript;
  Timer1.Enabled:=True;
end;

procedure TForm1.SubPos_EditChange(Sender: TObject);
begin
  if not SubPos_Edit.Focused then exit;
  ChemEdit1.SubPosition:=StrToInt(SubPos_Edit.Text);
  CheckBox1.Checked:=ChemEdit1.AutoSubscript;
  Timer1.Enabled:=True;
end;

procedure TForm1.CheckBox8Click(Sender: TObject);
begin
  ChemEdit1.AutoSubscript:=CheckBox8.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.Edit3Change(Sender: TObject);
begin
  if Edit3.Focused then begin
    ChemEdit1.Text:=Edit3.Text;
    EdText.Text:=Edit3.Text;
    Timer1.Enabled:=True;
  end;
end;

procedure TForm1.Panel42Resize(Sender: TObject);
begin
  with ChemEdit1 do begin
    Width:=Panel42.ClientWidth-2*Left;
    if not AutoSize then Height:=Panel42.ClientHeight-2*Top;
  end;
end;

procedure TForm1.Panel39Resize(Sender: TObject);
begin
  with Edit3 do begin
    Width:=Panel39.ClientWidth-2*Left;
    if not AutoSize then Height:=Panel39.ClientHeight-2*Top;
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
const a:array [TChemCorrect] of string = ('chmInvalid', 'chmPossible','chmCorrect');
begin
  Timer1.Enabled:=False;
{Labels}
  CheckBox1.Checked:=ChemLabel1.AutoSize;
  CheckBox2.Checked:=ChemLabel1.Enabled;
  CheckBox3.Checked:=ChemLabel1.Transparent;
  CheckBox4.Checked:=ChemLabel1.Visible;
  CheckBox7.Checked:=ChemLabel1.AutoSubscript;
  Label8.Caption:=a[ChemLabel1.Correct];
  MaskEdit1.Text:=IntToStr(ChemLabel1.SubPercent);
  MaskEdit8.Text:=IntToStr(ChemLabel1.SubPosition);
  MaskEdit2.Text:=IntToStr(ChemLabel1.Height);
  MaskEdit5.Text:=IntToStr(ChemLabel1.Width);
  MaskEdit3.Text:=IntToStr(ChemLabel1.Left);
  MaskEdit4.Text:=IntToStr(ChemLabel1.Top);
  ComboBox1.ItemIndex:=Integer(ChemLabel1.TryCorrect);
  ComboBox2.ItemIndex:=Integer(ChemLabel1.Align);
  ComboBox3.ItemIndex:=Integer(ChemLabel1.Alignment);
  ComboBox4.ItemIndex:=Integer(ChemLabel1.Layout);

{Boxes}
  ComboBox5.ItemIndex:=Integer(ChemComboBox1.TryCorrect);
  CheckBox9.Checked:=ChemComboBox1.AutoSubscript;
  MaskEdit6.Text:=IntToStr(ChemComboBox1.SubPercent);
  MaskEdit9.Text:=IntToStr(ChemComboBox1.SubPosition);

{Edits}
  ME_Sub.Text:=IntToStr(ChemEdit1.SubPercent);
  SubPos_Edit.Text:=IntToStr(ChemEdit1.SubPosition);
  LCorrect.Caption:=a[ChemEdit1.Correct];
  CB_TryCorrect.ItemIndex:=Integer(ChemEdit1.TryCorrect);
  CheckBox8.Checked:=ChemEdit1.AutoSubscript;
  CB_AutoSelect.Checked:=ChemEdit1.AutoSelect;
  CB_AutoSize.Checked:=ChemEdit1.AutoSize;
  CB_Border.Checked:=(ChemEdit1.BorderStyle=bsSingle);
  CB_Ctl3D.Checked:=ChemEdit1.Ctl3D;
  CB_Enabled.Checked:=ChemEdit1.Enabled;
  CB_ReadOnly.Checked:=ChemEdit1.ReadOnly;
  CB_Visible.Checked:=ChemEdit1.Visible;
  EdText.Text:=ChemEdit1.Text;

{DBChems}
  CheckBox10.Checked:=DBChemText1.AutoSubscript;
  MaskEdit7.Text:=IntToStr(DBChemText1.SubPercent);
  MaskEdit10.Text:=IntToStr(DBChemText1.SubPosition);
  ComboBox7.ItemIndex:=Integer(DBChemText1.TryCorrect);
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  Timer1.Enabled:=True;
end;


procedure TForm1.MaskEdit9Change(Sender: TObject);
begin
  if not MaskEdit9.Focused then exit;
  ChemListBox1.SubPosition:=StrToInt(MaskEdit9.Text);
  ChemComboBox1.SubPosition:=StrToInt(MaskEdit9.Text);
  Timer1.Enabled:=True;
end;

procedure TForm1.CheckBox9Click(Sender: TObject);
begin
  ChemListBox1.AutoSubscript:=CheckBox9.Checked;
  ChemComboBox1.AutoSubscript:=CheckBox9.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.Memo1Change(Sender: TObject);
var i:integer; s:string;
begin
  s:='';
  with Memo1 do
    for i:=0 to Lines.Count-1 do begin
      if i>0 then s:=s+#13#10;
      s:=s+Lines[i];
    end;
  Label1.Caption:=s;
  ChemLabel1.Caption:=s;
  Timer1.Enabled:=True;
end;

procedure TForm1.CheckBox10Click(Sender: TObject);
begin
  DBChemText1.AutoSubscript:=CheckBox10.Checked;
  DBChemEdit1.AutoSubscript:=CheckBox10.Checked;
  DBChemComboBox1.AutoSubscript:=CheckBox10.Checked;
  DBChemListBox1.AutoSubscript:=CheckBox10.Checked;
  Timer1.Enabled:=True;
end;

procedure TForm1.MaskEdit10Change(Sender: TObject);
begin
  if not MaskEdit10.Focused then exit;  
  DBChemText1.SubPosition:=StrToInt(MaskEdit10.Text);
  DBChemEdit1.SubPosition:=StrToInt(MaskEdit10.Text);
  DBChemListBox1.SubPosition:=StrToInt(MaskEdit10.Text);
  DBChemComboBox1.SubPosition:=StrToInt(MaskEdit10.Text);
  Timer1.Enabled:=True;
end;

procedure TForm1.Panel28Resize(Sender: TObject);
begin
  DBChemEdit1.Width:=Panel28.ClientWidth;
  Timer1.Enabled:=True;
end;

procedure TForm1.ComboBox8Change(Sender: TObject);
begin
  ChemEdit1.Alignment:=TAlignment(ComboBox8.ItemIndex);
  Timer1.Enabled:=True;
end;

end.
