{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{       Composite Components Pack (CCPack)              }
{                                                       }
{       Copyright (c) 1997,98 Sergey Orlik              }
{                                                       }
{       Written by:                                     }
{         Sergey Orlik                                  }
{         Inprise Moscow Office                         }
{         Internet:  sorlik@borland.ru                  }
{                                                       }
{*******************************************************}
{$WARNINGS OFF}
unit BoxFixEd;
interface
uses
  DsgnIntf, Classes, Boxes;

procedure Register;

implementation

uses
  SysUtils, Graphics, Menus, Forms, Controls, Dialogs, Buttons, StdCtrls,
  ComCtrls;

{ TNewActivePageProperty }
type
  TNewActivePageProperty = class(TComponentProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TNewActivePageProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList];
end;

procedure TNewActivePageProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Component: TComponent;
begin
  for I := 0 to {*** bug: Designer.Form}TControl(GetComponent(0)).Owner.ComponentCount - 1 do //*** fixed
  begin
    Component := {*** bug: Designer.Form}TControl(GetComponent(0)).Owner.Components[I]; //*** fixed
    if (Component.Name <> '') and (Component is TTabSheet) and
      (TTabSheet(Component).PageControl = GetComponent(0)) then
      Proc(Component.Name);
  end;
end;

{ TNewPageControlEditor }
type
  TNewPageControlEditor = class(TDefaultEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

resourcestring
  SNewPage = 'Ne&w Page';
  SNextPage = 'Ne&xt Page';
  SPrevPage = '&Previous Page';

const
  PageControlVerbs: array[0..2] of string = (SNewPage, SNextPage, SPrevPage);

procedure TNewPageControlEditor.ExecuteVerb(Index: Integer);
var
  PageControl: TPageControl;
  Page: TTabSheet;
  Designer: IFormDesigner;
begin
  if Component is TTabSheet then
    PageControl := TTabSheet(Component).PageControl else
    PageControl := TPageControl(Component);
  if PageControl <> nil then
  begin
    Designer := Self.Designer;
    if Index = 0 then
    begin
      Page := TTabSheet.Create(Component.Owner); //*** fixed
      try
        Page.Name := Designer.UniqueName(TTabSheet.ClassName);
        Page.Parent := PageControl;
        Page.PageControl := PageControl;
      except
        Page.Free;
        raise;
      end;
      PageControl.ActivePage := Page;
      Designer.SelectComponent(Page);
      Designer.Modified;
    end else
    begin
      Page := PageControl.FindNextPage(PageControl.ActivePage,
        Index = 1, False);
      if (Page <> nil) and (Page <> PageControl.ActivePage) then
      begin
        PageControl.ActivePage := Page;
        if Component is TTabSheet then Designer.SelectComponent(Page);
        Designer.Modified;
      end;
    end;
  end;
end;

function TNewPageControlEditor.GetVerb(Index: Integer): string;
begin
  Result := PageControlVerbs[Index];
end;

function TNewPageControlEditor.GetVerbCount: Integer;
begin
  Result := High(PageControlVerbs) + 1;
end;

{ TNewToolBarEditor }
type
  TNewToolBarEditor = class(TDefaultEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

resourcestring
  SNewBtn = 'New &Button';
  SNewSpr = 'New Se&parator';
const
  ToolBarVerbs: array[0..1] of string = (SNewBtn, SNewSpr);

procedure TNewToolBarEditor.ExecuteVerb(Index: Integer);
var
  ToolBar: TToolBar;
  Btn: TToolButton;
  Designer: IFormDesigner;
begin
  if Component is TToolButton then
    ToolBar := TToolBar(TToolButton(Component).Parent) else 
    ToolBar := TToolBar(Component);
  if ToolBar <> nil then
  begin
    Designer := Self.Designer;
    begin
      Btn := TToolButton.Create(Component.Owner); //*** fixed
      try
        Btn.Name := Designer.UniqueName(TToolButton.ClassName);
        Btn.Parent := ToolBar;
        if Index = 0 then
          Btn.Style:=tbsButton
        else begin
          Btn.Style:=tbsSeparator;
          Btn.Width:=8;
        end;
      except
        Btn.Free;
        raise;
      end;
      Designer.SelectComponent(Btn);
      Designer.Modified;
    end;
  end;
end;

function TNewToolBarEditor.GetVerb(Index: Integer): string;
begin
  Result := ToolBarVerbs[Index];
end;

function TNewToolBarEditor.GetVerbCount: Integer;
begin
  Result := High(ToolBarVerbs) + 1;
end;

procedure Register;
begin
  RegisterComponentEditor(TPageControl, TNewPageControlEditor);
  RegisterComponentEditor(TTabSheet, TNewPageControlEditor);
  RegisterPropertyEditor(TypeInfo(TTabSheet), TPageControl, 'ActivePage', TNewActivePageProperty);

  RegisterComponentEditor(TToolBar, TNewToolBarEditor);
  RegisterComponentEditor(TToolButton, TNewToolBarEditor);
end;

end.
