{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{       Composite Components Pack (CCPack)              }
{                                                       }
{       Copyright (c) 1997,98 Sergey Orlik              }
{                                                       }
{       Written by:                                     }
{         Sergey Orlik                                  }
{         Inprise Moscow Office                         }
{         Internet:  sorlik@borland.ru                  }
{                                                       }
{*******************************************************}

unit BoxDsgn;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Menus,
  ComCtrls, DsgnIntf, Boxes;

type
  TBoxCustomModule = class(TCustomModule)
  public
    procedure ValidateComponent(Component:IComponent); override;
  end;

procedure Register;

implementation

resourcestring
  sErrorCreateComponent = 'Component can not be added to a box';

{ TBoxCustomModule }

procedure TBoxCustomModule.ValidateComponent(Component:IComponent);
begin
  if Component.GetClassName = 'TMainMenu' then
    raise Exception.Create(sErrorCreateComponent)
end;

{ Register }

procedure Register;
begin
  RegisterCustomModule(TBox, TBoxCustomModule);
  RegisterCustomModule(TControlGroupBox, TBoxCustomModule);
end;

end.
