unit FlatComboBoxX;
{
    This software is provided 'as-is', without any express or implied warranty.
    In no event shall the author be held liable for any damages arising from the
    use of this software.

    Liscence: Freeware, free to use and distribute as long as the original source stays intact.
                        free to modify as long as all modifications are sent back to me.  :)

    FlatComboBoxX
    Copyright  1999 ahmoy law
    e-mail:  ahmoy_law@hotmail.com
             ahmoy_law@yahoo.com
    Version: Beta 1.00b

    Any suggestions, modifications, bugs or anything! kindly please send an email to me :)
    p/s: hidup oghe kelate!!!	
}


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComboBoxX;

const
    FCBX_FORM_FRAME = 2;

type
  TFlatComboBoxX = class(TComboBoxX)
  private
    { Private declarations }
    FMouseIn: boolean;
    FEnter: boolean;

    FWindowColor: TColor;

    procedure DrawWindow ( const aDC: HDC );
    procedure DrawBackGround ( const aDC: HDC );
    procedure DrawFrame ( const aDC: HDC );
    procedure DrawEdit ( const aDC: HDC );
    procedure DrawButton ( const aDC: HDC );

    function  GetColor: TColor;
    procedure SetColor ( Value: TColor );

  protected
    { Protected declarations }
    procedure PopupFormPaint; override;
    procedure DropDown; override;
    procedure DropUp; override;
    procedure NCDrawButton; override;
    procedure NCDrawFrame; override;
    procedure DrawEditWindow; override;

    procedure WMPaint ( var m: TWMPaint ); message WM_PAINT;
    procedure WMNCPaint (var Message: TMessage); message WM_NCPAINT;
    procedure WMNCCalcSize (var Message: TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure CMMouseEnter ( var m: TMessage ); message CM_MOUSEENTER;
    procedure CMMouseLeave ( var m: TMessage ); message CM_MOUSELEAVE;
    procedure CMEnter ( var m: TMessage ); message CM_ENTER;
    procedure CMExit ( var m: TMessage ); message CM_EXIT;
    procedure CMEnabledChanged (var Message: TMessage); message CM_EnabledChanged;

  public
    { Public declarations }
    constructor Create ( AOwner: TComponent ); override;

  published
    { Published declarations }
    property Color: TColor read GetColor write SetColor;
  end;



procedure Register;

// -----------------------------------------------------------------------------

implementation

uses
    Math;

constructor TFlatComboBoxX.Create ( AOwner: TComponent );
begin
inherited Create ( AOwner );

FFormFrameWidth := FCBX_FORM_FRAME;

AutoSize := False;
Ctl3D := False;
ControlStyle := ControlStyle - [csFramed]; {fixes a VCL bug with Win 3.x}

FMouseIn := FALSE;
FEnter   := FALSE;

FWindowColor := clWindow;
end;


procedure TFlatComboBoxX.WMNCCalcSize (var Message: TWMNCCalcSize);
begin
inherited;

OffsetRect ( Message.CalcSize_Params^.rgrc[0], 0, 1 );
dec ( Message.CalcSize_Params^.rgrc[0].Bottom, 3 );
end;


procedure TFlatComboBoxX.CMEnabledChanged (var Message: TMessage);
begin
inherited;

if ( Enabled ) then
  Inherited Color := FWindowColor
else
    Inherited Color := clBtnFace;
end;


procedure TFlatComboBoxX.PopupFormPaint;
var
    Y: integer;
    aRect: TRect;
begin
inherited;

aRect := FForm.ClientRect;
with FForm.Canvas do begin
    DrawEdge ( Handle, aRect, EDGE_RAISED, BF_RECT );
    Pen.Color := clBtnFace;
    Y := FListBox.Top + FListBox.Height;
    MoveTo ( FForm.ClientWidth - FFormFrameWidth - 1, Y );
    LineTo ( FForm.ClientWidth - FFormFrameWidth - 1, FForm.ClientHeight - FFormFrameWidth );
    end;
end;


procedure TFlatComboBoxX.NCDrawButton;
begin
DrawButton ( FEditCanvas.Handle );
DrawFrame ( FEditCanvas.Handle );
end;


procedure TFlatComboBoxX.NCDrawFrame;
begin
DrawFrame ( FEditCanvas.Handle );
end;


procedure TFlatComboBoxX.DrawEditWindow;
begin
inherited;
DrawWindow ( FEditCanvas.Handle );
end;


procedure TFlatComboBoxX.DropDown;
begin
NCDrawButton;
inherited;
end;


procedure TFlatComboBoxX.DropUp;
begin
inherited;
NCDrawButton;
end;


procedure TFlatComboBoxX.CMMouseEnter ( var m: TMessage );
begin
inherited;

FMouseIn := TRUE;

If ( not FEnter ) then
    DrawWindow ( FEditCanvas.Handle );
end;


procedure TFlatComboBoxX.CMMouseLeave ( var m: TMessage );
begin
inherited;

FMouseIn := FALSE;

if ( not FEnter ) then
    DrawWindow ( FEditCanvas.Handle );
end;


procedure TFlatComboBoxX.CMEnter ( var m: TMessage );
begin
inherited;
FEnter := TRUE;
DrawWindow ( FEditCanvas.Handle );
end;


procedure TFlatComboBoxX.CMExit ( var m: TMessage );
begin
inherited;
FEnter := FALSE;
DrawWindow ( FEditCanvas.Handle );
end;


procedure TFlatComboBoxX.WMNCPaint (var Message: TMessage);
begin
inherited;
DrawWindow ( FEditCanvas.Handle );
end;


procedure TFlatComboBoxX.WMPaint ( var m: TWMPaint );
begin
inherited;

if ( m.DC <> 0 ) then
    DrawWindow ( m.DC )
else begin
    DrawWindow ( FEditCanvas.Handle );
    end;
end;


function TFlatComboBoxX.GetColor: TColor;
begin
result := FWindowColor;
end;


procedure TFlatComboBoxX.SetColor ( Value: TColor );
begin
if ( FWindowColor = Value ) then
    exit;

FWindowColor := Value;
if ( Enabled ) then
    Inherited Color := Value;
end;


procedure TFlatComboBoxX.DrawBackGround ( const aDC: HDC );
var
   aCanvas: TCanvas;
   aTemp: integer;
   aWidth: integer;
   aHeight: integer;
   aSysWidth: integer;
begin
aSysWidth := GetSystemMetrics ( SM_CXVSCROLL );
aWidth  := Width;
aHeight := Height;

aCanvas := TCanvas.Create;
try
    aCanvas.Handle := aDC;

    with aCanvas do begin
         Brush.Style := bsSolid;
         Brush.Color := clBtnFace;
         aTemp := aWidth-aSysWidth;
         {Left}     FillRect ( Rect ( 0, 0, 2, aHeight ) );
         {Right}    FillRect ( Rect ( aTemp-1, 0, aWidth, aHeight ) );
         {Top}      FillRect ( Rect ( 2, 0, aTemp, 3 ) );
         {Bottom}   FillRect ( Rect ( 2, aHeight-3, aTemp, aHeight ) );
        end; // with
finally
    aCanvas.Handle := 0;
    aCanvas.Free;
    end;
end;


procedure TFlatComboBoxX.DrawButton ( const aDC: HDC );
var
   aCanvas: TCanvas;
   px, py: integer;
   aWidth: integer;
   aHeight: integer;
   aSysWidth: integer;
   aArrowHeight: integer;
   aArrowWidth:  integer;
begin
aSysWidth := GetSystemMetrics ( SM_CXVSCROLL );
aWidth  := Width;
aHeight := Height;
aArrowWidth  := Min ( (aSysWidth) div 3, ((aHeight-6) div 3)*2 - 1 );
if ( not Odd ( aArrowWidth ) ) then dec ( aArrowWidth );
aArrowHeight := (aArrowWidth+1) div 2;

aCanvas := TCanvas.Create;
try
    aCanvas.Handle := aDC;

    with aCanvas do begin
         Brush.Style := bsSolid;
         Brush.Color := clBtnFace;
         FillRect ( Rect ( aWidth-aSysWidth-1, 0, aWidth, aHeight ) );

         if ( not DroppedDown ) then begin
            if ( FMouseIn ) or ( FEnter ) then begin
               Pen.Color := clBtnShadow;
               MoveTo ( aWidth-aSysWidth, aHeight-4 );
               LineTo ( aWidth-3, aHeight-4 );
               LineTo ( aWidth-3, 3 );
               Pen.Color := clBtnHighlight;
               LineTo ( aWidth-aSysWidth, 3 );
               LineTo ( aWidth-aSysWidth, aHeight-4 );
               end
            else begin
                 Pen.Color := clBtnHighlight;
                 Rectangle ( aWidth-aSysWidth, 3, aWidth-2, aHeight-3 );
                 end;

            px := aWidth - (aSysWidth + aArrowWidth) div 2 - 1;
            py := (aHeight - aArrowHeight) div 2;
            end
         else begin
              Pen.Color := clBtnHighlight;
              MoveTo ( aWidth-aSysWidth, aHeight-4 );
              LineTo ( aWidth-3, aHeight-4 );
              LineTo ( aWidth-3, 3 );
              Pen.Color := clBtnShadow;
              LineTo ( aWidth-aSysWidth, 3 );
              LineTo ( aWidth-aSysWidth, aHeight-4 );

              px := aWidth - (aSysWidth + aArrowWidth) div 2;
              py := (aHeight - aArrowHeight) div 2 + 1;
              end;

         Pen.Color := clBtnText;
         Brush.Color := clBtnText;
         Brush.Style := bsSolid;
         Polygon ( [Point(px,py), Point(px+aArrowWidth-1,py), Point(px+aArrowWidth div 2, py+aArrowHeight-1)] );
         end; // with
finally
    aCanvas.Handle := 0;
    aCanvas.Free;
    end;
end;


procedure TFlatComboBoxX.DrawFrame ( const aDC: HDC );
var
   aCanvas: TCanvas;
   aWidth: integer;
   aHeight: integer;
begin
aWidth  := Width;
aHeight := Height;

aCanvas := TCanvas.Create;
try
    aCanvas.Handle := aDC;

    with aCanvas do begin
         if ( FEnter ) or ( FMouseIn ) {or ( csDesigning in ComponentState )} then begin
            Pen.Color := clBtnShadow;
            MoveTo ( aWidth-1, 1 );
            LineTo ( 0, 1 );
            LineTo ( 0, aHeight-2 );

            Pen.Color := clBtnHighlight;
            LineTo ( aWidth-1, aHeight-2 );
            LineTo ( aWidth-1, 1 );
            end;
         end; // with
finally
    aCanvas.Handle := 0;
    aCanvas.Free;
    end;
end;


procedure TFlatComboBoxX.DrawEdit ( const aDC: HDC );
var
   aCanvas: TCanvas;
   aWidth: integer;
   aHeight: integer;
   aSysWidth: integer;
   aEditRect: TRect;
begin
aSysWidth := GetSystemMetrics ( SM_CXVSCROLL );
aWidth  := Width;
aHeight := Height;

aEditRect := Rect ( 2, 3, aWidth-aSysWidth-1, aHeight-3 );

aCanvas := TCanvas.Create;
try
    aCanvas.Handle := aDC;

    with aCanvas do begin
        Brush.Style := bsClear;

        if ( Enabled ) then
            Pen.Color := FWindowColor
        else
            Pen.Color := clBtnHighlight;

        Rectangle ( aEditRect );

        // remove the focused rect
        if ( (Focused) and (Style = csDropDownList) ) then begin
            Pen.Color := clHighlight;
            MoveTo ( aEditRect.Left + 1, aEditRect.Top + 1 );
            LineTo ( aEditRect.Left + 1, aEditRect.Bottom - 1 );
            MoveTo ( aEditRect.Right - 3, aEditRect.Top + 1 );
            LineTo ( aEditRect.Right - 3, aEditRect.Bottom - 1 );
            end; // if
        end; // with

finally
    aCanvas.Handle := 0;
    aCanvas.Free;
    end;
end;



procedure TFlatComboBoxX.DrawWindow ( const aDC: HDC );
var
    aCanvas: TCanvas;
begin
aCanvas := TCanvas.Create;
try
   aCanvas.Handle := aDC;

   DrawBackGround ( aCanvas.Handle );
   DrawEdit ( aCanvas.Handle );
   DrawButton ( aCanvas.Handle );
   DrawFrame ( aCanvas.Handle );
finally
    aCanvas.Handle := 0;
    aCanvas.Free;
    end;
end;


//------------------------------------------------------------------------------


procedure Register;
begin
  RegisterComponents('Samples', [TFlatComboBoxX]);
end;

end.
