unit ShowRich;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, DBCtrls, DB, ComCtrls, Menus;

type
  TFrmShowRich = class(TForm)
    PnlMemo: TPanel;
    SrcRichEdit: TDataSource;
    Panel1: TPanel;
    BtnOk: TButton;
    BtnClose: TButton;
    DBRichEdit: TDBRichEdit;
    FontDialog1: TFontDialog;
    PopupMenu1: TPopupMenu;
    Font1: TMenuItem;
    Protect1: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtnOkClick(Sender: TObject);
    procedure BtnCloseClick(Sender: TObject);
    procedure DBRichEditChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure Protect1Click(Sender: TObject);
    procedure FontDialog1Apply(Sender: TObject; Wnd: HWND);
  private
    { Private declarations }
    procedure ApplyFont;
  public
    { Public declarations }
  end;

var
  FrmShowRich: TFrmShowRich;

implementation

{$R *.DFM}

procedure TFrmShowRich.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmShowRich.BtnOkClick(Sender: TObject);
begin
  DBRichEdit.Perform(CM_EXIT,0,1);
  Close;
end;

procedure TFrmShowRich.BtnCloseClick(Sender: TObject);
begin
  SendMessage(DBRichEdit.Handle,WM_UNDO,0,1);
  DBRichEdit.Perform(CM_EXIT,0,1);
  Close;
end;

procedure TFrmShowRich.DBRichEditChange(Sender: TObject);
begin
  if BtnClose.Caption = 'C&lose' then
    BtnClose.Caption := '&Cancel';
end;

procedure TFrmShowRich.FormShow(Sender: TObject);
begin
  DBRichEdit.OnChange := DBRichEditChange;
end;

procedure TFrmShowRich.FormActivate(Sender: TObject);
begin
  if DBRichEdit.ReadOnly then
    btnClose.Visible := False;
end;

procedure TFrmShowRich.Font1Click(Sender: TObject);
begin
  FontDialog1.Font.Name := DBRichEdit.SelAttributes.Name;
  FontDialog1.Font.Color := DBRichEdit.SelAttributes.Color;
  FontDialog1.Font.Size := DBRichEdit.SelAttributes.Size;
  FontDialog1.Font.Style := DBRichEdit.SelAttributes.Style;
  if FontDialog1.Execute then
    ApplyFont;
end;

procedure TFrmShowRich.ApplyFont;
begin
  DBRichEdit.SelAttributes.Name := FontDialog1.Font.Name;
  DBRichEdit.SelAttributes.Color := FontDialog1.Font.Color;
  DBRichEdit.SelAttributes.Size := FontDialog1.Font.Size;
  DBRichEdit.SelAttributes.Style := FontDialog1.Font.Style;
end;

procedure TFrmShowRich.PopupMenu1Popup(Sender: TObject);
begin
  Protect1.Enabled := (DBRichEdit.SelText <> '');
  Protect1.Checked := DBRichEdit.SelAttributes.Protected;
end;

procedure TFrmShowRich.Protect1Click(Sender: TObject);
begin
  Protect1.Checked := not Protect1.Checked;
  DBRichEdit.SelAttributes.Protected := Protect1.Checked;
end;

procedure TFrmShowRich.FontDialog1Apply(Sender: TObject; Wnd: HWND);
begin
  ApplyFont;
end;

end.
