unit ShowMemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, DBCtrls, DB;

type
  TFrmShowMemo = class(TForm)
    PnlMemo: TPanel;
    DBMemo: TDBMemo;
    SrcMemo: TDataSource;
    Panel1: TPanel;
    BtnOk: TButton;
    BtnClose: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtnOkClick(Sender: TObject);
    procedure BtnCloseClick(Sender: TObject);
    procedure DBMemoChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmShowMemo: TFrmShowMemo;

implementation

{$R *.DFM}

procedure TFrmShowMemo.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmShowMemo.BtnOkClick(Sender: TObject);
begin
  DBMemo.Perform(CM_EXIT,0,1);
  Close;
end;

procedure TFrmShowMemo.BtnCloseClick(Sender: TObject);
begin
  SendMessage(DBMemo.Handle,WM_UNDO,0,1);
  DBMemo.Perform(CM_EXIT,0,1);
  Close;
end;

procedure TFrmShowMemo.DBMemoChange(Sender: TObject);
begin
  if BtnClose.Caption = 'C&lose' then
    BtnClose.Caption := '&Cancel';
end;

procedure TFrmShowMemo.FormShow(Sender: TObject);
begin
  DBMemo.OnChange := DBMemoChange;
end;

procedure TFrmShowMemo.FormActivate(Sender: TObject);
begin
  if DBMemo.ReadOnly then
    btnClose.Visible := False;
end;

end.
