unit MSRichEd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, DBCtrls, ShowRich, DB, DBTables;

type
  TMSDBRichEdit = class(TDBRichEdit)
  private
    { Private declarations }
    FRichEditTitle : String;
    procedure ShowRichEdit(tblRichEdit : TTable; sFieldName, sHeading : String; lReadOnlyFlag : Boolean);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure DblClick(Sender : TObject);
  published
    { Published declarations }
    property ShowRichEditTitle : String read FRichEditTitle write FRichEditTitle;
  end;

procedure Register;

implementation

constructor TMSDBRichEdit.Create;
begin
  inherited Create(AOwner);
  OnDblClick := DblClick;
end;

destructor TMSDBRichEdit.Destroy;
begin
  inherited Destroy;
  if (Application.FindComponent('FrmShowRich') <> nil) then begin
    FrmShowRich.Close;
    FrmShowRich := nil;
  end;
end;

procedure TMSDBRichEdit.dblClick(Sender: TObject);
begin
  Self.Perform(CM_EXIT,0,1);
  ShowRichEdit(TTable(TDataSource(TMSDBRichEdit(Self).DataSource).DataSet),TMSDBRichEdit(Self).DataField,ShowRichEditTitle,TMSDBRichEdit(Self).ReadOnly);
end;

procedure TMSDBRichEdit.ShowRichEdit(tblRichEdit : TTable; sFieldName, sHeading : String; lReadOnlyFlag : Boolean);
begin
  if (Application.FindComponent('FrmShowRich') = nil) then
    Application.CreateForm(TFrmShowRich, FrmShowRich);
  if lReadOnlyFlag then
    sHeading := sHeading + ' - [Read Only]';
  FrmShowRich.Caption := sHeading;
  FrmShowRich.SrcRichEdit.DataSet := tblRichEdit;
  FrmShowRich.DBRichEdit.DataField := sFieldName;
  FrmShowRich.DBRichEdit.ReadOnly := lReadOnlyFlag;
  FrmShowRich.Show;
end;

procedure Register;
begin
  RegisterComponents('Delphi 3.0 Components', [TMSDBRichEdit]);
end;

end.
