unit FindDlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, DBTables ;

type
  TFindDlg = class(TReplaceDialog)
  private
    { Private declarations }
    FDataSet : TDataSet;
    FFieldNames : String;
    FFound : Boolean;
    FAbortProcess : Boolean;
    FAutoEdit : Boolean;
    procedure Find(Sender : TObject);
    procedure Replace(Sender : TObject);
    procedure Close(Sender : TObject);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property TableName : TDataSet read FDataSet write FDataSet;
    property FieldNames : String read FFieldNames write FFieldNames;
    property AutoEdit : Boolean read FAutoEdit write FAutoEdit;
  end;

procedure Register;

implementation

constructor TFindDlg.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  OnFind := Find;
  OnReplace := Replace;
  OnClose := Close;
  FFound := False;
  FAbortProcess := False;
end;

{ Find Window Position
  GetWindowRect(FindDialog1.Handle,Rect1);
  nWidth := Rect1.Right - Rect1.Left;
  nHeight := Rect1.Bottom - Rect1.Top;
  SetWindowPos(FindDialog1.Handle,0,(Self.Width-nWidth)+Self.Left,(Self.Height-nHeight)+(Self.Top+10),0,0,
    SWP_NOACTIVATE or SWP_NOSIZE or SWP_NOZORDER);
}
procedure TFindDlg.Close(Sender : TObject);
begin
  FAbortProcess := True;
end;

procedure TFindDlg.Find(Sender : TObject);
var
  sFindText : String;
  I : Integer;
  SearchField : TField;
  tblFind : TTable;
begin
  tblFind := TTable(TableName);
  sFindText := FindText;
  if tblFind.EOF then begin
    tblFind.First;
    FFound := False;
  end;
  tblFind.DisableControls;
  if FFound then
    if (frDown in Options) then
      tblFind.Next
    else
      tblFind.Prior;
  FFound := False;
  if frDown in Options then
    while not tblFind.EOF do begin
      for I := 0 to tblFind.FieldDefs.Count - 1 do begin
        Application.ProcessMessages;
        if FAbortProcess then begin
          FAbortProcess := False;
          tblFind.EnableControls;
          Abort;
        end;
        if (tblFind.FindField(tblFind.FieldDefs.Items[I].Name) <> nil) then begin
          SearchField := tblFind.FindField(tblFind.FieldDefs.Items[I].Name);
          if (Pos(UpperCase(sFindText),UpperCase(SearchField.AsString)) > 0) then begin
            FFound := True;
            if FAutoEdit then
              tblFind.Edit;
//            tblFind.FindField(tblFind.FieldDefs.Items[I].Name).FocusControl;
//            tblFind.FieldByName(tblFind.FieldDefs.Items[I].Name).FocusControl;
            Break;
          end;
        end;
      end;
      if FFound then
        Break;
      tblFind.Next;
    end
  else
    while not tblFind.BOF do begin
      for I := 0 to tblFind.FieldDefs.Count - 1 do begin
        Application.ProcessMessages;
        if FAbortProcess then begin
          tblFind.EnableControls;
          FAbortProcess := False;
          Abort;
        end;
        if (tblFind.FindField(tblFind.FieldDefs.Items[I].Name) <> nil) then begin
          SearchField := tblFind.FindField(tblFind.FieldDefs.Items[I].Name);
          if (Pos(UpperCase(sFindText),UpperCase(SearchField.AsString)) > 0) then begin
            FFound := True;
            if FAutoEdit then
              tblFind.Edit;
//            tblFind.FindField(tblFind.FieldDefs.Items[I].Name).FocusControl;
//            tblFind.FieldByName(tblFind.FieldDefs.Items[I].Name).FocusControl;
            Break;
          end;
        end;
      end;
      if FFound then
        Break;
      tblFind.Prior;
    end;
  if tblFind.EOF then begin
    FFound := False;
    tblFind.First;
    if (MessageDlg('Text '+'"'+FindText+'"'+' Not Found, '#13+
       'would you like to continue from first record',mtInformation,[mbYes,mbNo],0) = mrYes) then
      Find(Sender);
  end;
  tblFind.EnableControls;
end;

procedure TFindDlg.Replace(Sender : TObject);
begin
  {}
end;

destructor TFindDlg.Destroy;
begin
  inherited Destroy;
end;

procedure Register;
begin
  RegisterComponents('Delphi 3.0 Components', [TFindDlg]);
end;

end.
