unit QryDsgn;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Grids, DBGrids, Db, DBTables, FileCtrl, ComCtrls;

type
  TSQLCommandList = record
    Count : Integer;
    CommandIndex : Integer;
    Command : array [0..99] of String;
  end;

type
  TFrmQueryDesigner = class(TForm)
    Panel1: TPanel;
    BtnExecute: TButton;
    BtnClose: TButton;
    DBGrid1: TDBGrid;
    Splitter1: TSplitter;
    Query1: TQuery;
    Label1: TLabel;
    EdtTablePath: TEdit;
    DirectoryListBox1: TDirectoryListBox;
    BtnOpenDirListBox: TButton;
    DataSource1: TDataSource;
    GroupBox1: TGroupBox;
    RichEdit1: TRichEdit;
    BtnPrevious: TButton;
    BtnNext: TButton;
    procedure EdtTablePathExit(Sender: TObject);
    procedure BtnExecuteClick(Sender: TObject);
    procedure BtnCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure DirectoryListBox1Exit(Sender: TObject);
    procedure DirectoryListBox1Enter(Sender: TObject);
    procedure BtnOpenDirListBoxClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure RichEdit1KeyPress(Sender: TObject; var Key: Char);
    procedure BtnPreviousClick(Sender: TObject);
    procedure BtnNextClick(Sender: TObject);
  private
    { Private declarations }
    lShowStructure  : Boolean;
    sString : String;
    SQLCommandList : TSQLCommandList;
    procedure SetButtons;
  public
    { Public declarations }
    procedure ShowStructure(lStructure : Boolean);
  end;

var
  FrmQueryDesigner: TFrmQueryDesigner;

implementation

uses Menu, GenFunc;

{$R *.DFM}

procedure TFrmQueryDesigner.EdtTablePathExit(Sender: TObject);
begin
  if (EdtTablePath.Text = '') then
    Exit;
  if not DirectoryExists(EdtTablePath.Text) then begin
    MessageBeep(mb_Ok);
    ShowMessage('Invalid Path');
    EdtTablePath.Text := '';
    Abort;
  end
end;

procedure TFrmQueryDesigner.BtnExecuteClick(Sender: TObject);
var
  sErrorString : String;
begin
  sErrorString := '';
  if (RichEdit1.Text = '') then
    sErrorString := 'SQL Command cannot be blank';
  if (EdtTablePath.Text = '') then
    sErrorString := 'Table Path cannot be blank';
  if (sErrorString <> '') then begin
    MessageBeep(mb_Ok);
    ShowMessage(sErrorString);
    Abort;
  end;
  try
    Query1.Close;
    Query1.DataBaseName := EdtTablePath.Text;
    Query1.SQL.Clear;
    Query1.SQL.Add(RichEdit1.Text);
    Query1.Open;
    SQLCommandList.Command[SQLCommandList.Count] := RichEdit1.Text;
    SQLCommandList.Count := SQLCommandList.Count + 1;
    SQLCommandList.CommandIndex := SQLCommandList.Count-1;
    SetButtons;
  except
    on E:EDataBaseError do begin
      MessageBeep(mb_Ok);
      ShowMessage(E.Message);
      Abort;
    end;
  end;
end;

procedure TFrmQueryDesigner.BtnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TFrmQueryDesigner.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmQueryDesigner.DirectoryListBox1Exit(Sender: TObject);
begin
  DirectoryListBox1.Visible := False;
  EdtTablePath.Text := DirectoryListBox1.Directory;
  EdtTablePath.SetFocus;
end;

procedure TFrmQueryDesigner.DirectoryListBox1Enter(Sender: TObject);
begin
  try
    DirectoryListBox1.Directory := EdtTablePath.Text;
  except
    on E:EDataBaseError do begin
      MessageBeep(mb_Ok);
      ShowMessage(E.Message);
      Abort;
    end;
  end;
end;

procedure TFrmQueryDesigner.BtnOpenDirListBoxClick(Sender: TObject);
begin
  if not DirectoryListBox1.Visible then begin
      DirectoryListBox1.Visible := True;
      DirectoryListBox1.Width := EdtTablePath.Width;
      DirectoryListBox1.Top := EdtTablePath.Top + EdtTablePath.Height;
      DirectoryListBox1.Left := EdtTablePath.Left;
      DirectoryListBox1.SetFocus;
    end
  else
    begin
      DirectoryListBox1.Visible := False;
      EdtTablePath.SetFocus;
    end;
end;

procedure TFrmQueryDesigner.FormCreate(Sender: TObject);
begin
//  FrmMenu.AddWindowItem(Self.Name,Self.Caption);
  SQLCommandList.Count := 0;
  SQLCommandList.CommandIndex := 0;
end;

procedure TFrmQueryDesigner.FormDestroy(Sender: TObject);
begin
  FrmMenu.ShowClose(False);
//  FrmMenu.RemoveWindowItem(Self.Name)
end;

procedure TFrmQueryDesigner.FormDeactivate(Sender: TObject);
begin
  if Sender <> nil then begin
    FrmMenu.ShowMenuWindowItemChecked(Self.Name,False);
  end;
end;

procedure TFrmQueryDesigner.FormActivate(Sender: TObject);
begin
  FrmMenu.ShowClose(True);
  FrmMenu.Table1 := TTable(Query1);
  FrmMenu.ShowStructure1.Checked := lShowStructure;
  FrmMenu.ShowTableMenuItem(False);
  FrmMenu.ShowTextFileMenuItem(False);
  FrmMenu.ShowQueryMenuItem(True);
  AssignGridOptions(DBGrid1,dgAlwaysShowSelection, FrmMenu.ShowSelected1.Checked);
  AssignGridOptions(DBGrid1,dgAlwaysShowEditor, FrmMenu.ShowEdited1.Checked);
  AssignGridOptions(DBGrid1,dgConfirmDelete, FrmMenu.ConfirmDelete1.Checked);
end;

procedure TFrmQueryDesigner.ShowStructure(lStructure : Boolean);
var
  I : Integer;
begin
  lShowStructure := lStructure;
  for I := 0 to Query1.FieldCount - 1 do begin
    if lStructure then
      DBGrid1.Columns.Items[I].Title.Caption := DBGrid1.Fields[I].FieldName + ' : ' +
                                                FindFieldType(DBGrid1.Fields[I].DataType) + ' : ' +
                                                IntToStr(DBGrid1.Fields[I].DataSize)
    else
      DBGrid1.Columns.Items[I].Title.Caption := DBGrid1.Fields[I].FieldName;
  end;
end;

procedure TFrmQueryDesigner.RichEdit1KeyPress(Sender: TObject;
  var Key: Char);
begin
  if (Key <> ' ') then
    sString := sString + Key
  else
    begin
//      ShowMessage(sString);
      sString := '';
    end;
end;

procedure TFrmQueryDesigner.BtnPreviousClick(Sender: TObject);
begin
  if (SQLCommandList.CommandIndex > 0) then begin
    SQLCommandList.CommandIndex := SQLCommandList.CommandIndex -1;
    RichEdit1.Text := SQLCommandList.Command[SQLCommandList.CommandIndex];
  end;
  SetButtons;
end;

procedure TFrmQueryDesigner.BtnNextClick(Sender: TObject);
begin
  if (SQLCommandList.CommandIndex < SQLCommandList.Count-1) then begin
    SQLCommandList.CommandIndex := SQLCommandList.CommandIndex + 1;
    RichEdit1.Text := SQLCommandList.Command[SQLCommandList.CommandIndex];
  end;
  SetButtons;
end;

procedure TFrmQueryDesigner.SetButtons;
begin
  BtnPrevious.Enabled := (SQLCommandList.CommandIndex > 0);
  BtnNext.Enabled := (SQLCommandList.CommandIndex < SQLCommandList.Count-1);
end;

end.
