unit Pers_add;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBTables, Mask, ExtCtrls, GenFunc, Msdbnav,
  dbMask, Dialogs, msDBMemo;

type
  TFrmPers_add = class(TForm)
    Panel1: TPanel;
    SrcPers_add: TDataSource;
    Panel2: TPanel;
    msDBNavigator1: TmsDBNavigator;
    BtnClose: TButton;
    tblPers_Add: TTable;
    tblCategory: TTable;
    Button2: TButton;
    GroupBox1: TGroupBox;
    MSMemo1: TMSMemo;
    tblPers_AddCATEGORY: TStringField;
    tblPers_AddLAST: TStringField;
    tblPers_AddFIRST: TStringField;
    tblPers_AddMIDDLE: TStringField;
    tblPers_AddTITLE: TStringField;
    tblPers_AddDOB: TDateField;
    tblPers_AddIDENT: TStringField;
    tblPers_AddRESD_PIN: TStringField;
    tblPers_AddRESD_TEL1: TStringField;
    tblPers_AddRESD_TEL2: TStringField;
    tblPers_AddRESD_TEL3: TStringField;
    tblPers_AddPAGER: TStringField;
    tblPers_AddCELLULOR: TStringField;
    tblPers_AddPRINT: TBooleanField;
    tblPers_AddOFF_TEL1: TStringField;
    tblPers_AddOFF_TEL2: TStringField;
    tblPers_AddEMail: TStringField;
    tblPers_AddNote: TMemoField;
    FullName: TStringField;
    Panel3: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label17: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    EditFIRST: TDBEdit;
    EditMIDDLE: TDBEdit;
    EditLAST: TDBEdit;
    EditIDENT: TDBEdit;
    EditADD_RES1: TDBEdit;
    EditADD_RES2: TDBEdit;
    EditADD_RES3: TDBEdit;
    DBComboBox1: TDBComboBox;
    DBEdit1: TDBEdit;
    DBMaskEdit1: TDBMaskEdit;
    DBMaskEdit2: TDBEdit;
    DBMaskEdit3: TDBEdit;
    DBMaskEdit4: TDBEdit;
    DBMaskEdit5: TDBEdit;
    DBMaskEdit6: TDBEdit;
    DBMaskEdit7: TDBEdit;
    DBMaskEdit8: TDBEdit;
    DBMaskEdit9: TDBMaskEdit;
    DBMaskEdit10: TDBEdit;
    Label12: TLabel;
    Label13: TLabel;
    DBEdit2: TDBEdit;
    tblPers_AddDesignation: TStringField;
    tblPers_AddADD_RES1: TStringField;
    tblPers_AddADD_RES2: TStringField;
    tblPers_AddADD_RES3: TStringField;
    msDBNavigator2: TmsDBNavigator;
    Splitter1: TSplitter;
    BtnFindText: TButton;
    FindDialog1: TFindDialog;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtnCloseClick(Sender: TObject);
    procedure TblPers_addCalcFields(DataSet: TDataSet);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure tblPers_AddAfterPost(DataSet: TDataSet);
    procedure DBEdit1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure tblPers_AddDOBSetText(Sender: TField; const Text: string);
    procedure SrcPers_addStateChange(Sender: TObject);
    procedure tblPers_AddBeforePost(DataSet: TDataSet);
    procedure Button2Click(Sender: TObject);
    procedure BtnFindTextClick(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure FindDialog1Close(Sender: TObject);
  private
    { private declarations }
    sSearchFieldName : String;
  public
    { public declarations }
  end;

var
  FrmPers_add: TFrmPers_add;

implementation

uses
  ViewPers;

{$R *.DFM}

procedure TFrmPers_add.FormCreate(Sender: TObject);
begin
  if not OpenTable(tblPers_add, cDataDrive) then
    raise Exception.Create('Can not open personal database !');
  if not OpenTable(tblCategory, cDataDrive) then
    raise Exception.Create('Can not open category database !');
  BtnFindTextClick(Sender);
//  Self.Caption := Session.SessionName;
end;

procedure TFrmPers_add.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  tblPers_add.Close;
  tblCategory.Close;
  Action := Cafree;
end;

procedure TFrmPers_add.BtnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TFrmPers_add.TblPers_addCalcFields(DataSet: TDataSet);
begin
  FullName.AsString := tblPers_add.FieldByName('Last').AsString  + ' ' +
                       tblPers_add.FieldByName('First').AsString + ' ' +
                       tblPers_add.FieldByName('Middle').AsString+ ' ' +
                       tblPers_add.FieldByName('Title').AsString;
end;

procedure TFrmPers_add.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if IsDataChanged([tblPers_add]) then
    CanClose := (AskSaveChanges([tblPers_add],[mbYes,mbNo,mbCancel]) <> mrCancel);
  if (FindDialog1.Handle <> 0) and CanClose then
    SendMessage(FindDialog1.Handle,WM_Close,0,0);
end;

procedure TFrmPers_add.tblPers_AddAfterPost(DataSet: TDataSet);
var
  sCategory : String;
begin
  sCategory := tblPers_add.FieldByName('Category').AsString;
  if not tblCategory.Findkey([sCategory]) then
    tblCategory.Append
  else
    tblCategory.Edit;
  try
    tblCategory.FieldByName('Category').AsString := sCategory;
    tblCategory.Post;
  except
    tblCategory.Cancel;
  end;
end;

procedure TFrmPers_add.DBEdit1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbRight) then
    if DisplaySearchDialog(tblCategory, 'Category', '', 'Category', False,'', '','') = mrOk then
      tblPers_add.FieldByName('Category').AsString := tblCategory.FieldByName('Category').AsString;
end;

procedure TFrmPers_add.tblPers_AddDOBSetText(Sender: TField;
  const Text: string);
begin
  tblPers_Add.FieldByName('DOB').AsString := Text;
end;

procedure TFrmPers_add.SrcPers_addStateChange(Sender: TObject);
begin
{ CCPL's special requirement }
  if TTable(SrcPers_add.Dataset).State in [dsInsert, dsEdit] then
    ShowDataFields(Self, True, SrcPers_add)
  else
    ShowDataFields(Self, False, SrcPers_add);

  if tblPers_Add.State in [dsEdit, dsInsert] then begin
    tblPers_Add.FieldByName('Title').FocusControl;
  end;
end;

procedure TFrmPers_add.tblPers_AddBeforePost(DataSet: TDataSet);
begin
  if tblPers_Add.FieldByName('Last').AsString = '' then begin
    tblPers_Add.FieldByName('Last').FocusControl;
    Raise Exception.Create('Last name can not be blank !');
  end;
  if tblPers_Add.FieldByName('Category').AsString = '' then begin
    tblPers_Add.FieldByName('Category').FocusControl;
    Raise Exception.Create('Category can not be blank !');
  end;
end;

procedure TFrmPers_add.Button2Click(Sender: TObject);
var
  bmPersonal : TBookmark;
begin
  if FindDialog1.Handle <> 0 then
    SendMessage(FindDialog1.Handle,WM_Close,0,0);
  bmPersonal := tblPers_add.GetBookmark;
  Application.CreateForm(TfrmViewPersonal, frmViewPersonal);
  frmViewPersonal.srcPersonal.Dataset := tblPers_add;
  frmViewPersonal.tblCategory := tblCategory;
  frmViewPersonal.EditIndicator.Text := 'Gather';
  if frmViewPersonal.ShowModal <> mrOk then begin
      tblPers_add.GotoBookmark(bmPersonal);
      tblPers_add.FreeBookmark(bmPersonal);
    end
  else
    tblPers_add.Edit;
  BtnFindTextClick(Sender);
end;

procedure TFrmPers_add.BtnFindTextClick(Sender: TObject);
var
  Rect1 : TRect;
  nFindDlgLeft, nFindDlgTop, nWidth, nHeight : Integer;
//  IniFile : TRegIniFile;
begin
  FindDialog1.Execute;
//  IniFile := TRegIniFile.Create('Address.Ini');
//  nFindDlgLeft := IniFile.ReadString('Personal Address','FindDlgLeft',0);
//  nFindDlgTop := IniFile.ReadString('Personal Address','FindDlgRight',0);
//  IniFile.Free;
  GetWindowRect(FindDialog1.Handle,Rect1);
  nWidth := Rect1.Right - Rect1.Left;
  nHeight := Rect1.Bottom - Rect1.Top;
  SetWindowPos(FindDialog1.Handle,0,(Self.Width-nWidth)+Self.Left,(Self.Height-nHeight)+(Self.Top+10),0,0,
    SWP_NOACTIVATE or SWP_NOSIZE or SWP_NOZORDER);
  BtnFindText.Enabled := False;
end;

procedure TFrmPers_add.FindDialog1Find(Sender: TObject);
var
  sFindText : String;
  I : Integer;
  SearchField : TField;
begin
  sFindText := FindDialog1.FindText;
  if tblPers_Add.EOF then begin
    tblPers_Add.First;
    FindDialog1.Tag := 0;
  end;
  tblPers_Add.DisableControls;
  if (FindDialog1.Tag = 1) then
    if (frDown in FindDialog1.Options) then
      tblPers_Add.Next
    else
      tblPers_Add.Prior;
  FindDialog1.Tag := 0;
  if frDown in FindDialog1.Options then
    while not tblPers_Add.EOF do begin
      for I := 0 to tblPers_Add.FieldDefs.Count - 1 do begin
        if (tblPers_Add.FindField(tblPers_Add.FieldDefs.Items[I].Name) <> nil) then begin
          SearchField := tblPers_Add.FindField(tblPers_Add.FieldDefs.Items[I].Name);
          if (Pos(UpperCase(sFindText),UpperCase(SearchField.AsString)) > 0) then begin
            FindDialog1.Tag := 1;
            tblPers_Add.Edit;
//            tblPers_Add.FindField(tblPers_Add.FieldDefs.Items[I].Name).FocusControl;
//            FrmPers_add.Show;
//            tblPers_Add.FieldByName(tblPers_Add.FieldDefs.Items[I].Name).FocusControl;
            Break;
          end;
        end;
      end;
      if (FindDialog1.Tag = 1) then
        Break;
      tblPers_Add.Next;
    end
  else
    while not tblPers_Add.BOF do begin
      for I := 0 to tblPers_Add.FieldDefs.Count - 1 do begin
        if (tblPers_Add.FindField(tblPers_Add.FieldDefs.Items[I].Name) <> nil) then begin
          SearchField := tblPers_Add.FindField(tblPers_Add.FieldDefs.Items[I].Name);
          if (Pos(UpperCase(sFindText),UpperCase(SearchField.AsString)) > 0) then begin
            FindDialog1.Tag := 1;
            tblPers_Add.Edit;
//            tblPers_Add.FindField(tblPers_Add.FieldDefs.Items[I].Name).FocusControl;
//            FrmPers_add.Show;
//            tblPers_Add.FieldByName(tblPers_Add.FieldDefs.Items[I].Name).FocusControl;
            Break;
          end;
        end;
      end;
      if (FindDialog1.Tag = 1) then
        Break;
      tblPers_Add.Prior;
    end;
  if tblPers_Add.EOF then begin
    FindDialog1.Tag := 0;
    MessageDlg('Text '+FindDialog1.FindText+' Not Found',mtInformation,[mbOk],0);
  end;
  tblPers_Add.EnableControls;
end;

procedure TFrmPers_add.FindDialog1Close(Sender: TObject);
begin
  BtnFindText.Enabled := True;

end;

end.
