unit OpenFile;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, FileCtrl, ShellAPI;

type
  TFrmOpenTable = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BtnOpen: TButton;
    FileListBox1: TFileListBox;
    ListBox1: TListBox;
    BtnCancel: TButton;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    Splitter1: TSplitter;
    FilterComboBox1: TFilterComboBox;
    Label1: TLabel;
    EdtFileName: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    BtnRun: TButton;
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure BtnOpenClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure DirectoryListBox1Enter(Sender: TObject);
    procedure DirectoryListBox1Exit(Sender: TObject);
    procedure FilterComboBox1Change(Sender: TObject);
    procedure ListBox1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ListBox1Click(Sender: TObject);
    procedure DirectoryListBox1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ListBox1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BtnCancelClick(Sender: TObject);
    procedure BtnRunClick(Sender: TObject);
    procedure ListBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    wModalResult : TModalResult;
    procedure AssignFileName(sFileName : String);
    procedure GatherFileNames(ListBox : TListBox);
    function ValidateFileNames : Boolean;
    procedure EnableRunButton;
  public
    { Public declarations }
    function OpenFileDlg(sFileFilter : String; var sDirName : String; var aFiles : Array of String) : TModalResult;
  end;

var
  FrmOpenTable: TFrmOpenTable;

implementation

uses GenFunc;

{$R *.DFM}

procedure TFrmOpenTable.DirectoryListBox1Change(Sender: TObject);
begin
  ListBox1.Items.Assign(FileListBox1.Items);
end;

procedure TFrmOpenTable.BtnOpenClick(Sender: TObject);
begin
  try
//    if (ListBox1.SelCount <= 0) then
    if not ValidateFileNames then
      Exit;
    if (EdtFileName.Text <> '') then begin
//      Self.ModalResult := mrOk
        wModalResult := mrOk;
        Close;
      end
    else
//      Self.ModalResult := mrNone;
      wModalResult := mrNone;
  except
//    Self.ModalResult := mrNone;
    wModalResult := mrNone;
    Abort;
  end;
end;

procedure TFrmOpenTable.FormCreate(Sender: TObject);
begin
  DirectoryListBox1Change(FileListBox1);
end;

procedure TFrmOpenTable.ListBox1DblClick(Sender: TObject);
begin
  BtnOpen.Click;
end;

procedure TFrmOpenTable.DirectoryListBox1Enter(Sender: TObject);
begin
  BtnOpen.Default := False;
end;

procedure TFrmOpenTable.DirectoryListBox1Exit(Sender: TObject);
begin
  BtnOpen.Default := True;
end;

procedure TFrmOpenTable.FilterComboBox1Change(Sender: TObject);
begin
  DirectoryListBox1Change(FileListBox1);
end;

procedure TFrmOpenTable.ListBox1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  GatherFileNames(ListBox1);
  EnableRunButton;
end;

procedure TFrmOpenTable.ListBox1Click(Sender: TObject);
begin
  GatherFileNames(ListBox1);
end;

procedure TFrmOpenTable.GatherFileNames(ListBox : TListBox);
var
  I : Integer;
  sFileNames : String;
begin
  sFileNames := '';
  for I := 0 to ListBox.Items.Count - 1 do
    if ListBox.Selected[I] then
      sFileNames := sFileNames + ListBox.Items.Strings[I] + ',';
  AssignFileName(Copy(sFileNames,0,Length(sFileNames)-1));
end;

procedure TFrmOpenTable.AssignFileName(sFileName : String);
begin
  EdtFileName.Text := sFileName;
end;

function TFrmOpenTable.ValidateFileNames : Boolean;
var
  sFileName, sDirDelimiter : String;
begin
  Result := True;
  sFileName := EdtFileName.Text;
  if DirectoryExists(ExtractFileDir(sFileName)) then begin
    if not FileExists(sFileName) then
      sDirDelimiter := '\';
    try
      FileListBox1.Directory := ExtractFileDir(sFileName+sDirDelimiter);
    except
      FileListBox1.Directory := ExtractFileDir(sFileName);
    end;
    if (ExtractFileName(sFileName) = '') then begin
      Result := False;
      Exit;
    end;
    EdtFileName.Text := ExtractFileName(sFileName);
    sFileName := ExtractFileName(sFileName);
  end;
  if (Copy(FrmOpenTable.FileListBox1.Directory,Length(FrmOpenTable.FileListBox1.Directory),1) <> '\') then
    sDirDelimiter := '\'
  else
    sDirDelimiter := '';
  if (ExtractFileName(sFileName) <> '') then
    if not FileExists(FileListBox1.Directory + sDirDelimiter + ExtractFileName(sFileName)) then begin
      Result := (Pos(',',sFileName) > 0);
      try
        FileListBox1.Directory := sFileName;
        EdtFileName.Text := '';
        sFileName := '';
      except
        ;
      end;
    end
  else
//    Result := True;
end;

procedure TFrmOpenTable.DirectoryListBox1KeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if (Key = 8) then
    FileListBox1.Directory := '..';
end;

procedure TFrmOpenTable.ListBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  sDir : String;
begin
  if Key = 46 then begin
    sDir := FrmOpenTable.FileListBox1.Directory;
    if (Copy(FrmOpenTable.FileListBox1.Directory,Length(FrmOpenTable.FileListBox1.Directory),1) <> '\') then
      sDir := sDir + '\';
    DeleteFiles(ListBox1,True,sDir);
    FileListBox1.Update;
    DirectoryListBox1.OnChange(nil);
  end;
end;

function TFrmOpenTable.OpenFileDlg(sFileFilter : String; var sDirName : String; var aFiles : Array of String) : TModalResult;
var
  I : Integer;
  sDir, sFileNames, sFileName : String;
begin
  FilterComboBox1.Filter := sFileFilter;
  Self.ShowModal;
  Result := wModalResult;
  if (Result = mrOk) then begin
    if (Copy(FileListBox1.Directory,Length(FileListBox1.Directory),1) <> '\') then
      sDir := FileListBox1.Directory+'\'
    else
      sDir := FileListBox1.Directory;
    sDirName := sDir;
    sFileNames := UpperCase(EdtFileName.Text);
    I := 0;
    while Length(sFileNames) > 0 do begin
      if Pos(',',sFileNames) > 0 then begin
          sFileName := Copy(sFileNames,0,Pos(',',sFileNames)-1);
          sFileNames := Copy(sFileNames,Pos(',',sFileNames)+1,Length(sFileNames));
        end
      else
        begin
          sFileName := sFileNames;
          sFileNames := '';
        end;
      if FileExists(sDir + sFileName) then begin
        aFiles[I] := sFileName;
        I := I + 1;
      end;
    end;
  end;
end;

procedure TFrmOpenTable.BtnCancelClick(Sender: TObject);
begin
  wModalResult := mrNone;
  Close;
end;

procedure TFrmOpenTable.BtnRunClick(Sender: TObject);
var
  nResult : Integer;
begin
  if (ListBox1.SelCount <= 0) then
    Exit;
  nResult := ShellExecute(Self.Handle,PChar('Open'),PChar(ListBox1.Items.Strings[ListBox1.ItemIndex]),nil,nil,SW_SHOW);
  if nResult <=32 then
    ShellError(nResult);
end;

procedure TFrmOpenTable.EnableRunButton;
begin
  if (UpperCase(ExtractFileExt(ListBox1.Items.Strings[ListBox1.ItemIndex])) = '.COM') or
    (UpperCase(ExtractFileExt(ListBox1.Items.Strings[ListBox1.ItemIndex])) = '.EXE') then
    BtnRun.Enabled := True
  else
    BtnRun.Enabled := False;
end;

procedure TFrmOpenTable.ListBox1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  EnableRunButton;
end;

end.
