unit Mylib;

interface

uses
  Windows, Messages, SysUtils, DB, DBTables, Forms, FileCtrl, DBGrids, Dialogs;

const
  MB_Title  : String = 'CCPL Software Browser Utility';

var
  sWorkingDirectory, sTempDrive : String;

function FindFieldType(wDataType : TFieldType) : String;
procedure Scatter(tblSourceTable : TTable; var aTableStructure, aFieldContent : Array of String);
procedure Gather(tblSourceTable : TTable; var aTableStructure, aFieldContent : Array of String);
procedure Initialise(Application : TApplication);
procedure SetDateFormatForFields(tblSource : TTable);
procedure AssignGridOptions(DBGrid1 : TDBGrid; goGridOption : TDBGridOption; lFlag : Boolean);
procedure ShowTerminateMsg;

implementation

procedure Initialise(Application : TApplication);
var
  sExeName : String;
begin
  sExeName := Application.ExeName;
  sWorkingDirectory := ExtractFilePath(sExeName);
  sTempDrive := sWorkingDirectory + 'Temp\';
  if not DirectoryExists(sTempDrive) then
    CreateDir(sTempDrive);
end;

function FindFieldType(wDataType : TFieldType) : String;
var
  sFieldType : String;
begin
  if wDataType in [ftString] then
    sFieldType := 'String';
  if wDataType in [ftSmallint] then
    sFieldType := 'Smallint';
  if wDataType in [ftInteger] then
    sFieldType := 'Integer';
  if wDataType in [ftWord] then
    sFieldType := 'Word';
  if wDataType in [ftBoolean] then
    sFieldType := 'Boolean';
  if wDataType in [ftFloat] then
    sFieldType := 'Float';
  if wDataType in [ftCurrency] then
    sFieldType := 'Currency';
  if wDataType in [ftBCD] then
    sFieldType := 'BCD';
  if wDataType in [ftDate] then
    sFieldType := 'Date';
  if wDataType in [ftTime] then
    sFieldType := 'Time';
  if wDataType in [ftDateTime] then
    sFieldType := 'DateTime';
  if wDataType in [ftBytes] then
    sFieldType := 'Bytes';
  if wDataType in [ftVarBytes] then
    sFieldType := 'VarBytes';
  if wDataType in [ftAutoInc] then
    sFieldType := 'AutoInc';
  if wDataType in [ftBlob] then
    sFieldType := 'Blob';
  if wDataType in [ftMemo] then
    sFieldType := 'Memo';
  if wDataType in [ftGraphic] then
    sFieldType := 'Graphic';
  if wDataType in [ftFmtMemo] then
    sFieldType := 'FmtMemo';
  if wDataType in [ftParadoxOle] then
    sFieldType := 'ParadoxOle';
  if wDataType in [ftDBaseOle] then
    sFieldType := 'DBaseOle';
  if wDataType in [ftTypedBinary] then
    sFieldType := 'TypedBunary';
  Result := sFieldType;
end;

procedure Scatter(tblSourceTable : TTable; var aTableStructure, aFieldContent : Array of String);
var
  I : Integer;
begin
  for I := 0 to tblSourceTable.FieldDefs.Count - 1 do begin
    aTableStructure[I] := tblSourceTable.FieldDefs.Items[I].Name;
    aFieldContent[I] := tblSourceTable.FieldByName(aTableStructure[I]).AsString;
  end;
end;

procedure Gather(tblSourceTable : TTable; var aTableStructure, aFieldContent : Array of String);
var
  I : Integer;
begin
  for I := Low(aTableStructure) to High(aTableStructure) do begin
    if (tblSourceTable.FindField(aTableStructure[I]) <> nil) and (tblSourceTable.FindField(aTableStructure[I]).DataType <> ftAutoInc) then
      tblSourceTable.FieldByName(aTableStructure[I]).AsString := aFieldContent[I];
  end;
end;

procedure SetDateFormatForFields(tblSource : TTable);
var
  i : Integer;
begin
  try
    tblSource.FieldDefs.Update;
    for i := 0 to tblSource.FieldDefs.Count - 1 do begin
      if (tblSource.FindField(tblSource.FieldDefs.Items[I].Name) <> nil) and (tblSource.FindField(tblSource.FieldDefs.Items[I].Name).DataType = ftDate) then
        tblSource.FindField(tblSource.FieldDefs.Items[I].Name).EditMask := '99/99/9999';
    end;
  except
    raise;
  end;
end;

procedure AssignGridOptions(DBGrid1 : TDBGrid; goGridOption : TDBGridOption; lFlag : Boolean);
begin
  if lFlag then
    DBGrid1.Options := DBGrid1.Options + [goGridOption]
  else
    DBGrid1.Options := DBGrid1.Options - [goGridOption];
end;

procedure ShowTerminateMsg;
begin
  MessageBeep(mb_Ok);
  ShowMessage('Terminated');
end;

end.
