unit MedPlay;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ToolWin, Buttons, MPlayer, StdCtrls, ExtCtrls, Menus;

type
  TFrmMediaPlayer = class(TForm)
    Panel2: TPanel;
    MediaPlayer1: TMediaPlayer;
    ListBox1: TListBox;
    PopupMenu1: TPopupMenu;
    InsertFile1: TMenuItem;
    Remove1: TMenuItem;
    Panel1: TPanel;
    CheckBox1: TCheckBox;
    TrackBar1: TTrackBar;
    Timer1: TTimer;
    CheckBox2: TCheckBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure AssignFileName(sFileName : String);
    procedure ListBox1DblClick(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure InsertFile1Click(Sender: TObject);
    procedure Remove1Click(Sender: TObject);
    procedure ListBox1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure MediaPlayer1Notify(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure MediaPlayer1Click(Sender: TObject; Button: TMPBtnType;
      var DoDefault: Boolean);
    procedure TrackBar1Change(Sender: TObject);
  private
    { Private declarations }
    lResetTrackBarPos : Boolean;
    procedure RemoveSelectedItem;
    procedure PlayMediaPlayer;
  public
    { Public declarations }
    procedure OpenPlayer(sFileName : String);
  end;

var
  FrmMediaPlayer: TFrmMediaPlayer;

implementation

uses Menu, Literals, OpenFile, GenFunc, Player;

{$R *.DFM}

procedure TFrmMediaPlayer.OpenPlayer(sFileName : String);
var
  FFlags : LongInt;
begin
  Application.CreateForm(TFrmPlayer,FrmPlayer);
  FrmPlayer.Show;
  CheckBox2Click(nil);
  Self.Show;
  AssignFileName(sFileName);
  ListBox1.Items.Add(sFileName);
  ListBox1.Selected[0] := True;
  MediaPlayer1.Open;
end;

procedure TFrmMediaPlayer.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  FrmPlayer.Free;
  FrmPlayer := nil;
  MediaPlayer1.Close;
  Action := caFree;
end;

procedure TFrmMediaPlayer.FormActivate(Sender: TObject);
begin
  FrmMenu.ShowClose(True);
  FrmMenu.ShowQueryMenuItem(False);
  FrmMenu.ShowTextFileMenuItem(False);
  FrmMenu.ShowTableMenuItem(False);
end;

procedure TFrmMediaPlayer.FormDestroy(Sender: TObject);
begin
  FrmMenu.ShowClose(False);
//  FrmMenu.RemoveWindowItem(Self.Name)
end;

procedure TFrmMediaPlayer.AssignFileName(sFileName : String);
begin
  if (UpperCase(ExtractFileExt(sFileName)) = FE_WAV) then
    MediaPlayer1.DeviceType := dtAVIVideo;
  MediaPlayer1.FileName := sFileName;
end;

procedure TFrmMediaPlayer.ListBox1DblClick(Sender: TObject);
begin
  AssignFileName(ListBox1.Items.Strings[ListBox1.ItemIndex]);
  MediaPlayer1.Close;
  MediaPlayer1.Open;
//  MediaPlayer1.EnabledButtons := [btPause, btStop, btNext, btPrev, btStep, btBack, btRecord, btEject];
  PlayMediaPlayer;
end;

procedure TFrmMediaPlayer.ListBox1Click(Sender: TObject);
begin
  AssignFileName(ListBox1.Items.Strings[ListBox1.ItemIndex]);
  MediaPlayer1.Close;
  MediaPlayer1.Open;
end;

procedure TFrmMediaPlayer.InsertFile1Click(Sender: TObject);
var
  I : Integer;
  sDirectory : String;
  aFiles : Array [0..100] of String;
begin
  if (FrmOpenTable.OpenFileDlg(FF_MediaFiles + '|' + FF_All,sDirectory,aFiles) = mrOk) then begin
    for I := Low(aFiles) to High(aFiles) do begin
      if (aFiles[I] = '') then
        Break;
      ListBox1.Items.Add(sDirectory+aFiles[I]);
    end;
  end;
//  FrmOpenTable.Free;
//  FrmOpenTable := nil;
end;

procedure TFrmMediaPlayer.Remove1Click(Sender: TObject);
begin
  RemoveSelectedItem;
end;

procedure TFrmMediaPlayer.ListBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = 46 then
    RemoveSelectedItem;
end;

procedure TFrmMediaPlayer.RemoveSelectedItem;
var
  I : Integer;
begin
  if (ListBox1.SelCount <= 0) then
    Exit;
  I := 0;
  while (I <= (ListBox1.Items.Count - 1)) do begin
    if ListBox1.Selected[I] then
      ListBox1.Items.Delete(I)
    else
      I := I + 1;
  end;
end;

procedure TFrmMediaPlayer.MediaPlayer1Notify(Sender: TObject);
begin
//  TrackBar1.Position := 0;
  if CheckBox1.Checked then begin
      ListBox1.Selected[ListBox1.ItemIndex] := False;
      if (ListBox1.ItemIndex >= (ListBox1.Items.Count - 1)) then
        ListBox1.Selected[0] := True
      else
        ListBox1.Selected[ListBox1.ItemIndex+1] := True;
      AssignFileName(ListBox1.Items.Strings[ListBox1.ItemIndex]);
      MediaPlayer1.Close;
      MediaPlayer1.Open;
      PlayMediaPlayer;
    end
  else
    Timer1.Enabled := False;
end;

procedure TFrmMediaPlayer.Timer1Timer(Sender: TObject);
begin
  TrackBar1.Position := (MediaPlayer1.Position * TrackBar1.Max) div MediaPlayer1.Length;
end;

procedure TFrmMediaPlayer.PlayMediaPlayer;
begin
  Timer1.Enabled := True;
  MediaPlayer1.Play;
end;

procedure TFrmMediaPlayer.CheckBox2Click(Sender: TObject);
begin
  if CheckBox2.Checked then begin
      MediaPlayer1.Display := ListBox1;
//      Self.Height := Panel1.Height + Panel2.Height + 316; // + (Self.Height - Self.ClientHeight);
    end
  else
    begin
      MediaPlayer1.Display := FrmPlayer;
//      Self.Height := Panel1.Height + Panel2.Height + (Self.Height - Self.ClientHeight);
    end;
  ListBox1.Refresh;
end;

procedure TFrmMediaPlayer.MediaPlayer1Click(Sender: TObject;
  Button: TMPBtnType; var DoDefault: Boolean);
begin
  if (Button = btPlay) then
    Timer1.Enabled := True;
end;

procedure TFrmMediaPlayer.TrackBar1Change(Sender: TObject);
begin
  CheckBox1.Checked := False;
  lResetTrackBarPos := False;
  MediaPlayer1.PauseOnly;
  Timer1.Enabled := False;
  MediaPlayer1.Position := (TrackBar1.Position * MediaPlayer1.Length) div TrackBar1.Max;;
  TrackBar1.Perform(CM_Exit,0,0);
  MediaPlayer1.Play;
  lResetTrackBarPos := True;
  Timer1.Enabled := True;
end;

end.
