unit Mailing;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Menus;

type
  TFrmMailing = class(TForm)
    RichEdit1: TRichEdit;
    PopupMenu1: TPopupMenu;
    Print1: TMenuItem;
    FindText1: TMenuItem;
    FindDialog1: TFindDialog;
    SaveDialog1: TSaveDialog;
    Upper1: TMenuItem;
    Lower1: TMenuItem;
    UpperLower1: TMenuItem;
    N1: TMenuItem;
    FontDialog1: TFontDialog;
    N2: TMenuItem;
    Font1: TMenuItem;
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure FindText1Click(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure Upper1Click(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure FontDialog1Apply(Sender: TObject; Wnd: Integer);
  private
    { Private declarations }
    procedure ApplyFont;
  public
    { Public declarations }
    sFileName : String;
    procedure OpenTextFile(sTextFileName : String);
    procedure SaveToFile(sTextFileName : String);
  end;

var
  FrmMailing: TFrmMailing;

implementation

uses Menu;

{$R *.DFM}

procedure TFrmMailing.OpenTextFile(sTextFileName : String);
begin
  RichEdit1.Lines.Clear;
  Self.Caption := sTextFileName;
  if (sTextFileName <> '') then begin
      sFileName := sTextFileName;
      RichEdit1.Lines.LoadFromFile(sTextFileName);
    end
  else
    begin
      sFileName := '';
      Self.Caption := 'Document';
    end;
//  FrmMenu.AddWindowItem(Self.Name,Self.Caption);
end;

procedure TFrmMailing.SaveToFile(sTextFileName : String);
begin
  if (sTextFileName = '') then begin
    SaveDialog1.FileName := 'Document';
    if (SaveDialog1.Execute) then begin
      sTextFileName := SaveDialog1.FileName;
      sFileName := ExtractFileName(SaveDialog1.FileName);
    end;
  end;
  RichEdit1.Lines.SaveToFile(sTextFileName);
end;

procedure TFrmMailing.FormActivate(Sender: TObject);
begin
  FrmMenu.ShowClose(True);
  FrmMenu.ShowQueryMenuItem(False);
  FrmMenu.ShowTableMenuItem(False);
  FrmMenu.ShowTextFileMenuItem(True);
end;

procedure TFrmMailing.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmMailing.FormDestroy(Sender: TObject);
begin
  FrmMenu.ShowClose(False);
  if (FindDialog1.Handle <> 0) then
    SendMessage(FindDialog1.Handle,WM_Close,0,0);
//  FrmMenu.RemoveWindowItem(Self.Name)
end;

procedure TFrmMailing.Print1Click(Sender: TObject);
begin
  RichEdit1.Print(sFileName);
end;

procedure TFrmMailing.FindText1Click(Sender: TObject);
begin
  if FindDialog1.Execute then
end;

procedure TFrmMailing.FindDialog1Find(Sender: TObject);
begin
  if Self.FindComponent('RichEdit1') = nil then
    Exit;
  if (Pos(UpperCase(FindDialog1.FindText),UpperCase(RichEdit1.Text)) > 1) then begin
    RichEdit1.SelStart := Pos(UpperCase(FindDialog1.FindText),UpperCase(RichEdit1.Text))-1;
    RichEdit1.SelLength := Length(FindDialog1.FindText);
  end;
end;

procedure TFrmMailing.Upper1Click(Sender: TObject);
var
  sText : String;
  nLowOffSet : Integer;
  SelAttributes : TTextAttributes;
begin
  if (RichEdit1.SelLength > 0) then begin
    SelAttributes := RichEdit1.SelAttributes;
    sText := RichEdit1.SelText;
    RichEdit1.SetTextBuf(PChar(sText));
  end;
end;

procedure TFrmMailing.Font1Click(Sender: TObject);
begin
  FontDialog1.Font.Name := RichEdit1.SelAttributes.Name;
  FontDialog1.Font.Color := RichEdit1.SelAttributes.Color;
  FontDialog1.Font.Size := RichEdit1.SelAttributes.Size;
  FontDialog1.Font.Style := RichEdit1.SelAttributes.Style;
  if FontDialog1.Execute then
    ApplyFont;
end;

procedure TFrmMailing.FontDialog1Apply(Sender: TObject; Wnd: Integer);
begin
  ApplyFont;
end;

procedure TFrmMailing.ApplyFont;
begin
  if RichEdit1.PlainText then begin
      RichEdit1.Tag := RichEdit1.SelStart;
      RichEdit1.SelStart := 0;
      RichEdit1.SelLength := Length(RichEdit1.Text);
      RichEdit1.Font := FontDialog1.Font;
      RichEdit1.SelStart := RichEdit1.Tag;
    end
  else
    begin
      RichEdit1.SelAttributes.Name := FontDialog1.Font.Name;
      RichEdit1.SelAttributes.Color := FontDialog1.Font.Color;
      RichEdit1.SelAttributes.Size := FontDialog1.Font.Size;
      RichEdit1.SelAttributes.Style := FontDialog1.Font.Style;
    end;
end;

end.
