unit HtmlEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Menus, OleCtrls, NMHTML, ExtCtrls;

type
  TFrmHTMLEdit = class(TForm)
    PopupMenu1: TPopupMenu;
    Print1: TMenuItem;
    SaveDialog1: TSaveDialog;
    HTML1: THTML;
    Panel1: TPanel;
    ComboBox1: TComboBox;
    ViewSource1: TMenuItem;
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure ViewSource1Click(Sender: TObject);
    procedure HTML1DoRequestDoc(Sender: TObject; const URL: WideString;
      Element: HTMLElement; DocInput: DocInput;
      var EnableDefault: WordBool);
    procedure ComboBox1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    function ConvertHTMLPath(sString : String) : String;
  public
    { Public declarations }
    sFileName : String;
    procedure OpenHTMLFile(sHTMLFileName : String);
    procedure SaveToFile(sHTMLFileName : String);
  end;

var
  FrmHTMLEdit: TFrmHTMLEdit;

implementation

uses Menu, Literals;

{$R *.DFM}

procedure TFrmHTMLEdit.OpenHTMLFile(sHTMLFileName : String);
begin
  sHTMLFileName := ConvertHTMLPath(sHTMLFileName);
//  Self.Caption := HS_URLString+sHTMLFileName;
  ComboBox1.Items.Clear;
  if (sHTMLFileName <> '') then begin
      sFileName := sHTMLFileName;
      HTML1.RequestDoc(HS_URLString+sHTMLFileName);
    end
  else
    begin
      sFileName := '';
      Self.Caption := 'Document';
    end;
//  FrmMenu.AddWindowItem(Self.Name,Self.Caption);
end;

procedure TFrmHTMLEdit.SaveToFile(sHTMLFileName : String);
begin
  if (sHTMLFileName = '') then begin
    SaveDialog1.FileName := 'Document';
    if (SaveDialog1.Execute) then begin
      sHTMLFileName := SaveDialog1.FileName;
      sFileName := ExtractFileName(SaveDialog1.FileName);
    end;
  end;
end;

procedure TFrmHTMLEdit.FormActivate(Sender: TObject);
begin
  FrmMenu.ShowClose(True);
  FrmMenu.ShowQueryMenuItem(False);
  FrmMenu.ShowTableMenuItem(False);
  FrmMenu.ShowTextFileMenuItem(True);
end;

procedure TFrmHTMLEdit.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmHTMLEdit.FormDestroy(Sender: TObject);
begin
  FrmMenu.ShowClose(False);
//  if (FindDialog1.Handle <> 0) then
//    SendMessage(FindDialog1.Handle,WM_Close,0,0);
//  FrmMenu.RemoveWindowItem(Self.Name)
end;

function TFrmHTMLEdit.ConvertHTMLPath(sString : String) : String;
  procedure ReplaceChr(var sText : String; sSearchChar, sReplaceChar : Char);
  var
    I : Integer;
  begin
    for I := 0 to Length(sText) do begin
      if sText[I] = sSearchChar then
        sText[I] := sReplaceChar;
    end;
  end;
begin
  ReplaceChr(sString,':','|');
  ReplaceChr(sString,'\','/');
  Result := sString;
end;

procedure TFrmHTMLEdit.FormResize(Sender: TObject);
begin
  ComboBox1.Width := Panel1.Width; 
end;

procedure TFrmHTMLEdit.Print1Click(Sender: TObject);
begin
  HTML1.AutoPrint(HTML1.Handle);
end;

procedure TFrmHTMLEdit.ViewSource1Click(Sender: TObject);
begin
  HTML1.ViewSource := not HTML1.ViewSource;
  if HTML1.ViewSource then
    ViewSource1.Caption := 'View HTML'
  else
    ViewSource1.Caption := 'View Source';
end;

procedure TFrmHTMLEdit.HTML1DoRequestDoc(Sender: TObject;
  const URL: WideString; Element: HTMLElement; DocInput: DocInput;
  var EnableDefault: WordBool);
begin
  ComboBox1.Items.Add(URL);
  ComboBox1.ItemIndex := ComboBox1.Items.Count-1;
end;

procedure TFrmHTMLEdit.ComboBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = 13) and (UpperCase(ComboBox1.Text) <> UpperCase(HTML1.URL)) then begin
    try
      HTML1.RequestDoc(ComboBox1.Text);
    except
      raise;
    end;
  end;
end;

end.
