unit GenFunc;

interface

uses
  Windows, Messages, SysUtils, DB, DBTables, Forms, FileCtrl, DBGrids, Controls,
  Dialogs, StdCtrls, ShellAPI;

type
  TFields = record
    FieldNames : Array [0..500] of String;
    FieldValues : Array [0..500] of String;
  end;
  TTableRecords = record
    Fields : Array [0..1000] of TFields;
    TotalRecords : Integer;
  end;

var
  sWorkingDirectory, sTempDrive : String;

function FindFieldType(wDataType : TFieldType) : String;
procedure Scatter(tblSourceTable : TTable; var aTableStructure, aFieldContent : Array of String);
procedure Gather(tblSourceTable : TTable; var aTableStructure, aFieldContent : Array of String);
procedure MultiScatter(tblSourceTable : TTable; DBGrid : TDBGrid; var TableRecords : TTableRecords);
procedure MultiGather(tblSourceTable : TTable; var TableRecords : TTableRecords);
procedure Initialise(Application : TApplication);
procedure SetDateFormatForFields(tblSource : TTable);
procedure AssignGridOptions(DBGrid1 : TDBGrid; goGridOption : TDBGridOption; lFlag : Boolean);
procedure ShowTerminateMsg;
function FieldTypeToString(FieldType : TFieldType) : String;
procedure AssignNetFileDir(sPath : String);
function DeleteFiles(ListBox : TListBox; lConfirm : Boolean; sDirectory : String) : Boolean;
function DecryptString(sString : String) : String;
function EncryptString(sString : String) : String;
procedure ShellError(nResult : Integer);

implementation

procedure Initialise(Application : TApplication);
var
  sExeName : String;
begin
  sExeName := Application.ExeName;
  sWorkingDirectory := ExtractFilePath(sExeName);
  sTempDrive := sWorkingDirectory + 'Temp\';
  if not DirectoryExists(sTempDrive) then
    CreateDir(sTempDrive);
end;

function FindFieldType(wDataType : TFieldType) : String;
var
  sFieldType : String;
begin
  if wDataType in [ftString] then
    sFieldType := 'String';
  if wDataType in [ftSmallint] then
    sFieldType := 'Smallint';
  if wDataType in [ftInteger] then
    sFieldType := 'Integer';
  if wDataType in [ftWord] then
    sFieldType := 'Word';
  if wDataType in [ftBoolean] then
    sFieldType := 'Boolean';
  if wDataType in [ftFloat] then
    sFieldType := 'Float';
  if wDataType in [ftCurrency] then
    sFieldType := 'Currency';
  if wDataType in [ftBCD] then
    sFieldType := 'BCD';
  if wDataType in [ftDate] then
    sFieldType := 'Date';
  if wDataType in [ftTime] then
    sFieldType := 'Time';
  if wDataType in [ftDateTime] then
    sFieldType := 'DateTime';
  if wDataType in [ftBytes] then
    sFieldType := 'Bytes';
  if wDataType in [ftVarBytes] then
    sFieldType := 'VarBytes';
  if wDataType in [ftAutoInc] then
    sFieldType := 'AutoInc';
  if wDataType in [ftBlob] then
    sFieldType := 'Blob';
  if wDataType in [ftMemo] then
    sFieldType := 'Memo';
  if wDataType in [ftGraphic] then
    sFieldType := 'Graphic';
  if wDataType in [ftFmtMemo] then
    sFieldType := 'FmtMemo';
  if wDataType in [ftParadoxOle] then
    sFieldType := 'ParadoxOle';
  if wDataType in [ftDBaseOle] then
    sFieldType := 'DBaseOle';
  if wDataType in [ftTypedBinary] then
    sFieldType := 'TypedBunary';
  Result := sFieldType;
end;

procedure SetDateFormatForFields(tblSource : TTable);
var
  i : Integer;
begin
  try
    tblSource.FieldDefs.Update;
    for i := 0 to tblSource.FieldDefs.Count - 1 do begin
      if (tblSource.FindField(tblSource.FieldDefs.Items[I].Name) <> nil) and (tblSource.FindField(tblSource.FieldDefs.Items[I].Name).DataType = ftDate) then
        tblSource.FindField(tblSource.FieldDefs.Items[I].Name).EditMask := '99/99/9999';
    end;
  except
    raise;
  end;
end;

procedure AssignGridOptions(DBGrid1 : TDBGrid; goGridOption : TDBGridOption; lFlag : Boolean);
begin
  if lFlag then
    DBGrid1.Options := DBGrid1.Options + [goGridOption]
  else
    DBGrid1.Options := DBGrid1.Options - [goGridOption];
end;

procedure ShowTerminateMsg;
begin
  MessageBeep(mb_Ok);
  ShowMessage('Terminated');
end;

procedure Scatter(tblSourceTable : TTable; var aTableStructure, aFieldContent : Array of String);
var
  I : Integer;
begin
  for I := 0 to tblSourceTable.FieldDefs.Count - 1 do begin
    aTableStructure[I] := tblSourceTable.FieldDefs.Items[I].Name;
    aFieldContent[I] := tblSourceTable.FieldByName(aTableStructure[I]).AsString;
  end;
end;

procedure Gather(tblSourceTable : TTable; var aTableStructure, aFieldContent : Array of String);
var
  I : Integer;
begin
  if not (tblSourceTable.State in [dsInsert,dsEdit]) then
    if (MessageDlg('Add Record',mtConfirmation,[mbYes,mbNo],0) = mrYes) then
      tblSourceTable.Append
    else
      Exit;
  for I := Low(aTableStructure) to High(aTableStructure) do begin
    if (tblSourceTable.FindField(aTableStructure[I]) <> nil) and (tblSourceTable.FindField(aTableStructure[I]).DataType <> ftAutoInc) then
      tblSourceTable.FieldByName(aTableStructure[I]).AsString := aFieldContent[I];
  end;
end;

procedure MultiScatter(tblSourceTable : TTable; DBGrid : TDBGrid; var TableRecords : TTableRecords);
var
  I, J : Integer;
  bmSourceTable : TBookMark;
begin
  bmSourceTable := tblSourceTable.GetBookmark;
  tblSourceTable.First;
  I := 0;
  J := 0;
  tblSourceTable.DisableControls;
  try
    I := 0;
    while not tblSourceTable.EOF do begin
      if DBGrid.SelectedRows.CurrentRowSelected then begin
        for J := 0 to tblSourceTable.FieldDefs.Count - 1 do begin
          TableRecords.Fields[I].FieldNames[J] := tblSourceTable.FieldDefs.Items[J].Name;
          TableRecords.Fields[I].FieldValues[J] := tblSourceTable.FieldByName(TableRecords.Fields[I].FieldNames[J]).AsString;
        end;
        I := I + 1;
      end;
      tblSourceTable.Next;
    end;
    TableRecords.TotalRecords := I+1;
  except
    on E:EDataBaseError do begin
      MessageBeep(mb_Ok);
      ShowMessage('MultiGather');
    end;
  end;
  try
    tblSourceTable.GotoBookMark(bmSourceTable);
  except
    ;
  end;
  tblSourceTable.FreeBookmark(bmSourceTable);
  tblSourceTable.EnableControls;
end;

procedure MultiGather(tblSourceTable : TTable; var TableRecords : TTableRecords);
var
  I, J : Integer;
begin
  I := 0;
  J := 0;
  tblSourceTable.DisableControls;
  try
    if not (tblSourceTable.State in [dsInsert,dsEdit]) then begin
      if (MessageDlg('Add Records',mtConfirmation,[mbYes,mbNo],0) = mrNo) then
        Exit;
    end;
    for I := Low(TableRecords.Fields) to High(TableRecords.Fields) do begin
      if I >= (TableRecords.TotalRecords - 1) then
        Break;
      tblSourceTable.Append;
      for J := Low(TableRecords.Fields[I].FieldNames) to High(TableRecords.Fields[I].FieldNames) do begin
        if (tblSourceTable.FindField(TableRecords.Fields[I].FieldNames[J]) <> nil) and (tblSourceTable.FindField(TableRecords.Fields[I].FieldNames[J]).DataType <> ftAutoInc) then
          tblSourceTable.FieldByName(TableRecords.Fields[I].FieldNames[J]).AsString := TableRecords.Fields[I].FieldValues[J];
      end;
      tblSourceTable.Post;
    end;
  except
    on E:EDataBaseError do begin
      MessageBeep(mb_Ok);
      ShowMessage('MultiGather');
    end;
  end;
  tblSourceTable.EnableControls;
end;

function FieldTypeToString(FieldType : TFieldType) : String;
var
  sFieldType : String;
begin
  sFieldType := '';
  if FieldType in [ftString] then
    sFieldType := 'String';
  if FieldType in [ftSmallint] then
    sFieldType := 'Smallint';
  if FieldType in [ftInteger] then
    sFieldType := 'Integer';
  if FieldType in [ftWord] then
    sFieldType := 'Word';
  if FieldType in [ftBoolean] then
    sFieldType := 'Boolean';
  if FieldType in [ftFloat] then
    sFieldType := 'Float';
  if FieldType in [ftCurrency] then
    sFieldType := 'Currency';
  if FieldType in [ftBCD] then
    sFieldType := 'BCD';
  if FieldType in [ftDate] then
    sFieldType := 'Date';
  if FieldType in [ftTime] then
    sFieldType := 'Time';
  if FieldType in [ftDateTime] then
    sFieldType := 'DateTime';
  if FieldType in [ftBytes] then
    sFieldType := 'Bytes';
  if FieldType in [ftVarBytes] then
    sFieldType := 'VarBytes';
  if FieldType in [ftAutoInc] then
    sFieldType := 'AutoInc';
  if FieldType in [ftBlob] then
    sFieldType := 'Blob';
  if FieldType in [ftMemo] then
    sFieldType := 'Memo';
  if FieldType in [ftGraphic] then
    sFieldType := 'Graphic';
  if FieldType in [ftFmtMemo] then
    sFieldType := 'FmtMemo';
  if FieldType in [ftParadoxOle] then
    sFieldType := 'ParadoxOle';
  if FieldType in [ftDBaseOle] then
    sFieldType := 'DBaseOle';
  if FieldType in [ftTypedBinary] then
    sFieldType := 'TypedBinary';
  if FieldType in [ftUnknown] then
    sFieldType := 'Unkown';
  Result := sFieldType;
end;

procedure AssignNetFileDir(sPath : String);
begin
  Session.NetFileDir := sPath;
end;

function DeleteFiles(ListBox : TListBox; lConfirm : Boolean; sDirectory : String) : Boolean;
var
  I : Integer;
begin
  if (ListBox.SelCount <= 0) then
    Exit;
  if lConfirm and (MessageDlg('Delete File',mtWarning,[mbYes,mbNo],0) <> mrYes) then
    Exit;
  for I := 0 to ListBox.Items.Count - 1 do begin
    if ListBox.Selected[I] and FileExists(ListBox.Items[I]) then
      if not DeleteFile(sDirectory + ListBox.Items[I]) then begin
        MessageBeep(mb_Ok);
        ShowMessage('Error Deleting File ' + ListBox.Items[I]);
      end
  end;
end;

function DecryptString(sString : String) : String;
var
  i : Integer;
begin
  for i := 1 to Length(sString) do begin
    sString[i] := Chr(Ord(sString[i])+10);
  end;
  Result := sString;
end;

function EncryptString(sString : String) : String;
var
  i : Integer;
begin
  for i := 1 to Length(sString) do begin
    sString[i] := Chr(Ord(sString[i])-10);
  end;
  Result := sString;
end;

procedure ShellError(nResult : Integer);
var
  sErrMsg : String;
begin
  sErrMsg := '';
  MessageBeep(mb_Ok);
  case nResult of 
    0	                   : sErrMsg := 'The operating system is out of memory or resources.';
    ERROR_FILE_NOT_FOUND   : sErrMsg := 'The specified file was not found.';
    SE_ERR_FNF or ERROR_PATH_NOT_FOUND   : sErrMsg := 'The specified path was not found.' + ' / ' + 'The specified file was not found.';
    ERROR_BAD_FORMAT	   : sErrMsg := 'The .EXE file is invalid (non-Win32 .EXE or error in .EXE image).';
    SE_ERR_ACCESSDENIED	   : sErrMsg := 'The operating system denied access to the specified file.';
    SE_ERR_ASSOCINCOMPLETE : sErrMsg := 'The filename association is incomplete or invalid.';
    SE_ERR_DDEBUSY	   : sErrMsg := 'The DDE transaction could not be completed because other DDE transactions were being processed.';
    SE_ERR_DDEFAIL	   : sErrMsg := 'The DDE transaction failed.';
    SE_ERR_DDETIMEOUT	   : sErrMsg := 'The DDE transaction could not be completed because the request timed out.';
    SE_ERR_DLLNOTFOUND	   : sErrMsg := 'The specified dynamic-link library was not found.';
//    SE_ERR_FNF	     : sErrMsg := 'The specified file was not found.';
    SE_ERR_NOASSOC	   : sErrMsg := 'There is no application associated with the given filename extension.';
    SE_ERR_OOM	           : sErrMsg := 'There was not enough memory to complete the operation.';
//    SE_ERR_PNF	     : sErrMsg := 'The specified path was not found.';
    SE_ERR_SHARE	   : sErrMsg := 'A sharing violation occurred.';
  else
    sErrMsg := 'Error running application';
  end;
  ShowMessage(sErrMsg);
end;

end.
