unit Filter;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Db, DBTables;

type
  TFrmFilter = class(TForm)
    Panel1: TPanel;
    MFilter: TMemo;
    BtnOk: TButton;
    BtnCancel: TButton;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    BtnAdd: TButton;
    BtnClear: TButton;
    tblFilter: TTable;
    Label3: TLabel;
    ComboBox2: TComboBox;
    procedure BtnOkClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ComboBox1Click(Sender: TObject);
    procedure BtnAddClick(Sender: TObject);
    procedure BtnClearClick(Sender: TObject);
  private
    { Private declarations }
    procedure AddFieldsToCombo(tblSource : TTable);
  public
    { Public declarations }
    function ShowFilterForm(tblSource : TTable) : TModalResult;
  end;

var
  FrmFilter: TFrmFilter;

implementation

{$R *.DFM}

procedure TFrmFilter.BtnOkClick(Sender: TObject);
var
  sOldFilter : String;
  lOldFiltered : Boolean;
begin
  sOldFilter := tblFilter.Filter;
  lOldFiltered := tblFilter.Filtered;
  try
    tblFilter.Filtered := False;
    tblFilter.Filter := MFilter.Text;
    tblFilter.Filtered := True;
  except
    tblFilter.Filter := sOldFilter;
    tblFilter.Filtered := lOldFiltered;
    BtnOk.ModalResult := mrNone;
    raise;
  end;
end;

procedure TFrmFilter.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmFilter.ComboBox1Click(Sender: TObject);
begin
  MFilter.Text := MFilter.Text + ' ' + TComboBox(Sender).Items[TComboBox(Sender).ItemIndex];
end;

procedure TFrmFilter.BtnAddClick(Sender: TObject);
begin
  MFilter.Text := MFilter.Text + ' ' + '''' + Edit1.Text + '''';
end;

function TFrmFilter.ShowFilterForm(tblSource : TTable) : TModalResult;
begin
  AddFieldsToCombo(tblSource);
  tblFilter := tblSource;
  MFilter.Text := tblSource.Filter;
  Result := Self.ShowModal;
end;

procedure TFrmFilter.AddFieldsToCombo(tblSource : TTable);
var
  I : Integer;
begin
  ComboBox1.Items.Clear;
  for I := 0 to tblSource.FieldDefs.Count - 1 do
    ComboBox1.Items.Add(tblSource.FieldDefs.Items[I].Name);
end;

procedure TFrmFilter.BtnClearClick(Sender: TObject);
begin
  MFilter.Lines.Clear;
end;

end.
