unit Compare;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FileCtrl, StdCtrls, ExtCtrls, Db, DBTables, Grids, DBGrids, Menus;

type
  TFrmCompare = class(TForm)
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    FileListBox1: TFileListBox;
    GroupBox2: TGroupBox;
    DriveComboBox2: TDriveComboBox;
    DirectoryListBox2: TDirectoryListBox;
    FileListBox2: TFileListBox;
    tblSource: TTable;
    tblTarget: TTable;
    Panel4: TPanel;
    Panel2: TPanel;
    GroupBox4: TGroupBox;
    Memo1: TMemo;
    Panel3: TPanel;
    BtnStart: TButton;
    BtnCancel: TButton;
    BtnClose: TButton;
    DBGSource: TDBGrid;
    DBGTarget: TDBGrid;
    SrcSource: TDataSource;
    SrcTarget: TDataSource;
    BtnCheck: TButton;
    Splitter1: TSplitter;
    Splitter2: TSplitter;
    PopupMenu1: TPopupMenu;
    Scatter1: TMenuItem;
    Gather1: TMenuItem;
    N1: TMenuItem;
    New1: TMenuItem;
    Insert1: TMenuItem;
    Edit1: TMenuItem;
    Delete1: TMenuItem;
    N2: TMenuItem;
    Save1: TMenuItem;
    Revert1: TMenuItem;
    procedure BtnCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtnStartClick(Sender: TObject);
    procedure Scatter1Click(Sender: TObject);
    procedure Gather1Click(Sender: TObject);
    procedure FileListBox1Click(Sender: TObject);
    procedure FileListBox2Click(Sender: TObject);
    procedure BtnCheckClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Insert1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Revert1Click(Sender: TObject);
  private
    { Private declarations }
    lAbortProcess : Boolean;
//    aTableStructure, aFieldContent : Array [0..500] of string;
    function FileCompare(Source, Target : TFileListBox) : Boolean;
    function Compare(tblSource,tblTarget : TTable) : Boolean;
    procedure WriteLog(sString : String);
    procedure CheckFiles(tblFiles : TTable; FileListBox : TFileListBox);
  public
    { Public declarations }
  end;

var
  FrmCompare: TFrmCompare;

implementation

uses GenFunc, Menu, Literals;

{$R *.DFM}

procedure TFrmCompare.BtnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TFrmCompare.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmCompare.WriteLog(sString : String);
begin
  Memo1.Lines.Add(sString);
end;

function TFrmCompare.Compare(tblSource,tblTarget : TTable) : Boolean;
var
  I : Integer;
  TarFieldName : TField;
begin
  for I := 0 to tblSource.FieldDefs.Count - 1 do begin
    TarFieldName := nil;
    TarFieldName := tblTarget.FindField(tblSource.FieldDefs.Items[I].Name);
    if (TarFieldName <> nil) then begin
        if (TarFieldName.DataType <> tblSource.FieldDefs.Items[I].DataType) then begin
          WriteLog('     '+tblSource.FieldDefs.Items[I].Name +' Field data type is different');
          WriteLog('      ('+FindFieldType(tblSource.FieldDefs.Items[I].DataType)+' - '+FindFieldType(TarFieldName.DataType)+')');
        end;
        if (TarFieldName.Size <> tblSource.FieldDefs.Items[I].Size) then
          WriteLog('     Field '+tblSource.FieldDefs.Items[I].Name + ' size is different');
      end
    else
      WriteLog('     Field '+tblSource.FieldDefs.Items[I].Name + ' does not exist.');
  end;
  Application.ProcessMessages;
end;

function TFrmCompare.FileCompare(Source, Target : TFileListBox) : Boolean;
var
  I : Integer;
begin
  Memo1.Lines.Clear;
  Memo1.Refresh;
  if Source.Items.Count = 0 then begin
    MessageBeep(MB_ok);
    Application.MessageBox('No source files were found for comparision',PChar(MB_Title),mb_Ok);
    Exit
  end;
  tblSource.DataBaseName := Source.Directory;
  tblTarget.DataBaseName := Target.Directory;
  tblSource.DisableControls;
  tblTarget.DisableControls;
  for I := 0 to Source.Items.Count - 1 do begin
    if lAbortProcess then
      Break;
    tblSource.TableName := Source.Items.Strings[I];
    if not FileExists(tblTarget.DataBaseName+'\'+tblSource.TableName) then begin
        WriteLog('File does not exists '+ Source.Items.Strings[I]);
        Continue;
      end
    else begin
        tblTarget.TableName := tblSource.TableName;
        WriteLog('Comparing File '+ Source.Items.Strings[I]);
      end;
    tblSource.Active := True;
    tblTarget.Active := True;
    Compare(tblSource,tblTarget);
    tblSource.Active := False;
    tblTarget.Active := False;
  end;
  if lAbortProcess then
    WriteLog('File Comparision terminated...')
  else
    WriteLog('File Comparision Completes...');
  tblSource.EnableControls;
  tblTarget.EnableControls;
end;

procedure TFrmCompare.BtnStartClick(Sender: TObject);
begin
  lAbortProcess := False;
  BtnStart.Enabled := False;
  tblSource.Close;
  tblTarget.Close;
  FileCompare(FileListBox1,FileListBox2);
  BtnStart.Enabled := True;
end;

procedure TFrmCompare.Scatter1Click(Sender: TObject);
var
  Table1 : TTable;
begin
  if Self.ActiveControl.Name = 'DBGSource' then
    Table1 := tblSource
  else
    Table1 := tblTarget;
  Scatter(Table1, FrmMenu.aTableStructure, FrmMenu.aFieldContent);
end;

procedure TFrmCompare.Gather1Click(Sender: TObject);
var
  Table1 : TTable;
begin
  if Self.ActiveControl.Name = 'DBGSource' then
    Table1 := tblSource
  else
    Table1 := tblTarget;
  Gather(Table1, FrmMenu.aTableStructure, FrmMenu.aFieldContent);
end;

procedure TFrmCompare.FileListBox1Click(Sender: TObject);
begin
  tblSource.Active := False;
  tblSource.DataBaseName := FileListBox1.Directory;
  tblSource.TableName := FileListBox1.Items[FileListBox1.ItemIndex];
  tblSource.Active := True;
end;

procedure TFrmCompare.FileListBox2Click(Sender: TObject);
begin
  tblTarget.Active := False;
  tblTarget.DataBaseName := FileListBox2.Directory;
  tblTarget.TableName := FileListBox2.Items[FileListBox2.ItemIndex];
  tblTarget.Active := True;
end;

procedure TFrmCompare.BtnCheckClick(Sender: TObject);
var
  tblSoftware : TTable;
begin
  tblSoftware := TTable.Create(Self);
  tblSoftware.DatabaseName := sWorkingDirectory;
  tblSoftware.TableName := 'Ophthal.db';
  tblSoftware.Active := True;
  CheckFiles(tblSoftware,FileListBox1);
  tblSoftware.Close;
  tblSoftware.Free;
end;

procedure TFrmCompare.CheckFiles(tblFiles : TTable; FileListBox : TFileListBox);
var
  lFound : Boolean;
  I : Integer;
  sMessage : String;
begin
  tblFiles.First;
  Memo1.Lines.Clear;
  while not tblFiles.EOF do begin
//    if not FileExists(tblFiles.DataBaseName+'\'+tblFiles.FieldByName('FileName').AsString) then begin
    lFound := False;
    sMessage := 'File '+ tblFiles.FieldByName('FileName').AsString;
    for I := 0 to FileListBox.Items.Count - 1 do begin
      if UpperCase(tblFiles.FieldByName('FileName').AsString) = UpperCase(FileListBox.Items.Strings[I]) then begin
        lFound := True;
        WriteLog(sMessage + ' Found');
        Break;
      end;
    end;
    if not lFound then
      WriteLog(sMessage + ' not found');
    lFound := False;
    tblFiles.Next;
  end;
  WriteLog('Completes');
end;

procedure TFrmCompare.BtnCancelClick(Sender: TObject);
begin
  lAbortProcess := True;
end;

procedure TFrmCompare.New1Click(Sender: TObject);
begin
  if Self.ActiveControl.Name = 'DBGSource' then
    tblSource.Append
  else
    tblTarget.Append;
end;

procedure TFrmCompare.Insert1Click(Sender: TObject);
begin
  if Self.ActiveControl.Name = 'DBGSource' then
    tblSource.Insert
  else
    tblTarget.Insert;
end;

procedure TFrmCompare.Edit1Click(Sender: TObject);
begin
  if Self.ActiveControl.Name = 'DBGSource' then
    tblSource.Edit
  else
    tblTarget.Edit;
end;

procedure TFrmCompare.Delete1Click(Sender: TObject);
begin
  if Self.ActiveControl.Name = 'DBGSource' then
    tblSource.Delete
  else
    tblTarget.Delete;
end;

procedure TFrmCompare.Save1Click(Sender: TObject);
begin
  if Self.ActiveControl.Name = 'DBGSource' then begin
      if (tblSource.State in [dsInsert,dsEdit]) then
        tblSource.Post;
    end
  else
    if (tblTarget.State in [dsInsert,dsEdit]) then
      tblTarget.Post;
end;

procedure TFrmCompare.Revert1Click(Sender: TObject);
begin
  if Self.ActiveControl.Name = 'DBGSource' then begin
      if (tblSource.State in [dsInsert,dsEdit]) then
        tblSource.Cancel;
    end
  else
    if (tblTarget.State in [dsInsert,dsEdit]) then
      tblTarget.Cancel;
end;

end.
