unit Command;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

const
  {CW - Command Window}
  CW_All               : String = 'All';
  CW_Rest              : String = 'Rest';
  CW_Replace           : String = 'Replace';
  CW_For               : String = 'For';
  CW_Update            : String = 'Update';

type
  TFrmCommandWindow = class(TForm)
    Memo1: TMemo;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Memo1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    procedure RunCommand(sCommand : String);
    procedure GetCommands(sCommand,sFieldName,sValue : String);
  public
    { Public declarations }
  end;

var
  FrmCommandWindow: TFrmCommandWindow;

implementation

uses Menu;

{$R *.DFM}

procedure TFrmCommandWindow.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmCommandWindow.Memo1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = 13) then
    RunCommand(Memo1.Lines.Strings[Memo1.Lines.Count-1]);
end;

procedure TFrmCommandWindow.RunCommand(sCommand : String);
var
  sFieldName, sValue : String;
begin
  if (Pos(CW_Replace,sCommand) > 0) then begin
    GetCommands(sCommand,sFieldName,sValue);
    if not (Pos(CW_Rest,sCommand) > 0) then
      FrmMenu.Table1.First;
    while FrmMenu.Table1.EOF do begin
      FrmMenu.Table1.Edit;
      FrmMenu.Table1.FieldByName(sFieldName).AsString := sValue;
      FrmMenu.Table1.Post;
    end;
  end;
end;

procedure TFrmCommandWindow.GetCommands(sCommand,sFieldName,sValue : String);
var
  I : Integer;
  sCommandValue : String;
begin
//  if Pos
//  sCommandValue := s
end;

end.
