unit Browse;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, DBCtrls, Grids, DBGrids, DB, DBTables, StdCtrls, FileCtrl,
  ComCtrls, Menus, msDBMemo, FindDlg, MSRichEd;

type
  TFrmBrowser = class(TForm)
    DataSource1: TDataSource;
    Table1: TTable;
    PopupMenu1: TPopupMenu;
    Scatter1: TMenuItem;
    Gather1: TMenuItem;
    StatusBar1: TStatusBar;
    DBGrid1: TDBGrid;
    MSMemo1: TMSMemo;
    N1: TMenuItem;
    New1: TMenuItem;
    Edit1: TMenuItem;
    Insert1: TMenuItem;
    Delete1: TMenuItem;
    N2: TMenuItem;
    Save1: TMenuItem;
    Revert1: TMenuItem;
    N3: TMenuItem;
    MultipleScatter1: TMenuItem;
    MultipleGather1: TMenuItem;
    MSDBRichEdit1: TMSDBRichEdit;
    procedure FileListBox1Click(Sender: TObject);
    procedure Table1AfterPost(DataSet: TDataSet);
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure DBGrid1TitleClick(Column: TColumn);
    procedure Table1AfterScroll(DataSet: TDataSet);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Table1AfterOpen(DataSet: TDataSet);
    procedure Table1AfterClose(DataSet: TDataSet);
    procedure DataSource1StateChange(Sender: TObject);
    procedure Scatter1Click(Sender: TObject);
    procedure Gather1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Insert1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Revert1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure Table1BeforeInsert(DataSet: TDataSet);
    procedure Table1AfterInsert(DataSet: TDataSet);
    procedure DBGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure MultipleScatter1Click(Sender: TObject);
    procedure MultipleGather1Click(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DBGrid1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    lFieldModified, lShowStructure  : Boolean;
    nOldKey, nOldRecNo : Integer;
    procedure ShowMemo;
  public
    { Public declarations }
    procedure OpenBrowser(sDirectory, sFileName : String);
    function AskSaveChanges : Boolean;
    procedure ShowStructure(lStructure : Boolean);
  end;

var
  FrmBrowser: TFrmBrowser;

implementation

uses Compare, About, Filter, GenFunc, Menu, Literals;

{$R *.DFM}

procedure TFrmBrowser.FileListBox1Click(Sender: TObject);
begin
  Table1.Active := False;
  Table1.IndexFieldNames := '';
  Table1.Filter := '';
  Table1.Filtered := False;
//  Table1.DataBaseName := FileListBox1.Directory;
//  Table1.TableName := FileListBox1.Items[FileListBox1.ItemIndex];
  Table1.Active := True;
  ShowStructure(FrmMenu.ShowStructure1.Checked);
end;

procedure TFrmBrowser.Table1AfterPost(DataSet: TDataSet);
begin
  Table1.Refresh;
end;

procedure TFrmBrowser.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TFrmBrowser.About1Click(Sender: TObject);
begin
  Application.CreateForm(TAboutBox, AboutBox);
  AboutBox.ShowModal;
end;

procedure TFrmBrowser.DBGrid1TitleClick(Column: TColumn);
begin
  Table1.Filtered := False;
end;

procedure TFrmBrowser.Table1AfterScroll(DataSet: TDataSet);
begin
  StatusBar1.SimpleText := 'Table : '+ Table1.TableName +'  '+
                           'Records : ' + IntToStr(Table1.RecordCount) + '  ' +
                           'Record No : ' + IntToStr(Table1.RecNo) + '  ' +
                           'Filter : ' + Table1.Filter;
end;

procedure TFrmBrowser.OpenBrowser(sDirectory, sFileName : String);
  function ExtractPath(sString : String) : String;
  var
    sTmpString : String;
  begin
    sTmpString := Copy(sString,Pos('\',sString),Length(sString));
    sTmpString := Copy(sTmpString,0,Pos('File:',sTmpString)-3);
    Result := sTmpString;
  end;
begin
  try
    Self.Caption := sDirectory + sFileName;
    Table1.DatabaseName := sDirectory;
    Table1.TableName := sFileName;
    Table1.Open;
//    FrmMenu.AddWindowItem(Self.Name,Self.Caption);
  except
    on E:EDataBaseError do begin
      if (Pos('Insufficient table',E.Message) > 0) then
        E.Message := 'Invalid Password';
      If (Pos(EM_DirControlledby,UpperCase(E.Message)) > 0) then begin
        AssignNetFileDir(ExtractPath(E.Message));
        Table1.Open;
        Exit;
      end;
      ShowMessage(E.Message);
      Self.Close;
    end;
  end;
end;

procedure TFrmBrowser.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Table1.Active then
    Table1.Refresh;
  Table1.Close;  
  Action := caFree;
end;

procedure TFrmBrowser.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose := AskSaveChanges;
end;

function TFrmBrowser.AskSaveChanges : Boolean;
var
  wWord : Word;
begin
  wWord := mrNo;
  if lFieldModified then begin
    wWord := MessageDlg('Changes have been made save',mtWarning,[mbYes,mbNo,mbCancel],0);
    if (wWord = mrYes) then
      Table1.Post
    else
      if (wWord = mrNo) then
        Table1.Cancel;
  end;
  Result := (wWord <> mrCancel);
end;

procedure TFrmBrowser.FormActivate(Sender: TObject);
var
  I : Integer;
begin
  FrmMenu.Table1 := Table1;
  FrmMenu.ShowClose(True);
  FrmMenu.ShowStructure1.Checked := lShowStructure;
  FrmMenu.ShowQueryMenuItem(False);
  FrmMenu.ShowTextFileMenuItem(False);
  FrmMenu.ShowTableMenuItem(Table1.Active);
  AssignGridOptions(DBGrid1,dgAlwaysShowSelection,FrmMenu.ShowSelected1.Checked);
  AssignGridOptions(DBGrid1,dgAlwaysShowEditor,FrmMenu.ShowEdited1.Checked);
  AssignGridOptions(DBGrid1,dgConfirmDelete,FrmMenu.ConfirmDelete1.Checked);
  AssignGridOptions(DBGrid1,dgMultiSelect,FrmMenu.MultipleSelect1.Checked);
end;

procedure TFrmBrowser.Table1AfterOpen(DataSet: TDataSet);
begin
//  SetDateFormatForFields(TTable(DataSet));
  FormActivate(Self);
end;

procedure TFrmBrowser.Table1AfterClose(DataSet: TDataSet);
begin
  FormActivate(Self);
end;

procedure TFrmBrowser.ShowStructure(lStructure : Boolean);
var
  I : Integer;
begin
  lShowStructure := lStructure;
  for I := 0 to Table1.FieldCount - 1 do begin
    if lStructure then
      DBGrid1.Columns.Items[I].Title.Caption := DBGrid1.Fields[I].FieldName + ' : ' +
                                                FindFieldType(DBGrid1.Fields[I].DataType) + ' : ' +
                                                IntToStr(DBGrid1.Fields[I].DataSize)
    else
      DBGrid1.Columns.Items[I].Title.Caption := DBGrid1.Fields[I].FieldName;
  end;
end;

procedure TFrmBrowser.DataSource1StateChange(Sender: TObject);
begin
  lFieldModified := (Table1.State in [dsInsert,dsEdit]);
end;

procedure TFrmBrowser.Scatter1Click(Sender: TObject);
begin
  Scatter(Table1,FrmMenu.aTableStructure,FrmMenu.aFieldContent);
end;

procedure TFrmBrowser.Gather1Click(Sender: TObject);
begin
  Gather(Table1,FrmMenu.aTableStructure,FrmMenu.aFieldContent);
end;

procedure TFrmBrowser.New1Click(Sender: TObject);
begin
  Table1.Append;
end;

procedure TFrmBrowser.Insert1Click(Sender: TObject);
begin
  Table1.Insert;
end;

procedure TFrmBrowser.Edit1Click(Sender: TObject);
begin
  Table1.Edit;
end;

procedure TFrmBrowser.Delete1Click(Sender: TObject);
begin
  if (MessageDlg('Delete Record',mtConfirmation,[mbYes,mbNo],0) = mrYes) then
    Table1.Delete;
end;

procedure TFrmBrowser.Save1Click(Sender: TObject);
begin
  Table1.Post;
end;

procedure TFrmBrowser.Revert1Click(Sender: TObject);
begin
  Table1.Cancel;
end;

procedure TFrmBrowser.FormDestroy(Sender: TObject);
begin
  FrmMenu.ShowClose(False);
//  FrmMenu.RemoveWindowItem(Self.Name)
end;

procedure TFrmBrowser.FormDeactivate(Sender: TObject);
begin
  if Sender <> nil then
    FrmMenu.ShowMenuWindowItemChecked(Self.Name,False);
end;

procedure TFrmBrowser.PopupMenu1Popup(Sender: TObject);
begin
  Scatter1.Enabled := Table1.Active;
  Gather1.Enabled := Table1.Active;
  New1.Enabled := Table1.Active;
  Insert1.Enabled := Table1.Active;
  Edit1.Enabled := Table1.Active;
  Delete1.Enabled := Table1.Active;
  if Table1.Active then begin
    Save1.Enabled := (Table1.State in [dsInsert,dsEdit]);
    Revert1.Enabled := (Table1.State in [dsInsert,dsEdit]);
  end;
end;

procedure TFrmBrowser.Table1BeforeInsert(DataSet: TDataSet);
begin
  If FrmMenu.CarryFieldValues1.Checked then
    Scatter(Table1,FrmMenu.aTableStructure,FrmMenu.aFieldContent);
end;

procedure TFrmBrowser.Table1AfterInsert(DataSet: TDataSet);
begin
  If FrmMenu.CarryFieldValues1.Checked then
    Gather(Table1,FrmMenu.aTableStructure,FrmMenu.aFieldContent);
end;

procedure TFrmBrowser.DBGrid1DblClick(Sender: TObject);
begin
  ShowMemo;
end;

procedure TFrmBrowser.ShowMemo;
var
  sRichText : String;
begin
  if DBGrid1.SelectedField.DataType = ftMemo then begin
    sRichText := Table1.FieldByName(DBGrid1.SelectedField.FieldName).AsString;
    if Copy(sRichText,0,Length(MT_RichText)) = MT_RichText then begin
        MSDBRichEdit1.DataField := DBGrid1.SelectedField.FieldName;
        MSDBRichEdit1.dblClick(MSDBRichEdit1);
      end
    else
      begin
        MSMemo1.DataField := DBGrid1.SelectedField.FieldName;
        MSMemo1.dblClick(MSMemo1);
      end;
  end;
  if (DBGrid1.SelectedField.DataType = ftGraphic) or
    (DBGrid1.SelectedField.DataType = ftBlob) or
    (DBGrid1.SelectedField.DataType = ftParadoxOle) or
    (DBGrid1.SelectedField.DataType = ftDBaseOle) then begin
//    MSPicture1.DataField := DBGrid1.SelectedRows.FieldName;
//    MSPicture1.BringToFront;
//    MSPicture1.dblClick(MSPicture1);
  end;
end;

procedure TFrmBrowser.MultipleScatter1Click(Sender: TObject);
begin
  MultiScatter(Table1,DBGrid1,FrmMenu.TableRecords);
end;

procedure TFrmBrowser.MultipleGather1Click(Sender: TObject);
begin
  MultiGather(Table1,FrmMenu.TableRecords);
end;

procedure TFrmBrowser.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_ESCAPE then
    FrmMenu.SetLoopBreak;
end;

procedure TFrmBrowser.DBGrid1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = 13) then
    ShowMemo;
{  if (ssShift in Shift) and ((Key = 33) or (Key = 34)) then begin
    nOldRecNo := Table1.RecNo;
    nOldKey := Key;
  end;}
end;

procedure TFrmBrowser.DBGrid1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
{var
  bmCurrentPointer : TBookmark;
  nTotalRecords : Integer;}
begin
{  if (ssShift in Shift) then begin
    Table1.DisableControls;
    try
      bmCurrentPointer := Table1.GetBookmark;
      if (nOldKey = 33) then begin
        nTotalRecords := nOldRecNo - Table1.RecNo;
        while (not Table1.EOF) and (nTotalRecords > 0)  do begin
          DBGrid1.SelectedRows.CurrentRowSelected := True;
          Table1.Next;
          nTotalRecords := nTotalRecords - 1;
        end
      end;
      if (nOldKey = 34) then begin
        nTotalRecords := Table1.RecNo - nOldRecNo;
        while (not Table1.BOF) and (nTotalRecords > 0)  do begin
          DBGrid1.SelectedRows.CurrentRowSelected := True;
          Table1.Prior;
          nTotalRecords := nTotalRecords - 1;
        end;
      end;
      try
        Table1.GotoBookmark(bmCurrentPointer);
      except
        ;
      end;
      Table1.FreeBookmark(bmCurrentPointer);
    finally
      Table1.EnableControls;
      if (nOldKey = 33) or (nOldKey = 34) then begin
        nOldKey := 0;
        Key := 0;
      end;
    end;
  end;}
end;

end.
